// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: types/types.proto

/*
	Package types is a generated protocol buffer package.

	It is generated from these files:
		types/types.proto

	It has these top-level messages:
		Genesis
		Tx
		TxPayload
		Account
		TxSend
		Provider
		Providers
		TxCreateProvider
		ResourceUnit
		ResourceGroup
		ProviderAttribute
		GroupSpec
		DeploymentGroupID
		DeploymentGroup
		DeploymentGroups
		Deployment
		Deployments
		TxCreateDeployment
		TxUpdateDeployment
		TxCloseDeployment
		OrderID
		Order
		TxCreateOrder
		Orders
		FulfillmentID
		Fulfillment
		Fulfillments
		TxCreateFulfillment
		TxCloseFulfillment
		LeaseID
		Lease
		TxCreateLease
		TxCloseLease
		Leases
		ManifestRequest
		Manifest
		ManifestGroup
		ManifestService
		ManifestServiceExpose
		Empty
		AkashVersion
		ServerStatus
		ServerStatusParseable
		ProviderStatus
		ProviderManifestStatus
		ProviderBidengineStatus
		ProviderClusterStatus
		ProviderInventoryStatus
		DeployRespone
		LeaseStatusRequest
		ServiceStatusRequest
		ServiceStatusResponse
		LogRequest
		LogOptions
		Log
		LogResponse
		LeaseStatusResponse
		ServiceStatus
		ManifestGetRequest
		ManifestGetResponse
		ErrInvalidPayload
		ErrInternalError
		ErrResourceNotFound
*/
package types

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import github_com_ovrclk_akash_types_base "github.com/ovrclk/akash/types/base"

import strings "strings"
import reflect "reflect"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type DeploymentGroup_DeploymentGroupState int32

const (
	DeploymentGroup_OPEN    DeploymentGroup_DeploymentGroupState = 0
	DeploymentGroup_ORDERED DeploymentGroup_DeploymentGroupState = 1
	DeploymentGroup_CLOSED  DeploymentGroup_DeploymentGroupState = 3
)

var DeploymentGroup_DeploymentGroupState_name = map[int32]string{
	0: "OPEN",
	1: "ORDERED",
	3: "CLOSED",
}
var DeploymentGroup_DeploymentGroupState_value = map[string]int32{
	"OPEN":    0,
	"ORDERED": 1,
	"CLOSED":  3,
}

func (x DeploymentGroup_DeploymentGroupState) String() string {
	return proto.EnumName(DeploymentGroup_DeploymentGroupState_name, int32(x))
}
func (DeploymentGroup_DeploymentGroupState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{13, 0}
}

type Deployment_DeploymentState int32

const (
	Deployment_ACTIVE Deployment_DeploymentState = 0
	Deployment_CLOSED Deployment_DeploymentState = 2
)

var Deployment_DeploymentState_name = map[int32]string{
	0: "ACTIVE",
	2: "CLOSED",
}
var Deployment_DeploymentState_value = map[string]int32{
	"ACTIVE": 0,
	"CLOSED": 2,
}

func (x Deployment_DeploymentState) String() string {
	return proto.EnumName(Deployment_DeploymentState_name, int32(x))
}
func (Deployment_DeploymentState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{15, 0}
}

type TxCloseDeployment_ReasonCode int32

const (
	TxCloseDeployment_UNSET        TxCloseDeployment_ReasonCode = 0
	TxCloseDeployment_TENANT_CLOSE TxCloseDeployment_ReasonCode = 1
	TxCloseDeployment_INSUFFICIENT TxCloseDeployment_ReasonCode = 2
)

var TxCloseDeployment_ReasonCode_name = map[int32]string{
	0: "UNSET",
	1: "TENANT_CLOSE",
	2: "INSUFFICIENT",
}
var TxCloseDeployment_ReasonCode_value = map[string]int32{
	"UNSET":        0,
	"TENANT_CLOSE": 1,
	"INSUFFICIENT": 2,
}

func (x TxCloseDeployment_ReasonCode) String() string {
	return proto.EnumName(TxCloseDeployment_ReasonCode_name, int32(x))
}
func (TxCloseDeployment_ReasonCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{19, 0}
}

type Order_OrderState int32

const (
	Order_OPEN    Order_OrderState = 0
	Order_MATCHED Order_OrderState = 1
	Order_CLOSED  Order_OrderState = 2
)

var Order_OrderState_name = map[int32]string{
	0: "OPEN",
	1: "MATCHED",
	2: "CLOSED",
}
var Order_OrderState_value = map[string]int32{
	"OPEN":    0,
	"MATCHED": 1,
	"CLOSED":  2,
}

func (x Order_OrderState) String() string {
	return proto.EnumName(Order_OrderState_name, int32(x))
}
func (Order_OrderState) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{21, 0} }

type Fulfillment_FulfillmentState int32

const (
	Fulfillment_OPEN    Fulfillment_FulfillmentState = 0
	Fulfillment_MATCHED Fulfillment_FulfillmentState = 1
	Fulfillment_CLOSED  Fulfillment_FulfillmentState = 2
)

var Fulfillment_FulfillmentState_name = map[int32]string{
	0: "OPEN",
	1: "MATCHED",
	2: "CLOSED",
}
var Fulfillment_FulfillmentState_value = map[string]int32{
	"OPEN":    0,
	"MATCHED": 1,
	"CLOSED":  2,
}

func (x Fulfillment_FulfillmentState) String() string {
	return proto.EnumName(Fulfillment_FulfillmentState_name, int32(x))
}
func (Fulfillment_FulfillmentState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{25, 0}
}

type Lease_LeaseState int32

const (
	Lease_ACTIVE Lease_LeaseState = 0
	Lease_CLOSED Lease_LeaseState = 2
)

var Lease_LeaseState_name = map[int32]string{
	0: "ACTIVE",
	2: "CLOSED",
}
var Lease_LeaseState_value = map[string]int32{
	"ACTIVE": 0,
	"CLOSED": 2,
}

func (x Lease_LeaseState) String() string {
	return proto.EnumName(Lease_LeaseState_name, int32(x))
}
func (Lease_LeaseState) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{30, 0} }

// BEGIN GLOBAL
type Genesis struct {
	Accounts []Account `protobuf:"bytes,1,rep,name=accounts" json:"accounts"`
}

func (m *Genesis) Reset()                    { *m = Genesis{} }
func (m *Genesis) String() string            { return proto.CompactTextString(m) }
func (*Genesis) ProtoMessage()               {}
func (*Genesis) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{0} }

func (m *Genesis) GetAccounts() []Account {
	if m != nil {
		return m.Accounts
	}
	return nil
}

type Tx struct {
	Key       []byte    `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Signature []byte    `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	Payload   TxPayload `protobuf:"bytes,3,opt,name=payload" json:"payload"`
}

func (m *Tx) Reset()                    { *m = Tx{} }
func (m *Tx) String() string            { return proto.CompactTextString(m) }
func (*Tx) ProtoMessage()               {}
func (*Tx) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{1} }

func (m *Tx) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *Tx) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

func (m *Tx) GetPayload() TxPayload {
	if m != nil {
		return m.Payload
	}
	return TxPayload{}
}

type TxPayload struct {
	Nonce uint64 `protobuf:"varint,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	// Types that are valid to be assigned to Payload:
	//	*TxPayload_TxSend
	//	*TxPayload_TxCreateDeployment
	//	*TxPayload_TxUpdateDeployment
	//	*TxPayload_TxCreateOrder
	//	*TxPayload_TxCreateFulfillment
	//	*TxPayload_TxCreateLease
	//	*TxPayload_TxCreateProvider
	//	*TxPayload_TxCloseDeployment
	//	*TxPayload_TxCloseFulfillment
	//	*TxPayload_TxCloseLease
	Payload isTxPayload_Payload `protobuf_oneof:"payload"`
}

func (m *TxPayload) Reset()                    { *m = TxPayload{} }
func (m *TxPayload) String() string            { return proto.CompactTextString(m) }
func (*TxPayload) ProtoMessage()               {}
func (*TxPayload) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{2} }

type isTxPayload_Payload interface {
	isTxPayload_Payload()
}

type TxPayload_TxSend struct {
	TxSend *TxSend `protobuf:"bytes,2,opt,name=txSend,oneof"`
}
type TxPayload_TxCreateDeployment struct {
	TxCreateDeployment *TxCreateDeployment `protobuf:"bytes,3,opt,name=txCreateDeployment,oneof"`
}
type TxPayload_TxUpdateDeployment struct {
	TxUpdateDeployment *TxUpdateDeployment `protobuf:"bytes,4,opt,name=txUpdateDeployment,oneof"`
}
type TxPayload_TxCreateOrder struct {
	TxCreateOrder *TxCreateOrder `protobuf:"bytes,5,opt,name=txCreateOrder,oneof"`
}
type TxPayload_TxCreateFulfillment struct {
	TxCreateFulfillment *TxCreateFulfillment `protobuf:"bytes,6,opt,name=txCreateFulfillment,oneof"`
}
type TxPayload_TxCreateLease struct {
	TxCreateLease *TxCreateLease `protobuf:"bytes,7,opt,name=txCreateLease,oneof"`
}
type TxPayload_TxCreateProvider struct {
	TxCreateProvider *TxCreateProvider `protobuf:"bytes,8,opt,name=txCreateProvider,oneof"`
}
type TxPayload_TxCloseDeployment struct {
	TxCloseDeployment *TxCloseDeployment `protobuf:"bytes,9,opt,name=txCloseDeployment,oneof"`
}
type TxPayload_TxCloseFulfillment struct {
	TxCloseFulfillment *TxCloseFulfillment `protobuf:"bytes,10,opt,name=txCloseFulfillment,oneof"`
}
type TxPayload_TxCloseLease struct {
	TxCloseLease *TxCloseLease `protobuf:"bytes,11,opt,name=txCloseLease,oneof"`
}

func (*TxPayload_TxSend) isTxPayload_Payload()              {}
func (*TxPayload_TxCreateDeployment) isTxPayload_Payload()  {}
func (*TxPayload_TxUpdateDeployment) isTxPayload_Payload()  {}
func (*TxPayload_TxCreateOrder) isTxPayload_Payload()       {}
func (*TxPayload_TxCreateFulfillment) isTxPayload_Payload() {}
func (*TxPayload_TxCreateLease) isTxPayload_Payload()       {}
func (*TxPayload_TxCreateProvider) isTxPayload_Payload()    {}
func (*TxPayload_TxCloseDeployment) isTxPayload_Payload()   {}
func (*TxPayload_TxCloseFulfillment) isTxPayload_Payload()  {}
func (*TxPayload_TxCloseLease) isTxPayload_Payload()        {}

func (m *TxPayload) GetPayload() isTxPayload_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *TxPayload) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

func (m *TxPayload) GetTxSend() *TxSend {
	if x, ok := m.GetPayload().(*TxPayload_TxSend); ok {
		return x.TxSend
	}
	return nil
}

func (m *TxPayload) GetTxCreateDeployment() *TxCreateDeployment {
	if x, ok := m.GetPayload().(*TxPayload_TxCreateDeployment); ok {
		return x.TxCreateDeployment
	}
	return nil
}

func (m *TxPayload) GetTxUpdateDeployment() *TxUpdateDeployment {
	if x, ok := m.GetPayload().(*TxPayload_TxUpdateDeployment); ok {
		return x.TxUpdateDeployment
	}
	return nil
}

func (m *TxPayload) GetTxCreateOrder() *TxCreateOrder {
	if x, ok := m.GetPayload().(*TxPayload_TxCreateOrder); ok {
		return x.TxCreateOrder
	}
	return nil
}

func (m *TxPayload) GetTxCreateFulfillment() *TxCreateFulfillment {
	if x, ok := m.GetPayload().(*TxPayload_TxCreateFulfillment); ok {
		return x.TxCreateFulfillment
	}
	return nil
}

func (m *TxPayload) GetTxCreateLease() *TxCreateLease {
	if x, ok := m.GetPayload().(*TxPayload_TxCreateLease); ok {
		return x.TxCreateLease
	}
	return nil
}

func (m *TxPayload) GetTxCreateProvider() *TxCreateProvider {
	if x, ok := m.GetPayload().(*TxPayload_TxCreateProvider); ok {
		return x.TxCreateProvider
	}
	return nil
}

func (m *TxPayload) GetTxCloseDeployment() *TxCloseDeployment {
	if x, ok := m.GetPayload().(*TxPayload_TxCloseDeployment); ok {
		return x.TxCloseDeployment
	}
	return nil
}

func (m *TxPayload) GetTxCloseFulfillment() *TxCloseFulfillment {
	if x, ok := m.GetPayload().(*TxPayload_TxCloseFulfillment); ok {
		return x.TxCloseFulfillment
	}
	return nil
}

func (m *TxPayload) GetTxCloseLease() *TxCloseLease {
	if x, ok := m.GetPayload().(*TxPayload_TxCloseLease); ok {
		return x.TxCloseLease
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TxPayload) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TxPayload_OneofMarshaler, _TxPayload_OneofUnmarshaler, _TxPayload_OneofSizer, []interface{}{
		(*TxPayload_TxSend)(nil),
		(*TxPayload_TxCreateDeployment)(nil),
		(*TxPayload_TxUpdateDeployment)(nil),
		(*TxPayload_TxCreateOrder)(nil),
		(*TxPayload_TxCreateFulfillment)(nil),
		(*TxPayload_TxCreateLease)(nil),
		(*TxPayload_TxCreateProvider)(nil),
		(*TxPayload_TxCloseDeployment)(nil),
		(*TxPayload_TxCloseFulfillment)(nil),
		(*TxPayload_TxCloseLease)(nil),
	}
}

func _TxPayload_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TxPayload)
	// payload
	switch x := m.Payload.(type) {
	case *TxPayload_TxSend:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TxSend); err != nil {
			return err
		}
	case *TxPayload_TxCreateDeployment:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TxCreateDeployment); err != nil {
			return err
		}
	case *TxPayload_TxUpdateDeployment:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TxUpdateDeployment); err != nil {
			return err
		}
	case *TxPayload_TxCreateOrder:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TxCreateOrder); err != nil {
			return err
		}
	case *TxPayload_TxCreateFulfillment:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TxCreateFulfillment); err != nil {
			return err
		}
	case *TxPayload_TxCreateLease:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TxCreateLease); err != nil {
			return err
		}
	case *TxPayload_TxCreateProvider:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TxCreateProvider); err != nil {
			return err
		}
	case *TxPayload_TxCloseDeployment:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TxCloseDeployment); err != nil {
			return err
		}
	case *TxPayload_TxCloseFulfillment:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TxCloseFulfillment); err != nil {
			return err
		}
	case *TxPayload_TxCloseLease:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TxCloseLease); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TxPayload.Payload has unexpected type %T", x)
	}
	return nil
}

func _TxPayload_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TxPayload)
	switch tag {
	case 2: // payload.txSend
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TxSend)
		err := b.DecodeMessage(msg)
		m.Payload = &TxPayload_TxSend{msg}
		return true, err
	case 3: // payload.txCreateDeployment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TxCreateDeployment)
		err := b.DecodeMessage(msg)
		m.Payload = &TxPayload_TxCreateDeployment{msg}
		return true, err
	case 4: // payload.txUpdateDeployment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TxUpdateDeployment)
		err := b.DecodeMessage(msg)
		m.Payload = &TxPayload_TxUpdateDeployment{msg}
		return true, err
	case 5: // payload.txCreateOrder
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TxCreateOrder)
		err := b.DecodeMessage(msg)
		m.Payload = &TxPayload_TxCreateOrder{msg}
		return true, err
	case 6: // payload.txCreateFulfillment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TxCreateFulfillment)
		err := b.DecodeMessage(msg)
		m.Payload = &TxPayload_TxCreateFulfillment{msg}
		return true, err
	case 7: // payload.txCreateLease
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TxCreateLease)
		err := b.DecodeMessage(msg)
		m.Payload = &TxPayload_TxCreateLease{msg}
		return true, err
	case 8: // payload.txCreateProvider
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TxCreateProvider)
		err := b.DecodeMessage(msg)
		m.Payload = &TxPayload_TxCreateProvider{msg}
		return true, err
	case 9: // payload.txCloseDeployment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TxCloseDeployment)
		err := b.DecodeMessage(msg)
		m.Payload = &TxPayload_TxCloseDeployment{msg}
		return true, err
	case 10: // payload.txCloseFulfillment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TxCloseFulfillment)
		err := b.DecodeMessage(msg)
		m.Payload = &TxPayload_TxCloseFulfillment{msg}
		return true, err
	case 11: // payload.txCloseLease
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TxCloseLease)
		err := b.DecodeMessage(msg)
		m.Payload = &TxPayload_TxCloseLease{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TxPayload_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TxPayload)
	// payload
	switch x := m.Payload.(type) {
	case *TxPayload_TxSend:
		s := proto.Size(x.TxSend)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TxPayload_TxCreateDeployment:
		s := proto.Size(x.TxCreateDeployment)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TxPayload_TxUpdateDeployment:
		s := proto.Size(x.TxUpdateDeployment)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TxPayload_TxCreateOrder:
		s := proto.Size(x.TxCreateOrder)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TxPayload_TxCreateFulfillment:
		s := proto.Size(x.TxCreateFulfillment)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TxPayload_TxCreateLease:
		s := proto.Size(x.TxCreateLease)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TxPayload_TxCreateProvider:
		s := proto.Size(x.TxCreateProvider)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TxPayload_TxCloseDeployment:
		s := proto.Size(x.TxCloseDeployment)
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TxPayload_TxCloseFulfillment:
		s := proto.Size(x.TxCloseFulfillment)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TxPayload_TxCloseLease:
		s := proto.Size(x.TxCloseLease)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// BEGIN ACCOUNT
type Account struct {
	Address github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=address,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"address"`
	Balance uint64                                   `protobuf:"varint,2,opt,name=balance,proto3" json:"balance,omitempty"`
	Nonce   uint64                                   `protobuf:"varint,3,opt,name=nonce,proto3" json:"nonce,omitempty"`
}

func (m *Account) Reset()                    { *m = Account{} }
func (m *Account) String() string            { return proto.CompactTextString(m) }
func (*Account) ProtoMessage()               {}
func (*Account) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{3} }

func (m *Account) GetBalance() uint64 {
	if m != nil {
		return m.Balance
	}
	return 0
}

func (m *Account) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

type TxSend struct {
	From   github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=from,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"from"`
	To     github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,2,opt,name=to,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"to"`
	Amount uint64                                   `protobuf:"varint,3,opt,name=amount,proto3" json:"amount,omitempty"`
}

func (m *TxSend) Reset()                    { *m = TxSend{} }
func (m *TxSend) String() string            { return proto.CompactTextString(m) }
func (*TxSend) ProtoMessage()               {}
func (*TxSend) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{4} }

func (m *TxSend) GetAmount() uint64 {
	if m != nil {
		return m.Amount
	}
	return 0
}

type Provider struct {
	Address    github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=address,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"address"`
	Owner      github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,2,opt,name=owner,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"owner"`
	HostURI    string                                   `protobuf:"bytes,3,opt,name=hostURI,proto3" json:"hostURI,omitempty"`
	Attributes []ProviderAttribute                      `protobuf:"bytes,4,rep,name=attributes" json:"attributes"`
}

func (m *Provider) Reset()                    { *m = Provider{} }
func (m *Provider) String() string            { return proto.CompactTextString(m) }
func (*Provider) ProtoMessage()               {}
func (*Provider) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{5} }

func (m *Provider) GetHostURI() string {
	if m != nil {
		return m.HostURI
	}
	return ""
}

func (m *Provider) GetAttributes() []ProviderAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

type Providers struct {
	Providers []*Provider `protobuf:"bytes,1,rep,name=providers" json:"providers,omitempty"`
}

func (m *Providers) Reset()                    { *m = Providers{} }
func (m *Providers) String() string            { return proto.CompactTextString(m) }
func (*Providers) ProtoMessage()               {}
func (*Providers) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{6} }

func (m *Providers) GetProviders() []*Provider {
	if m != nil {
		return m.Providers
	}
	return nil
}

type TxCreateProvider struct {
	Owner      github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=owner,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"owner"`
	HostURI    string                                   `protobuf:"bytes,2,opt,name=hostURI,proto3" json:"hostURI,omitempty"`
	Attributes []ProviderAttribute                      `protobuf:"bytes,3,rep,name=attributes" json:"attributes"`
	Nonce      uint64                                   `protobuf:"varint,4,opt,name=nonce,proto3" json:"nonce,omitempty"`
}

func (m *TxCreateProvider) Reset()                    { *m = TxCreateProvider{} }
func (m *TxCreateProvider) String() string            { return proto.CompactTextString(m) }
func (*TxCreateProvider) ProtoMessage()               {}
func (*TxCreateProvider) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{7} }

func (m *TxCreateProvider) GetHostURI() string {
	if m != nil {
		return m.HostURI
	}
	return ""
}

func (m *TxCreateProvider) GetAttributes() []ProviderAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *TxCreateProvider) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

// BEGIN EXCHANGE
type ResourceUnit struct {
	CPU    uint32 `protobuf:"varint,1,opt,name=CPU,proto3" json:"cpu"`
	Memory uint64 `protobuf:"varint,2,opt,name=memory,proto3" json:"memory,omitempty"`
	Disk   uint64 `protobuf:"varint,3,opt,name=disk,proto3" json:"disk,omitempty"`
}

func (m *ResourceUnit) Reset()                    { *m = ResourceUnit{} }
func (m *ResourceUnit) String() string            { return proto.CompactTextString(m) }
func (*ResourceUnit) ProtoMessage()               {}
func (*ResourceUnit) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{8} }

func (m *ResourceUnit) GetCPU() uint32 {
	if m != nil {
		return m.CPU
	}
	return 0
}

func (m *ResourceUnit) GetMemory() uint64 {
	if m != nil {
		return m.Memory
	}
	return 0
}

func (m *ResourceUnit) GetDisk() uint64 {
	if m != nil {
		return m.Disk
	}
	return 0
}

type ResourceGroup struct {
	Unit  ResourceUnit `protobuf:"bytes,1,opt,name=unit" json:"unit"`
	Count uint32       `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	Price uint64       `protobuf:"varint,3,opt,name=price,proto3" json:"price,omitempty"`
}

func (m *ResourceGroup) Reset()                    { *m = ResourceGroup{} }
func (m *ResourceGroup) String() string            { return proto.CompactTextString(m) }
func (*ResourceGroup) ProtoMessage()               {}
func (*ResourceGroup) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{9} }

func (m *ResourceGroup) GetUnit() ResourceUnit {
	if m != nil {
		return m.Unit
	}
	return ResourceUnit{}
}

func (m *ResourceGroup) GetCount() uint32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *ResourceGroup) GetPrice() uint64 {
	if m != nil {
		return m.Price
	}
	return 0
}

type ProviderAttribute struct {
	Name  string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *ProviderAttribute) Reset()                    { *m = ProviderAttribute{} }
func (m *ProviderAttribute) String() string            { return proto.CompactTextString(m) }
func (*ProviderAttribute) ProtoMessage()               {}
func (*ProviderAttribute) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{10} }

func (m *ProviderAttribute) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ProviderAttribute) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type GroupSpec struct {
	Name         string              `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Requirements []ProviderAttribute `protobuf:"bytes,2,rep,name=requirements" json:"requirements"`
	Resources    []ResourceGroup     `protobuf:"bytes,3,rep,name=resources" json:"resources"`
}

func (m *GroupSpec) Reset()                    { *m = GroupSpec{} }
func (m *GroupSpec) String() string            { return proto.CompactTextString(m) }
func (*GroupSpec) ProtoMessage()               {}
func (*GroupSpec) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{11} }

func (m *GroupSpec) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GroupSpec) GetRequirements() []ProviderAttribute {
	if m != nil {
		return m.Requirements
	}
	return nil
}

func (m *GroupSpec) GetResources() []ResourceGroup {
	if m != nil {
		return m.Resources
	}
	return nil
}

type DeploymentGroupID struct {
	// deployment address
	Deployment github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=deployment,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"deployment"`
	// unique sequence over deployment
	Seq uint64 `protobuf:"varint,2,opt,name=seq,proto3" json:"seq,omitempty"`
}

func (m *DeploymentGroupID) Reset()                    { *m = DeploymentGroupID{} }
func (*DeploymentGroupID) ProtoMessage()               {}
func (*DeploymentGroupID) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{12} }

func (m *DeploymentGroupID) GetSeq() uint64 {
	if m != nil {
		return m.Seq
	}
	return 0
}

type DeploymentGroup struct {
	DeploymentGroupID `protobuf:"bytes,1,opt,name=id,embedded=id" json:"id"`
	Name              string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// max number of blocks orders are open
	OrderTTL     int64                                `protobuf:"varint,3,opt,name=orderTTL,proto3" json:"orderTTL,omitempty"`
	State        DeploymentGroup_DeploymentGroupState `protobuf:"varint,4,opt,name=state,proto3,enum=types.DeploymentGroup_DeploymentGroupState" json:"state,omitempty"`
	Requirements []ProviderAttribute                  `protobuf:"bytes,5,rep,name=requirements" json:"requirements"`
	Resources    []ResourceGroup                      `protobuf:"bytes,6,rep,name=resources" json:"resources"`
}

func (m *DeploymentGroup) Reset()                    { *m = DeploymentGroup{} }
func (m *DeploymentGroup) String() string            { return proto.CompactTextString(m) }
func (*DeploymentGroup) ProtoMessage()               {}
func (*DeploymentGroup) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{13} }

func (m *DeploymentGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeploymentGroup) GetOrderTTL() int64 {
	if m != nil {
		return m.OrderTTL
	}
	return 0
}

func (m *DeploymentGroup) GetState() DeploymentGroup_DeploymentGroupState {
	if m != nil {
		return m.State
	}
	return DeploymentGroup_OPEN
}

func (m *DeploymentGroup) GetRequirements() []ProviderAttribute {
	if m != nil {
		return m.Requirements
	}
	return nil
}

func (m *DeploymentGroup) GetResources() []ResourceGroup {
	if m != nil {
		return m.Resources
	}
	return nil
}

type DeploymentGroups struct {
	Items []*DeploymentGroup `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
}

func (m *DeploymentGroups) Reset()                    { *m = DeploymentGroups{} }
func (m *DeploymentGroups) String() string            { return proto.CompactTextString(m) }
func (*DeploymentGroups) ProtoMessage()               {}
func (*DeploymentGroups) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{14} }

func (m *DeploymentGroups) GetItems() []*DeploymentGroup {
	if m != nil {
		return m.Items
	}
	return nil
}

type Deployment struct {
	// BEGIN ID FIELDS
	Address github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=address,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"address"`
	Tenant  github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,2,opt,name=tenant,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"tenant"`
	State   Deployment_DeploymentState               `protobuf:"varint,3,opt,name=state,proto3,enum=types.Deployment_DeploymentState" json:"state,omitempty"`
	Version github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,4,opt,name=version,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"version"`
}

func (m *Deployment) Reset()                    { *m = Deployment{} }
func (m *Deployment) String() string            { return proto.CompactTextString(m) }
func (*Deployment) ProtoMessage()               {}
func (*Deployment) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{15} }

func (m *Deployment) GetState() Deployment_DeploymentState {
	if m != nil {
		return m.State
	}
	return Deployment_ACTIVE
}

type Deployments struct {
	Items []Deployment `protobuf:"bytes,1,rep,name=items" json:"items"`
}

func (m *Deployments) Reset()                    { *m = Deployments{} }
func (m *Deployments) String() string            { return proto.CompactTextString(m) }
func (*Deployments) ProtoMessage()               {}
func (*Deployments) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{16} }

func (m *Deployments) GetItems() []Deployment {
	if m != nil {
		return m.Items
	}
	return nil
}

type TxCreateDeployment struct {
	Tenant   github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=tenant,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"tenant"`
	Nonce    uint64                                   `protobuf:"varint,2,opt,name=nonce,proto3" json:"nonce,omitempty"`
	OrderTTL int64                                    `protobuf:"varint,3,opt,name=orderTTL,proto3" json:"orderTTL,omitempty"`
	Version  github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,4,opt,name=version,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"version"`
	Groups   []*GroupSpec                             `protobuf:"bytes,5,rep,name=groups" json:"groups,omitempty"`
}

func (m *TxCreateDeployment) Reset()                    { *m = TxCreateDeployment{} }
func (m *TxCreateDeployment) String() string            { return proto.CompactTextString(m) }
func (*TxCreateDeployment) ProtoMessage()               {}
func (*TxCreateDeployment) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{17} }

func (m *TxCreateDeployment) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

func (m *TxCreateDeployment) GetOrderTTL() int64 {
	if m != nil {
		return m.OrderTTL
	}
	return 0
}

func (m *TxCreateDeployment) GetGroups() []*GroupSpec {
	if m != nil {
		return m.Groups
	}
	return nil
}

type TxUpdateDeployment struct {
	Deployment github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=deployment,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"deployment"`
	Version    github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,2,opt,name=version,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"version"`
}

func (m *TxUpdateDeployment) Reset()                    { *m = TxUpdateDeployment{} }
func (m *TxUpdateDeployment) String() string            { return proto.CompactTextString(m) }
func (*TxUpdateDeployment) ProtoMessage()               {}
func (*TxUpdateDeployment) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{18} }

type TxCloseDeployment struct {
	// deployment address
	Deployment github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=deployment,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"deployment"`
	Reason     TxCloseDeployment_ReasonCode             `protobuf:"varint,2,opt,name=reason,proto3,enum=types.TxCloseDeployment_ReasonCode" json:"reason,omitempty"`
}

func (m *TxCloseDeployment) Reset()                    { *m = TxCloseDeployment{} }
func (m *TxCloseDeployment) String() string            { return proto.CompactTextString(m) }
func (*TxCloseDeployment) ProtoMessage()               {}
func (*TxCloseDeployment) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{19} }

func (m *TxCloseDeployment) GetReason() TxCloseDeployment_ReasonCode {
	if m != nil {
		return m.Reason
	}
	return TxCloseDeployment_UNSET
}

type OrderID struct {
	// deployment
	Deployment github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=deployment,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"deployment"`
	// deployment group sequence
	Group uint64 `protobuf:"varint,2,opt,name=group,proto3" json:"group,omitempty"`
	// order sequence
	Seq uint64 `protobuf:"varint,3,opt,name=seq,proto3" json:"seq,omitempty"`
}

func (m *OrderID) Reset()                    { *m = OrderID{} }
func (*OrderID) ProtoMessage()               {}
func (*OrderID) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{20} }

func (m *OrderID) GetGroup() uint64 {
	if m != nil {
		return m.Group
	}
	return 0
}

func (m *OrderID) GetSeq() uint64 {
	if m != nil {
		return m.Seq
	}
	return 0
}

type Order struct {
	OrderID `protobuf:"bytes,1,opt,name=id,embedded=id" json:"id"`
	// maximum block number order can be open
	EndAt int64            `protobuf:"varint,2,opt,name=endAt,proto3" json:"endAt,omitempty"`
	State Order_OrderState `protobuf:"varint,3,opt,name=state,proto3,enum=types.Order_OrderState" json:"state,omitempty"`
}

func (m *Order) Reset()                    { *m = Order{} }
func (m *Order) String() string            { return proto.CompactTextString(m) }
func (*Order) ProtoMessage()               {}
func (*Order) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{21} }

func (m *Order) GetEndAt() int64 {
	if m != nil {
		return m.EndAt
	}
	return 0
}

func (m *Order) GetState() Order_OrderState {
	if m != nil {
		return m.State
	}
	return Order_OPEN
}

type TxCreateOrder struct {
	OrderID `protobuf:"bytes,1,opt,name=id,embedded=id" json:"id"`
	// maximum block number order can be open
	EndAt int64 `protobuf:"varint,2,opt,name=endAt,proto3" json:"endAt,omitempty"`
}

func (m *TxCreateOrder) Reset()                    { *m = TxCreateOrder{} }
func (m *TxCreateOrder) String() string            { return proto.CompactTextString(m) }
func (*TxCreateOrder) ProtoMessage()               {}
func (*TxCreateOrder) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{22} }

func (m *TxCreateOrder) GetEndAt() int64 {
	if m != nil {
		return m.EndAt
	}
	return 0
}

type Orders struct {
	Items []*Order `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
}

func (m *Orders) Reset()                    { *m = Orders{} }
func (m *Orders) String() string            { return proto.CompactTextString(m) }
func (*Orders) ProtoMessage()               {}
func (*Orders) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{23} }

func (m *Orders) GetItems() []*Order {
	if m != nil {
		return m.Items
	}
	return nil
}

type FulfillmentID struct {
	// deployment address
	Deployment github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=deployment,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"deployment"`
	// deployment group sequence
	Group uint64 `protobuf:"varint,2,opt,name=group,proto3" json:"group,omitempty"`
	// order sequence
	Order uint64 `protobuf:"varint,3,opt,name=order,proto3" json:"order,omitempty"`
	// provider address
	Provider github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,4,opt,name=provider,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"provider"`
}

func (m *FulfillmentID) Reset()                    { *m = FulfillmentID{} }
func (*FulfillmentID) ProtoMessage()               {}
func (*FulfillmentID) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{24} }

func (m *FulfillmentID) GetGroup() uint64 {
	if m != nil {
		return m.Group
	}
	return 0
}

func (m *FulfillmentID) GetOrder() uint64 {
	if m != nil {
		return m.Order
	}
	return 0
}

type Fulfillment struct {
	FulfillmentID `protobuf:"bytes,1,opt,name=id,embedded=id" json:"id"`
	Price         uint64                       `protobuf:"varint,2,opt,name=price,proto3" json:"price,omitempty"`
	State         Fulfillment_FulfillmentState `protobuf:"varint,3,opt,name=state,proto3,enum=types.Fulfillment_FulfillmentState" json:"state,omitempty"`
}

func (m *Fulfillment) Reset()                    { *m = Fulfillment{} }
func (m *Fulfillment) String() string            { return proto.CompactTextString(m) }
func (*Fulfillment) ProtoMessage()               {}
func (*Fulfillment) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{25} }

func (m *Fulfillment) GetPrice() uint64 {
	if m != nil {
		return m.Price
	}
	return 0
}

func (m *Fulfillment) GetState() Fulfillment_FulfillmentState {
	if m != nil {
		return m.State
	}
	return Fulfillment_OPEN
}

type Fulfillments struct {
	Items []*Fulfillment `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
}

func (m *Fulfillments) Reset()                    { *m = Fulfillments{} }
func (m *Fulfillments) String() string            { return proto.CompactTextString(m) }
func (*Fulfillments) ProtoMessage()               {}
func (*Fulfillments) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{26} }

func (m *Fulfillments) GetItems() []*Fulfillment {
	if m != nil {
		return m.Items
	}
	return nil
}

type TxCreateFulfillment struct {
	FulfillmentID `protobuf:"bytes,1,opt,name=id,embedded=id" json:"id"`
	Price         uint64 `protobuf:"varint,2,opt,name=price,proto3" json:"price,omitempty"`
}

func (m *TxCreateFulfillment) Reset()                    { *m = TxCreateFulfillment{} }
func (m *TxCreateFulfillment) String() string            { return proto.CompactTextString(m) }
func (*TxCreateFulfillment) ProtoMessage()               {}
func (*TxCreateFulfillment) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{27} }

func (m *TxCreateFulfillment) GetPrice() uint64 {
	if m != nil {
		return m.Price
	}
	return 0
}

type TxCloseFulfillment struct {
	FulfillmentID `protobuf:"bytes,1,opt,name=id,embedded=id" json:"id"`
}

func (m *TxCloseFulfillment) Reset()                    { *m = TxCloseFulfillment{} }
func (m *TxCloseFulfillment) String() string            { return proto.CompactTextString(m) }
func (*TxCloseFulfillment) ProtoMessage()               {}
func (*TxCloseFulfillment) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{28} }

type LeaseID struct {
	// deployment address
	Deployment github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=deployment,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"deployment"`
	// deployment group sequence
	Group uint64 `protobuf:"varint,2,opt,name=group,proto3" json:"group,omitempty"`
	// order sequence
	Order uint64 `protobuf:"varint,3,opt,name=order,proto3" json:"order,omitempty"`
	// provider address
	Provider github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,4,opt,name=provider,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"provider"`
}

func (m *LeaseID) Reset()                    { *m = LeaseID{} }
func (*LeaseID) ProtoMessage()               {}
func (*LeaseID) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{29} }

func (m *LeaseID) GetGroup() uint64 {
	if m != nil {
		return m.Group
	}
	return 0
}

func (m *LeaseID) GetOrder() uint64 {
	if m != nil {
		return m.Order
	}
	return 0
}

type Lease struct {
	LeaseID `protobuf:"bytes,1,opt,name=id,embedded=id" json:"id"`
	// price of matching fulfillment
	Price uint64           `protobuf:"varint,2,opt,name=price,proto3" json:"price,omitempty"`
	State Lease_LeaseState `protobuf:"varint,3,opt,name=state,proto3,enum=types.Lease_LeaseState" json:"state,omitempty"`
}

func (m *Lease) Reset()                    { *m = Lease{} }
func (m *Lease) String() string            { return proto.CompactTextString(m) }
func (*Lease) ProtoMessage()               {}
func (*Lease) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{30} }

func (m *Lease) GetPrice() uint64 {
	if m != nil {
		return m.Price
	}
	return 0
}

func (m *Lease) GetState() Lease_LeaseState {
	if m != nil {
		return m.State
	}
	return Lease_ACTIVE
}

type TxCreateLease struct {
	LeaseID `protobuf:"bytes,1,opt,name=id,embedded=id" json:"id"`
	// price of matching fulfillment
	Price uint64 `protobuf:"varint,2,opt,name=price,proto3" json:"price,omitempty"`
}

func (m *TxCreateLease) Reset()                    { *m = TxCreateLease{} }
func (m *TxCreateLease) String() string            { return proto.CompactTextString(m) }
func (*TxCreateLease) ProtoMessage()               {}
func (*TxCreateLease) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{31} }

func (m *TxCreateLease) GetPrice() uint64 {
	if m != nil {
		return m.Price
	}
	return 0
}

type TxCloseLease struct {
	LeaseID `protobuf:"bytes,1,opt,name=id,embedded=id" json:"id"`
}

func (m *TxCloseLease) Reset()                    { *m = TxCloseLease{} }
func (m *TxCloseLease) String() string            { return proto.CompactTextString(m) }
func (*TxCloseLease) ProtoMessage()               {}
func (*TxCloseLease) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{32} }

type Leases struct {
	Items []*Lease `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
}

func (m *Leases) Reset()                    { *m = Leases{} }
func (m *Leases) String() string            { return proto.CompactTextString(m) }
func (*Leases) ProtoMessage()               {}
func (*Leases) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{33} }

func (m *Leases) GetItems() []*Lease {
	if m != nil {
		return m.Items
	}
	return nil
}

type ManifestRequest struct {
	Key        github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=key,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"key"`
	Signature  github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,2,opt,name=signature,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"signature"`
	Deployment github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,3,opt,name=deployment,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"deployment"`
	Manifest   *Manifest                                `protobuf:"bytes,4,opt,name=manifest" json:"manifest,omitempty"`
}

func (m *ManifestRequest) Reset()                    { *m = ManifestRequest{} }
func (m *ManifestRequest) String() string            { return proto.CompactTextString(m) }
func (*ManifestRequest) ProtoMessage()               {}
func (*ManifestRequest) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{34} }

func (m *ManifestRequest) GetManifest() *Manifest {
	if m != nil {
		return m.Manifest
	}
	return nil
}

type Manifest struct {
	Groups []*ManifestGroup `protobuf:"bytes,1,rep,name=groups" json:"groups,omitempty"`
}

func (m *Manifest) Reset()                    { *m = Manifest{} }
func (m *Manifest) String() string            { return proto.CompactTextString(m) }
func (*Manifest) ProtoMessage()               {}
func (*Manifest) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{35} }

func (m *Manifest) GetGroups() []*ManifestGroup {
	if m != nil {
		return m.Groups
	}
	return nil
}

type ManifestGroup struct {
	// Placement profile name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Service definitions
	Services []*ManifestService `protobuf:"bytes,2,rep,name=services" json:"services,omitempty"`
}

func (m *ManifestGroup) Reset()                    { *m = ManifestGroup{} }
func (m *ManifestGroup) String() string            { return proto.CompactTextString(m) }
func (*ManifestGroup) ProtoMessage()               {}
func (*ManifestGroup) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{36} }

func (m *ManifestGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ManifestGroup) GetServices() []*ManifestService {
	if m != nil {
		return m.Services
	}
	return nil
}

type ManifestService struct {
	// Service name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Docker image
	Image string   `protobuf:"bytes,2,opt,name=image,proto3" json:"image,omitempty"`
	Args  []string `protobuf:"bytes,3,rep,name=args" json:"args,omitempty"`
	Env   []string `protobuf:"bytes,4,rep,name=env" json:"env,omitempty"`
	// Resource requirements
	Unit *ResourceUnit `protobuf:"bytes,5,opt,name=unit" json:"unit,omitempty"`
	// Number of instances
	Count uint32 `protobuf:"varint,6,opt,name=count,proto3" json:"count,omitempty"`
	// Overlay Network Links
	Expose []*ManifestServiceExpose `protobuf:"bytes,7,rep,name=expose" json:"expose,omitempty"`
}

func (m *ManifestService) Reset()                    { *m = ManifestService{} }
func (m *ManifestService) String() string            { return proto.CompactTextString(m) }
func (*ManifestService) ProtoMessage()               {}
func (*ManifestService) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{37} }

func (m *ManifestService) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ManifestService) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *ManifestService) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *ManifestService) GetEnv() []string {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *ManifestService) GetUnit() *ResourceUnit {
	if m != nil {
		return m.Unit
	}
	return nil
}

func (m *ManifestService) GetCount() uint32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *ManifestService) GetExpose() []*ManifestServiceExpose {
	if m != nil {
		return m.Expose
	}
	return nil
}

type ManifestServiceExpose struct {
	Port         uint32 `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	ExternalPort uint32 `protobuf:"varint,2,opt,name=externalPort,proto3" json:"externalPort,omitempty"`
	Proto        string `protobuf:"bytes,3,opt,name=proto,proto3" json:"proto,omitempty"`
	Service      string `protobuf:"bytes,4,opt,name=service,proto3" json:"service,omitempty"`
	Global       bool   `protobuf:"varint,5,opt,name=global,proto3" json:"global,omitempty"`
	// accepted hostnames
	Hosts []string `protobuf:"bytes,6,rep,name=hosts" json:"hosts,omitempty"`
}

func (m *ManifestServiceExpose) Reset()                    { *m = ManifestServiceExpose{} }
func (m *ManifestServiceExpose) String() string            { return proto.CompactTextString(m) }
func (*ManifestServiceExpose) ProtoMessage()               {}
func (*ManifestServiceExpose) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{38} }

func (m *ManifestServiceExpose) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *ManifestServiceExpose) GetExternalPort() uint32 {
	if m != nil {
		return m.ExternalPort
	}
	return 0
}

func (m *ManifestServiceExpose) GetProto() string {
	if m != nil {
		return m.Proto
	}
	return ""
}

func (m *ManifestServiceExpose) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *ManifestServiceExpose) GetGlobal() bool {
	if m != nil {
		return m.Global
	}
	return false
}

func (m *ManifestServiceExpose) GetHosts() []string {
	if m != nil {
		return m.Hosts
	}
	return nil
}

type Empty struct {
}

func (m *Empty) Reset()                    { *m = Empty{} }
func (m *Empty) String() string            { return proto.CompactTextString(m) }
func (*Empty) ProtoMessage()               {}
func (*Empty) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{39} }

type AkashVersion struct {
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	Commit  string `protobuf:"bytes,2,opt,name=commit,proto3" json:"commit,omitempty"`
	Date    string `protobuf:"bytes,3,opt,name=date,proto3" json:"date,omitempty"`
}

func (m *AkashVersion) Reset()                    { *m = AkashVersion{} }
func (m *AkashVersion) String() string            { return proto.CompactTextString(m) }
func (*AkashVersion) ProtoMessage()               {}
func (*AkashVersion) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{40} }

func (m *AkashVersion) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *AkashVersion) GetCommit() string {
	if m != nil {
		return m.Commit
	}
	return ""
}

func (m *AkashVersion) GetDate() string {
	if m != nil {
		return m.Date
	}
	return ""
}

type ServerStatus struct {
	Provider github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=provider,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"provider"`
	Version  *AkashVersion                            `protobuf:"bytes,2,opt,name=version" json:"version"`
	Status   *ProviderStatus                          `protobuf:"bytes,3,opt,name=status" json:"status"`
	Code     int32                                    `protobuf:"varint,4,opt,name=code,proto3" json:"code,omitempty"`
	Message  string                                   `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *ServerStatus) Reset()                    { *m = ServerStatus{} }
func (m *ServerStatus) String() string            { return proto.CompactTextString(m) }
func (*ServerStatus) ProtoMessage()               {}
func (*ServerStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{41} }

func (m *ServerStatus) GetVersion() *AkashVersion {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *ServerStatus) GetStatus() *ProviderStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *ServerStatus) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *ServerStatus) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type ServerStatusParseable struct {
	Provider github_com_ovrclk_akash_types_base.Bytes `protobuf:"bytes,1,opt,name=provider,proto3,customtype=github.com/ovrclk/akash/types/base.Bytes" json:"provider"`
	Version  *AkashVersion                            `protobuf:"bytes,2,opt,name=version" json:"version"`
	Status   *ServerStatusParseable_ProviderStatus    `protobuf:"bytes,3,opt,name=status" json:"status"`
	Code     int32                                    `protobuf:"varint,4,opt,name=code,proto3" json:"code,omitempty"`
	Message  string                                   `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *ServerStatusParseable) Reset()                    { *m = ServerStatusParseable{} }
func (m *ServerStatusParseable) String() string            { return proto.CompactTextString(m) }
func (*ServerStatusParseable) ProtoMessage()               {}
func (*ServerStatusParseable) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{42} }

func (m *ServerStatusParseable) GetVersion() *AkashVersion {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *ServerStatusParseable) GetStatus() *ServerStatusParseable_ProviderStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *ServerStatusParseable) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *ServerStatusParseable) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type ServerStatusParseable_ProviderStatus struct {
	Cluster   *ServerStatusParseable_ProviderClusterStatus `protobuf:"bytes,1,opt,name=cluster" json:"cluster,omitempty"`
	Manifest  *ProviderManifestStatus                      `protobuf:"bytes,2,opt,name=manifest" json:"manifest,omitempty"`
	Bidengine *ProviderBidengineStatus                     `protobuf:"bytes,3,opt,name=bidengine" json:"bidengine,omitempty"`
}

func (m *ServerStatusParseable_ProviderStatus) Reset()         { *m = ServerStatusParseable_ProviderStatus{} }
func (m *ServerStatusParseable_ProviderStatus) String() string { return proto.CompactTextString(m) }
func (*ServerStatusParseable_ProviderStatus) ProtoMessage()    {}
func (*ServerStatusParseable_ProviderStatus) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{42, 0}
}

func (m *ServerStatusParseable_ProviderStatus) GetCluster() *ServerStatusParseable_ProviderClusterStatus {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *ServerStatusParseable_ProviderStatus) GetManifest() *ProviderManifestStatus {
	if m != nil {
		return m.Manifest
	}
	return nil
}

func (m *ServerStatusParseable_ProviderStatus) GetBidengine() *ProviderBidengineStatus {
	if m != nil {
		return m.Bidengine
	}
	return nil
}

type ServerStatusParseable_ProviderClusterStatus struct {
	Leases    uint32                                         `protobuf:"varint,1,opt,name=leases,proto3" json:"leases,omitempty"`
	Inventory *ServerStatusParseable_ProviderInventoryStatus `protobuf:"bytes,2,opt,name=inventory" json:"inventory,omitempty"`
}

func (m *ServerStatusParseable_ProviderClusterStatus) Reset() {
	*m = ServerStatusParseable_ProviderClusterStatus{}
}
func (m *ServerStatusParseable_ProviderClusterStatus) String() string {
	return proto.CompactTextString(m)
}
func (*ServerStatusParseable_ProviderClusterStatus) ProtoMessage() {}
func (*ServerStatusParseable_ProviderClusterStatus) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{42, 1}
}

func (m *ServerStatusParseable_ProviderClusterStatus) GetLeases() uint32 {
	if m != nil {
		return m.Leases
	}
	return 0
}

func (m *ServerStatusParseable_ProviderClusterStatus) GetInventory() *ServerStatusParseable_ProviderInventoryStatus {
	if m != nil {
		return m.Inventory
	}
	return nil
}

type ServerStatusParseable_ProviderInventoryStatus struct {
	Reservations *ServerStatusParseable_ProviderInventoryStatus_Reservations   `protobuf:"bytes,1,opt,name=reservations" json:"reservations,omitempty"`
	Available    []*ServerStatusParseable_ProviderInventoryStatus_ResourceUnit `protobuf:"bytes,2,rep,name=available" json:"available,omitempty"`
}

func (m *ServerStatusParseable_ProviderInventoryStatus) Reset() {
	*m = ServerStatusParseable_ProviderInventoryStatus{}
}
func (m *ServerStatusParseable_ProviderInventoryStatus) String() string {
	return proto.CompactTextString(m)
}
func (*ServerStatusParseable_ProviderInventoryStatus) ProtoMessage() {}
func (*ServerStatusParseable_ProviderInventoryStatus) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{42, 2}
}

func (m *ServerStatusParseable_ProviderInventoryStatus) GetReservations() *ServerStatusParseable_ProviderInventoryStatus_Reservations {
	if m != nil {
		return m.Reservations
	}
	return nil
}

func (m *ServerStatusParseable_ProviderInventoryStatus) GetAvailable() []*ServerStatusParseable_ProviderInventoryStatus_ResourceUnit {
	if m != nil {
		return m.Available
	}
	return nil
}

type ServerStatusParseable_ProviderInventoryStatus_ResourceUnit struct {
	CPU    uint32 `protobuf:"varint,1,opt,name=CPU,proto3" json:"cpu"`
	Memory string `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
	Disk   string `protobuf:"bytes,3,opt,name=disk,proto3" json:"disk,omitempty"`
}

func (m *ServerStatusParseable_ProviderInventoryStatus_ResourceUnit) Reset() {
	*m = ServerStatusParseable_ProviderInventoryStatus_ResourceUnit{}
}
func (m *ServerStatusParseable_ProviderInventoryStatus_ResourceUnit) String() string {
	return proto.CompactTextString(m)
}
func (*ServerStatusParseable_ProviderInventoryStatus_ResourceUnit) ProtoMessage() {}
func (*ServerStatusParseable_ProviderInventoryStatus_ResourceUnit) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{42, 2, 0}
}

func (m *ServerStatusParseable_ProviderInventoryStatus_ResourceUnit) GetCPU() uint32 {
	if m != nil {
		return m.CPU
	}
	return 0
}

func (m *ServerStatusParseable_ProviderInventoryStatus_ResourceUnit) GetMemory() string {
	if m != nil {
		return m.Memory
	}
	return ""
}

func (m *ServerStatusParseable_ProviderInventoryStatus_ResourceUnit) GetDisk() string {
	if m != nil {
		return m.Disk
	}
	return ""
}

type ServerStatusParseable_ProviderInventoryStatus_Reservations struct {
	Active  []*ServerStatusParseable_ProviderInventoryStatus_ResourceUnit `protobuf:"bytes,1,rep,name=active" json:"active,omitempty"`
	Pending []*ServerStatusParseable_ProviderInventoryStatus_ResourceUnit `protobuf:"bytes,2,rep,name=pending" json:"pending,omitempty"`
}

func (m *ServerStatusParseable_ProviderInventoryStatus_Reservations) Reset() {
	*m = ServerStatusParseable_ProviderInventoryStatus_Reservations{}
}
func (m *ServerStatusParseable_ProviderInventoryStatus_Reservations) String() string {
	return proto.CompactTextString(m)
}
func (*ServerStatusParseable_ProviderInventoryStatus_Reservations) ProtoMessage() {}
func (*ServerStatusParseable_ProviderInventoryStatus_Reservations) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{42, 2, 1}
}

func (m *ServerStatusParseable_ProviderInventoryStatus_Reservations) GetActive() []*ServerStatusParseable_ProviderInventoryStatus_ResourceUnit {
	if m != nil {
		return m.Active
	}
	return nil
}

func (m *ServerStatusParseable_ProviderInventoryStatus_Reservations) GetPending() []*ServerStatusParseable_ProviderInventoryStatus_ResourceUnit {
	if m != nil {
		return m.Pending
	}
	return nil
}

type ProviderStatus struct {
	Cluster   *ProviderClusterStatus   `protobuf:"bytes,1,opt,name=cluster" json:"cluster,omitempty"`
	Manifest  *ProviderManifestStatus  `protobuf:"bytes,2,opt,name=manifest" json:"manifest,omitempty"`
	Bidengine *ProviderBidengineStatus `protobuf:"bytes,3,opt,name=bidengine" json:"bidengine,omitempty"`
}

func (m *ProviderStatus) Reset()                    { *m = ProviderStatus{} }
func (m *ProviderStatus) String() string            { return proto.CompactTextString(m) }
func (*ProviderStatus) ProtoMessage()               {}
func (*ProviderStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{43} }

func (m *ProviderStatus) GetCluster() *ProviderClusterStatus {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *ProviderStatus) GetManifest() *ProviderManifestStatus {
	if m != nil {
		return m.Manifest
	}
	return nil
}

func (m *ProviderStatus) GetBidengine() *ProviderBidengineStatus {
	if m != nil {
		return m.Bidengine
	}
	return nil
}

type ProviderManifestStatus struct {
	Deployments uint32 `protobuf:"varint,1,opt,name=deployments,proto3" json:"deployments,omitempty"`
}

func (m *ProviderManifestStatus) Reset()                    { *m = ProviderManifestStatus{} }
func (m *ProviderManifestStatus) String() string            { return proto.CompactTextString(m) }
func (*ProviderManifestStatus) ProtoMessage()               {}
func (*ProviderManifestStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{44} }

func (m *ProviderManifestStatus) GetDeployments() uint32 {
	if m != nil {
		return m.Deployments
	}
	return 0
}

type ProviderBidengineStatus struct {
	Orders uint32 `protobuf:"varint,1,opt,name=orders,proto3" json:"orders,omitempty"`
}

func (m *ProviderBidengineStatus) Reset()                    { *m = ProviderBidengineStatus{} }
func (m *ProviderBidengineStatus) String() string            { return proto.CompactTextString(m) }
func (*ProviderBidengineStatus) ProtoMessage()               {}
func (*ProviderBidengineStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{45} }

func (m *ProviderBidengineStatus) GetOrders() uint32 {
	if m != nil {
		return m.Orders
	}
	return 0
}

type ProviderClusterStatus struct {
	Leases    uint32                   `protobuf:"varint,1,opt,name=leases,proto3" json:"leases,omitempty"`
	Inventory *ProviderInventoryStatus `protobuf:"bytes,2,opt,name=inventory" json:"inventory,omitempty"`
}

func (m *ProviderClusterStatus) Reset()                    { *m = ProviderClusterStatus{} }
func (m *ProviderClusterStatus) String() string            { return proto.CompactTextString(m) }
func (*ProviderClusterStatus) ProtoMessage()               {}
func (*ProviderClusterStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{46} }

func (m *ProviderClusterStatus) GetLeases() uint32 {
	if m != nil {
		return m.Leases
	}
	return 0
}

func (m *ProviderClusterStatus) GetInventory() *ProviderInventoryStatus {
	if m != nil {
		return m.Inventory
	}
	return nil
}

type ProviderInventoryStatus struct {
	Reservations *ProviderInventoryStatus_Reservations `protobuf:"bytes,1,opt,name=reservations" json:"reservations,omitempty"`
	Available    []*ResourceUnit                       `protobuf:"bytes,2,rep,name=available" json:"available,omitempty"`
}

func (m *ProviderInventoryStatus) Reset()                    { *m = ProviderInventoryStatus{} }
func (m *ProviderInventoryStatus) String() string            { return proto.CompactTextString(m) }
func (*ProviderInventoryStatus) ProtoMessage()               {}
func (*ProviderInventoryStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{47} }

func (m *ProviderInventoryStatus) GetReservations() *ProviderInventoryStatus_Reservations {
	if m != nil {
		return m.Reservations
	}
	return nil
}

func (m *ProviderInventoryStatus) GetAvailable() []*ResourceUnit {
	if m != nil {
		return m.Available
	}
	return nil
}

type ProviderInventoryStatus_Resource struct {
	CPU    uint32 `protobuf:"varint,1,opt,name=CPU,proto3" json:"cpu"`
	Memory uint32 `protobuf:"varint,2,opt,name=memory,proto3" json:"memory,omitempty"`
	Disk   uint32 `protobuf:"varint,3,opt,name=disk,proto3" json:"disk,omitempty"`
}

func (m *ProviderInventoryStatus_Resource) Reset()         { *m = ProviderInventoryStatus_Resource{} }
func (m *ProviderInventoryStatus_Resource) String() string { return proto.CompactTextString(m) }
func (*ProviderInventoryStatus_Resource) ProtoMessage()    {}
func (*ProviderInventoryStatus_Resource) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{47, 0}
}

func (m *ProviderInventoryStatus_Resource) GetCPU() uint32 {
	if m != nil {
		return m.CPU
	}
	return 0
}

func (m *ProviderInventoryStatus_Resource) GetMemory() uint32 {
	if m != nil {
		return m.Memory
	}
	return 0
}

func (m *ProviderInventoryStatus_Resource) GetDisk() uint32 {
	if m != nil {
		return m.Disk
	}
	return 0
}

type ProviderInventoryStatus_Reservations struct {
	Active  []*ResourceUnit `protobuf:"bytes,1,rep,name=active" json:"active,omitempty"`
	Pending []*ResourceUnit `protobuf:"bytes,2,rep,name=pending" json:"pending,omitempty"`
}

func (m *ProviderInventoryStatus_Reservations) Reset()         { *m = ProviderInventoryStatus_Reservations{} }
func (m *ProviderInventoryStatus_Reservations) String() string { return proto.CompactTextString(m) }
func (*ProviderInventoryStatus_Reservations) ProtoMessage()    {}
func (*ProviderInventoryStatus_Reservations) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{47, 1}
}

func (m *ProviderInventoryStatus_Reservations) GetActive() []*ResourceUnit {
	if m != nil {
		return m.Active
	}
	return nil
}

func (m *ProviderInventoryStatus_Reservations) GetPending() []*ResourceUnit {
	if m != nil {
		return m.Pending
	}
	return nil
}

type DeployRespone struct {
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *DeployRespone) Reset()                    { *m = DeployRespone{} }
func (m *DeployRespone) String() string            { return proto.CompactTextString(m) }
func (*DeployRespone) ProtoMessage()               {}
func (*DeployRespone) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{48} }

func (m *DeployRespone) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type LeaseStatusRequest struct {
	Deployment string `protobuf:"bytes,1,opt,name=deployment,proto3" json:"deployment,omitempty"`
	Group      string `protobuf:"bytes,2,opt,name=group,proto3" json:"group,omitempty"`
	Order      string `protobuf:"bytes,3,opt,name=order,proto3" json:"order,omitempty"`
	Provider   string `protobuf:"bytes,4,opt,name=provider,proto3" json:"provider,omitempty"`
}

func (m *LeaseStatusRequest) Reset()                    { *m = LeaseStatusRequest{} }
func (m *LeaseStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*LeaseStatusRequest) ProtoMessage()               {}
func (*LeaseStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{49} }

func (m *LeaseStatusRequest) GetDeployment() string {
	if m != nil {
		return m.Deployment
	}
	return ""
}

func (m *LeaseStatusRequest) GetGroup() string {
	if m != nil {
		return m.Group
	}
	return ""
}

func (m *LeaseStatusRequest) GetOrder() string {
	if m != nil {
		return m.Order
	}
	return ""
}

func (m *LeaseStatusRequest) GetProvider() string {
	if m != nil {
		return m.Provider
	}
	return ""
}

type ServiceStatusRequest struct {
	Name       string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Deployment string `protobuf:"bytes,2,opt,name=deployment,proto3" json:"deployment,omitempty"`
	Group      string `protobuf:"bytes,3,opt,name=group,proto3" json:"group,omitempty"`
	Order      string `protobuf:"bytes,4,opt,name=order,proto3" json:"order,omitempty"`
	Provider   string `protobuf:"bytes,5,opt,name=provider,proto3" json:"provider,omitempty"`
}

func (m *ServiceStatusRequest) Reset()                    { *m = ServiceStatusRequest{} }
func (m *ServiceStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*ServiceStatusRequest) ProtoMessage()               {}
func (*ServiceStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{50} }

func (m *ServiceStatusRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ServiceStatusRequest) GetDeployment() string {
	if m != nil {
		return m.Deployment
	}
	return ""
}

func (m *ServiceStatusRequest) GetGroup() string {
	if m != nil {
		return m.Group
	}
	return ""
}

func (m *ServiceStatusRequest) GetOrder() string {
	if m != nil {
		return m.Order
	}
	return ""
}

func (m *ServiceStatusRequest) GetProvider() string {
	if m != nil {
		return m.Provider
	}
	return ""
}

type ServiceStatusResponse struct {
	ObservedGeneration int64 `protobuf:"varint,1,opt,name=observedGeneration,proto3" json:"observedGeneration,omitempty"`
	Replicas           int32 `protobuf:"varint,2,opt,name=replicas,proto3" json:"replicas,omitempty"`
	UpdatedReplicas    int32 `protobuf:"varint,3,opt,name=updatedReplicas,proto3" json:"updatedReplicas,omitempty"`
	ReadyReplicas      int32 `protobuf:"varint,4,opt,name=readyReplicas,proto3" json:"readyReplicas,omitempty"`
	AvailableReplicas  int32 `protobuf:"varint,5,opt,name=availableReplicas,proto3" json:"availableReplicas,omitempty"`
}

func (m *ServiceStatusResponse) Reset()                    { *m = ServiceStatusResponse{} }
func (m *ServiceStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*ServiceStatusResponse) ProtoMessage()               {}
func (*ServiceStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{51} }

func (m *ServiceStatusResponse) GetObservedGeneration() int64 {
	if m != nil {
		return m.ObservedGeneration
	}
	return 0
}

func (m *ServiceStatusResponse) GetReplicas() int32 {
	if m != nil {
		return m.Replicas
	}
	return 0
}

func (m *ServiceStatusResponse) GetUpdatedReplicas() int32 {
	if m != nil {
		return m.UpdatedReplicas
	}
	return 0
}

func (m *ServiceStatusResponse) GetReadyReplicas() int32 {
	if m != nil {
		return m.ReadyReplicas
	}
	return 0
}

func (m *ServiceStatusResponse) GetAvailableReplicas() int32 {
	if m != nil {
		return m.AvailableReplicas
	}
	return 0
}

type LogRequest struct {
	Name       string      `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Deployment string      `protobuf:"bytes,2,opt,name=deployment,proto3" json:"deployment,omitempty"`
	Group      string      `protobuf:"bytes,3,opt,name=group,proto3" json:"group,omitempty"`
	Order      string      `protobuf:"bytes,4,opt,name=order,proto3" json:"order,omitempty"`
	Provider   string      `protobuf:"bytes,5,opt,name=provider,proto3" json:"provider,omitempty"`
	Options    *LogOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
}

func (m *LogRequest) Reset()                    { *m = LogRequest{} }
func (m *LogRequest) String() string            { return proto.CompactTextString(m) }
func (*LogRequest) ProtoMessage()               {}
func (*LogRequest) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{52} }

func (m *LogRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *LogRequest) GetDeployment() string {
	if m != nil {
		return m.Deployment
	}
	return ""
}

func (m *LogRequest) GetGroup() string {
	if m != nil {
		return m.Group
	}
	return ""
}

func (m *LogRequest) GetOrder() string {
	if m != nil {
		return m.Order
	}
	return ""
}

func (m *LogRequest) GetProvider() string {
	if m != nil {
		return m.Provider
	}
	return ""
}

func (m *LogRequest) GetOptions() *LogOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

type LogOptions struct {
	TailLines int64 `protobuf:"varint,1,opt,name=tailLines,proto3" json:"tailLines,omitempty"`
	Follow    bool  `protobuf:"varint,2,opt,name=follow,proto3" json:"follow,omitempty"`
}

func (m *LogOptions) Reset()                    { *m = LogOptions{} }
func (m *LogOptions) String() string            { return proto.CompactTextString(m) }
func (*LogOptions) ProtoMessage()               {}
func (*LogOptions) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{53} }

func (m *LogOptions) GetTailLines() int64 {
	if m != nil {
		return m.TailLines
	}
	return 0
}

func (m *LogOptions) GetFollow() bool {
	if m != nil {
		return m.Follow
	}
	return false
}

type Log struct {
	Name    string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *Log) Reset()                    { *m = Log{} }
func (m *Log) String() string            { return proto.CompactTextString(m) }
func (*Log) ProtoMessage()               {}
func (*Log) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{54} }

func (m *Log) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Log) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type LogResponse struct {
	Result *Log `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *LogResponse) Reset()                    { *m = LogResponse{} }
func (m *LogResponse) String() string            { return proto.CompactTextString(m) }
func (*LogResponse) ProtoMessage()               {}
func (*LogResponse) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{55} }

func (m *LogResponse) GetResult() *Log {
	if m != nil {
		return m.Result
	}
	return nil
}

type LeaseStatusResponse struct {
	Services []*ServiceStatus `protobuf:"bytes,1,rep,name=services" json:"services,omitempty"`
}

func (m *LeaseStatusResponse) Reset()                    { *m = LeaseStatusResponse{} }
func (m *LeaseStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*LeaseStatusResponse) ProtoMessage()               {}
func (*LeaseStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{56} }

func (m *LeaseStatusResponse) GetServices() []*ServiceStatus {
	if m != nil {
		return m.Services
	}
	return nil
}

type ServiceStatus struct {
	Name      string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	URIs      []string `protobuf:"bytes,2,rep,name=URIs" json:"URIs,omitempty"`
	Available int32    `protobuf:"varint,3,opt,name=available,proto3" json:"available,omitempty"`
	Total     int32    `protobuf:"varint,4,opt,name=total,proto3" json:"total,omitempty"`
}

func (m *ServiceStatus) Reset()                    { *m = ServiceStatus{} }
func (m *ServiceStatus) String() string            { return proto.CompactTextString(m) }
func (*ServiceStatus) ProtoMessage()               {}
func (*ServiceStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{57} }

func (m *ServiceStatus) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ServiceStatus) GetURIs() []string {
	if m != nil {
		return m.URIs
	}
	return nil
}

func (m *ServiceStatus) GetAvailable() int32 {
	if m != nil {
		return m.Available
	}
	return 0
}

func (m *ServiceStatus) GetTotal() int32 {
	if m != nil {
		return m.Total
	}
	return 0
}

type ManifestGetRequest struct {
	Lease []byte `protobuf:"bytes,1,opt,name=lease,proto3" json:"lease,omitempty"`
}

func (m *ManifestGetRequest) Reset()                    { *m = ManifestGetRequest{} }
func (m *ManifestGetRequest) String() string            { return proto.CompactTextString(m) }
func (*ManifestGetRequest) ProtoMessage()               {}
func (*ManifestGetRequest) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{58} }

func (m *ManifestGetRequest) GetLease() []byte {
	if m != nil {
		return m.Lease
	}
	return nil
}

type ManifestGetResponse struct {
	Manifest *Manifest `protobuf:"bytes,1,opt,name=manifest" json:"manifest,omitempty"`
}

func (m *ManifestGetResponse) Reset()                    { *m = ManifestGetResponse{} }
func (m *ManifestGetResponse) String() string            { return proto.CompactTextString(m) }
func (*ManifestGetResponse) ProtoMessage()               {}
func (*ManifestGetResponse) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{59} }

func (m *ManifestGetResponse) GetManifest() *Manifest {
	if m != nil {
		return m.Manifest
	}
	return nil
}

type ErrInvalidPayload struct {
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *ErrInvalidPayload) Reset()                    { *m = ErrInvalidPayload{} }
func (m *ErrInvalidPayload) String() string            { return proto.CompactTextString(m) }
func (*ErrInvalidPayload) ProtoMessage()               {}
func (*ErrInvalidPayload) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{60} }

func (m *ErrInvalidPayload) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type ErrInternalError struct {
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *ErrInternalError) Reset()                    { *m = ErrInternalError{} }
func (m *ErrInternalError) String() string            { return proto.CompactTextString(m) }
func (*ErrInternalError) ProtoMessage()               {}
func (*ErrInternalError) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{61} }

func (m *ErrInternalError) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type ErrResourceNotFound struct {
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *ErrResourceNotFound) Reset()                    { *m = ErrResourceNotFound{} }
func (m *ErrResourceNotFound) String() string            { return proto.CompactTextString(m) }
func (*ErrResourceNotFound) ProtoMessage()               {}
func (*ErrResourceNotFound) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{62} }

func (m *ErrResourceNotFound) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func init() {
	proto.RegisterType((*Genesis)(nil), "types.Genesis")
	proto.RegisterType((*Tx)(nil), "types.Tx")
	proto.RegisterType((*TxPayload)(nil), "types.TxPayload")
	proto.RegisterType((*Account)(nil), "types.Account")
	proto.RegisterType((*TxSend)(nil), "types.TxSend")
	proto.RegisterType((*Provider)(nil), "types.Provider")
	proto.RegisterType((*Providers)(nil), "types.Providers")
	proto.RegisterType((*TxCreateProvider)(nil), "types.TxCreateProvider")
	proto.RegisterType((*ResourceUnit)(nil), "types.ResourceUnit")
	proto.RegisterType((*ResourceGroup)(nil), "types.ResourceGroup")
	proto.RegisterType((*ProviderAttribute)(nil), "types.ProviderAttribute")
	proto.RegisterType((*GroupSpec)(nil), "types.GroupSpec")
	proto.RegisterType((*DeploymentGroupID)(nil), "types.DeploymentGroupID")
	proto.RegisterType((*DeploymentGroup)(nil), "types.DeploymentGroup")
	proto.RegisterType((*DeploymentGroups)(nil), "types.DeploymentGroups")
	proto.RegisterType((*Deployment)(nil), "types.Deployment")
	proto.RegisterType((*Deployments)(nil), "types.Deployments")
	proto.RegisterType((*TxCreateDeployment)(nil), "types.TxCreateDeployment")
	proto.RegisterType((*TxUpdateDeployment)(nil), "types.TxUpdateDeployment")
	proto.RegisterType((*TxCloseDeployment)(nil), "types.TxCloseDeployment")
	proto.RegisterType((*OrderID)(nil), "types.OrderID")
	proto.RegisterType((*Order)(nil), "types.Order")
	proto.RegisterType((*TxCreateOrder)(nil), "types.TxCreateOrder")
	proto.RegisterType((*Orders)(nil), "types.Orders")
	proto.RegisterType((*FulfillmentID)(nil), "types.FulfillmentID")
	proto.RegisterType((*Fulfillment)(nil), "types.Fulfillment")
	proto.RegisterType((*Fulfillments)(nil), "types.Fulfillments")
	proto.RegisterType((*TxCreateFulfillment)(nil), "types.TxCreateFulfillment")
	proto.RegisterType((*TxCloseFulfillment)(nil), "types.TxCloseFulfillment")
	proto.RegisterType((*LeaseID)(nil), "types.LeaseID")
	proto.RegisterType((*Lease)(nil), "types.Lease")
	proto.RegisterType((*TxCreateLease)(nil), "types.TxCreateLease")
	proto.RegisterType((*TxCloseLease)(nil), "types.TxCloseLease")
	proto.RegisterType((*Leases)(nil), "types.Leases")
	proto.RegisterType((*ManifestRequest)(nil), "types.ManifestRequest")
	proto.RegisterType((*Manifest)(nil), "types.Manifest")
	proto.RegisterType((*ManifestGroup)(nil), "types.ManifestGroup")
	proto.RegisterType((*ManifestService)(nil), "types.ManifestService")
	proto.RegisterType((*ManifestServiceExpose)(nil), "types.ManifestServiceExpose")
	proto.RegisterType((*Empty)(nil), "types.Empty")
	proto.RegisterType((*AkashVersion)(nil), "types.AkashVersion")
	proto.RegisterType((*ServerStatus)(nil), "types.ServerStatus")
	proto.RegisterType((*ServerStatusParseable)(nil), "types.ServerStatusParseable")
	proto.RegisterType((*ServerStatusParseable_ProviderStatus)(nil), "types.ServerStatusParseable.ProviderStatus")
	proto.RegisterType((*ServerStatusParseable_ProviderClusterStatus)(nil), "types.ServerStatusParseable.ProviderClusterStatus")
	proto.RegisterType((*ServerStatusParseable_ProviderInventoryStatus)(nil), "types.ServerStatusParseable.ProviderInventoryStatus")
	proto.RegisterType((*ServerStatusParseable_ProviderInventoryStatus_ResourceUnit)(nil), "types.ServerStatusParseable.ProviderInventoryStatus.ResourceUnit")
	proto.RegisterType((*ServerStatusParseable_ProviderInventoryStatus_Reservations)(nil), "types.ServerStatusParseable.ProviderInventoryStatus.Reservations")
	proto.RegisterType((*ProviderStatus)(nil), "types.ProviderStatus")
	proto.RegisterType((*ProviderManifestStatus)(nil), "types.ProviderManifestStatus")
	proto.RegisterType((*ProviderBidengineStatus)(nil), "types.ProviderBidengineStatus")
	proto.RegisterType((*ProviderClusterStatus)(nil), "types.ProviderClusterStatus")
	proto.RegisterType((*ProviderInventoryStatus)(nil), "types.ProviderInventoryStatus")
	proto.RegisterType((*ProviderInventoryStatus_Resource)(nil), "types.ProviderInventoryStatus.Resource")
	proto.RegisterType((*ProviderInventoryStatus_Reservations)(nil), "types.ProviderInventoryStatus.Reservations")
	proto.RegisterType((*DeployRespone)(nil), "types.DeployRespone")
	proto.RegisterType((*LeaseStatusRequest)(nil), "types.LeaseStatusRequest")
	proto.RegisterType((*ServiceStatusRequest)(nil), "types.ServiceStatusRequest")
	proto.RegisterType((*ServiceStatusResponse)(nil), "types.ServiceStatusResponse")
	proto.RegisterType((*LogRequest)(nil), "types.LogRequest")
	proto.RegisterType((*LogOptions)(nil), "types.LogOptions")
	proto.RegisterType((*Log)(nil), "types.Log")
	proto.RegisterType((*LogResponse)(nil), "types.LogResponse")
	proto.RegisterType((*LeaseStatusResponse)(nil), "types.LeaseStatusResponse")
	proto.RegisterType((*ServiceStatus)(nil), "types.ServiceStatus")
	proto.RegisterType((*ManifestGetRequest)(nil), "types.ManifestGetRequest")
	proto.RegisterType((*ManifestGetResponse)(nil), "types.ManifestGetResponse")
	proto.RegisterType((*ErrInvalidPayload)(nil), "types.ErrInvalidPayload")
	proto.RegisterType((*ErrInternalError)(nil), "types.ErrInternalError")
	proto.RegisterType((*ErrResourceNotFound)(nil), "types.ErrResourceNotFound")
	proto.RegisterEnum("types.DeploymentGroup_DeploymentGroupState", DeploymentGroup_DeploymentGroupState_name, DeploymentGroup_DeploymentGroupState_value)
	proto.RegisterEnum("types.Deployment_DeploymentState", Deployment_DeploymentState_name, Deployment_DeploymentState_value)
	proto.RegisterEnum("types.TxCloseDeployment_ReasonCode", TxCloseDeployment_ReasonCode_name, TxCloseDeployment_ReasonCode_value)
	proto.RegisterEnum("types.Order_OrderState", Order_OrderState_name, Order_OrderState_value)
	proto.RegisterEnum("types.Fulfillment_FulfillmentState", Fulfillment_FulfillmentState_name, Fulfillment_FulfillmentState_value)
	proto.RegisterEnum("types.Lease_LeaseState", Lease_LeaseState_name, Lease_LeaseState_value)
}
func (this *Account) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*Account)
	if !ok {
		that2, ok := that.(Account)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if c := this.Address.Compare(that1.Address); c != 0 {
		return c
	}
	if this.Balance != that1.Balance {
		if this.Balance < that1.Balance {
			return -1
		}
		return 1
	}
	if this.Nonce != that1.Nonce {
		if this.Nonce < that1.Nonce {
			return -1
		}
		return 1
	}
	return 0
}
func (this *Provider) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*Provider)
	if !ok {
		that2, ok := that.(Provider)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if c := this.Address.Compare(that1.Address); c != 0 {
		return c
	}
	if c := this.Owner.Compare(that1.Owner); c != 0 {
		return c
	}
	if this.HostURI != that1.HostURI {
		if this.HostURI < that1.HostURI {
			return -1
		}
		return 1
	}
	if len(this.Attributes) != len(that1.Attributes) {
		if len(this.Attributes) < len(that1.Attributes) {
			return -1
		}
		return 1
	}
	for i := range this.Attributes {
		if c := this.Attributes[i].Compare(&that1.Attributes[i]); c != 0 {
			return c
		}
	}
	return 0
}
func (this *ResourceUnit) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*ResourceUnit)
	if !ok {
		that2, ok := that.(ResourceUnit)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if this.CPU != that1.CPU {
		if this.CPU < that1.CPU {
			return -1
		}
		return 1
	}
	if this.Memory != that1.Memory {
		if this.Memory < that1.Memory {
			return -1
		}
		return 1
	}
	if this.Disk != that1.Disk {
		if this.Disk < that1.Disk {
			return -1
		}
		return 1
	}
	return 0
}
func (this *ResourceGroup) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*ResourceGroup)
	if !ok {
		that2, ok := that.(ResourceGroup)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if c := this.Unit.Compare(&that1.Unit); c != 0 {
		return c
	}
	if this.Count != that1.Count {
		if this.Count < that1.Count {
			return -1
		}
		return 1
	}
	if this.Price != that1.Price {
		if this.Price < that1.Price {
			return -1
		}
		return 1
	}
	return 0
}
func (this *ProviderAttribute) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*ProviderAttribute)
	if !ok {
		that2, ok := that.(ProviderAttribute)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if this.Name != that1.Name {
		if this.Name < that1.Name {
			return -1
		}
		return 1
	}
	if this.Value != that1.Value {
		if this.Value < that1.Value {
			return -1
		}
		return 1
	}
	return 0
}
func (this *DeploymentGroup) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*DeploymentGroup)
	if !ok {
		that2, ok := that.(DeploymentGroup)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if c := this.DeploymentGroupID.Compare(&that1.DeploymentGroupID); c != 0 {
		return c
	}
	if this.Name != that1.Name {
		if this.Name < that1.Name {
			return -1
		}
		return 1
	}
	if this.OrderTTL != that1.OrderTTL {
		if this.OrderTTL < that1.OrderTTL {
			return -1
		}
		return 1
	}
	if this.State != that1.State {
		if this.State < that1.State {
			return -1
		}
		return 1
	}
	if len(this.Requirements) != len(that1.Requirements) {
		if len(this.Requirements) < len(that1.Requirements) {
			return -1
		}
		return 1
	}
	for i := range this.Requirements {
		if c := this.Requirements[i].Compare(&that1.Requirements[i]); c != 0 {
			return c
		}
	}
	if len(this.Resources) != len(that1.Resources) {
		if len(this.Resources) < len(that1.Resources) {
			return -1
		}
		return 1
	}
	for i := range this.Resources {
		if c := this.Resources[i].Compare(&that1.Resources[i]); c != 0 {
			return c
		}
	}
	return 0
}
func (this *Deployment) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*Deployment)
	if !ok {
		that2, ok := that.(Deployment)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if c := this.Address.Compare(that1.Address); c != 0 {
		return c
	}
	if c := this.Tenant.Compare(that1.Tenant); c != 0 {
		return c
	}
	if this.State != that1.State {
		if this.State < that1.State {
			return -1
		}
		return 1
	}
	if c := this.Version.Compare(that1.Version); c != 0 {
		return c
	}
	return 0
}
func (this *Order) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*Order)
	if !ok {
		that2, ok := that.(Order)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if c := this.OrderID.Compare(&that1.OrderID); c != 0 {
		return c
	}
	if this.EndAt != that1.EndAt {
		if this.EndAt < that1.EndAt {
			return -1
		}
		return 1
	}
	if this.State != that1.State {
		if this.State < that1.State {
			return -1
		}
		return 1
	}
	return 0
}
func (this *Fulfillment) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*Fulfillment)
	if !ok {
		that2, ok := that.(Fulfillment)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if c := this.FulfillmentID.Compare(&that1.FulfillmentID); c != 0 {
		return c
	}
	if this.Price != that1.Price {
		if this.Price < that1.Price {
			return -1
		}
		return 1
	}
	if this.State != that1.State {
		if this.State < that1.State {
			return -1
		}
		return 1
	}
	return 0
}
func (this *Genesis) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.Genesis{")
	if this.Accounts != nil {
		vs := make([]*Account, len(this.Accounts))
		for i := range vs {
			vs[i] = &this.Accounts[i]
		}
		s = append(s, "Accounts: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Tx) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.Tx{")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	s = append(s, "Signature: "+fmt.Sprintf("%#v", this.Signature)+",\n")
	s = append(s, "Payload: "+strings.Replace(this.Payload.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TxPayload) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&types.TxPayload{")
	s = append(s, "Nonce: "+fmt.Sprintf("%#v", this.Nonce)+",\n")
	if this.Payload != nil {
		s = append(s, "Payload: "+fmt.Sprintf("%#v", this.Payload)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TxPayload_TxSend) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&types.TxPayload_TxSend{` +
		`TxSend:` + fmt.Sprintf("%#v", this.TxSend) + `}`}, ", ")
	return s
}
func (this *TxPayload_TxCreateDeployment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&types.TxPayload_TxCreateDeployment{` +
		`TxCreateDeployment:` + fmt.Sprintf("%#v", this.TxCreateDeployment) + `}`}, ", ")
	return s
}
func (this *TxPayload_TxUpdateDeployment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&types.TxPayload_TxUpdateDeployment{` +
		`TxUpdateDeployment:` + fmt.Sprintf("%#v", this.TxUpdateDeployment) + `}`}, ", ")
	return s
}
func (this *TxPayload_TxCreateOrder) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&types.TxPayload_TxCreateOrder{` +
		`TxCreateOrder:` + fmt.Sprintf("%#v", this.TxCreateOrder) + `}`}, ", ")
	return s
}
func (this *TxPayload_TxCreateFulfillment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&types.TxPayload_TxCreateFulfillment{` +
		`TxCreateFulfillment:` + fmt.Sprintf("%#v", this.TxCreateFulfillment) + `}`}, ", ")
	return s
}
func (this *TxPayload_TxCreateLease) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&types.TxPayload_TxCreateLease{` +
		`TxCreateLease:` + fmt.Sprintf("%#v", this.TxCreateLease) + `}`}, ", ")
	return s
}
func (this *TxPayload_TxCreateProvider) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&types.TxPayload_TxCreateProvider{` +
		`TxCreateProvider:` + fmt.Sprintf("%#v", this.TxCreateProvider) + `}`}, ", ")
	return s
}
func (this *TxPayload_TxCloseDeployment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&types.TxPayload_TxCloseDeployment{` +
		`TxCloseDeployment:` + fmt.Sprintf("%#v", this.TxCloseDeployment) + `}`}, ", ")
	return s
}
func (this *TxPayload_TxCloseFulfillment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&types.TxPayload_TxCloseFulfillment{` +
		`TxCloseFulfillment:` + fmt.Sprintf("%#v", this.TxCloseFulfillment) + `}`}, ", ")
	return s
}
func (this *TxPayload_TxCloseLease) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&types.TxPayload_TxCloseLease{` +
		`TxCloseLease:` + fmt.Sprintf("%#v", this.TxCloseLease) + `}`}, ", ")
	return s
}
func (this *Account) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.Account{")
	s = append(s, "Address: "+fmt.Sprintf("%#v", this.Address)+",\n")
	s = append(s, "Balance: "+fmt.Sprintf("%#v", this.Balance)+",\n")
	s = append(s, "Nonce: "+fmt.Sprintf("%#v", this.Nonce)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TxSend) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.TxSend{")
	s = append(s, "From: "+fmt.Sprintf("%#v", this.From)+",\n")
	s = append(s, "To: "+fmt.Sprintf("%#v", this.To)+",\n")
	s = append(s, "Amount: "+fmt.Sprintf("%#v", this.Amount)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Provider) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&types.Provider{")
	s = append(s, "Address: "+fmt.Sprintf("%#v", this.Address)+",\n")
	s = append(s, "Owner: "+fmt.Sprintf("%#v", this.Owner)+",\n")
	s = append(s, "HostURI: "+fmt.Sprintf("%#v", this.HostURI)+",\n")
	if this.Attributes != nil {
		vs := make([]*ProviderAttribute, len(this.Attributes))
		for i := range vs {
			vs[i] = &this.Attributes[i]
		}
		s = append(s, "Attributes: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Providers) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.Providers{")
	if this.Providers != nil {
		s = append(s, "Providers: "+fmt.Sprintf("%#v", this.Providers)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TxCreateProvider) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&types.TxCreateProvider{")
	s = append(s, "Owner: "+fmt.Sprintf("%#v", this.Owner)+",\n")
	s = append(s, "HostURI: "+fmt.Sprintf("%#v", this.HostURI)+",\n")
	if this.Attributes != nil {
		vs := make([]*ProviderAttribute, len(this.Attributes))
		for i := range vs {
			vs[i] = &this.Attributes[i]
		}
		s = append(s, "Attributes: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "Nonce: "+fmt.Sprintf("%#v", this.Nonce)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceUnit) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.ResourceUnit{")
	s = append(s, "CPU: "+fmt.Sprintf("%#v", this.CPU)+",\n")
	s = append(s, "Memory: "+fmt.Sprintf("%#v", this.Memory)+",\n")
	s = append(s, "Disk: "+fmt.Sprintf("%#v", this.Disk)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceGroup) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.ResourceGroup{")
	s = append(s, "Unit: "+strings.Replace(this.Unit.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Count: "+fmt.Sprintf("%#v", this.Count)+",\n")
	s = append(s, "Price: "+fmt.Sprintf("%#v", this.Price)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProviderAttribute) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.ProviderAttribute{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GroupSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.GroupSpec{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.Requirements != nil {
		vs := make([]*ProviderAttribute, len(this.Requirements))
		for i := range vs {
			vs[i] = &this.Requirements[i]
		}
		s = append(s, "Requirements: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	if this.Resources != nil {
		vs := make([]*ResourceGroup, len(this.Resources))
		for i := range vs {
			vs[i] = &this.Resources[i]
		}
		s = append(s, "Resources: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DeploymentGroupID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.DeploymentGroupID{")
	s = append(s, "Deployment: "+fmt.Sprintf("%#v", this.Deployment)+",\n")
	s = append(s, "Seq: "+fmt.Sprintf("%#v", this.Seq)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DeploymentGroup) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&types.DeploymentGroup{")
	s = append(s, "DeploymentGroupID: "+strings.Replace(this.DeploymentGroupID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "OrderTTL: "+fmt.Sprintf("%#v", this.OrderTTL)+",\n")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	if this.Requirements != nil {
		vs := make([]*ProviderAttribute, len(this.Requirements))
		for i := range vs {
			vs[i] = &this.Requirements[i]
		}
		s = append(s, "Requirements: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	if this.Resources != nil {
		vs := make([]*ResourceGroup, len(this.Resources))
		for i := range vs {
			vs[i] = &this.Resources[i]
		}
		s = append(s, "Resources: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DeploymentGroups) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.DeploymentGroups{")
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Deployment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&types.Deployment{")
	s = append(s, "Address: "+fmt.Sprintf("%#v", this.Address)+",\n")
	s = append(s, "Tenant: "+fmt.Sprintf("%#v", this.Tenant)+",\n")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Deployments) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.Deployments{")
	if this.Items != nil {
		vs := make([]*Deployment, len(this.Items))
		for i := range vs {
			vs[i] = &this.Items[i]
		}
		s = append(s, "Items: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TxCreateDeployment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&types.TxCreateDeployment{")
	s = append(s, "Tenant: "+fmt.Sprintf("%#v", this.Tenant)+",\n")
	s = append(s, "Nonce: "+fmt.Sprintf("%#v", this.Nonce)+",\n")
	s = append(s, "OrderTTL: "+fmt.Sprintf("%#v", this.OrderTTL)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	if this.Groups != nil {
		s = append(s, "Groups: "+fmt.Sprintf("%#v", this.Groups)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TxUpdateDeployment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.TxUpdateDeployment{")
	s = append(s, "Deployment: "+fmt.Sprintf("%#v", this.Deployment)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TxCloseDeployment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.TxCloseDeployment{")
	s = append(s, "Deployment: "+fmt.Sprintf("%#v", this.Deployment)+",\n")
	s = append(s, "Reason: "+fmt.Sprintf("%#v", this.Reason)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OrderID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.OrderID{")
	s = append(s, "Deployment: "+fmt.Sprintf("%#v", this.Deployment)+",\n")
	s = append(s, "Group: "+fmt.Sprintf("%#v", this.Group)+",\n")
	s = append(s, "Seq: "+fmt.Sprintf("%#v", this.Seq)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Order) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.Order{")
	s = append(s, "OrderID: "+strings.Replace(this.OrderID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "EndAt: "+fmt.Sprintf("%#v", this.EndAt)+",\n")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TxCreateOrder) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.TxCreateOrder{")
	s = append(s, "OrderID: "+strings.Replace(this.OrderID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "EndAt: "+fmt.Sprintf("%#v", this.EndAt)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Orders) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.Orders{")
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FulfillmentID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&types.FulfillmentID{")
	s = append(s, "Deployment: "+fmt.Sprintf("%#v", this.Deployment)+",\n")
	s = append(s, "Group: "+fmt.Sprintf("%#v", this.Group)+",\n")
	s = append(s, "Order: "+fmt.Sprintf("%#v", this.Order)+",\n")
	s = append(s, "Provider: "+fmt.Sprintf("%#v", this.Provider)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Fulfillment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.Fulfillment{")
	s = append(s, "FulfillmentID: "+strings.Replace(this.FulfillmentID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Price: "+fmt.Sprintf("%#v", this.Price)+",\n")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Fulfillments) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.Fulfillments{")
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TxCreateFulfillment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.TxCreateFulfillment{")
	s = append(s, "FulfillmentID: "+strings.Replace(this.FulfillmentID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Price: "+fmt.Sprintf("%#v", this.Price)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TxCloseFulfillment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.TxCloseFulfillment{")
	s = append(s, "FulfillmentID: "+strings.Replace(this.FulfillmentID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LeaseID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&types.LeaseID{")
	s = append(s, "Deployment: "+fmt.Sprintf("%#v", this.Deployment)+",\n")
	s = append(s, "Group: "+fmt.Sprintf("%#v", this.Group)+",\n")
	s = append(s, "Order: "+fmt.Sprintf("%#v", this.Order)+",\n")
	s = append(s, "Provider: "+fmt.Sprintf("%#v", this.Provider)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Lease) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.Lease{")
	s = append(s, "LeaseID: "+strings.Replace(this.LeaseID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Price: "+fmt.Sprintf("%#v", this.Price)+",\n")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TxCreateLease) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.TxCreateLease{")
	s = append(s, "LeaseID: "+strings.Replace(this.LeaseID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Price: "+fmt.Sprintf("%#v", this.Price)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TxCloseLease) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.TxCloseLease{")
	s = append(s, "LeaseID: "+strings.Replace(this.LeaseID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Leases) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.Leases{")
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ManifestRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&types.ManifestRequest{")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	s = append(s, "Signature: "+fmt.Sprintf("%#v", this.Signature)+",\n")
	s = append(s, "Deployment: "+fmt.Sprintf("%#v", this.Deployment)+",\n")
	if this.Manifest != nil {
		s = append(s, "Manifest: "+fmt.Sprintf("%#v", this.Manifest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Manifest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.Manifest{")
	if this.Groups != nil {
		s = append(s, "Groups: "+fmt.Sprintf("%#v", this.Groups)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ManifestGroup) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.ManifestGroup{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.Services != nil {
		s = append(s, "Services: "+fmt.Sprintf("%#v", this.Services)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ManifestService) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&types.ManifestService{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Image: "+fmt.Sprintf("%#v", this.Image)+",\n")
	s = append(s, "Args: "+fmt.Sprintf("%#v", this.Args)+",\n")
	s = append(s, "Env: "+fmt.Sprintf("%#v", this.Env)+",\n")
	if this.Unit != nil {
		s = append(s, "Unit: "+fmt.Sprintf("%#v", this.Unit)+",\n")
	}
	s = append(s, "Count: "+fmt.Sprintf("%#v", this.Count)+",\n")
	if this.Expose != nil {
		s = append(s, "Expose: "+fmt.Sprintf("%#v", this.Expose)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ManifestServiceExpose) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&types.ManifestServiceExpose{")
	s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	s = append(s, "ExternalPort: "+fmt.Sprintf("%#v", this.ExternalPort)+",\n")
	s = append(s, "Proto: "+fmt.Sprintf("%#v", this.Proto)+",\n")
	s = append(s, "Service: "+fmt.Sprintf("%#v", this.Service)+",\n")
	s = append(s, "Global: "+fmt.Sprintf("%#v", this.Global)+",\n")
	s = append(s, "Hosts: "+fmt.Sprintf("%#v", this.Hosts)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Empty) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&types.Empty{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AkashVersion) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.AkashVersion{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "Commit: "+fmt.Sprintf("%#v", this.Commit)+",\n")
	s = append(s, "Date: "+fmt.Sprintf("%#v", this.Date)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServerStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&types.ServerStatus{")
	s = append(s, "Provider: "+fmt.Sprintf("%#v", this.Provider)+",\n")
	if this.Version != nil {
		s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	}
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "Code: "+fmt.Sprintf("%#v", this.Code)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServerStatusParseable) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&types.ServerStatusParseable{")
	s = append(s, "Provider: "+fmt.Sprintf("%#v", this.Provider)+",\n")
	if this.Version != nil {
		s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	}
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "Code: "+fmt.Sprintf("%#v", this.Code)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServerStatusParseable_ProviderStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.ServerStatusParseable_ProviderStatus{")
	if this.Cluster != nil {
		s = append(s, "Cluster: "+fmt.Sprintf("%#v", this.Cluster)+",\n")
	}
	if this.Manifest != nil {
		s = append(s, "Manifest: "+fmt.Sprintf("%#v", this.Manifest)+",\n")
	}
	if this.Bidengine != nil {
		s = append(s, "Bidengine: "+fmt.Sprintf("%#v", this.Bidengine)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServerStatusParseable_ProviderClusterStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.ServerStatusParseable_ProviderClusterStatus{")
	s = append(s, "Leases: "+fmt.Sprintf("%#v", this.Leases)+",\n")
	if this.Inventory != nil {
		s = append(s, "Inventory: "+fmt.Sprintf("%#v", this.Inventory)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServerStatusParseable_ProviderInventoryStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.ServerStatusParseable_ProviderInventoryStatus{")
	if this.Reservations != nil {
		s = append(s, "Reservations: "+fmt.Sprintf("%#v", this.Reservations)+",\n")
	}
	if this.Available != nil {
		s = append(s, "Available: "+fmt.Sprintf("%#v", this.Available)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServerStatusParseable_ProviderInventoryStatus_ResourceUnit) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.ServerStatusParseable_ProviderInventoryStatus_ResourceUnit{")
	s = append(s, "CPU: "+fmt.Sprintf("%#v", this.CPU)+",\n")
	s = append(s, "Memory: "+fmt.Sprintf("%#v", this.Memory)+",\n")
	s = append(s, "Disk: "+fmt.Sprintf("%#v", this.Disk)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServerStatusParseable_ProviderInventoryStatus_Reservations) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.ServerStatusParseable_ProviderInventoryStatus_Reservations{")
	if this.Active != nil {
		s = append(s, "Active: "+fmt.Sprintf("%#v", this.Active)+",\n")
	}
	if this.Pending != nil {
		s = append(s, "Pending: "+fmt.Sprintf("%#v", this.Pending)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProviderStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.ProviderStatus{")
	if this.Cluster != nil {
		s = append(s, "Cluster: "+fmt.Sprintf("%#v", this.Cluster)+",\n")
	}
	if this.Manifest != nil {
		s = append(s, "Manifest: "+fmt.Sprintf("%#v", this.Manifest)+",\n")
	}
	if this.Bidengine != nil {
		s = append(s, "Bidengine: "+fmt.Sprintf("%#v", this.Bidengine)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProviderManifestStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.ProviderManifestStatus{")
	s = append(s, "Deployments: "+fmt.Sprintf("%#v", this.Deployments)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProviderBidengineStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.ProviderBidengineStatus{")
	s = append(s, "Orders: "+fmt.Sprintf("%#v", this.Orders)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProviderClusterStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.ProviderClusterStatus{")
	s = append(s, "Leases: "+fmt.Sprintf("%#v", this.Leases)+",\n")
	if this.Inventory != nil {
		s = append(s, "Inventory: "+fmt.Sprintf("%#v", this.Inventory)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProviderInventoryStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.ProviderInventoryStatus{")
	if this.Reservations != nil {
		s = append(s, "Reservations: "+fmt.Sprintf("%#v", this.Reservations)+",\n")
	}
	if this.Available != nil {
		s = append(s, "Available: "+fmt.Sprintf("%#v", this.Available)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProviderInventoryStatus_Resource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&types.ProviderInventoryStatus_Resource{")
	s = append(s, "CPU: "+fmt.Sprintf("%#v", this.CPU)+",\n")
	s = append(s, "Memory: "+fmt.Sprintf("%#v", this.Memory)+",\n")
	s = append(s, "Disk: "+fmt.Sprintf("%#v", this.Disk)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProviderInventoryStatus_Reservations) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.ProviderInventoryStatus_Reservations{")
	if this.Active != nil {
		s = append(s, "Active: "+fmt.Sprintf("%#v", this.Active)+",\n")
	}
	if this.Pending != nil {
		s = append(s, "Pending: "+fmt.Sprintf("%#v", this.Pending)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DeployRespone) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.DeployRespone{")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LeaseStatusRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&types.LeaseStatusRequest{")
	s = append(s, "Deployment: "+fmt.Sprintf("%#v", this.Deployment)+",\n")
	s = append(s, "Group: "+fmt.Sprintf("%#v", this.Group)+",\n")
	s = append(s, "Order: "+fmt.Sprintf("%#v", this.Order)+",\n")
	s = append(s, "Provider: "+fmt.Sprintf("%#v", this.Provider)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceStatusRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&types.ServiceStatusRequest{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Deployment: "+fmt.Sprintf("%#v", this.Deployment)+",\n")
	s = append(s, "Group: "+fmt.Sprintf("%#v", this.Group)+",\n")
	s = append(s, "Order: "+fmt.Sprintf("%#v", this.Order)+",\n")
	s = append(s, "Provider: "+fmt.Sprintf("%#v", this.Provider)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceStatusResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&types.ServiceStatusResponse{")
	s = append(s, "ObservedGeneration: "+fmt.Sprintf("%#v", this.ObservedGeneration)+",\n")
	s = append(s, "Replicas: "+fmt.Sprintf("%#v", this.Replicas)+",\n")
	s = append(s, "UpdatedReplicas: "+fmt.Sprintf("%#v", this.UpdatedReplicas)+",\n")
	s = append(s, "ReadyReplicas: "+fmt.Sprintf("%#v", this.ReadyReplicas)+",\n")
	s = append(s, "AvailableReplicas: "+fmt.Sprintf("%#v", this.AvailableReplicas)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LogRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&types.LogRequest{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Deployment: "+fmt.Sprintf("%#v", this.Deployment)+",\n")
	s = append(s, "Group: "+fmt.Sprintf("%#v", this.Group)+",\n")
	s = append(s, "Order: "+fmt.Sprintf("%#v", this.Order)+",\n")
	s = append(s, "Provider: "+fmt.Sprintf("%#v", this.Provider)+",\n")
	if this.Options != nil {
		s = append(s, "Options: "+fmt.Sprintf("%#v", this.Options)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LogOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.LogOptions{")
	s = append(s, "TailLines: "+fmt.Sprintf("%#v", this.TailLines)+",\n")
	s = append(s, "Follow: "+fmt.Sprintf("%#v", this.Follow)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Log) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.Log{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LogResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.LogResponse{")
	if this.Result != nil {
		s = append(s, "Result: "+fmt.Sprintf("%#v", this.Result)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LeaseStatusResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.LeaseStatusResponse{")
	if this.Services != nil {
		s = append(s, "Services: "+fmt.Sprintf("%#v", this.Services)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&types.ServiceStatus{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "URIs: "+fmt.Sprintf("%#v", this.URIs)+",\n")
	s = append(s, "Available: "+fmt.Sprintf("%#v", this.Available)+",\n")
	s = append(s, "Total: "+fmt.Sprintf("%#v", this.Total)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ManifestGetRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.ManifestGetRequest{")
	s = append(s, "Lease: "+fmt.Sprintf("%#v", this.Lease)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ManifestGetResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.ManifestGetResponse{")
	if this.Manifest != nil {
		s = append(s, "Manifest: "+fmt.Sprintf("%#v", this.Manifest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ErrInvalidPayload) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.ErrInvalidPayload{")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ErrInternalError) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.ErrInternalError{")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ErrResourceNotFound) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&types.ErrResourceNotFound{")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringTypes(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Cluster service

type ClusterClient interface {
	Status(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ServerStatus, error)
	Deploy(ctx context.Context, in *ManifestRequest, opts ...grpc.CallOption) (*DeployRespone, error)
	LeaseStatus(ctx context.Context, in *LeaseStatusRequest, opts ...grpc.CallOption) (*LeaseStatusResponse, error)
	ServiceStatus(ctx context.Context, in *ServiceStatusRequest, opts ...grpc.CallOption) (*ServiceStatusResponse, error)
	ServiceLogs(ctx context.Context, in *LogRequest, opts ...grpc.CallOption) (Cluster_ServiceLogsClient, error)
}

type clusterClient struct {
	cc *grpc.ClientConn
}

func NewClusterClient(cc *grpc.ClientConn) ClusterClient {
	return &clusterClient{cc}
}

func (c *clusterClient) Status(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ServerStatus, error) {
	out := new(ServerStatus)
	err := grpc.Invoke(ctx, "/types.Cluster/Status", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) Deploy(ctx context.Context, in *ManifestRequest, opts ...grpc.CallOption) (*DeployRespone, error) {
	out := new(DeployRespone)
	err := grpc.Invoke(ctx, "/types.Cluster/Deploy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) LeaseStatus(ctx context.Context, in *LeaseStatusRequest, opts ...grpc.CallOption) (*LeaseStatusResponse, error) {
	out := new(LeaseStatusResponse)
	err := grpc.Invoke(ctx, "/types.Cluster/LeaseStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) ServiceStatus(ctx context.Context, in *ServiceStatusRequest, opts ...grpc.CallOption) (*ServiceStatusResponse, error) {
	out := new(ServiceStatusResponse)
	err := grpc.Invoke(ctx, "/types.Cluster/ServiceStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) ServiceLogs(ctx context.Context, in *LogRequest, opts ...grpc.CallOption) (Cluster_ServiceLogsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Cluster_serviceDesc.Streams[0], c.cc, "/types.Cluster/ServiceLogs", opts...)
	if err != nil {
		return nil, err
	}
	x := &clusterServiceLogsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Cluster_ServiceLogsClient interface {
	Recv() (*Log, error)
	grpc.ClientStream
}

type clusterServiceLogsClient struct {
	grpc.ClientStream
}

func (x *clusterServiceLogsClient) Recv() (*Log, error) {
	m := new(Log)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for Cluster service

type ClusterServer interface {
	Status(context.Context, *Empty) (*ServerStatus, error)
	Deploy(context.Context, *ManifestRequest) (*DeployRespone, error)
	LeaseStatus(context.Context, *LeaseStatusRequest) (*LeaseStatusResponse, error)
	ServiceStatus(context.Context, *ServiceStatusRequest) (*ServiceStatusResponse, error)
	ServiceLogs(*LogRequest, Cluster_ServiceLogsServer) error
}

func RegisterClusterServer(s *grpc.Server, srv ClusterServer) {
	s.RegisterService(&_Cluster_serviceDesc, srv)
}

func _Cluster_Status_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServer).Status(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.Cluster/Status",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServer).Status(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cluster_Deploy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ManifestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServer).Deploy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.Cluster/Deploy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServer).Deploy(ctx, req.(*ManifestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cluster_LeaseStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LeaseStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServer).LeaseStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.Cluster/LeaseStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServer).LeaseStatus(ctx, req.(*LeaseStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cluster_ServiceStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ServiceStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServer).ServiceStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.Cluster/ServiceStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServer).ServiceStatus(ctx, req.(*ServiceStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cluster_ServiceLogs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LogRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ClusterServer).ServiceLogs(m, &clusterServiceLogsServer{stream})
}

type Cluster_ServiceLogsServer interface {
	Send(*Log) error
	grpc.ServerStream
}

type clusterServiceLogsServer struct {
	grpc.ServerStream
}

func (x *clusterServiceLogsServer) Send(m *Log) error {
	return x.ServerStream.SendMsg(m)
}

var _Cluster_serviceDesc = grpc.ServiceDesc{
	ServiceName: "types.Cluster",
	HandlerType: (*ClusterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Status",
			Handler:    _Cluster_Status_Handler,
		},
		{
			MethodName: "Deploy",
			Handler:    _Cluster_Deploy_Handler,
		},
		{
			MethodName: "LeaseStatus",
			Handler:    _Cluster_LeaseStatus_Handler,
		},
		{
			MethodName: "ServiceStatus",
			Handler:    _Cluster_ServiceStatus_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ServiceLogs",
			Handler:       _Cluster_ServiceLogs_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "types/types.proto",
}

func (m *Genesis) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Genesis: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Genesis: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Accounts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Accounts = append(m.Accounts, Account{})
			if err := m.Accounts[len(m.Accounts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tx) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tx: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tx: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Signature", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Signature = append(m.Signature[:0], dAtA[iNdEx:postIndex]...)
			if m.Signature == nil {
				m.Signature = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Payload.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxPayload) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxPayload: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxPayload: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nonce", wireType)
			}
			m.Nonce = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Nonce |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxSend", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TxSend{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &TxPayload_TxSend{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxCreateDeployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TxCreateDeployment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &TxPayload_TxCreateDeployment{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxUpdateDeployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TxUpdateDeployment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &TxPayload_TxUpdateDeployment{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxCreateOrder", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TxCreateOrder{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &TxPayload_TxCreateOrder{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxCreateFulfillment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TxCreateFulfillment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &TxPayload_TxCreateFulfillment{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxCreateLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TxCreateLease{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &TxPayload_TxCreateLease{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxCreateProvider", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TxCreateProvider{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &TxPayload_TxCreateProvider{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxCloseDeployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TxCloseDeployment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &TxPayload_TxCloseDeployment{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxCloseFulfillment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TxCloseFulfillment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &TxPayload_TxCloseFulfillment{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxCloseLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TxCloseLease{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &TxPayload_TxCloseLease{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Account) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Account: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Account: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Balance", wireType)
			}
			m.Balance = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Balance |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nonce", wireType)
			}
			m.Nonce = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Nonce |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxSend) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxSend: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxSend: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field From", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.From.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.To.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Amount", wireType)
			}
			m.Amount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Amount |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Provider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Provider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Provider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Owner", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Owner.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostURI", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostURI = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, ProviderAttribute{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Providers) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Providers: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Providers: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Providers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Providers = append(m.Providers, &Provider{})
			if err := m.Providers[len(m.Providers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxCreateProvider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxCreateProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxCreateProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Owner", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Owner.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostURI", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostURI = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, ProviderAttribute{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nonce", wireType)
			}
			m.Nonce = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Nonce |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceUnit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceUnit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceUnit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CPU", wireType)
			}
			m.CPU = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CPU |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memory", wireType)
			}
			m.Memory = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Memory |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Disk", wireType)
			}
			m.Disk = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Disk |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceGroup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceGroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceGroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Unit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Price", wireType)
			}
			m.Price = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Price |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProviderAttribute) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProviderAttribute: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProviderAttribute: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GroupSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Requirements", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Requirements = append(m.Requirements, ProviderAttribute{})
			if err := m.Requirements[len(m.Requirements)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, ResourceGroup{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentGroupID) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentGroupID: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentGroupID: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Deployment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seq", wireType)
			}
			m.Seq = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Seq |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentGroup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentGroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentGroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentGroupID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.DeploymentGroupID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderTTL", wireType)
			}
			m.OrderTTL = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OrderTTL |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (DeploymentGroup_DeploymentGroupState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Requirements", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Requirements = append(m.Requirements, ProviderAttribute{})
			if err := m.Requirements[len(m.Requirements)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, ResourceGroup{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentGroups) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentGroups: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentGroups: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &DeploymentGroup{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Deployment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Deployment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tenant", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Tenant.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (Deployment_DeploymentState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Version.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployments) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Deployments: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Deployments: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, Deployment{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxCreateDeployment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxCreateDeployment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxCreateDeployment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tenant", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Tenant.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nonce", wireType)
			}
			m.Nonce = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Nonce |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderTTL", wireType)
			}
			m.OrderTTL = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OrderTTL |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Version.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Groups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Groups = append(m.Groups, &GroupSpec{})
			if err := m.Groups[len(m.Groups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxUpdateDeployment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxUpdateDeployment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxUpdateDeployment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Deployment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Version.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxCloseDeployment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxCloseDeployment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxCloseDeployment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Deployment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			m.Reason = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Reason |= (TxCloseDeployment_ReasonCode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrderID) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrderID: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrderID: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Deployment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			m.Group = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Group |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seq", wireType)
			}
			m.Seq = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Seq |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Order) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Order: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Order: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OrderID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndAt", wireType)
			}
			m.EndAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndAt |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (Order_OrderState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxCreateOrder) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxCreateOrder: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxCreateOrder: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OrderID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndAt", wireType)
			}
			m.EndAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndAt |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Orders) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Orders: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Orders: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Order{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FulfillmentID) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FulfillmentID: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FulfillmentID: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Deployment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			m.Group = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Group |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Order", wireType)
			}
			m.Order = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Order |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Provider", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Provider.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Fulfillment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Fulfillment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Fulfillment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FulfillmentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FulfillmentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Price", wireType)
			}
			m.Price = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Price |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (Fulfillment_FulfillmentState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Fulfillments) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Fulfillments: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Fulfillments: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Fulfillment{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxCreateFulfillment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxCreateFulfillment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxCreateFulfillment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FulfillmentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FulfillmentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Price", wireType)
			}
			m.Price = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Price |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxCloseFulfillment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxCloseFulfillment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxCloseFulfillment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FulfillmentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FulfillmentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaseID) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaseID: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaseID: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Deployment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			m.Group = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Group |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Order", wireType)
			}
			m.Order = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Order |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Provider", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Provider.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Lease) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Lease: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Lease: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeaseID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Price", wireType)
			}
			m.Price = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Price |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (Lease_LeaseState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxCreateLease) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxCreateLease: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxCreateLease: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeaseID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Price", wireType)
			}
			m.Price = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Price |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxCloseLease) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxCloseLease: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxCloseLease: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeaseID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Leases) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Leases: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Leases: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Lease{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManifestRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManifestRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManifestRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Key.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Signature", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Signature.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Deployment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Manifest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Manifest == nil {
				m.Manifest = &Manifest{}
			}
			if err := m.Manifest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Manifest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Manifest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Manifest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Groups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Groups = append(m.Groups, &ManifestGroup{})
			if err := m.Groups[len(m.Groups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManifestGroup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManifestGroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManifestGroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Services", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Services = append(m.Services, &ManifestService{})
			if err := m.Services[len(m.Services)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManifestService) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManifestService: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManifestService: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Image = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Env", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Env = append(m.Env, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Unit == nil {
				m.Unit = &ResourceUnit{}
			}
			if err := m.Unit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expose", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Expose = append(m.Expose, &ManifestServiceExpose{})
			if err := m.Expose[len(m.Expose)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManifestServiceExpose) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManifestServiceExpose: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManifestServiceExpose: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalPort", wireType)
			}
			m.ExternalPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExternalPort |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Proto", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Proto = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Service = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Global", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Global = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hosts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hosts = append(m.Hosts, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Empty) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Empty: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Empty: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AkashVersion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AkashVersion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AkashVersion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Commit", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Commit = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Date", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Date = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Provider", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Provider.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Version == nil {
				m.Version = &AkashVersion{}
			}
			if err := m.Version.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &ProviderStatus{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerStatusParseable) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerStatusParseable: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerStatusParseable: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Provider", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Provider.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Version == nil {
				m.Version = &AkashVersion{}
			}
			if err := m.Version.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &ServerStatusParseable_ProviderStatus{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerStatusParseable_ProviderStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProviderStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProviderStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cluster == nil {
				m.Cluster = &ServerStatusParseable_ProviderClusterStatus{}
			}
			if err := m.Cluster.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Manifest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Manifest == nil {
				m.Manifest = &ProviderManifestStatus{}
			}
			if err := m.Manifest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bidengine", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Bidengine == nil {
				m.Bidengine = &ProviderBidengineStatus{}
			}
			if err := m.Bidengine.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerStatusParseable_ProviderClusterStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProviderClusterStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProviderClusterStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Leases", wireType)
			}
			m.Leases = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Leases |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inventory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Inventory == nil {
				m.Inventory = &ServerStatusParseable_ProviderInventoryStatus{}
			}
			if err := m.Inventory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerStatusParseable_ProviderInventoryStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProviderInventoryStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProviderInventoryStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reservations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Reservations == nil {
				m.Reservations = &ServerStatusParseable_ProviderInventoryStatus_Reservations{}
			}
			if err := m.Reservations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Available", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Available = append(m.Available, &ServerStatusParseable_ProviderInventoryStatus_ResourceUnit{})
			if err := m.Available[len(m.Available)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerStatusParseable_ProviderInventoryStatus_ResourceUnit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceUnit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceUnit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CPU", wireType)
			}
			m.CPU = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CPU |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memory", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Memory = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Disk", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Disk = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerStatusParseable_ProviderInventoryStatus_Reservations) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reservations: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reservations: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Active", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Active = append(m.Active, &ServerStatusParseable_ProviderInventoryStatus_ResourceUnit{})
			if err := m.Active[len(m.Active)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pending", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pending = append(m.Pending, &ServerStatusParseable_ProviderInventoryStatus_ResourceUnit{})
			if err := m.Pending[len(m.Pending)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProviderStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProviderStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProviderStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cluster == nil {
				m.Cluster = &ProviderClusterStatus{}
			}
			if err := m.Cluster.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Manifest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Manifest == nil {
				m.Manifest = &ProviderManifestStatus{}
			}
			if err := m.Manifest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bidengine", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Bidengine == nil {
				m.Bidengine = &ProviderBidengineStatus{}
			}
			if err := m.Bidengine.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProviderManifestStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProviderManifestStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProviderManifestStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployments", wireType)
			}
			m.Deployments = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Deployments |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProviderBidengineStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProviderBidengineStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProviderBidengineStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Orders", wireType)
			}
			m.Orders = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Orders |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProviderClusterStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProviderClusterStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProviderClusterStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Leases", wireType)
			}
			m.Leases = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Leases |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inventory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Inventory == nil {
				m.Inventory = &ProviderInventoryStatus{}
			}
			if err := m.Inventory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProviderInventoryStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProviderInventoryStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProviderInventoryStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reservations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Reservations == nil {
				m.Reservations = &ProviderInventoryStatus_Reservations{}
			}
			if err := m.Reservations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Available", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Available = append(m.Available, &ResourceUnit{})
			if err := m.Available[len(m.Available)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProviderInventoryStatus_Resource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Resource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Resource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CPU", wireType)
			}
			m.CPU = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CPU |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memory", wireType)
			}
			m.Memory = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Memory |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Disk", wireType)
			}
			m.Disk = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Disk |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProviderInventoryStatus_Reservations) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reservations: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reservations: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Active", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Active = append(m.Active, &ResourceUnit{})
			if err := m.Active[len(m.Active)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pending", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pending = append(m.Pending, &ResourceUnit{})
			if err := m.Pending[len(m.Pending)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeployRespone) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeployRespone: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeployRespone: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaseStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaseStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaseStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Deployment = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Group = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Order", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Order = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Provider", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Provider = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Deployment = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Group = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Order", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Order = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Provider", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Provider = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObservedGeneration", wireType)
			}
			m.ObservedGeneration = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ObservedGeneration |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replicas", wireType)
			}
			m.Replicas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Replicas |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedReplicas", wireType)
			}
			m.UpdatedReplicas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UpdatedReplicas |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadyReplicas", wireType)
			}
			m.ReadyReplicas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadyReplicas |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvailableReplicas", wireType)
			}
			m.AvailableReplicas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AvailableReplicas |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Deployment = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Group = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Order", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Order = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Provider", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Provider = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &LogOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TailLines", wireType)
			}
			m.TailLines = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TailLines |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Follow", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Follow = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Log) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Log: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Log: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Result == nil {
				m.Result = &Log{}
			}
			if err := m.Result.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaseStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaseStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaseStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Services", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Services = append(m.Services, &ServiceStatus{})
			if err := m.Services[len(m.Services)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field URIs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.URIs = append(m.URIs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Available", wireType)
			}
			m.Available = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Available |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Total", wireType)
			}
			m.Total = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Total |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManifestGetRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManifestGetRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManifestGetRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Lease = append(m.Lease[:0], dAtA[iNdEx:postIndex]...)
			if m.Lease == nil {
				m.Lease = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManifestGetResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManifestGetResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManifestGetResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Manifest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Manifest == nil {
				m.Manifest = &Manifest{}
			}
			if err := m.Manifest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ErrInvalidPayload) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ErrInvalidPayload: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ErrInvalidPayload: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ErrInternalError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ErrInternalError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ErrInternalError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ErrResourceNotFound) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ErrResourceNotFound: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ErrResourceNotFound: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTypes(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTypes
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTypes(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTypes = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTypes   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("types/types.proto", fileDescriptorTypes) }

var fileDescriptorTypes = []byte{
	// 2836 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x3a, 0xcd, 0x6f, 0x5c, 0x57,
	0xf5, 0x7e, 0x6f, 0x3e, 0xdf, 0x19, 0x4f, 0x32, 0xbe, 0x76, 0x52, 0x77, 0x7e, 0xf9, 0xc5, 0xe1,
	0xb5, 0x52, 0xdd, 0x26, 0xf1, 0xa4, 0xee, 0x67, 0xdc, 0x00, 0xf5, 0xd8, 0x93, 0xd8, 0xc5, 0xb5,
	0xcd, 0xb5, 0x5d, 0x84, 0xba, 0xa8, 0x9e, 0x67, 0x6e, 0x26, 0x8f, 0xbc, 0x79, 0x77, 0xfa, 0xde,
	0x1b, 0xd7, 0x56, 0x9a, 0x45, 0x01, 0x21, 0x55, 0xec, 0x40, 0x42, 0x2c, 0x40, 0x02, 0x89, 0x05,
	0x1b, 0x36, 0x48, 0xfc, 0x01, 0x6c, 0x10, 0x82, 0x4d, 0x25, 0x10, 0x54, 0x80, 0x82, 0x52, 0xb1,
	0x40, 0x5d, 0xb1, 0x63, 0x87, 0xd0, 0xfd, 0x7a, 0x5f, 0xf3, 0x26, 0x38, 0x13, 0x17, 0x45, 0x6c,
	0x92, 0x77, 0xee, 0x3d, 0xe7, 0xdc, 0x73, 0xcf, 0xd7, 0x3d, 0xe7, 0x8c, 0x61, 0x2a, 0x38, 0xea,
	0x13, 0xbf, 0xc1, 0xff, 0x5d, 0xe8, 0x7b, 0x34, 0xa0, 0xa8, 0xc0, 0x81, 0xfa, 0xe5, 0xae, 0x1d,
	0xdc, 0x1a, 0xec, 0x2f, 0xb4, 0x69, 0xaf, 0xd1, 0xa5, 0x5d, 0xda, 0xe0, 0xbb, 0xfb, 0x83, 0x9b,
	0x1c, 0xe2, 0x00, 0xff, 0x12, 0x54, 0xf5, 0x73, 0x5d, 0x4a, 0xbb, 0x0e, 0x69, 0x58, 0x7d, 0xbb,
	0x61, 0xb9, 0x2e, 0x0d, 0xac, 0xc0, 0xa6, 0xae, 0xe4, 0x69, 0xbe, 0x06, 0xa5, 0x1b, 0xc4, 0x25,
	0xbe, 0xed, 0xa3, 0x2b, 0x50, 0xb6, 0xda, 0x6d, 0x3a, 0x70, 0x03, 0x7f, 0x56, 0xbb, 0x90, 0x9b,
	0xaf, 0x2c, 0x9e, 0x5a, 0x10, 0xc7, 0x2f, 0x8b, 0xe5, 0x66, 0xfe, 0xd7, 0xf7, 0xe6, 0x26, 0x70,
	0x88, 0x65, 0xde, 0x04, 0x7d, 0xf7, 0x10, 0xd5, 0x20, 0x77, 0x9b, 0x1c, 0xcd, 0x6a, 0x17, 0xb4,
	0xf9, 0x49, 0xcc, 0x3e, 0xd1, 0x39, 0x30, 0x7c, 0xbb, 0xeb, 0x5a, 0xc1, 0xc0, 0x23, 0xb3, 0x3a,
	0x5f, 0x8f, 0x16, 0xd0, 0x15, 0x28, 0xf5, 0xad, 0x23, 0x87, 0x5a, 0x9d, 0xd9, 0xdc, 0x05, 0x6d,
	0xbe, 0xb2, 0x58, 0x93, 0xc7, 0xec, 0x1e, 0x6e, 0x8b, 0x75, 0x79, 0x90, 0x42, 0x33, 0x7f, 0x5f,
	0x00, 0x23, 0xdc, 0x44, 0x33, 0x50, 0x70, 0xa9, 0xdb, 0x26, 0xfc, 0xc4, 0x3c, 0x16, 0x00, 0x7a,
	0x06, 0x8a, 0xc1, 0xe1, 0x0e, 0x71, 0x3b, 0xfc, 0xc0, 0xca, 0x62, 0x35, 0x64, 0xca, 0x16, 0xd7,
	0x26, 0xb0, 0xdc, 0x46, 0x5f, 0x02, 0x14, 0x1c, 0xae, 0x78, 0xc4, 0x0a, 0xc8, 0x2a, 0xe9, 0x3b,
	0xf4, 0xa8, 0x47, 0xdc, 0x40, 0x4a, 0xf2, 0x64, 0x48, 0x94, 0x46, 0x58, 0x9b, 0xc0, 0x19, 0x64,
	0x82, 0xd9, 0x5e, 0xbf, 0x93, 0x64, 0x96, 0x4f, 0x31, 0x4b, 0x23, 0x08, 0x66, 0xe9, 0x55, 0x74,
	0x0d, 0xaa, 0xea, 0x88, 0x2d, 0xaf, 0x43, 0xbc, 0xd9, 0x02, 0xe7, 0x33, 0x93, 0x12, 0x8a, 0xef,
	0xad, 0x4d, 0xe0, 0x24, 0x32, 0xda, 0x84, 0x69, 0xb5, 0x70, 0x7d, 0xe0, 0xdc, 0xb4, 0x1d, 0x87,
	0xcb, 0x52, 0xe4, 0x3c, 0xea, 0x29, 0x1e, 0x31, 0x8c, 0xb5, 0x09, 0x9c, 0x45, 0x18, 0x97, 0x66,
	0x83, 0x58, 0x3e, 0x99, 0x2d, 0x65, 0x4a, 0xc3, 0xf7, 0xe2, 0xd2, 0xf0, 0x05, 0xd4, 0x82, 0x9a,
	0x5a, 0xd8, 0xf6, 0xe8, 0x81, 0xcd, 0xae, 0x53, 0xe6, 0x0c, 0x9e, 0x48, 0x31, 0x50, 0xdb, 0x6b,
	0x13, 0x78, 0x88, 0x04, 0xad, 0xc1, 0x54, 0x70, 0xb8, 0xe2, 0x50, 0x3f, 0xae, 0x5e, 0x83, 0xf3,
	0x99, 0x8d, 0xf8, 0x24, 0xf7, 0xd7, 0x26, 0xf0, 0x30, 0x91, 0x34, 0x3b, 0x5b, 0x8c, 0x6b, 0x07,
	0xd2, 0x66, 0x4f, 0x21, 0x48, 0xb3, 0xa7, 0x56, 0xd1, 0x55, 0x98, 0x94, 0xab, 0x42, 0x35, 0x15,
	0xce, 0x66, 0x3a, 0xc9, 0x46, 0x69, 0x26, 0x81, 0xda, 0x34, 0x42, 0xef, 0x37, 0xbf, 0xad, 0x41,
	0x49, 0x86, 0x16, 0x7a, 0x03, 0x4a, 0x56, 0xa7, 0xe3, 0x11, 0xdf, 0x17, 0x81, 0xd4, 0xbc, 0xc2,
	0x42, 0xe0, 0x4f, 0xf7, 0xe6, 0xe6, 0x63, 0xd1, 0x4e, 0x0f, 0xbc, 0xb6, 0x73, 0xbb, 0x61, 0xdd,
	0xb6, 0xfc, 0x5b, 0x22, 0x33, 0x34, 0xf6, 0x2d, 0x9f, 0x2c, 0x34, 0x8f, 0x02, 0xe2, 0x63, 0xc5,
	0x00, 0xcd, 0x42, 0x69, 0xdf, 0x72, 0x2c, 0x16, 0x22, 0x3a, 0x0f, 0x11, 0x05, 0x46, 0xa1, 0x93,
	0x8b, 0x85, 0xce, 0x52, 0xfe, 0xef, 0x3f, 0x9e, 0xd3, 0xcc, 0x9f, 0x6a, 0x50, 0x14, 0xc1, 0x82,
	0x56, 0x21, 0x7f, 0xd3, 0xa3, 0xbd, 0xb1, 0x25, 0xe1, 0xd4, 0xe8, 0x75, 0xd0, 0x03, 0x2a, 0xc2,
	0x7f, 0x0c, 0x1e, 0x7a, 0x40, 0xd1, 0x59, 0x28, 0x5a, 0x3d, 0xa6, 0x1e, 0x29, 0xaf, 0x84, 0xcc,
	0x7f, 0x69, 0x50, 0x0e, 0x5d, 0xe4, 0x24, 0x35, 0x77, 0x1d, 0x0a, 0xf4, 0x3d, 0x97, 0x78, 0x63,
	0x4b, 0x2d, 0xc8, 0x99, 0x05, 0x6e, 0x51, 0x3f, 0xd8, 0xc3, 0xeb, 0x5c, 0x72, 0x03, 0x2b, 0x10,
	0x7d, 0x01, 0xc0, 0x0a, 0x02, 0xcf, 0xde, 0x1f, 0x04, 0xc4, 0x9f, 0xcd, 0xf3, 0x34, 0xab, 0x3c,
	0x59, 0x5d, 0x69, 0x59, 0x21, 0xc8, 0x3c, 0x18, 0xa3, 0x90, 0xb6, 0x5a, 0x02, 0x43, 0x21, 0xfb,
	0xe8, 0x32, 0x18, 0x7d, 0x05, 0xc8, 0xc4, 0x7d, 0x3a, 0xc5, 0x11, 0x47, 0x18, 0xe6, 0x6f, 0x34,
	0xa8, 0xa5, 0x63, 0x2f, 0xba, 0xb8, 0x76, 0x62, 0x17, 0xd7, 0x1f, 0x74, 0xf1, 0xdc, 0xc3, 0x5e,
	0x3c, 0x72, 0xdd, 0x7c, 0xcc, 0x75, 0xcd, 0xb7, 0x61, 0x12, 0x13, 0x9f, 0x0e, 0xbc, 0x36, 0xd9,
	0x73, 0xed, 0x00, 0x3d, 0x09, 0xb9, 0x95, 0xed, 0x3d, 0x7e, 0x8b, 0x6a, 0xb3, 0xf4, 0xe9, 0xbd,
	0xb9, 0x5c, 0xbb, 0x3f, 0xc0, 0x6c, 0x8d, 0x39, 0x53, 0x8f, 0xf4, 0xa8, 0x77, 0x24, 0x83, 0x42,
	0x42, 0x08, 0x41, 0xbe, 0x63, 0xfb, 0xb7, 0xa5, 0x8b, 0xf1, 0x6f, 0xa9, 0xe5, 0x3e, 0x54, 0x15,
	0xf3, 0x1b, 0x1e, 0x1d, 0xf4, 0xd1, 0x65, 0xc8, 0x0f, 0x5c, 0x3b, 0xe0, 0xec, 0xa3, 0x70, 0x8f,
	0x0b, 0x20, 0x05, 0xe7, 0x68, 0x4c, 0x64, 0x1e, 0xdc, 0xfc, 0xc0, 0x2a, 0x16, 0x00, 0x5b, 0xed,
	0x7b, 0x76, 0x14, 0x83, 0x1c, 0x90, 0x27, 0xae, 0xc0, 0xd4, 0x90, 0x2e, 0x98, 0x80, 0xae, 0xd5,
	0x13, 0xcf, 0x9d, 0x81, 0xf9, 0x37, 0x63, 0x72, 0x60, 0x39, 0x03, 0x22, 0xb5, 0x2c, 0x00, 0xc9,
	0xe4, 0x87, 0x1a, 0x18, 0x5c, 0xde, 0x9d, 0x3e, 0x69, 0x67, 0x52, 0x37, 0x61, 0xd2, 0x23, 0xef,
	0x0e, 0x6c, 0x8f, 0xb0, 0x6c, 0xe6, 0xcf, 0xea, 0xc7, 0xb2, 0x46, 0x82, 0x06, 0xbd, 0x0a, 0x86,
	0x27, 0x2f, 0xae, 0xcc, 0x39, 0x93, 0x52, 0x08, 0x17, 0x42, 0x12, 0x47, 0xc8, 0xe6, 0x5d, 0x98,
	0x8a, 0xf2, 0x32, 0xc7, 0x59, 0x5f, 0x45, 0xdb, 0x00, 0x9d, 0x28, 0xc3, 0x8f, 0xeb, 0x85, 0x31,
	0x1e, 0xac, 0x2c, 0xf1, 0xc9, 0xbb, 0xd2, 0xd8, 0xec, 0x73, 0x29, 0xff, 0xfd, 0x1f, 0xcd, 0x4d,
	0x98, 0xff, 0xd4, 0xe1, 0x74, 0xea, 0x7c, 0xb4, 0x08, 0xba, 0xdd, 0x91, 0x66, 0x55, 0x6a, 0x18,
	0x92, 0xb1, 0x59, 0x66, 0xf2, 0x7c, 0x74, 0x6f, 0x4e, 0xc3, 0xba, 0xdd, 0x09, 0x15, 0xab, 0xc7,
	0x14, 0x5b, 0x87, 0x32, 0x65, 0x8f, 0xf1, 0xee, 0xee, 0x06, 0x37, 0x6f, 0x0e, 0x87, 0x30, 0x5a,
	0x86, 0x82, 0x1f, 0x58, 0x81, 0x70, 0xe0, 0x53, 0x8b, 0x17, 0xb3, 0x8f, 0x49, 0xc3, 0x3b, 0x8c,
	0x04, 0x0b, 0xca, 0x21, 0xbb, 0x15, 0x1e, 0xd5, 0x6e, 0xc5, 0x87, 0xb1, 0xdb, 0x55, 0x98, 0xc9,
	0x12, 0x0e, 0x95, 0x21, 0xbf, 0xb5, 0xdd, 0xda, 0xac, 0x4d, 0xa0, 0x0a, 0x94, 0xb6, 0xf0, 0x6a,
	0x0b, 0xb7, 0x56, 0x6b, 0x1a, 0x02, 0x28, 0xae, 0x6c, 0x6c, 0xed, 0xb4, 0x56, 0x6b, 0x39, 0xe9,
	0x98, 0xaf, 0x43, 0x2d, 0xc5, 0xc0, 0x47, 0x97, 0xa0, 0x60, 0x07, 0xa4, 0xa7, 0x12, 0xd7, 0xd9,
	0x6c, 0xad, 0x60, 0x81, 0x64, 0x7e, 0xac, 0x03, 0xc4, 0xde, 0xf4, 0x93, 0x4c, 0xfd, 0x6b, 0x50,
	0x0c, 0x88, 0x6b, 0xc9, 0x68, 0x1d, 0x87, 0x95, 0xa4, 0x47, 0xaf, 0x28, 0x43, 0xe7, 0xb8, 0xa1,
	0x3f, 0x37, 0x74, 0xa5, 0xd8, 0x67, 0xc2, 0xbc, 0x6f, 0x40, 0xe9, 0x80, 0x78, 0xbe, 0x4d, 0x5d,
	0xee, 0x23, 0x63, 0x5d, 0x47, 0x32, 0x30, 0x9f, 0x8d, 0x3b, 0xb9, 0xb0, 0x13, 0x40, 0x71, 0x79,
	0x65, 0x77, 0xfd, 0xad, 0x56, 0x6d, 0x22, 0x66, 0x1c, 0x5d, 0x1a, 0xe7, 0x1a, 0x54, 0x22, 0x02,
	0xf6, 0xa8, 0x24, 0xec, 0x32, 0x35, 0x74, 0x09, 0xe9, 0x1f, 0xd2, 0x30, 0xdf, 0xd2, 0x01, 0x0d,
	0x17, 0xcd, 0x31, 0xa5, 0x6a, 0x8f, 0xa8, 0xd4, 0x30, 0xfd, 0xeb, 0xf1, 0xa2, 0xff, 0x41, 0xf1,
	0x76, 0x82, 0xda, 0x44, 0xf3, 0x50, 0xec, 0x72, 0x7f, 0x95, 0x21, 0xa7, 0x3a, 0x96, 0x30, 0xcd,
	0x62, 0xb9, 0x6f, 0xfe, 0x5c, 0x63, 0x8a, 0x18, 0x2a, 0xed, 0x4f, 0x3e, 0xbd, 0xc5, 0xae, 0xa7,
	0x3f, 0xaa, 0xb3, 0xfc, 0x55, 0x83, 0xa9, 0xa1, 0x32, 0xfa, 0x33, 0x90, 0xf9, 0x35, 0x28, 0x7a,
	0xc4, 0xf2, 0xa5, 0xc8, 0xa7, 0x16, 0x9f, 0x1a, 0x55, 0xc2, 0x2f, 0x60, 0x8e, 0xb6, 0x42, 0x3b,
	0x04, 0x4b, 0x12, 0xf3, 0x35, 0x80, 0x68, 0x15, 0x19, 0x50, 0xd8, 0xdb, 0xdc, 0x69, 0xed, 0xd6,
	0x26, 0x50, 0x0d, 0x26, 0x77, 0x5b, 0x9b, 0xcb, 0x9b, 0xbb, 0xef, 0x70, 0x97, 0xae, 0x69, 0x6c,
	0x65, 0x7d, 0x73, 0x67, 0xef, 0xfa, 0xf5, 0xf5, 0x95, 0xf5, 0xd6, 0xe6, 0x6e, 0x4d, 0x37, 0x3f,
	0xd4, 0xa0, 0xc4, 0xdb, 0xa4, 0xcf, 0xe4, 0xa9, 0x99, 0x81, 0x02, 0x37, 0xbf, 0x72, 0x4e, 0x0e,
	0xa8, 0x07, 0x28, 0x97, 0x7e, 0x80, 0x7e, 0xa6, 0x41, 0x41, 0xb4, 0x6c, 0xf3, 0xb1, 0x67, 0x47,
	0xf5, 0xda, 0x52, 0xca, 0xd4, 0x63, 0x33, 0x03, 0x05, 0xe2, 0x76, 0x96, 0x45, 0x72, 0xca, 0x61,
	0x01, 0xb0, 0x20, 0x8d, 0x67, 0x9a, 0x27, 0xe2, 0x2c, 0xc4, 0xbf, 0xf1, 0xfc, 0x62, 0x36, 0x00,
	0xa2, 0xc5, 0x64, 0xda, 0x7e, 0x73, 0x79, 0x77, 0x65, 0x2d, 0x95, 0xb6, 0x55, 0x66, 0xd8, 0x82,
	0x6a, 0xa2, 0xf5, 0x7c, 0x54, 0xb1, 0xcd, 0x4b, 0x50, 0xe4, 0xe8, 0x3e, 0x32, 0x93, 0x59, 0x66,
	0x32, 0xce, 0x4c, 0xa5, 0x96, 0xfb, 0x1a, 0x54, 0x63, 0xbd, 0xd7, 0x7f, 0xd1, 0x80, 0x33, 0x50,
	0xe0, 0xd9, 0x44, 0x55, 0x6a, 0x1c, 0x40, 0x1b, 0x50, 0x56, 0xc5, 0xf4, 0xd8, 0x89, 0x25, 0xe4,
	0x20, 0x5d, 0xe2, 0xb7, 0x1a, 0x54, 0xe2, 0xfd, 0xe5, 0x42, 0x4c, 0xc3, 0xea, 0x75, 0x4e, 0xe8,
	0x60, 0x58, 0xcf, 0xa2, 0xa6, 0xd4, 0x63, 0x35, 0x25, 0xba, 0x9a, 0x74, 0x8f, 0xa7, 0x86, 0x19,
	0xc5, 0xbf, 0x13, 0xae, 0xf2, 0x12, 0xd4, 0xd2, 0x5b, 0xc7, 0x77, 0x98, 0x57, 0x61, 0x32, 0x46,
	0xec, 0xa3, 0xf9, 0xa4, 0x95, 0xd1, 0xb0, 0x1c, 0xca, 0xd6, 0x6f, 0xc3, 0x74, 0xc6, 0x84, 0xe2,
	0x64, 0xd4, 0x61, 0xae, 0xf2, 0x27, 0x2a, 0xdd, 0xca, 0x3f, 0x24, 0x6f, 0xf3, 0xcf, 0x1a, 0x94,
	0x78, 0x27, 0xff, 0x3f, 0xe9, 0x88, 0x3f, 0xd0, 0xa0, 0x20, 0x06, 0x38, 0x59, 0x41, 0x2e, 0xef,
	0x7d, 0x2c, 0xe7, 0x1b, 0x91, 0x9b, 0x38, 0x0b, 0xf1, 0x6f, 0xc2, 0xe1, 0x9e, 0x06, 0x88, 0x16,
	0x47, 0x95, 0x2a, 0xf1, 0x54, 0x74, 0x22, 0x52, 0x32, 0x57, 0x8d, 0x4f, 0x6b, 0x8e, 0xcf, 0x8f,
	0x25, 0x31, 0xbe, 0x31, 0x32, 0x89, 0xf1, 0x5d, 0xe5, 0xd8, 0x3f, 0xd1, 0xe1, 0xf4, 0x9b, 0x96,
	0x6b, 0xdf, 0x24, 0x7e, 0x80, 0xc9, 0xbb, 0x03, 0xe2, 0x07, 0xa8, 0x19, 0x9b, 0x9b, 0x8e, 0x61,
	0x3a, 0x3e, 0x69, 0xdd, 0x1c, 0x9a, 0xb4, 0x8e, 0xc1, 0x29, 0x36, 0x9b, 0x4d, 0x7a, 0x74, 0xee,
	0x04, 0x3c, 0xfa, 0x22, 0x94, 0x7b, 0xf2, 0xe2, 0x72, 0x2e, 0xaa, 0x86, 0x13, 0xa1, 0x3e, 0x42,
	0x04, 0xf3, 0x55, 0x28, 0xab, 0x55, 0x74, 0x29, 0xac, 0xb9, 0xb4, 0x44, 0x97, 0xa2, 0x10, 0x44,
	0x63, 0xa0, 0xea, 0xae, 0xaf, 0x40, 0x35, 0xb1, 0x91, 0xd9, 0xf7, 0x2e, 0x42, 0xd9, 0x27, 0xde,
	0x81, 0xcd, 0x5a, 0x1f, 0x3d, 0xd1, 0x6f, 0x28, 0xda, 0x1d, 0xb1, 0x8d, 0x43, 0x3c, 0xf3, 0x0f,
	0x5a, 0x64, 0x39, 0xb9, 0x3b, 0xaa, 0x23, 0xb7, 0x7b, 0x56, 0x37, 0xec, 0xc8, 0x39, 0xc0, 0x30,
	0x2d, 0xaf, 0x2b, 0x1a, 0x64, 0x03, 0xf3, 0x6f, 0x56, 0x17, 0x10, 0xf7, 0x80, 0xcf, 0x7e, 0x0c,
	0xcc, 0x3e, 0xd1, 0x33, 0x72, 0xae, 0x50, 0x18, 0x39, 0x57, 0x48, 0x4f, 0x14, 0x8a, 0xf1, 0x89,
	0xc2, 0x8b, 0x50, 0x24, 0x87, 0x7d, 0xca, 0x47, 0xb4, 0xec, 0x52, 0xe7, 0xb2, 0x2f, 0xd5, 0xe2,
	0x38, 0x58, 0xe2, 0xb2, 0x32, 0xe4, 0x4c, 0x26, 0x06, 0x13, 0xba, 0x4f, 0x3d, 0x91, 0xd0, 0xaa,
	0x98, 0x7f, 0x23, 0x13, 0x26, 0xc9, 0x61, 0x40, 0x3c, 0xd7, 0x72, 0xb6, 0xd9, 0x9e, 0x18, 0x69,
	0x24, 0xd6, 0x44, 0x88, 0xd1, 0x80, 0xca, 0x99, 0x97, 0x00, 0xd0, 0x2c, 0x94, 0xa4, 0x32, 0xb9,
	0xfd, 0x0d, 0xac, 0x40, 0x74, 0x16, 0x8a, 0x5d, 0x87, 0xee, 0x5b, 0x0e, 0xbf, 0x78, 0x19, 0x4b,
	0x88, 0xf1, 0xb9, 0x45, 0xfd, 0x40, 0xb4, 0xa7, 0x06, 0x16, 0x80, 0x59, 0x82, 0x42, 0xab, 0xd7,
	0x0f, 0x8e, 0xcc, 0x5d, 0x98, 0x5c, 0x66, 0x7e, 0xf7, 0x96, 0x2c, 0xce, 0x67, 0xa3, 0x4a, 0x58,
	0x18, 0x24, 0x2c, 0xdb, 0xcf, 0x42, 0xb1, 0x4d, 0x7b, 0x3d, 0x3b, 0x90, 0x46, 0x91, 0x10, 0x1f,
	0xf9, 0xa8, 0xd4, 0x64, 0x60, 0xfe, 0x6d, 0x7e, 0xa0, 0xc3, 0x24, 0x53, 0x83, 0x28, 0x8f, 0x06,
	0x7e, 0x22, 0xbd, 0x6a, 0x8f, 0x9a, 0x5e, 0xd1, 0x52, 0xb2, 0x5c, 0x8f, 0xac, 0x1c, 0xbf, 0x4a,
	0xb3, 0xf2, 0xe9, 0xbd, 0x39, 0x85, 0x17, 0x5d, 0xe3, 0x2a, 0x14, 0x7d, 0x2e, 0x93, 0xfc, 0x95,
	0xe2, 0x4c, 0xaa, 0xe1, 0x17, 0x02, 0x37, 0xe1, 0xd3, 0x7b, 0x73, 0x12, 0x11, 0xcb, 0xff, 0xd9,
	0x4d, 0xdb, 0xb4, 0x23, 0x34, 0x5f, 0xc0, 0xfc, 0x9b, 0xe9, 0xab, 0x47, 0x7c, 0x9f, 0xf9, 0x6a,
	0x41, 0xe8, 0x4b, 0x82, 0xe6, 0x37, 0x0d, 0x38, 0x13, 0xd7, 0xc1, 0xb6, 0xe5, 0xf9, 0xc4, 0xda,
	0x77, 0xc8, 0x63, 0xa4, 0x8c, 0xad, 0x94, 0x32, 0xd4, 0x1c, 0x25, 0x53, 0xee, 0x13, 0x57, 0x51,
	0xfd, 0x8f, 0x1a, 0x9c, 0x4a, 0x32, 0x45, 0x1b, 0x50, 0x6a, 0x3b, 0x03, 0x3f, 0x90, 0xaa, 0xa9,
	0x2c, 0x2e, 0x1e, 0x4b, 0xa4, 0x15, 0x41, 0x23, 0xb6, 0xb1, 0x62, 0x81, 0xae, 0xc6, 0xf2, 0xa5,
	0x50, 0xce, 0xff, 0xa7, 0xcc, 0x1d, 0x06, 0xad, 0xa0, 0x0c, 0xd1, 0xd1, 0x35, 0x30, 0xf6, 0xed,
	0x0e, 0x71, 0xbb, 0xb6, 0x4b, 0xa4, 0x76, 0xce, 0xa7, 0x68, 0x9b, 0x6a, 0x5f, 0x12, 0x47, 0x04,
	0xf5, 0x6f, 0x68, 0x70, 0x26, 0x53, 0x36, 0x16, 0x46, 0x0e, 0x7f, 0xea, 0x64, 0x46, 0x90, 0x10,
	0xc2, 0x60, 0xd8, 0xee, 0x01, 0x71, 0x03, 0x35, 0x54, 0xad, 0x2c, 0xbe, 0x78, 0xac, 0xab, 0xaf,
	0x2b, 0x2a, 0x25, 0x45, 0xc8, 0xa6, 0xfe, 0x41, 0x1e, 0x9e, 0x18, 0x81, 0x86, 0x08, 0x4c, 0x7a,
	0x84, 0x25, 0x0f, 0xf1, 0x0b, 0xa6, 0xd4, 0xf6, 0xf2, 0x38, 0x47, 0xb2, 0xe4, 0x1a, 0x32, 0xc2,
	0x09, 0xb6, 0xe8, 0x1d, 0x30, 0xac, 0x03, 0xcb, 0x76, 0x18, 0xbd, 0x7c, 0x26, 0xc6, 0x3e, 0x23,
	0x4a, 0xe0, 0x11, 0xcf, 0xfa, 0xde, 0xb8, 0x43, 0x6b, 0x23, 0x73, 0x68, 0x6d, 0x88, 0xa1, 0x75,
	0xfd, 0x57, 0x1a, 0xe7, 0x1b, 0x5d, 0xe4, 0xab, 0x50, 0xb4, 0xda, 0x81, 0x7d, 0x40, 0xe4, 0x0b,
	0x7a, 0x02, 0xb7, 0x90, 0x0c, 0xd1, 0xdb, 0x50, 0xea, 0x13, 0xb7, 0x63, 0xbb, 0xdd, 0x93, 0xd3,
	0x90, 0xe2, 0x68, 0xfe, 0x72, 0x38, 0xc6, 0x5e, 0x4e, 0xc7, 0xd8, 0xb9, 0x94, 0x63, 0x3f, 0x66,
	0xd1, 0x64, 0x2e, 0xc1, 0xd9, 0xec, 0x13, 0xd0, 0x05, 0xa8, 0x44, 0xe5, 0x91, 0x0a, 0xa9, 0xf8,
	0x92, 0xf9, 0x7c, 0x14, 0x02, 0xa9, 0x13, 0x98, 0x3f, 0xf0, 0xe2, 0x3f, 0x0c, 0x45, 0x01, 0x99,
	0xbd, 0x87, 0x8d, 0xdd, 0x6b, 0xc3, 0xb1, 0x9b, 0xbe, 0xdd, 0xe8, 0x28, 0x35, 0xff, 0xa2, 0x8f,
	0x8e, 0xd2, 0xad, 0xcc, 0x28, 0xbd, 0xf8, 0x60, 0xe6, 0x0f, 0x8a, 0xc7, 0xe7, 0x87, 0xe3, 0x31,
	0xb3, 0x44, 0x8a, 0x45, 0xd8, 0x97, 0xa1, 0xac, 0xb6, 0x8e, 0x1f, 0x5d, 0xd5, 0xcc, 0xe8, 0xaa,
	0xca, 0xe8, 0xfa, 0x5a, 0x2a, 0xb8, 0x2e, 0xa6, 0x82, 0x2b, 0x53, 0x24, 0x15, 0x2e, 0x97, 0xd3,
	0xe1, 0x92, 0x89, 0x1d, 0x06, 0xc0, 0xb3, 0x50, 0x15, 0xb3, 0x30, 0x4c, 0xfc, 0x3e, 0x75, 0x13,
	0xef, 0x91, 0x96, 0x7c, 0xb2, 0xdf, 0x07, 0x14, 0xf6, 0x4d, 0x03, 0x5f, 0xb5, 0x16, 0xe7, 0x87,
	0x1a, 0x53, 0x63, 0x74, 0x9b, 0x69, 0x64, 0xb6, 0x99, 0x86, 0x6a, 0x33, 0xeb, 0xa9, 0x36, 0xd3,
	0x88, 0x1e, 0x72, 0xf3, 0x3b, 0x1a, 0xcc, 0xc8, 0xda, 0x31, 0x29, 0x40, 0x56, 0x85, 0x9c, 0x14,
	0x4a, 0x1f, 0x2d, 0x54, 0x2e, 0x53, 0xa8, 0xfc, 0x28, 0xa1, 0x0a, 0x29, 0xa1, 0xee, 0x6b, 0xa2,
	0x8a, 0x89, 0x09, 0xc5, 0xb4, 0xe8, 0x13, 0xb4, 0x00, 0x88, 0xee, 0x33, 0x1b, 0x92, 0xce, 0x0d,
	0xe2, 0x12, 0x8f, 0x9b, 0x92, 0xcb, 0x98, 0xc3, 0x19, 0x3b, 0xec, 0x14, 0x8f, 0xf4, 0x1d, 0xbb,
	0x6d, 0xf9, 0x5c, 0xde, 0x02, 0x0e, 0x61, 0x34, 0x0f, 0xa7, 0x07, 0x7c, 0xca, 0xdb, 0xc1, 0x0a,
	0x25, 0xc7, 0x51, 0xd2, 0xcb, 0xe8, 0x69, 0xa8, 0x7a, 0xc4, 0xea, 0x1c, 0x85, 0x78, 0xa2, 0xd2,
	0x48, 0x2e, 0xa2, 0x4b, 0x30, 0x15, 0xfa, 0x6f, 0x88, 0x59, 0xe0, 0x98, 0xc3, 0x1b, 0xe6, 0x2f,
	0x34, 0x80, 0x0d, 0xda, 0x7d, 0x0c, 0xd4, 0x8d, 0x2e, 0x42, 0x89, 0xf6, 0x45, 0xa8, 0x8b, 0xbf,
	0x35, 0x51, 0xbf, 0x15, 0x6c, 0xd0, 0xee, 0x96, 0xd8, 0xc0, 0x0a, 0xc3, 0x6c, 0x72, 0xb1, 0xe5,
	0x32, 0x3a, 0x07, 0x46, 0x60, 0xd9, 0xce, 0x86, 0xed, 0xca, 0xfc, 0x94, 0xc3, 0xd1, 0x02, 0x8b,
	0xce, 0x9b, 0xd4, 0x71, 0xe8, 0x7b, 0x5c, 0xf8, 0x32, 0x96, 0x90, 0xf9, 0x02, 0xe4, 0x36, 0x68,
	0x37, 0xf3, 0xce, 0xb1, 0x38, 0xd1, 0x93, 0x71, 0xf2, 0x3c, 0x54, 0xb8, 0xbe, 0xa4, 0x27, 0x98,
	0x50, 0xf4, 0x88, 0x3f, 0x70, 0xd4, 0x6f, 0xb9, 0x10, 0xc9, 0x8c, 0xe5, 0x8e, 0x79, 0x03, 0xa6,
	0x13, 0xa1, 0x25, 0x49, 0xaf, 0xc4, 0x9a, 0xc8, 0x64, 0x67, 0x9a, 0x74, 0xba, 0xa8, 0x85, 0xbc,
	0x0d, 0xd5, 0xc4, 0x56, 0xa6, 0xe8, 0x08, 0xf2, 0x7b, 0x78, 0x5d, 0xf4, 0xa5, 0x06, 0xe6, 0xdf,
	0x4c, 0x3f, 0x51, 0xe6, 0x13, 0xde, 0x15, 0x2d, 0x30, 0x53, 0x05, 0x34, 0xb0, 0x1c, 0xe9, 0x4f,
	0x02, 0x30, 0x9f, 0x03, 0x14, 0x36, 0xc2, 0x24, 0x9c, 0x35, 0xcc, 0x40, 0x81, 0x27, 0x7e, 0xf9,
	0x57, 0x5a, 0x02, 0x30, 0x9b, 0x30, 0x9d, 0xc0, 0x95, 0x37, 0x8c, 0xb7, 0xec, 0xda, 0x7f, 0x6a,
	0xd9, 0x2f, 0xc3, 0x54, 0xcb, 0x63, 0xe9, 0xdc, 0x72, 0xec, 0x8e, 0xfa, 0x13, 0xad, 0xd1, 0xf9,
	0xea, 0x12, 0xd4, 0x38, 0xba, 0x68, 0x1b, 0x5b, 0x9e, 0x47, 0xbd, 0x07, 0x60, 0x37, 0x60, 0xba,
	0xe5, 0x79, 0x2a, 0x49, 0x6e, 0xd2, 0xe0, 0x3a, 0x1d, 0xb8, 0x0f, 0x60, 0xbf, 0xf8, 0xbd, 0x3c,
	0x94, 0xe4, 0x03, 0x88, 0xae, 0x41, 0x51, 0xea, 0x5b, 0x8d, 0x64, 0x78, 0xff, 0x58, 0x9f, 0xce,
	0x28, 0x55, 0xcc, 0xd3, 0x5f, 0xff, 0xdd, 0xdf, 0xbe, 0xab, 0x1b, 0xa8, 0xd4, 0xf0, 0x55, 0x55,
	0x5f, 0x14, 0x39, 0x18, 0xa5, 0x67, 0x04, 0x52, 0xa7, 0xf5, 0x99, 0xc4, 0x6f, 0x62, 0x32, 0x55,
	0x9b, 0x33, 0x9c, 0xd1, 0x29, 0xd3, 0x68, 0x28, 0x15, 0x2d, 0x69, 0xcf, 0xa1, 0xf7, 0xa1, 0x12,
	0xf3, 0x25, 0xf4, 0x64, 0x7c, 0x46, 0x94, 0xc8, 0x9c, 0xf5, 0x7a, 0xd6, 0x96, 0x30, 0x8c, 0xf9,
	0x32, 0xe7, 0x7d, 0x05, 0x2d, 0x34, 0xb8, 0xfd, 0x1a, 0x77, 0xa2, 0x70, 0xbe, 0xdb, 0xb8, 0xc3,
	0x03, 0xf8, 0x6e, 0xe3, 0x0e, 0x0f, 0xd9, 0xbb, 0x8d, 0x3b, 0x2a, 0x42, 0xef, 0xa2, 0x0f, 0xb5,
	0xb4, 0x07, 0xfe, 0x5f, 0xa6, 0xcb, 0x4a, 0x11, 0xce, 0x65, 0x6f, 0x4a, 0x21, 0x3e, 0xcf, 0x85,
	0x78, 0x05, 0xbd, 0xf4, 0x70, 0x42, 0x34, 0xee, 0x30, 0x37, 0xbf, 0x8b, 0x06, 0x50, 0x91, 0x7c,
	0x37, 0x68, 0xd7, 0x47, 0xb1, 0x64, 0xa1, 0x8e, 0x8f, 0xc5, 0xa2, 0xd9, 0xe2, 0x87, 0x7d, 0xd1,
	0x7c, 0xb1, 0xe1, 0xd0, 0xae, 0xff, 0x90, 0x67, 0x2d, 0xa9, 0xb4, 0x73, 0x45, 0x6b, 0xd6, 0x3e,
	0xbe, 0x7f, 0x5e, 0xfb, 0xc7, 0xfd, 0xf3, 0xda, 0x47, 0x9f, 0x9c, 0xd7, 0x3e, 0xfe, 0xe4, 0xbc,
	0xb6, 0x5f, 0xe4, 0xe3, 0x89, 0x17, 0xfe, 0x1d, 0x00, 0x00, 0xff, 0xff, 0x53, 0x82, 0x39, 0x19,
	0x69, 0x29, 0x00, 0x00,
}
