// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: nginx.proto

package proto

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// NGINX config action enum
type NginxConfigAction int32

const (
	// Unknown action
	NginxConfigAction_UNKNOWN NginxConfigAction = 0
	// Apply config action
	NginxConfigAction_APPLY NginxConfigAction = 1
	// Test config action (This will be implemented in a future release)
	NginxConfigAction_TEST NginxConfigAction = 2
	// Rollback config action (This will be implemented in a future release)
	NginxConfigAction_ROLLBACK NginxConfigAction = 3
	// Return config action (This will be implemented in a future release)
	NginxConfigAction_RETURN NginxConfigAction = 4
	// Force config apply action
	NginxConfigAction_FORCE NginxConfigAction = 5
)

var NginxConfigAction_name = map[int32]string{
	0: "UNKNOWN",
	1: "APPLY",
	2: "TEST",
	3: "ROLLBACK",
	4: "RETURN",
	5: "FORCE",
}

var NginxConfigAction_value = map[string]int32{
	"UNKNOWN":  0,
	"APPLY":    1,
	"TEST":     2,
	"ROLLBACK": 3,
	"RETURN":   4,
	"FORCE":    5,
}

func (x NginxConfigAction) String() string {
	return proto.EnumName(NginxConfigAction_name, int32(x))
}

func (NginxConfigAction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_917f1a70b1fd7255, []int{0}
}

// SSL type enum
type NginxSslMetaData_NginxSslType int32

const (
	// SSL complied with NGINX
	NginxSslMetaData_BUILT NginxSslMetaData_NginxSslType = 0
	// SSL not complied with NGINX
	NginxSslMetaData_RUN NginxSslMetaData_NginxSslType = 1
)

var NginxSslMetaData_NginxSslType_name = map[int32]string{
	0: "BUILT",
	1: "RUN",
}

var NginxSslMetaData_NginxSslType_value = map[string]int32{
	"BUILT": 0,
	"RUN":   1,
}

func (x NginxSslMetaData_NginxSslType) String() string {
	return proto.EnumName(NginxSslMetaData_NginxSslType_name, int32(x))
}

func (NginxSslMetaData_NginxSslType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_917f1a70b1fd7255, []int{2, 0}
}

// NGINX status enum
type NginxHealth_NginxStatus int32

const (
	// Unknown status
	NginxHealth_UNKNOWN NginxHealth_NginxStatus = 0
	// Active status
	NginxHealth_ACTIVE NginxHealth_NginxStatus = 1
	// Degraded status
	NginxHealth_DEGRADED NginxHealth_NginxStatus = 2
)

var NginxHealth_NginxStatus_name = map[int32]string{
	0: "UNKNOWN",
	1: "ACTIVE",
	2: "DEGRADED",
}

var NginxHealth_NginxStatus_value = map[string]int32{
	"UNKNOWN":  0,
	"ACTIVE":   1,
	"DEGRADED": 2,
}

func (x NginxHealth_NginxStatus) String() string {
	return proto.EnumName(NginxHealth_NginxStatus_name, int32(x))
}

func (NginxHealth_NginxStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_917f1a70b1fd7255, []int{3, 0}
}

// swagger:model NginxDetails
// Represents NGINX details about a single NGINX instance
type NginxDetails struct {
	// NGINX ID.
	// Example: b636d4376dea15405589692d3c5d3869ff3a9b26b0e7bb4bb1aa7e658ace1437
	NginxId string `protobuf:"bytes,1,opt,name=nginx_id,json=nginxId,proto3" json:"nginx_id"`
	// NGINX version.
	// Example: 1.23.2
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version"`
	// Path to NGINX configuration.
	// Example: /usr/local/nginx/conf/nginx.conf
	ConfPath string `protobuf:"bytes,3,opt,name=conf_path,json=confPath,proto3" json:"conf_path"`
	// Process ID of NGINX instance.
	// Example: 8
	ProcessId string `protobuf:"bytes,4,opt,name=process_id,json=processId,proto3" json:"process_id"`
	// The path to the NGINX executable.
	// Example: /usr/local/nginx/sbin/nginx
	ProcessPath string `protobuf:"bytes,5,opt,name=process_path,json=processPath,proto3" json:"process_path"`
	// The start time of the NGINX instance.
	// Example: 1670429190000
	StartTime int64 `protobuf:"varint,6,opt,name=start_time,json=startTime,proto3" json:"start_time"`
	// Determines if the NGINX instance was built from the source code in github or not.
	// Example: false
	BuiltFromSource bool `protobuf:"varint,7,opt,name=built_from_source,json=builtFromSource,proto3" json:"built_from_source"`
	// List of NGINX loadable modules.
	// Example: []
	LoadableModules []string `protobuf:"bytes,8,rep,name=loadable_modules,json=loadableModules,proto3" json:"loadable_modules"`
	// List of NGINX runtime modules.
	// Example: [ "http_stub_status_module" ]
	RuntimeModules []string `protobuf:"bytes,9,rep,name=runtime_modules,json=runtimeModules,proto3" json:"runtime_modules"`
	// NGINX Plus metadata.
	Plus *NginxPlusMetaData `protobuf:"bytes,10,opt,name=plus,proto3" json:"plus"`
	// NGINX SSL metadata.
	Ssl *NginxSslMetaData `protobuf:"bytes,11,opt,name=ssl,proto3" json:"ssl"`
	// Status URL.
	// Example: http://localhost:8080/api
	StatusUrl string `protobuf:"bytes,12,opt,name=status_url,json=statusUrl,proto3" json:"status_url"`
	// Command line arguments that were used when the NGINX instance was started.
	// Example: [ "", "with-http_stub_status_module" ]
	ConfigureArgs        []string `protobuf:"bytes,13,rep,name=configure_args,json=configureArgs,proto3" json:"configure_args"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NginxDetails) Reset()         { *m = NginxDetails{} }
func (m *NginxDetails) String() string { return proto.CompactTextString(m) }
func (*NginxDetails) ProtoMessage()    {}
func (*NginxDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_917f1a70b1fd7255, []int{0}
}
func (m *NginxDetails) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NginxDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NginxDetails.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NginxDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NginxDetails.Merge(m, src)
}
func (m *NginxDetails) XXX_Size() int {
	return m.Size()
}
func (m *NginxDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_NginxDetails.DiscardUnknown(m)
}

var xxx_messageInfo_NginxDetails proto.InternalMessageInfo

func (m *NginxDetails) GetNginxId() string {
	if m != nil {
		return m.NginxId
	}
	return ""
}

func (m *NginxDetails) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *NginxDetails) GetConfPath() string {
	if m != nil {
		return m.ConfPath
	}
	return ""
}

func (m *NginxDetails) GetProcessId() string {
	if m != nil {
		return m.ProcessId
	}
	return ""
}

func (m *NginxDetails) GetProcessPath() string {
	if m != nil {
		return m.ProcessPath
	}
	return ""
}

func (m *NginxDetails) GetStartTime() int64 {
	if m != nil {
		return m.StartTime
	}
	return 0
}

func (m *NginxDetails) GetBuiltFromSource() bool {
	if m != nil {
		return m.BuiltFromSource
	}
	return false
}

func (m *NginxDetails) GetLoadableModules() []string {
	if m != nil {
		return m.LoadableModules
	}
	return nil
}

func (m *NginxDetails) GetRuntimeModules() []string {
	if m != nil {
		return m.RuntimeModules
	}
	return nil
}

func (m *NginxDetails) GetPlus() *NginxPlusMetaData {
	if m != nil {
		return m.Plus
	}
	return nil
}

func (m *NginxDetails) GetSsl() *NginxSslMetaData {
	if m != nil {
		return m.Ssl
	}
	return nil
}

func (m *NginxDetails) GetStatusUrl() string {
	if m != nil {
		return m.StatusUrl
	}
	return ""
}

func (m *NginxDetails) GetConfigureArgs() []string {
	if m != nil {
		return m.ConfigureArgs
	}
	return nil
}

// swagger:model NginxPlusMetaData
// Represents NGINX Plus metadata
type NginxPlusMetaData struct {
	// Determines if its a plus instance or not.
	// Example: true
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled"`
	// NGINX Plus version.
	// Example: R27
	Release              string   `protobuf:"bytes,2,opt,name=release,proto3" json:"release"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NginxPlusMetaData) Reset()         { *m = NginxPlusMetaData{} }
func (m *NginxPlusMetaData) String() string { return proto.CompactTextString(m) }
func (*NginxPlusMetaData) ProtoMessage()    {}
func (*NginxPlusMetaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_917f1a70b1fd7255, []int{1}
}
func (m *NginxPlusMetaData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NginxPlusMetaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NginxPlusMetaData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NginxPlusMetaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NginxPlusMetaData.Merge(m, src)
}
func (m *NginxPlusMetaData) XXX_Size() int {
	return m.Size()
}
func (m *NginxPlusMetaData) XXX_DiscardUnknown() {
	xxx_messageInfo_NginxPlusMetaData.DiscardUnknown(m)
}

var xxx_messageInfo_NginxPlusMetaData proto.InternalMessageInfo

func (m *NginxPlusMetaData) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *NginxPlusMetaData) GetRelease() string {
	if m != nil {
		return m.Release
	}
	return ""
}

// swagger:model NginxSslMetaData
// Represents NGINX SSL metadata
type NginxSslMetaData struct {
	// SSL Type.
	// Example: 0
	SslType NginxSslMetaData_NginxSslType `protobuf:"varint,1,opt,name=ssl_type,json=sslType,proto3,enum=f5.nginx.agent.sdk.NginxSslMetaData_NginxSslType" json:"ssl_type"`
	// List of SSL information (e.g. version, type, etc).
	// Example: null
	Details              []string `protobuf:"bytes,2,rep,name=details,proto3" json:"details"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NginxSslMetaData) Reset()         { *m = NginxSslMetaData{} }
func (m *NginxSslMetaData) String() string { return proto.CompactTextString(m) }
func (*NginxSslMetaData) ProtoMessage()    {}
func (*NginxSslMetaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_917f1a70b1fd7255, []int{2}
}
func (m *NginxSslMetaData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NginxSslMetaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NginxSslMetaData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NginxSslMetaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NginxSslMetaData.Merge(m, src)
}
func (m *NginxSslMetaData) XXX_Size() int {
	return m.Size()
}
func (m *NginxSslMetaData) XXX_DiscardUnknown() {
	xxx_messageInfo_NginxSslMetaData.DiscardUnknown(m)
}

var xxx_messageInfo_NginxSslMetaData proto.InternalMessageInfo

func (m *NginxSslMetaData) GetSslType() NginxSslMetaData_NginxSslType {
	if m != nil {
		return m.SslType
	}
	return NginxSslMetaData_BUILT
}

func (m *NginxSslMetaData) GetDetails() []string {
	if m != nil {
		return m.Details
	}
	return nil
}

// Represents the health of a NGINX instance
type NginxHealth struct {
	// NGINX ID
	NginxId string `protobuf:"bytes,1,opt,name=nginx_id,json=nginxId,proto3" json:"nginx_id"`
	// NGINX status
	NginxStatus NginxHealth_NginxStatus `protobuf:"varint,2,opt,name=nginx_status,json=nginxStatus,proto3,enum=f5.nginx.agent.sdk.NginxHealth_NginxStatus" json:"nginx_status"`
	// Provides an error message of why a NGINX instance is degraded
	DegradedReason       string   `protobuf:"bytes,3,opt,name=degraded_reason,json=degradedReason,proto3" json:"degraded_reason"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NginxHealth) Reset()         { *m = NginxHealth{} }
func (m *NginxHealth) String() string { return proto.CompactTextString(m) }
func (*NginxHealth) ProtoMessage()    {}
func (*NginxHealth) Descriptor() ([]byte, []int) {
	return fileDescriptor_917f1a70b1fd7255, []int{3}
}
func (m *NginxHealth) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NginxHealth) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NginxHealth.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NginxHealth) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NginxHealth.Merge(m, src)
}
func (m *NginxHealth) XXX_Size() int {
	return m.Size()
}
func (m *NginxHealth) XXX_DiscardUnknown() {
	xxx_messageInfo_NginxHealth.DiscardUnknown(m)
}

var xxx_messageInfo_NginxHealth proto.InternalMessageInfo

func (m *NginxHealth) GetNginxId() string {
	if m != nil {
		return m.NginxId
	}
	return ""
}

func (m *NginxHealth) GetNginxStatus() NginxHealth_NginxStatus {
	if m != nil {
		return m.NginxStatus
	}
	return NginxHealth_UNKNOWN
}

func (m *NginxHealth) GetDegradedReason() string {
	if m != nil {
		return m.DegradedReason
	}
	return ""
}

// Represents a NGINX config
type NginxConfig struct {
	// NGINX config action
	Action NginxConfigAction `protobuf:"varint,1,opt,name=action,proto3,enum=f5.nginx.agent.sdk.NginxConfigAction" json:"action"`
	// Metadata information about the configuration
	ConfigData *ConfigDescriptor `protobuf:"bytes,2,opt,name=config_data,json=configData,proto3" json:"config_data"`
	// Zipped file of all NGINX config files
	Zconfig *ZippedFile `protobuf:"bytes,3,opt,name=zconfig,proto3" json:"zconfig"`
	// Zipped file of all auxiliary files
	Zaux *ZippedFile `protobuf:"bytes,4,opt,name=zaux,proto3" json:"zaux"`
	// Information about all access log files
	AccessLogs *AccessLogs `protobuf:"bytes,5,opt,name=access_logs,json=accessLogs,proto3" json:"access_logs"`
	// Information about all error log files
	ErrorLogs *ErrorLogs `protobuf:"bytes,6,opt,name=error_logs,json=errorLogs,proto3" json:"error_logs"`
	// Information about all SSL certificates files
	Ssl *SslCertificates `protobuf:"bytes,7,opt,name=ssl,proto3" json:"ssl"`
	// Directory map of all config and aux files
	DirectoryMap         *DirectoryMap `protobuf:"bytes,8,opt,name=directory_map,json=directoryMap,proto3" json:"directory_map"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *NginxConfig) Reset()         { *m = NginxConfig{} }
func (m *NginxConfig) String() string { return proto.CompactTextString(m) }
func (*NginxConfig) ProtoMessage()    {}
func (*NginxConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_917f1a70b1fd7255, []int{4}
}
func (m *NginxConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NginxConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NginxConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NginxConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NginxConfig.Merge(m, src)
}
func (m *NginxConfig) XXX_Size() int {
	return m.Size()
}
func (m *NginxConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NginxConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NginxConfig proto.InternalMessageInfo

func (m *NginxConfig) GetAction() NginxConfigAction {
	if m != nil {
		return m.Action
	}
	return NginxConfigAction_UNKNOWN
}

func (m *NginxConfig) GetConfigData() *ConfigDescriptor {
	if m != nil {
		return m.ConfigData
	}
	return nil
}

func (m *NginxConfig) GetZconfig() *ZippedFile {
	if m != nil {
		return m.Zconfig
	}
	return nil
}

func (m *NginxConfig) GetZaux() *ZippedFile {
	if m != nil {
		return m.Zaux
	}
	return nil
}

func (m *NginxConfig) GetAccessLogs() *AccessLogs {
	if m != nil {
		return m.AccessLogs
	}
	return nil
}

func (m *NginxConfig) GetErrorLogs() *ErrorLogs {
	if m != nil {
		return m.ErrorLogs
	}
	return nil
}

func (m *NginxConfig) GetSsl() *SslCertificates {
	if m != nil {
		return m.Ssl
	}
	return nil
}

func (m *NginxConfig) GetDirectoryMap() *DirectoryMap {
	if m != nil {
		return m.DirectoryMap
	}
	return nil
}

// Represents access log files
type AccessLogs struct {
	// List of access log files
	AccessLog            []*AccessLog `protobuf:"bytes,1,rep,name=access_log,json=accessLog,proto3" json:"access_log"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *AccessLogs) Reset()         { *m = AccessLogs{} }
func (m *AccessLogs) String() string { return proto.CompactTextString(m) }
func (*AccessLogs) ProtoMessage()    {}
func (*AccessLogs) Descriptor() ([]byte, []int) {
	return fileDescriptor_917f1a70b1fd7255, []int{5}
}
func (m *AccessLogs) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AccessLogs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccessLogs.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AccessLogs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessLogs.Merge(m, src)
}
func (m *AccessLogs) XXX_Size() int {
	return m.Size()
}
func (m *AccessLogs) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessLogs.DiscardUnknown(m)
}

var xxx_messageInfo_AccessLogs proto.InternalMessageInfo

func (m *AccessLogs) GetAccessLog() []*AccessLog {
	if m != nil {
		return m.AccessLog
	}
	return nil
}

// Represents an access log file
type AccessLog struct {
	// Name of file
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name"`
	// Format of the file
	Format string `protobuf:"bytes,2,opt,name=format,proto3" json:"format"`
	// File Permissions
	Permissions string `protobuf:"bytes,3,opt,name=permissions,proto3" json:"permissions"`
	// Determines if the file is readable or not
	Readable             bool     `protobuf:"varint,4,opt,name=readable,proto3" json:"readable"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccessLog) Reset()         { *m = AccessLog{} }
func (m *AccessLog) String() string { return proto.CompactTextString(m) }
func (*AccessLog) ProtoMessage()    {}
func (*AccessLog) Descriptor() ([]byte, []int) {
	return fileDescriptor_917f1a70b1fd7255, []int{6}
}
func (m *AccessLog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AccessLog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccessLog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AccessLog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessLog.Merge(m, src)
}
func (m *AccessLog) XXX_Size() int {
	return m.Size()
}
func (m *AccessLog) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessLog.DiscardUnknown(m)
}

var xxx_messageInfo_AccessLog proto.InternalMessageInfo

func (m *AccessLog) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AccessLog) GetFormat() string {
	if m != nil {
		return m.Format
	}
	return ""
}

func (m *AccessLog) GetPermissions() string {
	if m != nil {
		return m.Permissions
	}
	return ""
}

func (m *AccessLog) GetReadable() bool {
	if m != nil {
		return m.Readable
	}
	return false
}

// Represents error log files
type ErrorLogs struct {
	// List of error log files
	ErrorLog             []*ErrorLog `protobuf:"bytes,1,rep,name=error_log,json=errorLog,proto3" json:"error_log"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ErrorLogs) Reset()         { *m = ErrorLogs{} }
func (m *ErrorLogs) String() string { return proto.CompactTextString(m) }
func (*ErrorLogs) ProtoMessage()    {}
func (*ErrorLogs) Descriptor() ([]byte, []int) {
	return fileDescriptor_917f1a70b1fd7255, []int{7}
}
func (m *ErrorLogs) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ErrorLogs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ErrorLogs.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ErrorLogs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ErrorLogs.Merge(m, src)
}
func (m *ErrorLogs) XXX_Size() int {
	return m.Size()
}
func (m *ErrorLogs) XXX_DiscardUnknown() {
	xxx_messageInfo_ErrorLogs.DiscardUnknown(m)
}

var xxx_messageInfo_ErrorLogs proto.InternalMessageInfo

func (m *ErrorLogs) GetErrorLog() []*ErrorLog {
	if m != nil {
		return m.ErrorLog
	}
	return nil
}

// Represents an error log file
type ErrorLog struct {
	// Name of file
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name"`
	// Log level
	LogLevel string `protobuf:"bytes,2,opt,name=log_level,json=logLevel,proto3" json:"log_level"`
	// File Permissions
	Permissions string `protobuf:"bytes,3,opt,name=permissions,proto3" json:"permissions"`
	// Determines if the file is readable or not
	Readable             bool     `protobuf:"varint,4,opt,name=readable,proto3" json:"readable"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ErrorLog) Reset()         { *m = ErrorLog{} }
func (m *ErrorLog) String() string { return proto.CompactTextString(m) }
func (*ErrorLog) ProtoMessage()    {}
func (*ErrorLog) Descriptor() ([]byte, []int) {
	return fileDescriptor_917f1a70b1fd7255, []int{8}
}
func (m *ErrorLog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ErrorLog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ErrorLog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ErrorLog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ErrorLog.Merge(m, src)
}
func (m *ErrorLog) XXX_Size() int {
	return m.Size()
}
func (m *ErrorLog) XXX_DiscardUnknown() {
	xxx_messageInfo_ErrorLog.DiscardUnknown(m)
}

var xxx_messageInfo_ErrorLog proto.InternalMessageInfo

func (m *ErrorLog) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ErrorLog) GetLogLevel() string {
	if m != nil {
		return m.LogLevel
	}
	return ""
}

func (m *ErrorLog) GetPermissions() string {
	if m != nil {
		return m.Permissions
	}
	return ""
}

func (m *ErrorLog) GetReadable() bool {
	if m != nil {
		return m.Readable
	}
	return false
}

func init() {
	proto.RegisterEnum("f5.nginx.agent.sdk.NginxConfigAction", NginxConfigAction_name, NginxConfigAction_value)
	proto.RegisterEnum("f5.nginx.agent.sdk.NginxSslMetaData_NginxSslType", NginxSslMetaData_NginxSslType_name, NginxSslMetaData_NginxSslType_value)
	proto.RegisterEnum("f5.nginx.agent.sdk.NginxHealth_NginxStatus", NginxHealth_NginxStatus_name, NginxHealth_NginxStatus_value)
	proto.RegisterType((*NginxDetails)(nil), "f5.nginx.agent.sdk.NginxDetails")
	proto.RegisterType((*NginxPlusMetaData)(nil), "f5.nginx.agent.sdk.NginxPlusMetaData")
	proto.RegisterType((*NginxSslMetaData)(nil), "f5.nginx.agent.sdk.NginxSslMetaData")
	proto.RegisterType((*NginxHealth)(nil), "f5.nginx.agent.sdk.NginxHealth")
	proto.RegisterType((*NginxConfig)(nil), "f5.nginx.agent.sdk.NginxConfig")
	proto.RegisterType((*AccessLogs)(nil), "f5.nginx.agent.sdk.AccessLogs")
	proto.RegisterType((*AccessLog)(nil), "f5.nginx.agent.sdk.AccessLog")
	proto.RegisterType((*ErrorLogs)(nil), "f5.nginx.agent.sdk.ErrorLogs")
	proto.RegisterType((*ErrorLog)(nil), "f5.nginx.agent.sdk.ErrorLog")
}

func init() { proto.RegisterFile("nginx.proto", fileDescriptor_917f1a70b1fd7255) }

var fileDescriptor_917f1a70b1fd7255 = []byte{
	// 1166 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0xcd, 0x6e, 0xdb, 0x46,
	0x10, 0x0e, 0x2d, 0xd9, 0x22, 0x47, 0xb2, 0xcd, 0x6c, 0x5b, 0x80, 0x28, 0x52, 0x53, 0x60, 0x1b,
	0xd4, 0x4d, 0x51, 0x1b, 0x71, 0x5a, 0x14, 0x45, 0x83, 0x06, 0x92, 0xa5, 0x34, 0x46, 0x14, 0xc7,
	0x58, 0xcb, 0x69, 0xeb, 0x0b, 0xbb, 0x16, 0xd7, 0x34, 0x11, 0x4a, 0x14, 0x76, 0xa9, 0x20, 0xc9,
	0x33, 0xf4, 0x49, 0x7a, 0xeb, 0xb1, 0x6f, 0xd0, 0x5b, 0xfb, 0x04, 0x44, 0x91, 0x23, 0x2f, 0x7d,
	0x85, 0x82, 0xb3, 0x4b, 0x4a, 0xfe, 0x6b, 0x72, 0xe9, 0x85, 0x9a, 0xf9, 0x76, 0xbe, 0x6f, 0x39,
	0xb3, 0xb3, 0x43, 0x41, 0x73, 0x12, 0x46, 0x93, 0x97, 0x5b, 0x53, 0x91, 0xa4, 0x09, 0x21, 0xa7,
	0x5f, 0x6d, 0x29, 0x9f, 0x85, 0x7c, 0x92, 0x6e, 0xc9, 0xe0, 0xf9, 0x87, 0xad, 0x51, 0x32, 0x1e,
	0x27, 0x13, 0x15, 0x51, 0x78, 0x93, 0xd3, 0x28, 0xd4, 0x1e, 0x84, 0x49, 0x98, 0x28, 0xdb, 0xfb,
	0x73, 0x19, 0x5a, 0xfb, 0x05, 0xb7, 0xc7, 0x53, 0x16, 0xc5, 0x92, 0x7c, 0x0a, 0x26, 0x6a, 0xf9,
	0x51, 0xe0, 0x18, 0x6d, 0x63, 0xd3, 0xea, 0xb6, 0xf2, 0xcc, 0xad, 0x30, 0xda, 0x40, 0x6b, 0x2f,
	0x20, 0xb7, 0xa1, 0xf1, 0x82, 0x0b, 0x19, 0x25, 0x13, 0x67, 0x09, 0xe3, 0x9a, 0x79, 0xe6, 0x96,
	0x10, 0x2d, 0x0d, 0x72, 0x07, 0xac, 0x62, 0x73, 0x7f, 0xca, 0xd2, 0x33, 0xa7, 0x86, 0x81, 0xab,
	0x79, 0xe6, 0xce, 0x41, 0x6a, 0x16, 0xe6, 0x01, 0x4b, 0xcf, 0xc8, 0x17, 0x00, 0x53, 0x91, 0x8c,
	0xb8, 0x94, 0xc5, 0xee, 0x75, 0x0c, 0x5e, 0xcb, 0x33, 0x77, 0x01, 0xa5, 0x96, 0xb6, 0xf7, 0x02,
	0x72, 0x0f, 0x5a, 0xe5, 0x02, 0xaa, 0x2f, 0x23, 0xc1, 0xce, 0x33, 0xf7, 0x1c, 0x4e, 0x9b, 0xda,
	0x2b, 0xf7, 0x90, 0x29, 0x13, 0xa9, 0x9f, 0x46, 0x63, 0xee, 0xac, 0xb4, 0x8d, 0xcd, 0x9a, 0xda,
	0x63, 0x8e, 0x52, 0x0b, 0xed, 0x61, 0x34, 0xe6, 0xa4, 0x03, 0x37, 0x4f, 0x66, 0x51, 0x9c, 0xfa,
	0xa7, 0x22, 0x19, 0xfb, 0x32, 0x99, 0x89, 0x11, 0x77, 0x1a, 0x6d, 0x63, 0xd3, 0xec, 0x7e, 0x90,
	0x67, 0xee, 0xe5, 0x45, 0xba, 0x8e, 0xd0, 0x43, 0x91, 0x8c, 0x0f, 0x11, 0x20, 0x0f, 0xc0, 0x8e,
	0x13, 0x16, 0xb0, 0x93, 0x98, 0xfb, 0xe3, 0x24, 0x98, 0xc5, 0x5c, 0x3a, 0x66, 0xbb, 0xb6, 0x69,
	0x75, 0xdf, 0xcf, 0x33, 0xf7, 0xd2, 0x1a, 0x5d, 0x2f, 0x91, 0x27, 0x0a, 0x20, 0xf7, 0x61, 0x5d,
	0xcc, 0x26, 0xc5, 0x9b, 0x55, 0x7c, 0x0b, 0xf9, 0xef, 0xe5, 0x99, 0x7b, 0x71, 0x89, 0xae, 0x69,
	0xa0, 0x64, 0xef, 0x42, 0x7d, 0x1a, 0xcf, 0xa4, 0x03, 0x6d, 0x63, 0xb3, 0xb9, 0x73, 0x7b, 0xeb,
	0x72, 0xb3, 0x6c, 0x61, 0x03, 0x1c, 0xc4, 0x33, 0xf9, 0x84, 0xa7, 0xac, 0xc7, 0x52, 0xd6, 0x35,
	0xf3, 0xcc, 0x45, 0x1a, 0xc5, 0x27, 0x79, 0x00, 0x35, 0x29, 0x63, 0xa7, 0x89, 0x1a, 0x9f, 0x5c,
	0xab, 0x71, 0x28, 0xe3, 0x4a, 0xa2, 0x91, 0x67, 0x6e, 0x41, 0xa2, 0xc5, 0x43, 0x97, 0x3d, 0x9d,
	0x49, 0x7f, 0x26, 0x62, 0xa7, 0x35, 0x3f, 0xda, 0x39, 0x8a, 0x65, 0x4f, 0x67, 0xf2, 0x48, 0xc4,
	0xe4, 0x1b, 0x58, 0x53, 0x2d, 0x3b, 0x13, 0xdc, 0x67, 0x22, 0x94, 0xce, 0x2a, 0x66, 0x4c, 0xf2,
	0xcc, 0xbd, 0xb0, 0x42, 0x57, 0x2b, 0xbf, 0x23, 0x42, 0xe9, 0x31, 0xb8, 0x79, 0x29, 0x9f, 0xa2,
	0x59, 0xf9, 0xa4, 0xa8, 0xa9, 0x6a, 0x6a, 0x53, 0x35, 0xab, 0x86, 0x68, 0x69, 0x14, 0x61, 0x82,
	0xc7, 0x9c, 0x49, 0xbe, 0xd8, 0xd3, 0x1a, 0xa2, 0xa5, 0xe1, 0xfd, 0x6e, 0x80, 0x7d, 0x31, 0x5f,
	0x72, 0x0c, 0xa6, 0x94, 0xb1, 0x9f, 0xbe, 0x9a, 0x72, 0xdc, 0x63, 0x6d, 0xe7, 0xee, 0xbb, 0xd4,
	0xa9, 0x02, 0x86, 0xaf, 0xa6, 0x5c, 0xdd, 0xb5, 0x52, 0x86, 0x36, 0xa4, 0x82, 0x8b, 0xf7, 0x0a,
	0xd4, 0xfd, 0x74, 0x96, 0xb0, 0x0e, 0xf8, 0x5e, 0x1a, 0xa2, 0xa5, 0xe1, 0x79, 0xfa, 0x2e, 0x6b,
	0x35, 0x62, 0xc1, 0x72, 0xf7, 0x68, 0x6f, 0x30, 0xb4, 0x6f, 0x90, 0x06, 0xd4, 0xe8, 0xd1, 0xbe,
	0x6d, 0x78, 0xbf, 0x2c, 0x41, 0x13, 0x83, 0x1e, 0x71, 0x16, 0xa7, 0x67, 0xef, 0x7e, 0xdf, 0x7f,
	0x86, 0x96, 0x02, 0xd5, 0x29, 0x61, 0x81, 0xd6, 0x76, 0x3e, 0xbf, 0x36, 0x47, 0xa5, 0xaf, 0xd3,
	0x43, 0x8a, 0xba, 0x9a, 0x8b, 0x22, 0x54, 0xcd, 0x31, 0xb5, 0x5c, 0xf4, 0x79, 0xc0, 0x43, 0xc1,
	0x02, 0x1e, 0xf8, 0x82, 0x33, 0x99, 0x4c, 0xf4, 0xc0, 0xc0, 0x3e, 0xbf, 0xb0, 0x44, 0xd7, 0x4a,
	0x80, 0xa2, 0xef, 0x7d, 0xa9, 0xf3, 0xd2, 0x62, 0x4d, 0x68, 0x1c, 0xed, 0x3f, 0xde, 0x7f, 0xfa,
	0xc3, 0xbe, 0x7d, 0x83, 0x00, 0xac, 0x74, 0x76, 0x87, 0x7b, 0xcf, 0xfa, 0xb6, 0x41, 0x5a, 0x60,
	0xf6, 0xfa, 0xdf, 0xd3, 0x4e, 0xaf, 0xdf, 0xb3, 0x97, 0xbc, 0x7f, 0xea, 0x9a, 0xb6, 0x8b, 0x4d,
	0x44, 0xf6, 0x60, 0x85, 0x8d, 0xd2, 0x62, 0xa8, 0xa9, 0x33, 0xbc, 0xfe, 0xbe, 0x28, 0x42, 0x07,
	0x83, 0xbb, 0x90, 0x67, 0xae, 0x26, 0x52, 0xfd, 0x4b, 0x9e, 0x41, 0x53, 0x75, 0xa6, 0x1f, 0xb0,
	0x94, 0x61, 0xbd, 0xae, 0xb9, 0x3b, 0x4a, 0xaa, 0xc7, 0xe5, 0x48, 0x44, 0xd3, 0x34, 0x11, 0xdd,
	0xf5, 0x3c, 0x73, 0x17, 0xc9, 0x14, 0x94, 0x83, 0x8d, 0xd6, 0x87, 0xc6, 0x6b, 0xe5, 0x62, 0x79,
	0x9a, 0x3b, 0x1b, 0x57, 0x69, 0x1e, 0x47, 0xd3, 0x29, 0x0f, 0x1e, 0x46, 0x31, 0x57, 0xcd, 0xa2,
	0x29, 0xb4, 0x34, 0xc8, 0x7d, 0xa8, 0xbf, 0x66, 0xb3, 0x97, 0x38, 0x66, 0xdf, 0xae, 0x81, 0x03,
	0xa1, 0x88, 0xa7, 0xf8, 0x24, 0x07, 0xd0, 0x64, 0x23, 0x1c, 0xb1, 0x71, 0x12, 0x4a, 0x1c, 0xbd,
	0xd7, 0x88, 0x74, 0x30, 0x6c, 0x90, 0x84, 0x52, 0xa5, 0xb5, 0x40, 0xa3, 0xc0, 0xaa, 0x45, 0x32,
	0x00, 0xe0, 0x42, 0x24, 0x42, 0x09, 0xae, 0xa0, 0xe0, 0x47, 0x57, 0x09, 0xf6, 0x8b, 0x28, 0xd4,
	0xc3, 0x01, 0x32, 0x27, 0x51, 0x8b, 0x97, 0x4b, 0xe4, 0x3b, 0x35, 0xb0, 0x1a, 0x28, 0xf3, 0xf1,
	0x55, 0x32, 0x87, 0x32, 0xde, 0xe5, 0x22, 0x8d, 0x4e, 0xa3, 0x11, 0x4b, 0xb9, 0xbc, 0x30, 0xaf,
	0x7e, 0x84, 0xd5, 0x20, 0x12, 0x7c, 0x94, 0x26, 0xe2, 0x95, 0x3f, 0x66, 0x53, 0xc7, 0x44, 0xa5,
	0xf6, 0x55, 0x4a, 0xbd, 0x32, 0xf0, 0x09, 0x9b, 0x76, 0x6f, 0xe6, 0x99, 0x7b, 0x9e, 0x4a, 0x5b,
	0xc1, 0x42, 0x80, 0x77, 0x0c, 0xd0, 0x39, 0x97, 0xf5, 0xbc, 0x20, 0x8e, 0xd1, 0xae, 0x5d, 0x97,
	0x75, 0xc5, 0x51, 0x59, 0xcf, 0x49, 0xd4, 0xaa, 0x8a, 0xe8, 0xfd, 0x6a, 0x80, 0x55, 0x05, 0x92,
	0x5b, 0x50, 0x9f, 0xb0, 0x31, 0xd7, 0xd7, 0x1a, 0x4f, 0xb0, 0xf0, 0x29, 0x3e, 0x89, 0x07, 0x2b,
	0xa7, 0x89, 0x18, 0xb3, 0x54, 0x8f, 0x3a, 0x6c, 0x61, 0x85, 0x50, 0xfd, 0x4b, 0xee, 0x42, 0x73,
	0xca, 0xc5, 0x38, 0x92, 0xc5, 0xa7, 0x5c, 0xea, 0xdb, 0x88, 0xa7, 0xb8, 0x00, 0xd3, 0x45, 0x87,
	0x6c, 0x82, 0x29, 0xb8, 0xfa, 0x7e, 0x61, 0x6b, 0x99, 0x6a, 0x9e, 0x94, 0x18, 0xad, 0x2c, 0xef,
	0x08, 0xac, 0xea, 0x28, 0xc9, 0x23, 0xb0, 0xaa, 0x83, 0xd4, 0x65, 0xb8, 0xf5, 0x5f, 0x87, 0xaf,
	0xfe, 0x44, 0x54, 0x14, 0x6a, 0x96, 0x47, 0xef, 0xfd, 0x66, 0x80, 0x59, 0x46, 0xbd, 0xa5, 0x04,
	0x77, 0xc0, 0x8a, 0x93, 0xd0, 0x8f, 0xf9, 0x0b, 0x1e, 0xeb, 0x2a, 0xa0, 0x6c, 0x05, 0x52, 0x33,
	0x4e, 0xc2, 0x41, 0x61, 0xfd, 0xaf, 0xa5, 0xb8, 0x73, 0xac, 0xbf, 0x59, 0x8b, 0x33, 0xe5, 0xfc,
	0x04, 0xb3, 0x60, 0xb9, 0x73, 0x70, 0x30, 0xf8, 0xc9, 0x36, 0x88, 0x09, 0xf5, 0x61, 0xff, 0x70,
	0x68, 0x2f, 0x15, 0xa3, 0x8c, 0x3e, 0x1d, 0x0c, 0xba, 0x9d, 0xdd, 0xc7, 0x76, 0xad, 0x18, 0x72,
	0xb4, 0x3f, 0x3c, 0xa2, 0xfb, 0x76, 0xbd, 0x08, 0x7f, 0xf8, 0x94, 0xee, 0xf6, 0xed, 0xe5, 0xee,
	0xd7, 0x7f, 0xbc, 0xd9, 0x30, 0xfe, 0x7a, 0xb3, 0x61, 0xfc, 0xfd, 0x66, 0xc3, 0x38, 0xfe, 0x2c,
	0x8c, 0xd2, 0xb3, 0xd9, 0xc9, 0xd6, 0x28, 0x19, 0x6f, 0x63, 0x6d, 0xb7, 0xb1, 0xb6, 0xdb, 0x32,
	0x78, 0xbe, 0xfd, 0x62, 0x67, 0x1b, 0xff, 0x14, 0x7e, 0x8b, 0xcf, 0x93, 0x15, 0xfc, 0xb9, 0xf7,
	0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x4d, 0x80, 0x5c, 0xfb, 0x6c, 0x0a, 0x00, 0x00,
}

func (m *NginxDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NginxDetails) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NginxDetails) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ConfigureArgs) > 0 {
		for iNdEx := len(m.ConfigureArgs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ConfigureArgs[iNdEx])
			copy(dAtA[i:], m.ConfigureArgs[iNdEx])
			i = encodeVarintNginx(dAtA, i, uint64(len(m.ConfigureArgs[iNdEx])))
			i--
			dAtA[i] = 0x6a
		}
	}
	if len(m.StatusUrl) > 0 {
		i -= len(m.StatusUrl)
		copy(dAtA[i:], m.StatusUrl)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.StatusUrl)))
		i--
		dAtA[i] = 0x62
	}
	if m.Ssl != nil {
		{
			size, err := m.Ssl.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNginx(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.Plus != nil {
		{
			size, err := m.Plus.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNginx(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.RuntimeModules) > 0 {
		for iNdEx := len(m.RuntimeModules) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RuntimeModules[iNdEx])
			copy(dAtA[i:], m.RuntimeModules[iNdEx])
			i = encodeVarintNginx(dAtA, i, uint64(len(m.RuntimeModules[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.LoadableModules) > 0 {
		for iNdEx := len(m.LoadableModules) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.LoadableModules[iNdEx])
			copy(dAtA[i:], m.LoadableModules[iNdEx])
			i = encodeVarintNginx(dAtA, i, uint64(len(m.LoadableModules[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if m.BuiltFromSource {
		i--
		if m.BuiltFromSource {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.StartTime != 0 {
		i = encodeVarintNginx(dAtA, i, uint64(m.StartTime))
		i--
		dAtA[i] = 0x30
	}
	if len(m.ProcessPath) > 0 {
		i -= len(m.ProcessPath)
		copy(dAtA[i:], m.ProcessPath)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.ProcessPath)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ProcessId) > 0 {
		i -= len(m.ProcessId)
		copy(dAtA[i:], m.ProcessId)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.ProcessId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ConfPath) > 0 {
		i -= len(m.ConfPath)
		copy(dAtA[i:], m.ConfPath)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.ConfPath)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NginxId) > 0 {
		i -= len(m.NginxId)
		copy(dAtA[i:], m.NginxId)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.NginxId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NginxPlusMetaData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NginxPlusMetaData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NginxPlusMetaData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Release) > 0 {
		i -= len(m.Release)
		copy(dAtA[i:], m.Release)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.Release)))
		i--
		dAtA[i] = 0x12
	}
	if m.Enabled {
		i--
		if m.Enabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NginxSslMetaData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NginxSslMetaData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NginxSslMetaData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Details) > 0 {
		for iNdEx := len(m.Details) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Details[iNdEx])
			copy(dAtA[i:], m.Details[iNdEx])
			i = encodeVarintNginx(dAtA, i, uint64(len(m.Details[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.SslType != 0 {
		i = encodeVarintNginx(dAtA, i, uint64(m.SslType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NginxHealth) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NginxHealth) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NginxHealth) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DegradedReason) > 0 {
		i -= len(m.DegradedReason)
		copy(dAtA[i:], m.DegradedReason)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.DegradedReason)))
		i--
		dAtA[i] = 0x1a
	}
	if m.NginxStatus != 0 {
		i = encodeVarintNginx(dAtA, i, uint64(m.NginxStatus))
		i--
		dAtA[i] = 0x10
	}
	if len(m.NginxId) > 0 {
		i -= len(m.NginxId)
		copy(dAtA[i:], m.NginxId)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.NginxId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NginxConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NginxConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NginxConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DirectoryMap != nil {
		{
			size, err := m.DirectoryMap.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNginx(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.Ssl != nil {
		{
			size, err := m.Ssl.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNginx(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.ErrorLogs != nil {
		{
			size, err := m.ErrorLogs.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNginx(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.AccessLogs != nil {
		{
			size, err := m.AccessLogs.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNginx(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Zaux != nil {
		{
			size, err := m.Zaux.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNginx(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Zconfig != nil {
		{
			size, err := m.Zconfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNginx(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.ConfigData != nil {
		{
			size, err := m.ConfigData.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNginx(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Action != 0 {
		i = encodeVarintNginx(dAtA, i, uint64(m.Action))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *AccessLogs) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccessLogs) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccessLogs) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AccessLog) > 0 {
		for iNdEx := len(m.AccessLog) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AccessLog[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNginx(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AccessLog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccessLog) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccessLog) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Readable {
		i--
		if m.Readable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Permissions) > 0 {
		i -= len(m.Permissions)
		copy(dAtA[i:], m.Permissions)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.Permissions)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Format) > 0 {
		i -= len(m.Format)
		copy(dAtA[i:], m.Format)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.Format)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ErrorLogs) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ErrorLogs) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ErrorLogs) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ErrorLog) > 0 {
		for iNdEx := len(m.ErrorLog) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ErrorLog[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNginx(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ErrorLog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ErrorLog) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ErrorLog) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Readable {
		i--
		if m.Readable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Permissions) > 0 {
		i -= len(m.Permissions)
		copy(dAtA[i:], m.Permissions)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.Permissions)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.LogLevel) > 0 {
		i -= len(m.LogLevel)
		copy(dAtA[i:], m.LogLevel)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.LogLevel)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintNginx(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintNginx(dAtA []byte, offset int, v uint64) int {
	offset -= sovNginx(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *NginxDetails) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NginxId)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	l = len(m.ConfPath)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	l = len(m.ProcessId)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	l = len(m.ProcessPath)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.StartTime != 0 {
		n += 1 + sovNginx(uint64(m.StartTime))
	}
	if m.BuiltFromSource {
		n += 2
	}
	if len(m.LoadableModules) > 0 {
		for _, s := range m.LoadableModules {
			l = len(s)
			n += 1 + l + sovNginx(uint64(l))
		}
	}
	if len(m.RuntimeModules) > 0 {
		for _, s := range m.RuntimeModules {
			l = len(s)
			n += 1 + l + sovNginx(uint64(l))
		}
	}
	if m.Plus != nil {
		l = m.Plus.Size()
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.Ssl != nil {
		l = m.Ssl.Size()
		n += 1 + l + sovNginx(uint64(l))
	}
	l = len(m.StatusUrl)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	if len(m.ConfigureArgs) > 0 {
		for _, s := range m.ConfigureArgs {
			l = len(s)
			n += 1 + l + sovNginx(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NginxPlusMetaData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Enabled {
		n += 2
	}
	l = len(m.Release)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NginxSslMetaData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SslType != 0 {
		n += 1 + sovNginx(uint64(m.SslType))
	}
	if len(m.Details) > 0 {
		for _, s := range m.Details {
			l = len(s)
			n += 1 + l + sovNginx(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NginxHealth) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NginxId)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.NginxStatus != 0 {
		n += 1 + sovNginx(uint64(m.NginxStatus))
	}
	l = len(m.DegradedReason)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NginxConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Action != 0 {
		n += 1 + sovNginx(uint64(m.Action))
	}
	if m.ConfigData != nil {
		l = m.ConfigData.Size()
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.Zconfig != nil {
		l = m.Zconfig.Size()
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.Zaux != nil {
		l = m.Zaux.Size()
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.AccessLogs != nil {
		l = m.AccessLogs.Size()
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.ErrorLogs != nil {
		l = m.ErrorLogs.Size()
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.Ssl != nil {
		l = m.Ssl.Size()
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.DirectoryMap != nil {
		l = m.DirectoryMap.Size()
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccessLogs) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.AccessLog) > 0 {
		for _, e := range m.AccessLog {
			l = e.Size()
			n += 1 + l + sovNginx(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccessLog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	l = len(m.Format)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	l = len(m.Permissions)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.Readable {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ErrorLogs) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ErrorLog) > 0 {
		for _, e := range m.ErrorLog {
			l = e.Size()
			n += 1 + l + sovNginx(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ErrorLog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	l = len(m.LogLevel)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	l = len(m.Permissions)
	if l > 0 {
		n += 1 + l + sovNginx(uint64(l))
	}
	if m.Readable {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovNginx(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozNginx(x uint64) (n int) {
	return sovNginx(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *NginxDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNginx
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NginxDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NginxDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NginxId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NginxId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProcessId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProcessPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			m.StartTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuiltFromSource", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BuiltFromSource = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadableModules", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LoadableModules = append(m.LoadableModules, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeModules", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeModules = append(m.RuntimeModules, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Plus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Plus == nil {
				m.Plus = &NginxPlusMetaData{}
			}
			if err := m.Plus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ssl", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ssl == nil {
				m.Ssl = &NginxSslMetaData{}
			}
			if err := m.Ssl.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatusUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatusUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigureArgs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigureArgs = append(m.ConfigureArgs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNginx(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNginx
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NginxPlusMetaData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNginx
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NginxPlusMetaData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NginxPlusMetaData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Enabled = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Release", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Release = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNginx(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNginx
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NginxSslMetaData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNginx
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NginxSslMetaData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NginxSslMetaData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SslType", wireType)
			}
			m.SslType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SslType |= NginxSslMetaData_NginxSslType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Details", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Details = append(m.Details, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNginx(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNginx
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NginxHealth) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNginx
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NginxHealth: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NginxHealth: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NginxId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NginxId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NginxStatus", wireType)
			}
			m.NginxStatus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NginxStatus |= NginxHealth_NginxStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DegradedReason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DegradedReason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNginx(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNginx
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NginxConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNginx
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NginxConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NginxConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= NginxConfigAction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigData", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConfigData == nil {
				m.ConfigData = &ConfigDescriptor{}
			}
			if err := m.ConfigData.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Zconfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Zconfig == nil {
				m.Zconfig = &ZippedFile{}
			}
			if err := m.Zconfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Zaux", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Zaux == nil {
				m.Zaux = &ZippedFile{}
			}
			if err := m.Zaux.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessLogs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AccessLogs == nil {
				m.AccessLogs = &AccessLogs{}
			}
			if err := m.AccessLogs.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorLogs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ErrorLogs == nil {
				m.ErrorLogs = &ErrorLogs{}
			}
			if err := m.ErrorLogs.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ssl", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ssl == nil {
				m.Ssl = &SslCertificates{}
			}
			if err := m.Ssl.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DirectoryMap", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DirectoryMap == nil {
				m.DirectoryMap = &DirectoryMap{}
			}
			if err := m.DirectoryMap.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNginx(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNginx
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AccessLogs) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNginx
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccessLogs: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccessLogs: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessLog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessLog = append(m.AccessLog, &AccessLog{})
			if err := m.AccessLog[len(m.AccessLog)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNginx(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNginx
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AccessLog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNginx
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccessLog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccessLog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Format", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Format = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Permissions = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Readable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Readable = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipNginx(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNginx
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ErrorLogs) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNginx
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ErrorLogs: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ErrorLogs: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorLog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorLog = append(m.ErrorLog, &ErrorLog{})
			if err := m.ErrorLog[len(m.ErrorLog)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNginx(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNginx
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ErrorLog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNginx
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ErrorLog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ErrorLog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogLevel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LogLevel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNginx
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNginx
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Permissions = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Readable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Readable = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipNginx(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNginx
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipNginx(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowNginx
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNginx
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthNginx
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupNginx
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthNginx
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthNginx        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowNginx          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupNginx = fmt.Errorf("proto: unexpected end of group")
)
