// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1-devel
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/plugin_curation.proto

package registryv1alpha1

import (
	v1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/image/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	pluginpb "google.golang.org/protobuf/types/pluginpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The supported plugin registries for curated plugins.
type PluginRegistryType int32

const (
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_UNSPECIFIED PluginRegistryType = 0
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_GO          PluginRegistryType = 1
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_NPM         PluginRegistryType = 2
)

// Enum value maps for PluginRegistryType.
var (
	PluginRegistryType_name = map[int32]string{
		0: "PLUGIN_REGISTRY_TYPE_UNSPECIFIED",
		1: "PLUGIN_REGISTRY_TYPE_GO",
		2: "PLUGIN_REGISTRY_TYPE_NPM",
	}
	PluginRegistryType_value = map[string]int32{
		"PLUGIN_REGISTRY_TYPE_UNSPECIFIED": 0,
		"PLUGIN_REGISTRY_TYPE_GO":          1,
		"PLUGIN_REGISTRY_TYPE_NPM":         2,
	}
)

func (x PluginRegistryType) Enum() *PluginRegistryType {
	p := new(PluginRegistryType)
	*p = x
	return p
}

func (x PluginRegistryType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PluginRegistryType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[0].Descriptor()
}

func (PluginRegistryType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[0]
}

func (x PluginRegistryType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PluginRegistryType.Descriptor instead.
func (PluginRegistryType) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{0}
}

// PluginLanguage is used to specify the output languages a plugin supports.
type PluginLanguage int32

const (
	PluginLanguage_PLUGIN_LANGUAGE_UNSPECIFIED PluginLanguage = 0
	PluginLanguage_PLUGIN_LANGUAGE_GO          PluginLanguage = 1
	PluginLanguage_PLUGIN_LANGUAGE_JAVASCRIPT  PluginLanguage = 2
	PluginLanguage_PLUGIN_LANGUAGE_TYPESCRIPT  PluginLanguage = 3
	PluginLanguage_PLUGIN_LANGUAGE_SWIFT       PluginLanguage = 4
	PluginLanguage_PLUGIN_LANGUAGE_CPP         PluginLanguage = 5
	PluginLanguage_PLUGIN_LANGUAGE_JAVA        PluginLanguage = 6
	PluginLanguage_PLUGIN_LANGUAGE_DART        PluginLanguage = 7
	PluginLanguage_PLUGIN_LANGUAGE_RUST        PluginLanguage = 8
	PluginLanguage_PLUGIN_LANGUAGE_PYTHON      PluginLanguage = 9
	PluginLanguage_PLUGIN_LANGUAGE_RUBY        PluginLanguage = 10
	PluginLanguage_PLUGIN_LANGUAGE_KOTLIN      PluginLanguage = 11
	PluginLanguage_PLUGIN_LANGUAGE_OBJECTIVE_C PluginLanguage = 12
	PluginLanguage_PLUGIN_LANGUAGE_PHP         PluginLanguage = 13
	PluginLanguage_PLUGIN_LANGUAGE_CSHARP      PluginLanguage = 14
)

// Enum value maps for PluginLanguage.
var (
	PluginLanguage_name = map[int32]string{
		0:  "PLUGIN_LANGUAGE_UNSPECIFIED",
		1:  "PLUGIN_LANGUAGE_GO",
		2:  "PLUGIN_LANGUAGE_JAVASCRIPT",
		3:  "PLUGIN_LANGUAGE_TYPESCRIPT",
		4:  "PLUGIN_LANGUAGE_SWIFT",
		5:  "PLUGIN_LANGUAGE_CPP",
		6:  "PLUGIN_LANGUAGE_JAVA",
		7:  "PLUGIN_LANGUAGE_DART",
		8:  "PLUGIN_LANGUAGE_RUST",
		9:  "PLUGIN_LANGUAGE_PYTHON",
		10: "PLUGIN_LANGUAGE_RUBY",
		11: "PLUGIN_LANGUAGE_KOTLIN",
		12: "PLUGIN_LANGUAGE_OBJECTIVE_C",
		13: "PLUGIN_LANGUAGE_PHP",
		14: "PLUGIN_LANGUAGE_CSHARP",
	}
	PluginLanguage_value = map[string]int32{
		"PLUGIN_LANGUAGE_UNSPECIFIED": 0,
		"PLUGIN_LANGUAGE_GO":          1,
		"PLUGIN_LANGUAGE_JAVASCRIPT":  2,
		"PLUGIN_LANGUAGE_TYPESCRIPT":  3,
		"PLUGIN_LANGUAGE_SWIFT":       4,
		"PLUGIN_LANGUAGE_CPP":         5,
		"PLUGIN_LANGUAGE_JAVA":        6,
		"PLUGIN_LANGUAGE_DART":        7,
		"PLUGIN_LANGUAGE_RUST":        8,
		"PLUGIN_LANGUAGE_PYTHON":      9,
		"PLUGIN_LANGUAGE_RUBY":        10,
		"PLUGIN_LANGUAGE_KOTLIN":      11,
		"PLUGIN_LANGUAGE_OBJECTIVE_C": 12,
		"PLUGIN_LANGUAGE_PHP":         13,
		"PLUGIN_LANGUAGE_CSHARP":      14,
	}
)

func (x PluginLanguage) Enum() *PluginLanguage {
	p := new(PluginLanguage)
	*p = x
	return p
}

func (x PluginLanguage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PluginLanguage) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[1].Descriptor()
}

func (PluginLanguage) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[1]
}

func (x PluginLanguage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PluginLanguage.Descriptor instead.
func (PluginLanguage) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{1}
}

// NPMImportStyle is used to specify the import style the plugin supports.
type NPMImportStyle int32

const (
	NPMImportStyle_NPM_IMPORT_STYLE_UNSPECIFIED NPMImportStyle = 0
	NPMImportStyle_NPM_IMPORT_STYLE_MODULE      NPMImportStyle = 1
	NPMImportStyle_NPM_IMPORT_STYLE_COMMONJS    NPMImportStyle = 2
)

// Enum value maps for NPMImportStyle.
var (
	NPMImportStyle_name = map[int32]string{
		0: "NPM_IMPORT_STYLE_UNSPECIFIED",
		1: "NPM_IMPORT_STYLE_MODULE",
		2: "NPM_IMPORT_STYLE_COMMONJS",
	}
	NPMImportStyle_value = map[string]int32{
		"NPM_IMPORT_STYLE_UNSPECIFIED": 0,
		"NPM_IMPORT_STYLE_MODULE":      1,
		"NPM_IMPORT_STYLE_COMMONJS":    2,
	}
)

func (x NPMImportStyle) Enum() *NPMImportStyle {
	p := new(NPMImportStyle)
	*p = x
	return p
}

func (x NPMImportStyle) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NPMImportStyle) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[2].Descriptor()
}

func (NPMImportStyle) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[2]
}

func (x NPMImportStyle) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NPMImportStyle.Descriptor instead.
func (NPMImportStyle) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{2}
}

// GoConfig is the configuration for a Go plugin.
type GoConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optionally define the runtime libraries for the plugin.
	RuntimeLibraries []*GoConfig_RuntimeLibrary `protobuf:"bytes,1,rep,name=runtime_libraries,json=runtimeLibraries,proto3" json:"runtime_libraries,omitempty"`
	// The minimum Go version required by the plugin.
	MinimumVersion string `protobuf:"bytes,2,opt,name=minimum_version,json=minimumVersion,proto3" json:"minimum_version,omitempty"`
}

func (x *GoConfig) Reset() {
	*x = GoConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoConfig) ProtoMessage() {}

func (x *GoConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoConfig.ProtoReflect.Descriptor instead.
func (*GoConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{0}
}

func (x *GoConfig) GetRuntimeLibraries() []*GoConfig_RuntimeLibrary {
	if x != nil {
		return x.RuntimeLibraries
	}
	return nil
}

func (x *GoConfig) GetMinimumVersion() string {
	if x != nil {
		return x.MinimumVersion
	}
	return ""
}

// NPMConfig is the configuration for a JavaScript NPM plugin.
type NPMConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optionally define the runtime libraries for the plugin.
	RuntimeLibraries []*NPMConfig_RuntimeLibrary `protobuf:"bytes,1,rep,name=runtime_libraries,json=runtimeLibraries,proto3" json:"runtime_libraries,omitempty"`
	// Optionally define a configuration for rewriting import paths, a feature mainly
	// used for remote code generation in the BSR npm registry, which makes it possible
	// to serve the output of a BSR module and a plugin in an individual package.
	//
	// All plugins based on @bufbuild/protoplugin support the option "rewrite_imports".
	// Setting this value, i.e. "connectweb.js" or "pb.js", informs the BSR npm registry
	// that the plugin supports import rewrites with the given import suffix.
	RewriteImportPathSuffix string `protobuf:"bytes,2,opt,name=rewrite_import_path_suffix,json=rewriteImportPathSuffix,proto3" json:"rewrite_import_path_suffix,omitempty"`
	// The import style used for the "type" field in the package.json file.
	// This exists to support legacy plugins that require "commonjs" support.
	ImportStyle NPMImportStyle `protobuf:"varint,3,opt,name=import_style,json=importStyle,proto3,enum=buf.alpha.registry.v1alpha1.NPMImportStyle" json:"import_style,omitempty"`
}

func (x *NPMConfig) Reset() {
	*x = NPMConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NPMConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NPMConfig) ProtoMessage() {}

func (x *NPMConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NPMConfig.ProtoReflect.Descriptor instead.
func (*NPMConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{1}
}

func (x *NPMConfig) GetRuntimeLibraries() []*NPMConfig_RuntimeLibrary {
	if x != nil {
		return x.RuntimeLibraries
	}
	return nil
}

func (x *NPMConfig) GetRewriteImportPathSuffix() string {
	if x != nil {
		return x.RewriteImportPathSuffix
	}
	return ""
}

func (x *NPMConfig) GetImportStyle() NPMImportStyle {
	if x != nil {
		return x.ImportStyle
	}
	return NPMImportStyle_NPM_IMPORT_STYLE_UNSPECIFIED
}

// RegistryConfig is the configuration for the remote registry of a plugin.
type RegistryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to RegistryConfig:
	//
	//	*RegistryConfig_GoConfig
	//	*RegistryConfig_NpmConfig
	RegistryConfig isRegistryConfig_RegistryConfig `protobuf_oneof:"registry_config"`
	// The options to pass to the plugin. These will
	// be merged into a single, comma-separated string.
	Options []string `protobuf:"bytes,10,rep,name=options,proto3" json:"options,omitempty"`
}

func (x *RegistryConfig) Reset() {
	*x = RegistryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegistryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegistryConfig) ProtoMessage() {}

func (x *RegistryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegistryConfig.ProtoReflect.Descriptor instead.
func (*RegistryConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{2}
}

func (m *RegistryConfig) GetRegistryConfig() isRegistryConfig_RegistryConfig {
	if m != nil {
		return m.RegistryConfig
	}
	return nil
}

func (x *RegistryConfig) GetGoConfig() *GoConfig {
	if x, ok := x.GetRegistryConfig().(*RegistryConfig_GoConfig); ok {
		return x.GoConfig
	}
	return nil
}

func (x *RegistryConfig) GetNpmConfig() *NPMConfig {
	if x, ok := x.GetRegistryConfig().(*RegistryConfig_NpmConfig); ok {
		return x.NpmConfig
	}
	return nil
}

func (x *RegistryConfig) GetOptions() []string {
	if x != nil {
		return x.Options
	}
	return nil
}

type isRegistryConfig_RegistryConfig interface {
	isRegistryConfig_RegistryConfig()
}

type RegistryConfig_GoConfig struct {
	GoConfig *GoConfig `protobuf:"bytes,1,opt,name=go_config,json=goConfig,proto3,oneof"`
}

type RegistryConfig_NpmConfig struct {
	NpmConfig *NPMConfig `protobuf:"bytes,2,opt,name=npm_config,json=npmConfig,proto3,oneof"`
}

func (*RegistryConfig_GoConfig) isRegistryConfig_RegistryConfig() {}

func (*RegistryConfig_NpmConfig) isRegistryConfig_RegistryConfig() {}

type CuratedPluginReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The owner of the plugin, i.e. "library".
	Owner string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the plugin, i.e. "connect-go".
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Semver-formatted plugin version.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// The revision for this plugin version.
	Revision uint32 `protobuf:"varint,4,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (x *CuratedPluginReference) Reset() {
	*x = CuratedPluginReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CuratedPluginReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CuratedPluginReference) ProtoMessage() {}

func (x *CuratedPluginReference) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CuratedPluginReference.ProtoReflect.Descriptor instead.
func (*CuratedPluginReference) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{3}
}

func (x *CuratedPluginReference) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *CuratedPluginReference) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CuratedPluginReference) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *CuratedPluginReference) GetRevision() uint32 {
	if x != nil {
		return x.Revision
	}
	return 0
}

// CuratedPlugin represents a protoc plugin curated by Buf, such as protoc-gen-go.
type CuratedPlugin struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the plugin, which uniquely identifies the plugin.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The owner of the plugin, i.e. "library".
	Owner string `protobuf:"bytes,2,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the plugin, i.e. "connect-go".
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The optional registry type of the plugin.
	RegistryType PluginRegistryType `protobuf:"varint,4,opt,name=registry_type,json=registryType,proto3,enum=buf.alpha.registry.v1alpha1.PluginRegistryType" json:"registry_type,omitempty"`
	// Semver-formatted plugin version.
	Version string `protobuf:"bytes,5,opt,name=version,proto3" json:"version,omitempty"`
	// The full container image digest associated with this plugin version including
	// the algorithm.
	// Ref: https://github.com/opencontainers/image-spec/blob/main/descriptor.md#digests
	ContainerImageDigest string `protobuf:"bytes,6,opt,name=container_image_digest,json=containerImageDigest,proto3" json:"container_image_digest,omitempty"`
	// The creation time of the plugin.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// List of plugin dependencies.
	Dependencies []*CuratedPluginReference `protobuf:"bytes,9,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	// Optionally specify the URL leading to the source code of the plugin, if available.
	SourceUrl string `protobuf:"bytes,10,opt,name=source_url,json=sourceUrl,proto3" json:"source_url,omitempty"`
	// Optionally specify a brief description of the plugin functionality.
	Description string `protobuf:"bytes,11,opt,name=description,proto3" json:"description,omitempty"`
	// The configuration for the remote registry of the plugin.
	RegistryConfig *RegistryConfig `protobuf:"bytes,12,opt,name=registry_config,json=registryConfig,proto3" json:"registry_config,omitempty"`
	// The revision for this plugin version.
	Revision uint32 `protobuf:"varint,13,opt,name=revision,proto3" json:"revision,omitempty"`
	// The output languages supported by the plugin.
	OutputLanguages []PluginLanguage `protobuf:"varint,14,rep,packed,name=output_languages,json=outputLanguages,proto3,enum=buf.alpha.registry.v1alpha1.PluginLanguage" json:"output_languages,omitempty"`
	// spdx_license_id is the license of the plugin, which should be one of the identifiers
	// defined in https://spdx.org/licenses
	SpdxLicenseId string `protobuf:"bytes,15,opt,name=spdx_license_id,json=spdxLicenseId,proto3" json:"spdx_license_id,omitempty"`
	// license_url specifies an optional URL for the plugin's license (if not using a standard spdx_license_id).
	LicenseUrl string `protobuf:"bytes,16,opt,name=license_url,json=licenseUrl,proto3" json:"license_url,omitempty"`
	// verified indicates the plugin has been verified. Verification is a property
	// of the BSR and cannot be set by end-users.
	Verified bool `protobuf:"varint,17,opt,name=verified,proto3" json:"verified,omitempty"`
}

func (x *CuratedPlugin) Reset() {
	*x = CuratedPlugin{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CuratedPlugin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CuratedPlugin) ProtoMessage() {}

func (x *CuratedPlugin) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CuratedPlugin.ProtoReflect.Descriptor instead.
func (*CuratedPlugin) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{4}
}

func (x *CuratedPlugin) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *CuratedPlugin) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *CuratedPlugin) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CuratedPlugin) GetRegistryType() PluginRegistryType {
	if x != nil {
		return x.RegistryType
	}
	return PluginRegistryType_PLUGIN_REGISTRY_TYPE_UNSPECIFIED
}

func (x *CuratedPlugin) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *CuratedPlugin) GetContainerImageDigest() string {
	if x != nil {
		return x.ContainerImageDigest
	}
	return ""
}

func (x *CuratedPlugin) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CuratedPlugin) GetDependencies() []*CuratedPluginReference {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *CuratedPlugin) GetSourceUrl() string {
	if x != nil {
		return x.SourceUrl
	}
	return ""
}

func (x *CuratedPlugin) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CuratedPlugin) GetRegistryConfig() *RegistryConfig {
	if x != nil {
		return x.RegistryConfig
	}
	return nil
}

func (x *CuratedPlugin) GetRevision() uint32 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *CuratedPlugin) GetOutputLanguages() []PluginLanguage {
	if x != nil {
		return x.OutputLanguages
	}
	return nil
}

func (x *CuratedPlugin) GetSpdxLicenseId() string {
	if x != nil {
		return x.SpdxLicenseId
	}
	return ""
}

func (x *CuratedPlugin) GetLicenseUrl() string {
	if x != nil {
		return x.LicenseUrl
	}
	return ""
}

func (x *CuratedPlugin) GetVerified() bool {
	if x != nil {
		return x.Verified
	}
	return false
}

type GenerateCodeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The image to run plugins against to generate the desired file outputs.
	//
	// All image files that are not imports and not well-known types will be generated.
	// If you want to filter what files are generated, modify the image.
	// If you want to include imports, set include_imports.
	Image    *v1.Image                  `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	Requests []*PluginGenerationRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
	// Include imports from the Image in generation.
	IncludeImports bool `protobuf:"varint,3,opt,name=include_imports,json=includeImports,proto3" json:"include_imports,omitempty"`
	// Include Well-Known Types from the Image in generation.
	//
	// include_imports must be set if include_well_known_types is set.
	IncludeWellKnownTypes bool `protobuf:"varint,4,opt,name=include_well_known_types,json=includeWellKnownTypes,proto3" json:"include_well_known_types,omitempty"`
}

func (x *GenerateCodeRequest) Reset() {
	*x = GenerateCodeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateCodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateCodeRequest) ProtoMessage() {}

func (x *GenerateCodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateCodeRequest.ProtoReflect.Descriptor instead.
func (*GenerateCodeRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{5}
}

func (x *GenerateCodeRequest) GetImage() *v1.Image {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *GenerateCodeRequest) GetRequests() []*PluginGenerationRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *GenerateCodeRequest) GetIncludeImports() bool {
	if x != nil {
		return x.IncludeImports
	}
	return false
}

func (x *GenerateCodeRequest) GetIncludeWellKnownTypes() bool {
	if x != nil {
		return x.IncludeWellKnownTypes
	}
	return false
}

type GenerateCodeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Responses from each plugin execution.
	// The order of each response matches the order in the GenerateCodeRequest.
	Responses []*PluginGenerationResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
}

func (x *GenerateCodeResponse) Reset() {
	*x = GenerateCodeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateCodeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateCodeResponse) ProtoMessage() {}

func (x *GenerateCodeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateCodeResponse.ProtoReflect.Descriptor instead.
func (*GenerateCodeResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{6}
}

func (x *GenerateCodeResponse) GetResponses() []*PluginGenerationResponse {
	if x != nil {
		return x.Responses
	}
	return nil
}

// Request for performing code generation using the specified plugin.
type PluginGenerationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The plugin to execute.
	PluginReference *CuratedPluginReference `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3" json:"plugin_reference,omitempty"`
	// The options to pass to the plugin. These will
	// be merged into a single, comma-separated string.
	Options []string `protobuf:"bytes,2,rep,name=options,proto3" json:"options,omitempty"`
}

func (x *PluginGenerationRequest) Reset() {
	*x = PluginGenerationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PluginGenerationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginGenerationRequest) ProtoMessage() {}

func (x *PluginGenerationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PluginGenerationRequest.ProtoReflect.Descriptor instead.
func (*PluginGenerationRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{7}
}

func (x *PluginGenerationRequest) GetPluginReference() *CuratedPluginReference {
	if x != nil {
		return x.PluginReference
	}
	return nil
}

func (x *PluginGenerationRequest) GetOptions() []string {
	if x != nil {
		return x.Options
	}
	return nil
}

// Response from code generation for a given plugin.
type PluginGenerationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Generated code from the plugin.
	Response *pluginpb.CodeGeneratorResponse `protobuf:"bytes,1,opt,name=response,proto3" json:"response,omitempty"`
}

func (x *PluginGenerationResponse) Reset() {
	*x = PluginGenerationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PluginGenerationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginGenerationResponse) ProtoMessage() {}

func (x *PluginGenerationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PluginGenerationResponse.ProtoReflect.Descriptor instead.
func (*PluginGenerationResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{8}
}

func (x *PluginGenerationResponse) GetResponse() *pluginpb.CodeGeneratorResponse {
	if x != nil {
		return x.Response
	}
	return nil
}

type CreateCuratedPluginRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The owner of the plugin, i.e. "library".
	Owner string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the plugin, i.e. "connect-go".
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The optional registry type of the plugin.
	RegistryType PluginRegistryType `protobuf:"varint,3,opt,name=registry_type,json=registryType,proto3,enum=buf.alpha.registry.v1alpha1.PluginRegistryType" json:"registry_type,omitempty"`
	// Semver-formatted plugin version.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// The full container image digest associated with this plugin version including
	// the algorithm.
	// Ref: https://github.com/opencontainers/image-spec/blob/main/descriptor.md#digests
	ContainerImageDigest string `protobuf:"bytes,5,opt,name=container_image_digest,json=containerImageDigest,proto3" json:"container_image_digest,omitempty"`
	// List of plugin dependencies.
	Dependencies []*CuratedPluginReference `protobuf:"bytes,7,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	// The URL leading to the source code of the plugin, if available.
	SourceUrl string `protobuf:"bytes,8,opt,name=source_url,json=sourceUrl,proto3" json:"source_url,omitempty"`
	// A brief description of the plugin functionality.
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// The configuration for the remote registry of the plugin.
	RegistryConfig *RegistryConfig `protobuf:"bytes,12,opt,name=registry_config,json=registryConfig,proto3" json:"registry_config,omitempty"`
	// The revision for this plugin version.
	Revision uint32 `protobuf:"varint,13,opt,name=revision,proto3" json:"revision,omitempty"`
	// The output languages supported by the plugin.
	OutputLanguages []PluginLanguage `protobuf:"varint,14,rep,packed,name=output_languages,json=outputLanguages,proto3,enum=buf.alpha.registry.v1alpha1.PluginLanguage" json:"output_languages,omitempty"`
	// spdx_license_id is the license of the plugin, which should be one of the identifiers
	// defined in https://spdx.org/licenses
	SpdxLicenseId string `protobuf:"bytes,15,opt,name=spdx_license_id,json=spdxLicenseId,proto3" json:"spdx_license_id,omitempty"`
	// license_url specifies an optional URL for the plugin's license (if not using a standard spdx_license_id).
	LicenseUrl string `protobuf:"bytes,16,opt,name=license_url,json=licenseUrl,proto3" json:"license_url,omitempty"`
}

func (x *CreateCuratedPluginRequest) Reset() {
	*x = CreateCuratedPluginRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCuratedPluginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCuratedPluginRequest) ProtoMessage() {}

func (x *CreateCuratedPluginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCuratedPluginRequest.ProtoReflect.Descriptor instead.
func (*CreateCuratedPluginRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{9}
}

func (x *CreateCuratedPluginRequest) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetRegistryType() PluginRegistryType {
	if x != nil {
		return x.RegistryType
	}
	return PluginRegistryType_PLUGIN_REGISTRY_TYPE_UNSPECIFIED
}

func (x *CreateCuratedPluginRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetContainerImageDigest() string {
	if x != nil {
		return x.ContainerImageDigest
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetDependencies() []*CuratedPluginReference {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *CreateCuratedPluginRequest) GetSourceUrl() string {
	if x != nil {
		return x.SourceUrl
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetRegistryConfig() *RegistryConfig {
	if x != nil {
		return x.RegistryConfig
	}
	return nil
}

func (x *CreateCuratedPluginRequest) GetRevision() uint32 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *CreateCuratedPluginRequest) GetOutputLanguages() []PluginLanguage {
	if x != nil {
		return x.OutputLanguages
	}
	return nil
}

func (x *CreateCuratedPluginRequest) GetSpdxLicenseId() string {
	if x != nil {
		return x.SpdxLicenseId
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetLicenseUrl() string {
	if x != nil {
		return x.LicenseUrl
	}
	return ""
}

type CreateCuratedPluginResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created plugin.
	Configuration *CuratedPlugin `protobuf:"bytes,1,opt,name=configuration,proto3" json:"configuration,omitempty"`
}

func (x *CreateCuratedPluginResponse) Reset() {
	*x = CreateCuratedPluginResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCuratedPluginResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCuratedPluginResponse) ProtoMessage() {}

func (x *CreateCuratedPluginResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCuratedPluginResponse.ProtoReflect.Descriptor instead.
func (*CreateCuratedPluginResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{10}
}

func (x *CreateCuratedPluginResponse) GetConfiguration() *CuratedPlugin {
	if x != nil {
		return x.Configuration
	}
	return nil
}

type ListCuratedPluginsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The first page is returned if this is empty.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	Reverse   bool   `protobuf:"varint,3,opt,name=reverse,proto3" json:"reverse,omitempty"`
}

func (x *ListCuratedPluginsRequest) Reset() {
	*x = ListCuratedPluginsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCuratedPluginsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCuratedPluginsRequest) ProtoMessage() {}

func (x *ListCuratedPluginsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCuratedPluginsRequest.ProtoReflect.Descriptor instead.
func (*ListCuratedPluginsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{11}
}

func (x *ListCuratedPluginsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCuratedPluginsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCuratedPluginsRequest) GetReverse() bool {
	if x != nil {
		return x.Reverse
	}
	return false
}

type ListCuratedPluginsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Plugins []*CuratedPlugin `protobuf:"bytes,1,rep,name=plugins,proto3" json:"plugins,omitempty"`
	// There are no more pages if this is empty.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCuratedPluginsResponse) Reset() {
	*x = ListCuratedPluginsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCuratedPluginsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCuratedPluginsResponse) ProtoMessage() {}

func (x *ListCuratedPluginsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCuratedPluginsResponse.ProtoReflect.Descriptor instead.
func (*ListCuratedPluginsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{12}
}

func (x *ListCuratedPluginsResponse) GetPlugins() []*CuratedPlugin {
	if x != nil {
		return x.Plugins
	}
	return nil
}

func (x *ListCuratedPluginsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type GetLatestCuratedPluginRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The owner of the plugin, i.e. "library".
	Owner string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the plugin, i.e. "connect-go".
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Both version (semver-formatted) and revision are optional, which means
	// return the latest plugin.
	// If version is set, but revision is omitted, then return the latest
	// revision for that version.
	// If version and revision are both set, return specific plugin.
	// It is an error to set a revision without a corresponding version.
	Version  string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	Revision uint32 `protobuf:"varint,4,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (x *GetLatestCuratedPluginRequest) Reset() {
	*x = GetLatestCuratedPluginRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLatestCuratedPluginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLatestCuratedPluginRequest) ProtoMessage() {}

func (x *GetLatestCuratedPluginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLatestCuratedPluginRequest.ProtoReflect.Descriptor instead.
func (*GetLatestCuratedPluginRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{13}
}

func (x *GetLatestCuratedPluginRequest) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *GetLatestCuratedPluginRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetLatestCuratedPluginRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *GetLatestCuratedPluginRequest) GetRevision() uint32 {
	if x != nil {
		return x.Revision
	}
	return 0
}

type GetLatestCuratedPluginResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Plugin *CuratedPlugin `protobuf:"bytes,1,opt,name=plugin,proto3" json:"plugin,omitempty"`
	// versions is a semver-sorted list in descending order.
	Versions []*CuratedPluginVersionRevisions `protobuf:"bytes,2,rep,name=versions,proto3" json:"versions,omitempty"`
}

func (x *GetLatestCuratedPluginResponse) Reset() {
	*x = GetLatestCuratedPluginResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLatestCuratedPluginResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLatestCuratedPluginResponse) ProtoMessage() {}

func (x *GetLatestCuratedPluginResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLatestCuratedPluginResponse.ProtoReflect.Descriptor instead.
func (*GetLatestCuratedPluginResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{14}
}

func (x *GetLatestCuratedPluginResponse) GetPlugin() *CuratedPlugin {
	if x != nil {
		return x.Plugin
	}
	return nil
}

func (x *GetLatestCuratedPluginResponse) GetVersions() []*CuratedPluginVersionRevisions {
	if x != nil {
		return x.Versions
	}
	return nil
}

type CuratedPluginVersionRevisions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// revisions is a sorted list in descending order.
	Revisions []uint32 `protobuf:"varint,2,rep,packed,name=revisions,proto3" json:"revisions,omitempty"`
}

func (x *CuratedPluginVersionRevisions) Reset() {
	*x = CuratedPluginVersionRevisions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CuratedPluginVersionRevisions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CuratedPluginVersionRevisions) ProtoMessage() {}

func (x *CuratedPluginVersionRevisions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CuratedPluginVersionRevisions.ProtoReflect.Descriptor instead.
func (*CuratedPluginVersionRevisions) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{15}
}

func (x *CuratedPluginVersionRevisions) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *CuratedPluginVersionRevisions) GetRevisions() []uint32 {
	if x != nil {
		return x.Revisions
	}
	return nil
}

// RuntimeLibrary describes the runtime library dependency of the generated code.
type GoConfig_RuntimeLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the runtime library module, i.e. "google.golang.org/protobuf".
	Module string `protobuf:"bytes,1,opt,name=module,proto3" json:"module,omitempty"`
	// The version of the runtime library, i.e. "v1.27.1".
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GoConfig_RuntimeLibrary) Reset() {
	*x = GoConfig_RuntimeLibrary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoConfig_RuntimeLibrary) ProtoMessage() {}

func (x *GoConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoConfig_RuntimeLibrary.ProtoReflect.Descriptor instead.
func (*GoConfig_RuntimeLibrary) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{0, 0}
}

func (x *GoConfig_RuntimeLibrary) GetModule() string {
	if x != nil {
		return x.Module
	}
	return ""
}

func (x *GoConfig_RuntimeLibrary) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// RuntimeLibrary describes the runtime library dependency of the generated code.
type NPMConfig_RuntimeLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the runtime library package, i.e. "@grpc/grpc-js".
	Package string `protobuf:"bytes,1,opt,name=package,proto3" json:"package,omitempty"`
	// The version of the runtime library, i.e. "^1.27.1".
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *NPMConfig_RuntimeLibrary) Reset() {
	*x = NPMConfig_RuntimeLibrary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NPMConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NPMConfig_RuntimeLibrary) ProtoMessage() {}

func (x *NPMConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NPMConfig_RuntimeLibrary.ProtoReflect.Descriptor instead.
func (*NPMConfig_RuntimeLibrary) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{1, 0}
}

func (x *NPMConfig_RuntimeLibrary) GetPackage() string {
	if x != nil {
		return x.Package
	}
	return ""
}

func (x *NPMConfig_RuntimeLibrary) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

var File_buf_alpha_registry_v1alpha1_plugin_curation_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDesc = []byte{
	0x0a, 0x31, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x1a, 0x1e, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xda, 0x01, 0x0a, 0x08, 0x47, 0x6f, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x11, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x10, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x69,
	0x6d, 0x75, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x1a, 0x42, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xc2, 0x02, 0x0a, 0x09, 0x4e, 0x50, 0x4d, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x62, 0x0a, 0x11, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4e, 0x50, 0x4d,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x10, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x1a, 0x72, 0x65, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x73,
	0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x72, 0x65, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x61, 0x74, 0x68, 0x53, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x12, 0x4e, 0x0a, 0x0c, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73,
	0x74, 0x79, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4e, 0x50, 0x4d, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53,
	0x74, 0x79, 0x6c, 0x65, 0x1a, 0x44, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd2, 0x01, 0x0a, 0x0e, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a,
	0x09, 0x67, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x08, 0x67, 0x6f, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x47, 0x0a, 0x0a, 0x6e, 0x70, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4e, 0x50, 0x4d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48,
	0x00, 0x52, 0x09, 0x6e, 0x70, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x11, 0x0a, 0x0f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x0a, 0x22,
	0x78, 0x0a, 0x16, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a,
	0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xf5, 0x05, 0x0a, 0x0d, 0x43, 0x75,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x0d, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x6c,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2b,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x0f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x73, 0x70, 0x64, 0x78, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x70, 0x64, 0x78, 0x4c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f,
	0x75, 0x72, 0x6c, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65,
	0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65,
	0x64, 0x22, 0xfa, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2f, 0x0a, 0x05, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x50, 0x0a, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x27, 0x0a, 0x0f,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x37, 0x0a, 0x18, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x5f, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x57, 0x65, 0x6c, 0x6c, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0x6b,
	0x0a, 0x14, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x52, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x22, 0x93, 0x01, 0x0a, 0x17,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x22, 0x67, 0x0a, 0x18, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a,
	0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x99, 0x05, 0x0a, 0x1a, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x0d, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x14, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x0c, 0x64, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x75,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69,
	0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x6c,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72,
	0x6c, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x72, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x0f, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x73, 0x70, 0x64, 0x78, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x70, 0x64, 0x78, 0x4c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x5f, 0x75, 0x72, 0x6c, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x55, 0x72, 0x6c, 0x22, 0x6f, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x71, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x22, 0x8a, 0x01, 0x0a, 0x1a, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x07, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x07, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7f, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x4c, 0x61,
	0x74, 0x65, 0x73, 0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xbc, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74,
	0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x70,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65,
	0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x06, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12,
	0x56, 0x0a, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x08, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x57, 0x0a, 0x1d, 0x43, 0x75, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x09, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2a, 0x75, 0x0a, 0x12, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e,
	0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17,
	0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x47, 0x4f, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x4c, 0x55,
	0x47, 0x49, 0x4e, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x4e, 0x50, 0x4d, 0x10, 0x02, 0x2a, 0xb3, 0x03, 0x0a, 0x0e, 0x50, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x4c,
	0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x50,
	0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x47,
	0x4f, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41,
	0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x4a, 0x41, 0x56, 0x41, 0x53, 0x43, 0x52, 0x49, 0x50,
	0x54, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41,
	0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x53, 0x43, 0x52, 0x49, 0x50,
	0x54, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41,
	0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x57, 0x49, 0x46, 0x54, 0x10, 0x04, 0x12, 0x17,
	0x0a, 0x13, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47,
	0x45, 0x5f, 0x43, 0x50, 0x50, 0x10, 0x05, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x4c, 0x55, 0x47, 0x49,
	0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x4a, 0x41, 0x56, 0x41, 0x10,
	0x06, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47,
	0x55, 0x41, 0x47, 0x45, 0x5f, 0x44, 0x41, 0x52, 0x54, 0x10, 0x07, 0x12, 0x18, 0x0a, 0x14, 0x50,
	0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x52,
	0x55, 0x53, 0x54, 0x10, 0x08, 0x12, 0x1a, 0x0a, 0x16, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f,
	0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x50, 0x59, 0x54, 0x48, 0x4f, 0x4e, 0x10,
	0x09, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47,
	0x55, 0x41, 0x47, 0x45, 0x5f, 0x52, 0x55, 0x42, 0x59, 0x10, 0x0a, 0x12, 0x1a, 0x0a, 0x16, 0x50,
	0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x4b,
	0x4f, 0x54, 0x4c, 0x49, 0x4e, 0x10, 0x0b, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x4c, 0x55, 0x47, 0x49,
	0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x5f, 0x43, 0x10, 0x0c, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x4c, 0x55, 0x47,
	0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x50, 0x48, 0x50, 0x10,
	0x0d, 0x12, 0x1a, 0x0a, 0x16, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47,
	0x55, 0x41, 0x47, 0x45, 0x5f, 0x43, 0x53, 0x48, 0x41, 0x52, 0x50, 0x10, 0x0e, 0x2a, 0x6e, 0x0a,
	0x0e, 0x4e, 0x50, 0x4d, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12,
	0x20, 0x0a, 0x1c, 0x4e, 0x50, 0x4d, 0x5f, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x53, 0x54,
	0x59, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1b, 0x0a, 0x17, 0x4e, 0x50, 0x4d, 0x5f, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f,
	0x53, 0x54, 0x59, 0x4c, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x1d,
	0x0a, 0x19, 0x4e, 0x50, 0x4d, 0x5f, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x53, 0x54, 0x59,
	0x4c, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x4f, 0x4e, 0x4a, 0x53, 0x10, 0x02, 0x32, 0xbe, 0x03,
	0x0a, 0x15, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x43, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x85, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x12, 0x36,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x88, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65,
	0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x72, 0x61,
	0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x38, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x91, 0x01, 0x0a, 0x16, 0x47,
	0x65, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x75, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0x8c,
	0x01, 0x0a, 0x15, 0x43, 0x6f, 0x64, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x73, 0x0a, 0x0c, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x30, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0xa0, 0x02,
	0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x42, 0x13, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x43, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62, 0x75,
	0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x3b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x52, 0xaa, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x2e,
	0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x56,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c,
	0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02, 0x27, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c, 0x70, 0x68,
	0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea,
	0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a, 0x3a, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x3a, 0x3a, 0x52, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescOnce sync.Once
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescData = file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDesc
)

func file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP() []byte {
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescOnce.Do(func() {
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescData)
	})
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescData
}

var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_goTypes = []interface{}{
	(PluginRegistryType)(0),                // 0: buf.alpha.registry.v1alpha1.PluginRegistryType
	(PluginLanguage)(0),                    // 1: buf.alpha.registry.v1alpha1.PluginLanguage
	(NPMImportStyle)(0),                    // 2: buf.alpha.registry.v1alpha1.NPMImportStyle
	(*GoConfig)(nil),                       // 3: buf.alpha.registry.v1alpha1.GoConfig
	(*NPMConfig)(nil),                      // 4: buf.alpha.registry.v1alpha1.NPMConfig
	(*RegistryConfig)(nil),                 // 5: buf.alpha.registry.v1alpha1.RegistryConfig
	(*CuratedPluginReference)(nil),         // 6: buf.alpha.registry.v1alpha1.CuratedPluginReference
	(*CuratedPlugin)(nil),                  // 7: buf.alpha.registry.v1alpha1.CuratedPlugin
	(*GenerateCodeRequest)(nil),            // 8: buf.alpha.registry.v1alpha1.GenerateCodeRequest
	(*GenerateCodeResponse)(nil),           // 9: buf.alpha.registry.v1alpha1.GenerateCodeResponse
	(*PluginGenerationRequest)(nil),        // 10: buf.alpha.registry.v1alpha1.PluginGenerationRequest
	(*PluginGenerationResponse)(nil),       // 11: buf.alpha.registry.v1alpha1.PluginGenerationResponse
	(*CreateCuratedPluginRequest)(nil),     // 12: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest
	(*CreateCuratedPluginResponse)(nil),    // 13: buf.alpha.registry.v1alpha1.CreateCuratedPluginResponse
	(*ListCuratedPluginsRequest)(nil),      // 14: buf.alpha.registry.v1alpha1.ListCuratedPluginsRequest
	(*ListCuratedPluginsResponse)(nil),     // 15: buf.alpha.registry.v1alpha1.ListCuratedPluginsResponse
	(*GetLatestCuratedPluginRequest)(nil),  // 16: buf.alpha.registry.v1alpha1.GetLatestCuratedPluginRequest
	(*GetLatestCuratedPluginResponse)(nil), // 17: buf.alpha.registry.v1alpha1.GetLatestCuratedPluginResponse
	(*CuratedPluginVersionRevisions)(nil),  // 18: buf.alpha.registry.v1alpha1.CuratedPluginVersionRevisions
	(*GoConfig_RuntimeLibrary)(nil),        // 19: buf.alpha.registry.v1alpha1.GoConfig.RuntimeLibrary
	(*NPMConfig_RuntimeLibrary)(nil),       // 20: buf.alpha.registry.v1alpha1.NPMConfig.RuntimeLibrary
	(*timestamppb.Timestamp)(nil),          // 21: google.protobuf.Timestamp
	(*v1.Image)(nil),                       // 22: buf.alpha.image.v1.Image
	(*pluginpb.CodeGeneratorResponse)(nil), // 23: google.protobuf.compiler.CodeGeneratorResponse
}
var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_depIdxs = []int32{
	19, // 0: buf.alpha.registry.v1alpha1.GoConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.GoConfig.RuntimeLibrary
	20, // 1: buf.alpha.registry.v1alpha1.NPMConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.NPMConfig.RuntimeLibrary
	2,  // 2: buf.alpha.registry.v1alpha1.NPMConfig.import_style:type_name -> buf.alpha.registry.v1alpha1.NPMImportStyle
	3,  // 3: buf.alpha.registry.v1alpha1.RegistryConfig.go_config:type_name -> buf.alpha.registry.v1alpha1.GoConfig
	4,  // 4: buf.alpha.registry.v1alpha1.RegistryConfig.npm_config:type_name -> buf.alpha.registry.v1alpha1.NPMConfig
	0,  // 5: buf.alpha.registry.v1alpha1.CuratedPlugin.registry_type:type_name -> buf.alpha.registry.v1alpha1.PluginRegistryType
	21, // 6: buf.alpha.registry.v1alpha1.CuratedPlugin.create_time:type_name -> google.protobuf.Timestamp
	6,  // 7: buf.alpha.registry.v1alpha1.CuratedPlugin.dependencies:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginReference
	5,  // 8: buf.alpha.registry.v1alpha1.CuratedPlugin.registry_config:type_name -> buf.alpha.registry.v1alpha1.RegistryConfig
	1,  // 9: buf.alpha.registry.v1alpha1.CuratedPlugin.output_languages:type_name -> buf.alpha.registry.v1alpha1.PluginLanguage
	22, // 10: buf.alpha.registry.v1alpha1.GenerateCodeRequest.image:type_name -> buf.alpha.image.v1.Image
	10, // 11: buf.alpha.registry.v1alpha1.GenerateCodeRequest.requests:type_name -> buf.alpha.registry.v1alpha1.PluginGenerationRequest
	11, // 12: buf.alpha.registry.v1alpha1.GenerateCodeResponse.responses:type_name -> buf.alpha.registry.v1alpha1.PluginGenerationResponse
	6,  // 13: buf.alpha.registry.v1alpha1.PluginGenerationRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginReference
	23, // 14: buf.alpha.registry.v1alpha1.PluginGenerationResponse.response:type_name -> google.protobuf.compiler.CodeGeneratorResponse
	0,  // 15: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.registry_type:type_name -> buf.alpha.registry.v1alpha1.PluginRegistryType
	6,  // 16: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.dependencies:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginReference
	5,  // 17: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.registry_config:type_name -> buf.alpha.registry.v1alpha1.RegistryConfig
	1,  // 18: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.output_languages:type_name -> buf.alpha.registry.v1alpha1.PluginLanguage
	7,  // 19: buf.alpha.registry.v1alpha1.CreateCuratedPluginResponse.configuration:type_name -> buf.alpha.registry.v1alpha1.CuratedPlugin
	7,  // 20: buf.alpha.registry.v1alpha1.ListCuratedPluginsResponse.plugins:type_name -> buf.alpha.registry.v1alpha1.CuratedPlugin
	7,  // 21: buf.alpha.registry.v1alpha1.GetLatestCuratedPluginResponse.plugin:type_name -> buf.alpha.registry.v1alpha1.CuratedPlugin
	18, // 22: buf.alpha.registry.v1alpha1.GetLatestCuratedPluginResponse.versions:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginVersionRevisions
	14, // 23: buf.alpha.registry.v1alpha1.PluginCurationService.ListCuratedPlugins:input_type -> buf.alpha.registry.v1alpha1.ListCuratedPluginsRequest
	12, // 24: buf.alpha.registry.v1alpha1.PluginCurationService.CreateCuratedPlugin:input_type -> buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest
	16, // 25: buf.alpha.registry.v1alpha1.PluginCurationService.GetLatestCuratedPlugin:input_type -> buf.alpha.registry.v1alpha1.GetLatestCuratedPluginRequest
	8,  // 26: buf.alpha.registry.v1alpha1.CodeGenerationService.GenerateCode:input_type -> buf.alpha.registry.v1alpha1.GenerateCodeRequest
	15, // 27: buf.alpha.registry.v1alpha1.PluginCurationService.ListCuratedPlugins:output_type -> buf.alpha.registry.v1alpha1.ListCuratedPluginsResponse
	13, // 28: buf.alpha.registry.v1alpha1.PluginCurationService.CreateCuratedPlugin:output_type -> buf.alpha.registry.v1alpha1.CreateCuratedPluginResponse
	17, // 29: buf.alpha.registry.v1alpha1.PluginCurationService.GetLatestCuratedPlugin:output_type -> buf.alpha.registry.v1alpha1.GetLatestCuratedPluginResponse
	9,  // 30: buf.alpha.registry.v1alpha1.CodeGenerationService.GenerateCode:output_type -> buf.alpha.registry.v1alpha1.GenerateCodeResponse
	27, // [27:31] is the sub-list for method output_type
	23, // [23:27] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_plugin_curation_proto_init() }
func file_buf_alpha_registry_v1alpha1_plugin_curation_proto_init() {
	if File_buf_alpha_registry_v1alpha1_plugin_curation_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NPMConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegistryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CuratedPluginReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CuratedPlugin); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateCodeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateCodeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PluginGenerationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PluginGenerationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCuratedPluginRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCuratedPluginResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCuratedPluginsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCuratedPluginsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLatestCuratedPluginRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLatestCuratedPluginResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CuratedPluginVersionRevisions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoConfig_RuntimeLibrary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NPMConfig_RuntimeLibrary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*RegistryConfig_GoConfig)(nil),
		(*RegistryConfig_NpmConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_plugin_curation_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_plugin_curation_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_plugin_curation_proto = out.File
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDesc = nil
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_depIdxs = nil
}
