// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/alpha/registry/v1alpha1/user.proto

package registryv1alpha1connect

import (
	context "context"
	errors "errors"
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	connect_go "github.com/bufbuild/connect-go"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect_go.IsAtLeastVersion0_1_0

const (
	// UserServiceName is the fully-qualified name of the UserService service.
	UserServiceName = "buf.alpha.registry.v1alpha1.UserService"
)

// UserServiceClient is a client for the buf.alpha.registry.v1alpha1.UserService service.
type UserServiceClient interface {
	// CreateUser creates a new user with the given username.
	CreateUser(context.Context, *connect_go.Request[v1alpha1.CreateUserRequest]) (*connect_go.Response[v1alpha1.CreateUserResponse], error)
	// GetUser gets a user by ID.
	GetUser(context.Context, *connect_go.Request[v1alpha1.GetUserRequest]) (*connect_go.Response[v1alpha1.GetUserResponse], error)
	// GetUserByUsername gets a user by username.
	GetUserByUsername(context.Context, *connect_go.Request[v1alpha1.GetUserByUsernameRequest]) (*connect_go.Response[v1alpha1.GetUserByUsernameResponse], error)
	// ListUsers lists all users.
	ListUsers(context.Context, *connect_go.Request[v1alpha1.ListUsersRequest]) (*connect_go.Response[v1alpha1.ListUsersResponse], error)
	// ListOrganizationUsers lists all users for an organization.
	// TODO: #663 move this to organization service
	ListOrganizationUsers(context.Context, *connect_go.Request[v1alpha1.ListOrganizationUsersRequest]) (*connect_go.Response[v1alpha1.ListOrganizationUsersResponse], error)
	// DeleteUser deletes a user.
	DeleteUser(context.Context, *connect_go.Request[v1alpha1.DeleteUserRequest]) (*connect_go.Response[v1alpha1.DeleteUserResponse], error)
	// Deactivate user deactivates a user.
	DeactivateUser(context.Context, *connect_go.Request[v1alpha1.DeactivateUserRequest]) (*connect_go.Response[v1alpha1.DeactivateUserResponse], error)
	// UpdateUserServerRole update the role of an user in the server.
	UpdateUserServerRole(context.Context, *connect_go.Request[v1alpha1.UpdateUserServerRoleRequest]) (*connect_go.Response[v1alpha1.UpdateUserServerRoleResponse], error)
	// CountUsers returns the number of users in the server by the user state provided.
	CountUsers(context.Context, *connect_go.Request[v1alpha1.CountUsersRequest]) (*connect_go.Response[v1alpha1.CountUsersResponse], error)
	// UpdateUserSettings update the user settings including description.
	UpdateUserSettings(context.Context, *connect_go.Request[v1alpha1.UpdateUserSettingsRequest]) (*connect_go.Response[v1alpha1.UpdateUserSettingsResponse], error)
}

// NewUserServiceClient constructs a client for the buf.alpha.registry.v1alpha1.UserService service.
// By default, it uses the Connect protocol with the binary Protobuf Codec, asks for gzipped
// responses, and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the
// connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewUserServiceClient(httpClient connect_go.HTTPClient, baseURL string, opts ...connect_go.ClientOption) UserServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &userServiceClient{
		createUser: connect_go.NewClient[v1alpha1.CreateUserRequest, v1alpha1.CreateUserResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.UserService/CreateUser",
			opts...,
		),
		getUser: connect_go.NewClient[v1alpha1.GetUserRequest, v1alpha1.GetUserResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.UserService/GetUser",
			opts...,
		),
		getUserByUsername: connect_go.NewClient[v1alpha1.GetUserByUsernameRequest, v1alpha1.GetUserByUsernameResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.UserService/GetUserByUsername",
			opts...,
		),
		listUsers: connect_go.NewClient[v1alpha1.ListUsersRequest, v1alpha1.ListUsersResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.UserService/ListUsers",
			opts...,
		),
		listOrganizationUsers: connect_go.NewClient[v1alpha1.ListOrganizationUsersRequest, v1alpha1.ListOrganizationUsersResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.UserService/ListOrganizationUsers",
			opts...,
		),
		deleteUser: connect_go.NewClient[v1alpha1.DeleteUserRequest, v1alpha1.DeleteUserResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.UserService/DeleteUser",
			opts...,
		),
		deactivateUser: connect_go.NewClient[v1alpha1.DeactivateUserRequest, v1alpha1.DeactivateUserResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.UserService/DeactivateUser",
			opts...,
		),
		updateUserServerRole: connect_go.NewClient[v1alpha1.UpdateUserServerRoleRequest, v1alpha1.UpdateUserServerRoleResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.UserService/UpdateUserServerRole",
			opts...,
		),
		countUsers: connect_go.NewClient[v1alpha1.CountUsersRequest, v1alpha1.CountUsersResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.UserService/CountUsers",
			opts...,
		),
		updateUserSettings: connect_go.NewClient[v1alpha1.UpdateUserSettingsRequest, v1alpha1.UpdateUserSettingsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.UserService/UpdateUserSettings",
			opts...,
		),
	}
}

// userServiceClient implements UserServiceClient.
type userServiceClient struct {
	createUser            *connect_go.Client[v1alpha1.CreateUserRequest, v1alpha1.CreateUserResponse]
	getUser               *connect_go.Client[v1alpha1.GetUserRequest, v1alpha1.GetUserResponse]
	getUserByUsername     *connect_go.Client[v1alpha1.GetUserByUsernameRequest, v1alpha1.GetUserByUsernameResponse]
	listUsers             *connect_go.Client[v1alpha1.ListUsersRequest, v1alpha1.ListUsersResponse]
	listOrganizationUsers *connect_go.Client[v1alpha1.ListOrganizationUsersRequest, v1alpha1.ListOrganizationUsersResponse]
	deleteUser            *connect_go.Client[v1alpha1.DeleteUserRequest, v1alpha1.DeleteUserResponse]
	deactivateUser        *connect_go.Client[v1alpha1.DeactivateUserRequest, v1alpha1.DeactivateUserResponse]
	updateUserServerRole  *connect_go.Client[v1alpha1.UpdateUserServerRoleRequest, v1alpha1.UpdateUserServerRoleResponse]
	countUsers            *connect_go.Client[v1alpha1.CountUsersRequest, v1alpha1.CountUsersResponse]
	updateUserSettings    *connect_go.Client[v1alpha1.UpdateUserSettingsRequest, v1alpha1.UpdateUserSettingsResponse]
}

// CreateUser calls buf.alpha.registry.v1alpha1.UserService.CreateUser.
func (c *userServiceClient) CreateUser(ctx context.Context, req *connect_go.Request[v1alpha1.CreateUserRequest]) (*connect_go.Response[v1alpha1.CreateUserResponse], error) {
	return c.createUser.CallUnary(ctx, req)
}

// GetUser calls buf.alpha.registry.v1alpha1.UserService.GetUser.
func (c *userServiceClient) GetUser(ctx context.Context, req *connect_go.Request[v1alpha1.GetUserRequest]) (*connect_go.Response[v1alpha1.GetUserResponse], error) {
	return c.getUser.CallUnary(ctx, req)
}

// GetUserByUsername calls buf.alpha.registry.v1alpha1.UserService.GetUserByUsername.
func (c *userServiceClient) GetUserByUsername(ctx context.Context, req *connect_go.Request[v1alpha1.GetUserByUsernameRequest]) (*connect_go.Response[v1alpha1.GetUserByUsernameResponse], error) {
	return c.getUserByUsername.CallUnary(ctx, req)
}

// ListUsers calls buf.alpha.registry.v1alpha1.UserService.ListUsers.
func (c *userServiceClient) ListUsers(ctx context.Context, req *connect_go.Request[v1alpha1.ListUsersRequest]) (*connect_go.Response[v1alpha1.ListUsersResponse], error) {
	return c.listUsers.CallUnary(ctx, req)
}

// ListOrganizationUsers calls buf.alpha.registry.v1alpha1.UserService.ListOrganizationUsers.
func (c *userServiceClient) ListOrganizationUsers(ctx context.Context, req *connect_go.Request[v1alpha1.ListOrganizationUsersRequest]) (*connect_go.Response[v1alpha1.ListOrganizationUsersResponse], error) {
	return c.listOrganizationUsers.CallUnary(ctx, req)
}

// DeleteUser calls buf.alpha.registry.v1alpha1.UserService.DeleteUser.
func (c *userServiceClient) DeleteUser(ctx context.Context, req *connect_go.Request[v1alpha1.DeleteUserRequest]) (*connect_go.Response[v1alpha1.DeleteUserResponse], error) {
	return c.deleteUser.CallUnary(ctx, req)
}

// DeactivateUser calls buf.alpha.registry.v1alpha1.UserService.DeactivateUser.
func (c *userServiceClient) DeactivateUser(ctx context.Context, req *connect_go.Request[v1alpha1.DeactivateUserRequest]) (*connect_go.Response[v1alpha1.DeactivateUserResponse], error) {
	return c.deactivateUser.CallUnary(ctx, req)
}

// UpdateUserServerRole calls buf.alpha.registry.v1alpha1.UserService.UpdateUserServerRole.
func (c *userServiceClient) UpdateUserServerRole(ctx context.Context, req *connect_go.Request[v1alpha1.UpdateUserServerRoleRequest]) (*connect_go.Response[v1alpha1.UpdateUserServerRoleResponse], error) {
	return c.updateUserServerRole.CallUnary(ctx, req)
}

// CountUsers calls buf.alpha.registry.v1alpha1.UserService.CountUsers.
func (c *userServiceClient) CountUsers(ctx context.Context, req *connect_go.Request[v1alpha1.CountUsersRequest]) (*connect_go.Response[v1alpha1.CountUsersResponse], error) {
	return c.countUsers.CallUnary(ctx, req)
}

// UpdateUserSettings calls buf.alpha.registry.v1alpha1.UserService.UpdateUserSettings.
func (c *userServiceClient) UpdateUserSettings(ctx context.Context, req *connect_go.Request[v1alpha1.UpdateUserSettingsRequest]) (*connect_go.Response[v1alpha1.UpdateUserSettingsResponse], error) {
	return c.updateUserSettings.CallUnary(ctx, req)
}

// UserServiceHandler is an implementation of the buf.alpha.registry.v1alpha1.UserService service.
type UserServiceHandler interface {
	// CreateUser creates a new user with the given username.
	CreateUser(context.Context, *connect_go.Request[v1alpha1.CreateUserRequest]) (*connect_go.Response[v1alpha1.CreateUserResponse], error)
	// GetUser gets a user by ID.
	GetUser(context.Context, *connect_go.Request[v1alpha1.GetUserRequest]) (*connect_go.Response[v1alpha1.GetUserResponse], error)
	// GetUserByUsername gets a user by username.
	GetUserByUsername(context.Context, *connect_go.Request[v1alpha1.GetUserByUsernameRequest]) (*connect_go.Response[v1alpha1.GetUserByUsernameResponse], error)
	// ListUsers lists all users.
	ListUsers(context.Context, *connect_go.Request[v1alpha1.ListUsersRequest]) (*connect_go.Response[v1alpha1.ListUsersResponse], error)
	// ListOrganizationUsers lists all users for an organization.
	// TODO: #663 move this to organization service
	ListOrganizationUsers(context.Context, *connect_go.Request[v1alpha1.ListOrganizationUsersRequest]) (*connect_go.Response[v1alpha1.ListOrganizationUsersResponse], error)
	// DeleteUser deletes a user.
	DeleteUser(context.Context, *connect_go.Request[v1alpha1.DeleteUserRequest]) (*connect_go.Response[v1alpha1.DeleteUserResponse], error)
	// Deactivate user deactivates a user.
	DeactivateUser(context.Context, *connect_go.Request[v1alpha1.DeactivateUserRequest]) (*connect_go.Response[v1alpha1.DeactivateUserResponse], error)
	// UpdateUserServerRole update the role of an user in the server.
	UpdateUserServerRole(context.Context, *connect_go.Request[v1alpha1.UpdateUserServerRoleRequest]) (*connect_go.Response[v1alpha1.UpdateUserServerRoleResponse], error)
	// CountUsers returns the number of users in the server by the user state provided.
	CountUsers(context.Context, *connect_go.Request[v1alpha1.CountUsersRequest]) (*connect_go.Response[v1alpha1.CountUsersResponse], error)
	// UpdateUserSettings update the user settings including description.
	UpdateUserSettings(context.Context, *connect_go.Request[v1alpha1.UpdateUserSettingsRequest]) (*connect_go.Response[v1alpha1.UpdateUserSettingsResponse], error)
}

// NewUserServiceHandler builds an HTTP handler from the service implementation. It returns the path
// on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewUserServiceHandler(svc UserServiceHandler, opts ...connect_go.HandlerOption) (string, http.Handler) {
	mux := http.NewServeMux()
	mux.Handle("/buf.alpha.registry.v1alpha1.UserService/CreateUser", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.UserService/CreateUser",
		svc.CreateUser,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.UserService/GetUser", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.UserService/GetUser",
		svc.GetUser,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.UserService/GetUserByUsername", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.UserService/GetUserByUsername",
		svc.GetUserByUsername,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.UserService/ListUsers", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.UserService/ListUsers",
		svc.ListUsers,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.UserService/ListOrganizationUsers", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.UserService/ListOrganizationUsers",
		svc.ListOrganizationUsers,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.UserService/DeleteUser", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.UserService/DeleteUser",
		svc.DeleteUser,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.UserService/DeactivateUser", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.UserService/DeactivateUser",
		svc.DeactivateUser,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.UserService/UpdateUserServerRole", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.UserService/UpdateUserServerRole",
		svc.UpdateUserServerRole,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.UserService/CountUsers", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.UserService/CountUsers",
		svc.CountUsers,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.UserService/UpdateUserSettings", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.UserService/UpdateUserSettings",
		svc.UpdateUserSettings,
		opts...,
	))
	return "/buf.alpha.registry.v1alpha1.UserService/", mux
}

// UnimplementedUserServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedUserServiceHandler struct{}

func (UnimplementedUserServiceHandler) CreateUser(context.Context, *connect_go.Request[v1alpha1.CreateUserRequest]) (*connect_go.Response[v1alpha1.CreateUserResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.UserService.CreateUser is not implemented"))
}

func (UnimplementedUserServiceHandler) GetUser(context.Context, *connect_go.Request[v1alpha1.GetUserRequest]) (*connect_go.Response[v1alpha1.GetUserResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.UserService.GetUser is not implemented"))
}

func (UnimplementedUserServiceHandler) GetUserByUsername(context.Context, *connect_go.Request[v1alpha1.GetUserByUsernameRequest]) (*connect_go.Response[v1alpha1.GetUserByUsernameResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.UserService.GetUserByUsername is not implemented"))
}

func (UnimplementedUserServiceHandler) ListUsers(context.Context, *connect_go.Request[v1alpha1.ListUsersRequest]) (*connect_go.Response[v1alpha1.ListUsersResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.UserService.ListUsers is not implemented"))
}

func (UnimplementedUserServiceHandler) ListOrganizationUsers(context.Context, *connect_go.Request[v1alpha1.ListOrganizationUsersRequest]) (*connect_go.Response[v1alpha1.ListOrganizationUsersResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.UserService.ListOrganizationUsers is not implemented"))
}

func (UnimplementedUserServiceHandler) DeleteUser(context.Context, *connect_go.Request[v1alpha1.DeleteUserRequest]) (*connect_go.Response[v1alpha1.DeleteUserResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.UserService.DeleteUser is not implemented"))
}

func (UnimplementedUserServiceHandler) DeactivateUser(context.Context, *connect_go.Request[v1alpha1.DeactivateUserRequest]) (*connect_go.Response[v1alpha1.DeactivateUserResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.UserService.DeactivateUser is not implemented"))
}

func (UnimplementedUserServiceHandler) UpdateUserServerRole(context.Context, *connect_go.Request[v1alpha1.UpdateUserServerRoleRequest]) (*connect_go.Response[v1alpha1.UpdateUserServerRoleResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.UserService.UpdateUserServerRole is not implemented"))
}

func (UnimplementedUserServiceHandler) CountUsers(context.Context, *connect_go.Request[v1alpha1.CountUsersRequest]) (*connect_go.Response[v1alpha1.CountUsersResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.UserService.CountUsers is not implemented"))
}

func (UnimplementedUserServiceHandler) UpdateUserSettings(context.Context, *connect_go.Request[v1alpha1.UpdateUserSettingsRequest]) (*connect_go.Response[v1alpha1.UpdateUserSettingsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.UserService.UpdateUserSettings is not implemented"))
}
