// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/alpha/registry/v1alpha1/recommendation.proto

package registryv1alpha1connect

import (
	context "context"
	errors "errors"
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	connect_go "github.com/bufbuild/connect-go"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect_go.IsAtLeastVersion0_1_0

const (
	// RecommendationServiceName is the fully-qualified name of the RecommendationService service.
	RecommendationServiceName = "buf.alpha.registry.v1alpha1.RecommendationService"
)

// RecommendationServiceClient is a client for the buf.alpha.registry.v1alpha1.RecommendationService
// service.
type RecommendationServiceClient interface {
	// RecommendedRepositories returns a list of recommended repositories.
	RecommendedRepositories(context.Context, *connect_go.Request[v1alpha1.RecommendedRepositoriesRequest]) (*connect_go.Response[v1alpha1.RecommendedRepositoriesResponse], error)
	// RecommendedTemplates returns a list of recommended templates.
	//
	// Deprecated: do not use.
	RecommendedTemplates(context.Context, *connect_go.Request[v1alpha1.RecommendedTemplatesRequest]) (*connect_go.Response[v1alpha1.RecommendedTemplatesResponse], error)
	// ListRecommendedResources returns a list of recommended resources.
	ListRecommendedResources(context.Context, *connect_go.Request[v1alpha1.ListRecommendedResourcesRequest]) (*connect_go.Response[v1alpha1.ListRecommendedResourcesResponse], error)
	// SetRecommendedResources set the list of recommendated resources in the server.
	SetRecommendedResources(context.Context, *connect_go.Request[v1alpha1.SetRecommendedResourcesRequest]) (*connect_go.Response[v1alpha1.SetRecommendedResourcesResponse], error)
}

// NewRecommendationServiceClient constructs a client for the
// buf.alpha.registry.v1alpha1.RecommendationService service. By default, it uses the Connect
// protocol with the binary Protobuf Codec, asks for gzipped responses, and sends uncompressed
// requests. To use the gRPC or gRPC-Web protocols, supply the connect.WithGRPC() or
// connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewRecommendationServiceClient(httpClient connect_go.HTTPClient, baseURL string, opts ...connect_go.ClientOption) RecommendationServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &recommendationServiceClient{
		recommendedRepositories: connect_go.NewClient[v1alpha1.RecommendedRepositoriesRequest, v1alpha1.RecommendedRepositoriesResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.RecommendationService/RecommendedRepositories",
			opts...,
		),
		recommendedTemplates: connect_go.NewClient[v1alpha1.RecommendedTemplatesRequest, v1alpha1.RecommendedTemplatesResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.RecommendationService/RecommendedTemplates",
			opts...,
		),
		listRecommendedResources: connect_go.NewClient[v1alpha1.ListRecommendedResourcesRequest, v1alpha1.ListRecommendedResourcesResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.RecommendationService/ListRecommendedResources",
			opts...,
		),
		setRecommendedResources: connect_go.NewClient[v1alpha1.SetRecommendedResourcesRequest, v1alpha1.SetRecommendedResourcesResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.RecommendationService/SetRecommendedResources",
			opts...,
		),
	}
}

// recommendationServiceClient implements RecommendationServiceClient.
type recommendationServiceClient struct {
	recommendedRepositories  *connect_go.Client[v1alpha1.RecommendedRepositoriesRequest, v1alpha1.RecommendedRepositoriesResponse]
	recommendedTemplates     *connect_go.Client[v1alpha1.RecommendedTemplatesRequest, v1alpha1.RecommendedTemplatesResponse]
	listRecommendedResources *connect_go.Client[v1alpha1.ListRecommendedResourcesRequest, v1alpha1.ListRecommendedResourcesResponse]
	setRecommendedResources  *connect_go.Client[v1alpha1.SetRecommendedResourcesRequest, v1alpha1.SetRecommendedResourcesResponse]
}

// RecommendedRepositories calls
// buf.alpha.registry.v1alpha1.RecommendationService.RecommendedRepositories.
func (c *recommendationServiceClient) RecommendedRepositories(ctx context.Context, req *connect_go.Request[v1alpha1.RecommendedRepositoriesRequest]) (*connect_go.Response[v1alpha1.RecommendedRepositoriesResponse], error) {
	return c.recommendedRepositories.CallUnary(ctx, req)
}

// RecommendedTemplates calls
// buf.alpha.registry.v1alpha1.RecommendationService.RecommendedTemplates.
//
// Deprecated: do not use.
func (c *recommendationServiceClient) RecommendedTemplates(ctx context.Context, req *connect_go.Request[v1alpha1.RecommendedTemplatesRequest]) (*connect_go.Response[v1alpha1.RecommendedTemplatesResponse], error) {
	return c.recommendedTemplates.CallUnary(ctx, req)
}

// ListRecommendedResources calls
// buf.alpha.registry.v1alpha1.RecommendationService.ListRecommendedResources.
func (c *recommendationServiceClient) ListRecommendedResources(ctx context.Context, req *connect_go.Request[v1alpha1.ListRecommendedResourcesRequest]) (*connect_go.Response[v1alpha1.ListRecommendedResourcesResponse], error) {
	return c.listRecommendedResources.CallUnary(ctx, req)
}

// SetRecommendedResources calls
// buf.alpha.registry.v1alpha1.RecommendationService.SetRecommendedResources.
func (c *recommendationServiceClient) SetRecommendedResources(ctx context.Context, req *connect_go.Request[v1alpha1.SetRecommendedResourcesRequest]) (*connect_go.Response[v1alpha1.SetRecommendedResourcesResponse], error) {
	return c.setRecommendedResources.CallUnary(ctx, req)
}

// RecommendationServiceHandler is an implementation of the
// buf.alpha.registry.v1alpha1.RecommendationService service.
type RecommendationServiceHandler interface {
	// RecommendedRepositories returns a list of recommended repositories.
	RecommendedRepositories(context.Context, *connect_go.Request[v1alpha1.RecommendedRepositoriesRequest]) (*connect_go.Response[v1alpha1.RecommendedRepositoriesResponse], error)
	// RecommendedTemplates returns a list of recommended templates.
	//
	// Deprecated: do not use.
	RecommendedTemplates(context.Context, *connect_go.Request[v1alpha1.RecommendedTemplatesRequest]) (*connect_go.Response[v1alpha1.RecommendedTemplatesResponse], error)
	// ListRecommendedResources returns a list of recommended resources.
	ListRecommendedResources(context.Context, *connect_go.Request[v1alpha1.ListRecommendedResourcesRequest]) (*connect_go.Response[v1alpha1.ListRecommendedResourcesResponse], error)
	// SetRecommendedResources set the list of recommendated resources in the server.
	SetRecommendedResources(context.Context, *connect_go.Request[v1alpha1.SetRecommendedResourcesRequest]) (*connect_go.Response[v1alpha1.SetRecommendedResourcesResponse], error)
}

// NewRecommendationServiceHandler builds an HTTP handler from the service implementation. It
// returns the path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewRecommendationServiceHandler(svc RecommendationServiceHandler, opts ...connect_go.HandlerOption) (string, http.Handler) {
	mux := http.NewServeMux()
	mux.Handle("/buf.alpha.registry.v1alpha1.RecommendationService/RecommendedRepositories", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.RecommendationService/RecommendedRepositories",
		svc.RecommendedRepositories,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.RecommendationService/RecommendedTemplates", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.RecommendationService/RecommendedTemplates",
		svc.RecommendedTemplates,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.RecommendationService/ListRecommendedResources", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.RecommendationService/ListRecommendedResources",
		svc.ListRecommendedResources,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.RecommendationService/SetRecommendedResources", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.RecommendationService/SetRecommendedResources",
		svc.SetRecommendedResources,
		opts...,
	))
	return "/buf.alpha.registry.v1alpha1.RecommendationService/", mux
}

// UnimplementedRecommendationServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedRecommendationServiceHandler struct{}

func (UnimplementedRecommendationServiceHandler) RecommendedRepositories(context.Context, *connect_go.Request[v1alpha1.RecommendedRepositoriesRequest]) (*connect_go.Response[v1alpha1.RecommendedRepositoriesResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.RecommendationService.RecommendedRepositories is not implemented"))
}

func (UnimplementedRecommendationServiceHandler) RecommendedTemplates(context.Context, *connect_go.Request[v1alpha1.RecommendedTemplatesRequest]) (*connect_go.Response[v1alpha1.RecommendedTemplatesResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.RecommendationService.RecommendedTemplates is not implemented"))
}

func (UnimplementedRecommendationServiceHandler) ListRecommendedResources(context.Context, *connect_go.Request[v1alpha1.ListRecommendedResourcesRequest]) (*connect_go.Response[v1alpha1.ListRecommendedResourcesResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.RecommendationService.ListRecommendedResources is not implemented"))
}

func (UnimplementedRecommendationServiceHandler) SetRecommendedResources(context.Context, *connect_go.Request[v1alpha1.SetRecommendedResourcesRequest]) (*connect_go.Response[v1alpha1.SetRecommendedResourcesResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.RecommendationService.SetRecommendedResources is not implemented"))
}
