// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/alpha/registry/v1alpha1/push.proto

package registryv1alpha1connect

import (
	context "context"
	errors "errors"
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	connect_go "github.com/bufbuild/connect-go"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect_go.IsAtLeastVersion0_1_0

const (
	// PushServiceName is the fully-qualified name of the PushService service.
	PushServiceName = "buf.alpha.registry.v1alpha1.PushService"
)

// PushServiceClient is a client for the buf.alpha.registry.v1alpha1.PushService service.
type PushServiceClient interface {
	// Push pushes.
	Push(context.Context, *connect_go.Request[v1alpha1.PushRequest]) (*connect_go.Response[v1alpha1.PushResponse], error)
}

// NewPushServiceClient constructs a client for the buf.alpha.registry.v1alpha1.PushService service.
// By default, it uses the Connect protocol with the binary Protobuf Codec, asks for gzipped
// responses, and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the
// connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewPushServiceClient(httpClient connect_go.HTTPClient, baseURL string, opts ...connect_go.ClientOption) PushServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &pushServiceClient{
		push: connect_go.NewClient[v1alpha1.PushRequest, v1alpha1.PushResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PushService/Push",
			opts...,
		),
	}
}

// pushServiceClient implements PushServiceClient.
type pushServiceClient struct {
	push *connect_go.Client[v1alpha1.PushRequest, v1alpha1.PushResponse]
}

// Push calls buf.alpha.registry.v1alpha1.PushService.Push.
func (c *pushServiceClient) Push(ctx context.Context, req *connect_go.Request[v1alpha1.PushRequest]) (*connect_go.Response[v1alpha1.PushResponse], error) {
	return c.push.CallUnary(ctx, req)
}

// PushServiceHandler is an implementation of the buf.alpha.registry.v1alpha1.PushService service.
type PushServiceHandler interface {
	// Push pushes.
	Push(context.Context, *connect_go.Request[v1alpha1.PushRequest]) (*connect_go.Response[v1alpha1.PushResponse], error)
}

// NewPushServiceHandler builds an HTTP handler from the service implementation. It returns the path
// on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewPushServiceHandler(svc PushServiceHandler, opts ...connect_go.HandlerOption) (string, http.Handler) {
	mux := http.NewServeMux()
	mux.Handle("/buf.alpha.registry.v1alpha1.PushService/Push", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PushService/Push",
		svc.Push,
		opts...,
	))
	return "/buf.alpha.registry.v1alpha1.PushService/", mux
}

// UnimplementedPushServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedPushServiceHandler struct{}

func (UnimplementedPushServiceHandler) Push(context.Context, *connect_go.Request[v1alpha1.PushRequest]) (*connect_go.Response[v1alpha1.PushResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PushService.Push is not implemented"))
}
