// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// buf/alpha/registry/v1alpha1/plugin.proto is a deprecated file.

package registryv1alpha1connect

import (
	context "context"
	errors "errors"
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	connect_go "github.com/bufbuild/connect-go"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect_go.IsAtLeastVersion0_1_0

const (
	// PluginServiceName is the fully-qualified name of the PluginService service.
	PluginServiceName = "buf.alpha.registry.v1alpha1.PluginService"
)

// PluginServiceClient is a client for the buf.alpha.registry.v1alpha1.PluginService service.
type PluginServiceClient interface {
	// ListPlugins returns all the plugins available to the user. This includes
	// public plugins, those uploaded to organizations the user is part of,
	// and any plugins uploaded directly by the user.
	ListPlugins(context.Context, *connect_go.Request[v1alpha1.ListPluginsRequest]) (*connect_go.Response[v1alpha1.ListPluginsResponse], error)
	// ListUserPlugins lists all plugins belonging to a user.
	ListUserPlugins(context.Context, *connect_go.Request[v1alpha1.ListUserPluginsRequest]) (*connect_go.Response[v1alpha1.ListUserPluginsResponse], error)
	// ListOrganizationPlugins lists all plugins for an organization.
	ListOrganizationPlugins(context.Context, *connect_go.Request[v1alpha1.ListOrganizationPluginsRequest]) (*connect_go.Response[v1alpha1.ListOrganizationPluginsResponse], error)
	// GetPluginVersion returns the plugin version, if found.
	GetPluginVersion(context.Context, *connect_go.Request[v1alpha1.GetPluginVersionRequest]) (*connect_go.Response[v1alpha1.GetPluginVersionResponse], error)
	// ListPluginVersions lists all the versions available for the specified plugin.
	ListPluginVersions(context.Context, *connect_go.Request[v1alpha1.ListPluginVersionsRequest]) (*connect_go.Response[v1alpha1.ListPluginVersionsResponse], error)
	// CreatePlugin creates a new plugin.
	CreatePlugin(context.Context, *connect_go.Request[v1alpha1.CreatePluginRequest]) (*connect_go.Response[v1alpha1.CreatePluginResponse], error)
	// GetPlugin returns the plugin, if found.
	GetPlugin(context.Context, *connect_go.Request[v1alpha1.GetPluginRequest]) (*connect_go.Response[v1alpha1.GetPluginResponse], error)
	// DeletePlugin deletes the plugin, if it exists. Note that deleting
	// a plugin may cause breaking changes for templates using that plugin,
	// and should be done with extreme care.
	DeletePlugin(context.Context, *connect_go.Request[v1alpha1.DeletePluginRequest]) (*connect_go.Response[v1alpha1.DeletePluginResponse], error)
	// SetPluginContributor sets the role of a user in the plugin.
	SetPluginContributor(context.Context, *connect_go.Request[v1alpha1.SetPluginContributorRequest]) (*connect_go.Response[v1alpha1.SetPluginContributorResponse], error)
	// ListPluginContributors returns the list of contributors that has an explicit role against the plugin.
	// This does not include users who have implicit roles against the plugin, unless they have also been
	// assigned a role explicitly.
	ListPluginContributors(context.Context, *connect_go.Request[v1alpha1.ListPluginContributorsRequest]) (*connect_go.Response[v1alpha1.ListPluginContributorsResponse], error)
	// DeprecatePlugin deprecates the plugin, if found.
	DeprecatePlugin(context.Context, *connect_go.Request[v1alpha1.DeprecatePluginRequest]) (*connect_go.Response[v1alpha1.DeprecatePluginResponse], error)
	// UndeprecatePlugin makes the plugin not deprecated and removes any deprecation_message.
	UndeprecatePlugin(context.Context, *connect_go.Request[v1alpha1.UndeprecatePluginRequest]) (*connect_go.Response[v1alpha1.UndeprecatePluginResponse], error)
	// GetTemplate returns the template, if found.
	GetTemplate(context.Context, *connect_go.Request[v1alpha1.GetTemplateRequest]) (*connect_go.Response[v1alpha1.GetTemplateResponse], error)
	// ListTemplates returns all the templates available to the user. This includes
	// public templates, those owned by organizations the user is part of,
	// and any created directly by the user.
	ListTemplates(context.Context, *connect_go.Request[v1alpha1.ListTemplatesRequest]) (*connect_go.Response[v1alpha1.ListTemplatesResponse], error)
	// ListTemplatesUserCanAccess is like ListTemplates, but does not return
	// public templates.
	ListTemplatesUserCanAccess(context.Context, *connect_go.Request[v1alpha1.ListTemplatesUserCanAccessRequest]) (*connect_go.Response[v1alpha1.ListTemplatesUserCanAccessResponse], error)
	// ListUserPlugins lists all templates belonging to a user.
	ListUserTemplates(context.Context, *connect_go.Request[v1alpha1.ListUserTemplatesRequest]) (*connect_go.Response[v1alpha1.ListUserTemplatesResponse], error)
	// ListOrganizationTemplates lists all templates for an organization.
	ListOrganizationTemplates(context.Context, *connect_go.Request[v1alpha1.ListOrganizationTemplatesRequest]) (*connect_go.Response[v1alpha1.ListOrganizationTemplatesResponse], error)
	// GetTemplateVersion returns the template version, if found.
	GetTemplateVersion(context.Context, *connect_go.Request[v1alpha1.GetTemplateVersionRequest]) (*connect_go.Response[v1alpha1.GetTemplateVersionResponse], error)
	// ListTemplateVersions lists all the template versions available for the specified template.
	ListTemplateVersions(context.Context, *connect_go.Request[v1alpha1.ListTemplateVersionsRequest]) (*connect_go.Response[v1alpha1.ListTemplateVersionsResponse], error)
	// CreateTemplate creates a new template.
	CreateTemplate(context.Context, *connect_go.Request[v1alpha1.CreateTemplateRequest]) (*connect_go.Response[v1alpha1.CreateTemplateResponse], error)
	// DeleteTemplate deletes the template, if it exists.
	DeleteTemplate(context.Context, *connect_go.Request[v1alpha1.DeleteTemplateRequest]) (*connect_go.Response[v1alpha1.DeleteTemplateResponse], error)
	// CreateTemplateVersion creates a new template version.
	CreateTemplateVersion(context.Context, *connect_go.Request[v1alpha1.CreateTemplateVersionRequest]) (*connect_go.Response[v1alpha1.CreateTemplateVersionResponse], error)
	// SetTemplateContributor sets the role of a user in the template.
	SetTemplateContributor(context.Context, *connect_go.Request[v1alpha1.SetTemplateContributorRequest]) (*connect_go.Response[v1alpha1.SetTemplateContributorResponse], error)
	// ListTemplateContributors returns the list of contributors that has an explicit role against the template.
	// This does not include users who have implicit roles against the template, unless they have also been
	// assigned a role explicitly.
	ListTemplateContributors(context.Context, *connect_go.Request[v1alpha1.ListTemplateContributorsRequest]) (*connect_go.Response[v1alpha1.ListTemplateContributorsResponse], error)
	// DeprecateTemplate deprecates the template, if found.
	DeprecateTemplate(context.Context, *connect_go.Request[v1alpha1.DeprecateTemplateRequest]) (*connect_go.Response[v1alpha1.DeprecateTemplateResponse], error)
	// UndeprecateTemplate makes the template not deprecated and removes any deprecation_message.
	UndeprecateTemplate(context.Context, *connect_go.Request[v1alpha1.UndeprecateTemplateRequest]) (*connect_go.Response[v1alpha1.UndeprecateTemplateResponse], error)
}

// NewPluginServiceClient constructs a client for the buf.alpha.registry.v1alpha1.PluginService
// service. By default, it uses the Connect protocol with the binary Protobuf Codec, asks for
// gzipped responses, and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply
// the connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewPluginServiceClient(httpClient connect_go.HTTPClient, baseURL string, opts ...connect_go.ClientOption) PluginServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &pluginServiceClient{
		listPlugins: connect_go.NewClient[v1alpha1.ListPluginsRequest, v1alpha1.ListPluginsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/ListPlugins",
			opts...,
		),
		listUserPlugins: connect_go.NewClient[v1alpha1.ListUserPluginsRequest, v1alpha1.ListUserPluginsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/ListUserPlugins",
			opts...,
		),
		listOrganizationPlugins: connect_go.NewClient[v1alpha1.ListOrganizationPluginsRequest, v1alpha1.ListOrganizationPluginsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/ListOrganizationPlugins",
			opts...,
		),
		getPluginVersion: connect_go.NewClient[v1alpha1.GetPluginVersionRequest, v1alpha1.GetPluginVersionResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/GetPluginVersion",
			opts...,
		),
		listPluginVersions: connect_go.NewClient[v1alpha1.ListPluginVersionsRequest, v1alpha1.ListPluginVersionsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/ListPluginVersions",
			opts...,
		),
		createPlugin: connect_go.NewClient[v1alpha1.CreatePluginRequest, v1alpha1.CreatePluginResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/CreatePlugin",
			opts...,
		),
		getPlugin: connect_go.NewClient[v1alpha1.GetPluginRequest, v1alpha1.GetPluginResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/GetPlugin",
			opts...,
		),
		deletePlugin: connect_go.NewClient[v1alpha1.DeletePluginRequest, v1alpha1.DeletePluginResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/DeletePlugin",
			opts...,
		),
		setPluginContributor: connect_go.NewClient[v1alpha1.SetPluginContributorRequest, v1alpha1.SetPluginContributorResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/SetPluginContributor",
			opts...,
		),
		listPluginContributors: connect_go.NewClient[v1alpha1.ListPluginContributorsRequest, v1alpha1.ListPluginContributorsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/ListPluginContributors",
			opts...,
		),
		deprecatePlugin: connect_go.NewClient[v1alpha1.DeprecatePluginRequest, v1alpha1.DeprecatePluginResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/DeprecatePlugin",
			opts...,
		),
		undeprecatePlugin: connect_go.NewClient[v1alpha1.UndeprecatePluginRequest, v1alpha1.UndeprecatePluginResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/UndeprecatePlugin",
			opts...,
		),
		getTemplate: connect_go.NewClient[v1alpha1.GetTemplateRequest, v1alpha1.GetTemplateResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/GetTemplate",
			opts...,
		),
		listTemplates: connect_go.NewClient[v1alpha1.ListTemplatesRequest, v1alpha1.ListTemplatesResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/ListTemplates",
			opts...,
		),
		listTemplatesUserCanAccess: connect_go.NewClient[v1alpha1.ListTemplatesUserCanAccessRequest, v1alpha1.ListTemplatesUserCanAccessResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/ListTemplatesUserCanAccess",
			opts...,
		),
		listUserTemplates: connect_go.NewClient[v1alpha1.ListUserTemplatesRequest, v1alpha1.ListUserTemplatesResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/ListUserTemplates",
			opts...,
		),
		listOrganizationTemplates: connect_go.NewClient[v1alpha1.ListOrganizationTemplatesRequest, v1alpha1.ListOrganizationTemplatesResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/ListOrganizationTemplates",
			opts...,
		),
		getTemplateVersion: connect_go.NewClient[v1alpha1.GetTemplateVersionRequest, v1alpha1.GetTemplateVersionResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/GetTemplateVersion",
			opts...,
		),
		listTemplateVersions: connect_go.NewClient[v1alpha1.ListTemplateVersionsRequest, v1alpha1.ListTemplateVersionsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/ListTemplateVersions",
			opts...,
		),
		createTemplate: connect_go.NewClient[v1alpha1.CreateTemplateRequest, v1alpha1.CreateTemplateResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/CreateTemplate",
			opts...,
		),
		deleteTemplate: connect_go.NewClient[v1alpha1.DeleteTemplateRequest, v1alpha1.DeleteTemplateResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/DeleteTemplate",
			opts...,
		),
		createTemplateVersion: connect_go.NewClient[v1alpha1.CreateTemplateVersionRequest, v1alpha1.CreateTemplateVersionResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/CreateTemplateVersion",
			opts...,
		),
		setTemplateContributor: connect_go.NewClient[v1alpha1.SetTemplateContributorRequest, v1alpha1.SetTemplateContributorResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/SetTemplateContributor",
			opts...,
		),
		listTemplateContributors: connect_go.NewClient[v1alpha1.ListTemplateContributorsRequest, v1alpha1.ListTemplateContributorsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/ListTemplateContributors",
			opts...,
		),
		deprecateTemplate: connect_go.NewClient[v1alpha1.DeprecateTemplateRequest, v1alpha1.DeprecateTemplateResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/DeprecateTemplate",
			opts...,
		),
		undeprecateTemplate: connect_go.NewClient[v1alpha1.UndeprecateTemplateRequest, v1alpha1.UndeprecateTemplateResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.PluginService/UndeprecateTemplate",
			opts...,
		),
	}
}

// pluginServiceClient implements PluginServiceClient.
type pluginServiceClient struct {
	listPlugins                *connect_go.Client[v1alpha1.ListPluginsRequest, v1alpha1.ListPluginsResponse]
	listUserPlugins            *connect_go.Client[v1alpha1.ListUserPluginsRequest, v1alpha1.ListUserPluginsResponse]
	listOrganizationPlugins    *connect_go.Client[v1alpha1.ListOrganizationPluginsRequest, v1alpha1.ListOrganizationPluginsResponse]
	getPluginVersion           *connect_go.Client[v1alpha1.GetPluginVersionRequest, v1alpha1.GetPluginVersionResponse]
	listPluginVersions         *connect_go.Client[v1alpha1.ListPluginVersionsRequest, v1alpha1.ListPluginVersionsResponse]
	createPlugin               *connect_go.Client[v1alpha1.CreatePluginRequest, v1alpha1.CreatePluginResponse]
	getPlugin                  *connect_go.Client[v1alpha1.GetPluginRequest, v1alpha1.GetPluginResponse]
	deletePlugin               *connect_go.Client[v1alpha1.DeletePluginRequest, v1alpha1.DeletePluginResponse]
	setPluginContributor       *connect_go.Client[v1alpha1.SetPluginContributorRequest, v1alpha1.SetPluginContributorResponse]
	listPluginContributors     *connect_go.Client[v1alpha1.ListPluginContributorsRequest, v1alpha1.ListPluginContributorsResponse]
	deprecatePlugin            *connect_go.Client[v1alpha1.DeprecatePluginRequest, v1alpha1.DeprecatePluginResponse]
	undeprecatePlugin          *connect_go.Client[v1alpha1.UndeprecatePluginRequest, v1alpha1.UndeprecatePluginResponse]
	getTemplate                *connect_go.Client[v1alpha1.GetTemplateRequest, v1alpha1.GetTemplateResponse]
	listTemplates              *connect_go.Client[v1alpha1.ListTemplatesRequest, v1alpha1.ListTemplatesResponse]
	listTemplatesUserCanAccess *connect_go.Client[v1alpha1.ListTemplatesUserCanAccessRequest, v1alpha1.ListTemplatesUserCanAccessResponse]
	listUserTemplates          *connect_go.Client[v1alpha1.ListUserTemplatesRequest, v1alpha1.ListUserTemplatesResponse]
	listOrganizationTemplates  *connect_go.Client[v1alpha1.ListOrganizationTemplatesRequest, v1alpha1.ListOrganizationTemplatesResponse]
	getTemplateVersion         *connect_go.Client[v1alpha1.GetTemplateVersionRequest, v1alpha1.GetTemplateVersionResponse]
	listTemplateVersions       *connect_go.Client[v1alpha1.ListTemplateVersionsRequest, v1alpha1.ListTemplateVersionsResponse]
	createTemplate             *connect_go.Client[v1alpha1.CreateTemplateRequest, v1alpha1.CreateTemplateResponse]
	deleteTemplate             *connect_go.Client[v1alpha1.DeleteTemplateRequest, v1alpha1.DeleteTemplateResponse]
	createTemplateVersion      *connect_go.Client[v1alpha1.CreateTemplateVersionRequest, v1alpha1.CreateTemplateVersionResponse]
	setTemplateContributor     *connect_go.Client[v1alpha1.SetTemplateContributorRequest, v1alpha1.SetTemplateContributorResponse]
	listTemplateContributors   *connect_go.Client[v1alpha1.ListTemplateContributorsRequest, v1alpha1.ListTemplateContributorsResponse]
	deprecateTemplate          *connect_go.Client[v1alpha1.DeprecateTemplateRequest, v1alpha1.DeprecateTemplateResponse]
	undeprecateTemplate        *connect_go.Client[v1alpha1.UndeprecateTemplateRequest, v1alpha1.UndeprecateTemplateResponse]
}

// ListPlugins calls buf.alpha.registry.v1alpha1.PluginService.ListPlugins.
func (c *pluginServiceClient) ListPlugins(ctx context.Context, req *connect_go.Request[v1alpha1.ListPluginsRequest]) (*connect_go.Response[v1alpha1.ListPluginsResponse], error) {
	return c.listPlugins.CallUnary(ctx, req)
}

// ListUserPlugins calls buf.alpha.registry.v1alpha1.PluginService.ListUserPlugins.
func (c *pluginServiceClient) ListUserPlugins(ctx context.Context, req *connect_go.Request[v1alpha1.ListUserPluginsRequest]) (*connect_go.Response[v1alpha1.ListUserPluginsResponse], error) {
	return c.listUserPlugins.CallUnary(ctx, req)
}

// ListOrganizationPlugins calls buf.alpha.registry.v1alpha1.PluginService.ListOrganizationPlugins.
func (c *pluginServiceClient) ListOrganizationPlugins(ctx context.Context, req *connect_go.Request[v1alpha1.ListOrganizationPluginsRequest]) (*connect_go.Response[v1alpha1.ListOrganizationPluginsResponse], error) {
	return c.listOrganizationPlugins.CallUnary(ctx, req)
}

// GetPluginVersion calls buf.alpha.registry.v1alpha1.PluginService.GetPluginVersion.
func (c *pluginServiceClient) GetPluginVersion(ctx context.Context, req *connect_go.Request[v1alpha1.GetPluginVersionRequest]) (*connect_go.Response[v1alpha1.GetPluginVersionResponse], error) {
	return c.getPluginVersion.CallUnary(ctx, req)
}

// ListPluginVersions calls buf.alpha.registry.v1alpha1.PluginService.ListPluginVersions.
func (c *pluginServiceClient) ListPluginVersions(ctx context.Context, req *connect_go.Request[v1alpha1.ListPluginVersionsRequest]) (*connect_go.Response[v1alpha1.ListPluginVersionsResponse], error) {
	return c.listPluginVersions.CallUnary(ctx, req)
}

// CreatePlugin calls buf.alpha.registry.v1alpha1.PluginService.CreatePlugin.
func (c *pluginServiceClient) CreatePlugin(ctx context.Context, req *connect_go.Request[v1alpha1.CreatePluginRequest]) (*connect_go.Response[v1alpha1.CreatePluginResponse], error) {
	return c.createPlugin.CallUnary(ctx, req)
}

// GetPlugin calls buf.alpha.registry.v1alpha1.PluginService.GetPlugin.
func (c *pluginServiceClient) GetPlugin(ctx context.Context, req *connect_go.Request[v1alpha1.GetPluginRequest]) (*connect_go.Response[v1alpha1.GetPluginResponse], error) {
	return c.getPlugin.CallUnary(ctx, req)
}

// DeletePlugin calls buf.alpha.registry.v1alpha1.PluginService.DeletePlugin.
func (c *pluginServiceClient) DeletePlugin(ctx context.Context, req *connect_go.Request[v1alpha1.DeletePluginRequest]) (*connect_go.Response[v1alpha1.DeletePluginResponse], error) {
	return c.deletePlugin.CallUnary(ctx, req)
}

// SetPluginContributor calls buf.alpha.registry.v1alpha1.PluginService.SetPluginContributor.
func (c *pluginServiceClient) SetPluginContributor(ctx context.Context, req *connect_go.Request[v1alpha1.SetPluginContributorRequest]) (*connect_go.Response[v1alpha1.SetPluginContributorResponse], error) {
	return c.setPluginContributor.CallUnary(ctx, req)
}

// ListPluginContributors calls buf.alpha.registry.v1alpha1.PluginService.ListPluginContributors.
func (c *pluginServiceClient) ListPluginContributors(ctx context.Context, req *connect_go.Request[v1alpha1.ListPluginContributorsRequest]) (*connect_go.Response[v1alpha1.ListPluginContributorsResponse], error) {
	return c.listPluginContributors.CallUnary(ctx, req)
}

// DeprecatePlugin calls buf.alpha.registry.v1alpha1.PluginService.DeprecatePlugin.
func (c *pluginServiceClient) DeprecatePlugin(ctx context.Context, req *connect_go.Request[v1alpha1.DeprecatePluginRequest]) (*connect_go.Response[v1alpha1.DeprecatePluginResponse], error) {
	return c.deprecatePlugin.CallUnary(ctx, req)
}

// UndeprecatePlugin calls buf.alpha.registry.v1alpha1.PluginService.UndeprecatePlugin.
func (c *pluginServiceClient) UndeprecatePlugin(ctx context.Context, req *connect_go.Request[v1alpha1.UndeprecatePluginRequest]) (*connect_go.Response[v1alpha1.UndeprecatePluginResponse], error) {
	return c.undeprecatePlugin.CallUnary(ctx, req)
}

// GetTemplate calls buf.alpha.registry.v1alpha1.PluginService.GetTemplate.
func (c *pluginServiceClient) GetTemplate(ctx context.Context, req *connect_go.Request[v1alpha1.GetTemplateRequest]) (*connect_go.Response[v1alpha1.GetTemplateResponse], error) {
	return c.getTemplate.CallUnary(ctx, req)
}

// ListTemplates calls buf.alpha.registry.v1alpha1.PluginService.ListTemplates.
func (c *pluginServiceClient) ListTemplates(ctx context.Context, req *connect_go.Request[v1alpha1.ListTemplatesRequest]) (*connect_go.Response[v1alpha1.ListTemplatesResponse], error) {
	return c.listTemplates.CallUnary(ctx, req)
}

// ListTemplatesUserCanAccess calls
// buf.alpha.registry.v1alpha1.PluginService.ListTemplatesUserCanAccess.
func (c *pluginServiceClient) ListTemplatesUserCanAccess(ctx context.Context, req *connect_go.Request[v1alpha1.ListTemplatesUserCanAccessRequest]) (*connect_go.Response[v1alpha1.ListTemplatesUserCanAccessResponse], error) {
	return c.listTemplatesUserCanAccess.CallUnary(ctx, req)
}

// ListUserTemplates calls buf.alpha.registry.v1alpha1.PluginService.ListUserTemplates.
func (c *pluginServiceClient) ListUserTemplates(ctx context.Context, req *connect_go.Request[v1alpha1.ListUserTemplatesRequest]) (*connect_go.Response[v1alpha1.ListUserTemplatesResponse], error) {
	return c.listUserTemplates.CallUnary(ctx, req)
}

// ListOrganizationTemplates calls
// buf.alpha.registry.v1alpha1.PluginService.ListOrganizationTemplates.
func (c *pluginServiceClient) ListOrganizationTemplates(ctx context.Context, req *connect_go.Request[v1alpha1.ListOrganizationTemplatesRequest]) (*connect_go.Response[v1alpha1.ListOrganizationTemplatesResponse], error) {
	return c.listOrganizationTemplates.CallUnary(ctx, req)
}

// GetTemplateVersion calls buf.alpha.registry.v1alpha1.PluginService.GetTemplateVersion.
func (c *pluginServiceClient) GetTemplateVersion(ctx context.Context, req *connect_go.Request[v1alpha1.GetTemplateVersionRequest]) (*connect_go.Response[v1alpha1.GetTemplateVersionResponse], error) {
	return c.getTemplateVersion.CallUnary(ctx, req)
}

// ListTemplateVersions calls buf.alpha.registry.v1alpha1.PluginService.ListTemplateVersions.
func (c *pluginServiceClient) ListTemplateVersions(ctx context.Context, req *connect_go.Request[v1alpha1.ListTemplateVersionsRequest]) (*connect_go.Response[v1alpha1.ListTemplateVersionsResponse], error) {
	return c.listTemplateVersions.CallUnary(ctx, req)
}

// CreateTemplate calls buf.alpha.registry.v1alpha1.PluginService.CreateTemplate.
func (c *pluginServiceClient) CreateTemplate(ctx context.Context, req *connect_go.Request[v1alpha1.CreateTemplateRequest]) (*connect_go.Response[v1alpha1.CreateTemplateResponse], error) {
	return c.createTemplate.CallUnary(ctx, req)
}

// DeleteTemplate calls buf.alpha.registry.v1alpha1.PluginService.DeleteTemplate.
func (c *pluginServiceClient) DeleteTemplate(ctx context.Context, req *connect_go.Request[v1alpha1.DeleteTemplateRequest]) (*connect_go.Response[v1alpha1.DeleteTemplateResponse], error) {
	return c.deleteTemplate.CallUnary(ctx, req)
}

// CreateTemplateVersion calls buf.alpha.registry.v1alpha1.PluginService.CreateTemplateVersion.
func (c *pluginServiceClient) CreateTemplateVersion(ctx context.Context, req *connect_go.Request[v1alpha1.CreateTemplateVersionRequest]) (*connect_go.Response[v1alpha1.CreateTemplateVersionResponse], error) {
	return c.createTemplateVersion.CallUnary(ctx, req)
}

// SetTemplateContributor calls buf.alpha.registry.v1alpha1.PluginService.SetTemplateContributor.
func (c *pluginServiceClient) SetTemplateContributor(ctx context.Context, req *connect_go.Request[v1alpha1.SetTemplateContributorRequest]) (*connect_go.Response[v1alpha1.SetTemplateContributorResponse], error) {
	return c.setTemplateContributor.CallUnary(ctx, req)
}

// ListTemplateContributors calls
// buf.alpha.registry.v1alpha1.PluginService.ListTemplateContributors.
func (c *pluginServiceClient) ListTemplateContributors(ctx context.Context, req *connect_go.Request[v1alpha1.ListTemplateContributorsRequest]) (*connect_go.Response[v1alpha1.ListTemplateContributorsResponse], error) {
	return c.listTemplateContributors.CallUnary(ctx, req)
}

// DeprecateTemplate calls buf.alpha.registry.v1alpha1.PluginService.DeprecateTemplate.
func (c *pluginServiceClient) DeprecateTemplate(ctx context.Context, req *connect_go.Request[v1alpha1.DeprecateTemplateRequest]) (*connect_go.Response[v1alpha1.DeprecateTemplateResponse], error) {
	return c.deprecateTemplate.CallUnary(ctx, req)
}

// UndeprecateTemplate calls buf.alpha.registry.v1alpha1.PluginService.UndeprecateTemplate.
func (c *pluginServiceClient) UndeprecateTemplate(ctx context.Context, req *connect_go.Request[v1alpha1.UndeprecateTemplateRequest]) (*connect_go.Response[v1alpha1.UndeprecateTemplateResponse], error) {
	return c.undeprecateTemplate.CallUnary(ctx, req)
}

// PluginServiceHandler is an implementation of the buf.alpha.registry.v1alpha1.PluginService
// service.
type PluginServiceHandler interface {
	// ListPlugins returns all the plugins available to the user. This includes
	// public plugins, those uploaded to organizations the user is part of,
	// and any plugins uploaded directly by the user.
	ListPlugins(context.Context, *connect_go.Request[v1alpha1.ListPluginsRequest]) (*connect_go.Response[v1alpha1.ListPluginsResponse], error)
	// ListUserPlugins lists all plugins belonging to a user.
	ListUserPlugins(context.Context, *connect_go.Request[v1alpha1.ListUserPluginsRequest]) (*connect_go.Response[v1alpha1.ListUserPluginsResponse], error)
	// ListOrganizationPlugins lists all plugins for an organization.
	ListOrganizationPlugins(context.Context, *connect_go.Request[v1alpha1.ListOrganizationPluginsRequest]) (*connect_go.Response[v1alpha1.ListOrganizationPluginsResponse], error)
	// GetPluginVersion returns the plugin version, if found.
	GetPluginVersion(context.Context, *connect_go.Request[v1alpha1.GetPluginVersionRequest]) (*connect_go.Response[v1alpha1.GetPluginVersionResponse], error)
	// ListPluginVersions lists all the versions available for the specified plugin.
	ListPluginVersions(context.Context, *connect_go.Request[v1alpha1.ListPluginVersionsRequest]) (*connect_go.Response[v1alpha1.ListPluginVersionsResponse], error)
	// CreatePlugin creates a new plugin.
	CreatePlugin(context.Context, *connect_go.Request[v1alpha1.CreatePluginRequest]) (*connect_go.Response[v1alpha1.CreatePluginResponse], error)
	// GetPlugin returns the plugin, if found.
	GetPlugin(context.Context, *connect_go.Request[v1alpha1.GetPluginRequest]) (*connect_go.Response[v1alpha1.GetPluginResponse], error)
	// DeletePlugin deletes the plugin, if it exists. Note that deleting
	// a plugin may cause breaking changes for templates using that plugin,
	// and should be done with extreme care.
	DeletePlugin(context.Context, *connect_go.Request[v1alpha1.DeletePluginRequest]) (*connect_go.Response[v1alpha1.DeletePluginResponse], error)
	// SetPluginContributor sets the role of a user in the plugin.
	SetPluginContributor(context.Context, *connect_go.Request[v1alpha1.SetPluginContributorRequest]) (*connect_go.Response[v1alpha1.SetPluginContributorResponse], error)
	// ListPluginContributors returns the list of contributors that has an explicit role against the plugin.
	// This does not include users who have implicit roles against the plugin, unless they have also been
	// assigned a role explicitly.
	ListPluginContributors(context.Context, *connect_go.Request[v1alpha1.ListPluginContributorsRequest]) (*connect_go.Response[v1alpha1.ListPluginContributorsResponse], error)
	// DeprecatePlugin deprecates the plugin, if found.
	DeprecatePlugin(context.Context, *connect_go.Request[v1alpha1.DeprecatePluginRequest]) (*connect_go.Response[v1alpha1.DeprecatePluginResponse], error)
	// UndeprecatePlugin makes the plugin not deprecated and removes any deprecation_message.
	UndeprecatePlugin(context.Context, *connect_go.Request[v1alpha1.UndeprecatePluginRequest]) (*connect_go.Response[v1alpha1.UndeprecatePluginResponse], error)
	// GetTemplate returns the template, if found.
	GetTemplate(context.Context, *connect_go.Request[v1alpha1.GetTemplateRequest]) (*connect_go.Response[v1alpha1.GetTemplateResponse], error)
	// ListTemplates returns all the templates available to the user. This includes
	// public templates, those owned by organizations the user is part of,
	// and any created directly by the user.
	ListTemplates(context.Context, *connect_go.Request[v1alpha1.ListTemplatesRequest]) (*connect_go.Response[v1alpha1.ListTemplatesResponse], error)
	// ListTemplatesUserCanAccess is like ListTemplates, but does not return
	// public templates.
	ListTemplatesUserCanAccess(context.Context, *connect_go.Request[v1alpha1.ListTemplatesUserCanAccessRequest]) (*connect_go.Response[v1alpha1.ListTemplatesUserCanAccessResponse], error)
	// ListUserPlugins lists all templates belonging to a user.
	ListUserTemplates(context.Context, *connect_go.Request[v1alpha1.ListUserTemplatesRequest]) (*connect_go.Response[v1alpha1.ListUserTemplatesResponse], error)
	// ListOrganizationTemplates lists all templates for an organization.
	ListOrganizationTemplates(context.Context, *connect_go.Request[v1alpha1.ListOrganizationTemplatesRequest]) (*connect_go.Response[v1alpha1.ListOrganizationTemplatesResponse], error)
	// GetTemplateVersion returns the template version, if found.
	GetTemplateVersion(context.Context, *connect_go.Request[v1alpha1.GetTemplateVersionRequest]) (*connect_go.Response[v1alpha1.GetTemplateVersionResponse], error)
	// ListTemplateVersions lists all the template versions available for the specified template.
	ListTemplateVersions(context.Context, *connect_go.Request[v1alpha1.ListTemplateVersionsRequest]) (*connect_go.Response[v1alpha1.ListTemplateVersionsResponse], error)
	// CreateTemplate creates a new template.
	CreateTemplate(context.Context, *connect_go.Request[v1alpha1.CreateTemplateRequest]) (*connect_go.Response[v1alpha1.CreateTemplateResponse], error)
	// DeleteTemplate deletes the template, if it exists.
	DeleteTemplate(context.Context, *connect_go.Request[v1alpha1.DeleteTemplateRequest]) (*connect_go.Response[v1alpha1.DeleteTemplateResponse], error)
	// CreateTemplateVersion creates a new template version.
	CreateTemplateVersion(context.Context, *connect_go.Request[v1alpha1.CreateTemplateVersionRequest]) (*connect_go.Response[v1alpha1.CreateTemplateVersionResponse], error)
	// SetTemplateContributor sets the role of a user in the template.
	SetTemplateContributor(context.Context, *connect_go.Request[v1alpha1.SetTemplateContributorRequest]) (*connect_go.Response[v1alpha1.SetTemplateContributorResponse], error)
	// ListTemplateContributors returns the list of contributors that has an explicit role against the template.
	// This does not include users who have implicit roles against the template, unless they have also been
	// assigned a role explicitly.
	ListTemplateContributors(context.Context, *connect_go.Request[v1alpha1.ListTemplateContributorsRequest]) (*connect_go.Response[v1alpha1.ListTemplateContributorsResponse], error)
	// DeprecateTemplate deprecates the template, if found.
	DeprecateTemplate(context.Context, *connect_go.Request[v1alpha1.DeprecateTemplateRequest]) (*connect_go.Response[v1alpha1.DeprecateTemplateResponse], error)
	// UndeprecateTemplate makes the template not deprecated and removes any deprecation_message.
	UndeprecateTemplate(context.Context, *connect_go.Request[v1alpha1.UndeprecateTemplateRequest]) (*connect_go.Response[v1alpha1.UndeprecateTemplateResponse], error)
}

// NewPluginServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewPluginServiceHandler(svc PluginServiceHandler, opts ...connect_go.HandlerOption) (string, http.Handler) {
	mux := http.NewServeMux()
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/ListPlugins", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/ListPlugins",
		svc.ListPlugins,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/ListUserPlugins", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/ListUserPlugins",
		svc.ListUserPlugins,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/ListOrganizationPlugins", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/ListOrganizationPlugins",
		svc.ListOrganizationPlugins,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/GetPluginVersion", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/GetPluginVersion",
		svc.GetPluginVersion,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/ListPluginVersions", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/ListPluginVersions",
		svc.ListPluginVersions,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/CreatePlugin", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/CreatePlugin",
		svc.CreatePlugin,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/GetPlugin", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/GetPlugin",
		svc.GetPlugin,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/DeletePlugin", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/DeletePlugin",
		svc.DeletePlugin,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/SetPluginContributor", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/SetPluginContributor",
		svc.SetPluginContributor,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/ListPluginContributors", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/ListPluginContributors",
		svc.ListPluginContributors,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/DeprecatePlugin", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/DeprecatePlugin",
		svc.DeprecatePlugin,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/UndeprecatePlugin", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/UndeprecatePlugin",
		svc.UndeprecatePlugin,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/GetTemplate", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/GetTemplate",
		svc.GetTemplate,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/ListTemplates", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/ListTemplates",
		svc.ListTemplates,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/ListTemplatesUserCanAccess", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/ListTemplatesUserCanAccess",
		svc.ListTemplatesUserCanAccess,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/ListUserTemplates", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/ListUserTemplates",
		svc.ListUserTemplates,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/ListOrganizationTemplates", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/ListOrganizationTemplates",
		svc.ListOrganizationTemplates,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/GetTemplateVersion", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/GetTemplateVersion",
		svc.GetTemplateVersion,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/ListTemplateVersions", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/ListTemplateVersions",
		svc.ListTemplateVersions,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/CreateTemplate", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/CreateTemplate",
		svc.CreateTemplate,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/DeleteTemplate", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/DeleteTemplate",
		svc.DeleteTemplate,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/CreateTemplateVersion", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/CreateTemplateVersion",
		svc.CreateTemplateVersion,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/SetTemplateContributor", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/SetTemplateContributor",
		svc.SetTemplateContributor,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/ListTemplateContributors", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/ListTemplateContributors",
		svc.ListTemplateContributors,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/DeprecateTemplate", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/DeprecateTemplate",
		svc.DeprecateTemplate,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.PluginService/UndeprecateTemplate", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.PluginService/UndeprecateTemplate",
		svc.UndeprecateTemplate,
		opts...,
	))
	return "/buf.alpha.registry.v1alpha1.PluginService/", mux
}

// UnimplementedPluginServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedPluginServiceHandler struct{}

func (UnimplementedPluginServiceHandler) ListPlugins(context.Context, *connect_go.Request[v1alpha1.ListPluginsRequest]) (*connect_go.Response[v1alpha1.ListPluginsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.ListPlugins is not implemented"))
}

func (UnimplementedPluginServiceHandler) ListUserPlugins(context.Context, *connect_go.Request[v1alpha1.ListUserPluginsRequest]) (*connect_go.Response[v1alpha1.ListUserPluginsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.ListUserPlugins is not implemented"))
}

func (UnimplementedPluginServiceHandler) ListOrganizationPlugins(context.Context, *connect_go.Request[v1alpha1.ListOrganizationPluginsRequest]) (*connect_go.Response[v1alpha1.ListOrganizationPluginsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.ListOrganizationPlugins is not implemented"))
}

func (UnimplementedPluginServiceHandler) GetPluginVersion(context.Context, *connect_go.Request[v1alpha1.GetPluginVersionRequest]) (*connect_go.Response[v1alpha1.GetPluginVersionResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.GetPluginVersion is not implemented"))
}

func (UnimplementedPluginServiceHandler) ListPluginVersions(context.Context, *connect_go.Request[v1alpha1.ListPluginVersionsRequest]) (*connect_go.Response[v1alpha1.ListPluginVersionsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.ListPluginVersions is not implemented"))
}

func (UnimplementedPluginServiceHandler) CreatePlugin(context.Context, *connect_go.Request[v1alpha1.CreatePluginRequest]) (*connect_go.Response[v1alpha1.CreatePluginResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.CreatePlugin is not implemented"))
}

func (UnimplementedPluginServiceHandler) GetPlugin(context.Context, *connect_go.Request[v1alpha1.GetPluginRequest]) (*connect_go.Response[v1alpha1.GetPluginResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.GetPlugin is not implemented"))
}

func (UnimplementedPluginServiceHandler) DeletePlugin(context.Context, *connect_go.Request[v1alpha1.DeletePluginRequest]) (*connect_go.Response[v1alpha1.DeletePluginResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.DeletePlugin is not implemented"))
}

func (UnimplementedPluginServiceHandler) SetPluginContributor(context.Context, *connect_go.Request[v1alpha1.SetPluginContributorRequest]) (*connect_go.Response[v1alpha1.SetPluginContributorResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.SetPluginContributor is not implemented"))
}

func (UnimplementedPluginServiceHandler) ListPluginContributors(context.Context, *connect_go.Request[v1alpha1.ListPluginContributorsRequest]) (*connect_go.Response[v1alpha1.ListPluginContributorsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.ListPluginContributors is not implemented"))
}

func (UnimplementedPluginServiceHandler) DeprecatePlugin(context.Context, *connect_go.Request[v1alpha1.DeprecatePluginRequest]) (*connect_go.Response[v1alpha1.DeprecatePluginResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.DeprecatePlugin is not implemented"))
}

func (UnimplementedPluginServiceHandler) UndeprecatePlugin(context.Context, *connect_go.Request[v1alpha1.UndeprecatePluginRequest]) (*connect_go.Response[v1alpha1.UndeprecatePluginResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.UndeprecatePlugin is not implemented"))
}

func (UnimplementedPluginServiceHandler) GetTemplate(context.Context, *connect_go.Request[v1alpha1.GetTemplateRequest]) (*connect_go.Response[v1alpha1.GetTemplateResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.GetTemplate is not implemented"))
}

func (UnimplementedPluginServiceHandler) ListTemplates(context.Context, *connect_go.Request[v1alpha1.ListTemplatesRequest]) (*connect_go.Response[v1alpha1.ListTemplatesResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.ListTemplates is not implemented"))
}

func (UnimplementedPluginServiceHandler) ListTemplatesUserCanAccess(context.Context, *connect_go.Request[v1alpha1.ListTemplatesUserCanAccessRequest]) (*connect_go.Response[v1alpha1.ListTemplatesUserCanAccessResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.ListTemplatesUserCanAccess is not implemented"))
}

func (UnimplementedPluginServiceHandler) ListUserTemplates(context.Context, *connect_go.Request[v1alpha1.ListUserTemplatesRequest]) (*connect_go.Response[v1alpha1.ListUserTemplatesResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.ListUserTemplates is not implemented"))
}

func (UnimplementedPluginServiceHandler) ListOrganizationTemplates(context.Context, *connect_go.Request[v1alpha1.ListOrganizationTemplatesRequest]) (*connect_go.Response[v1alpha1.ListOrganizationTemplatesResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.ListOrganizationTemplates is not implemented"))
}

func (UnimplementedPluginServiceHandler) GetTemplateVersion(context.Context, *connect_go.Request[v1alpha1.GetTemplateVersionRequest]) (*connect_go.Response[v1alpha1.GetTemplateVersionResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.GetTemplateVersion is not implemented"))
}

func (UnimplementedPluginServiceHandler) ListTemplateVersions(context.Context, *connect_go.Request[v1alpha1.ListTemplateVersionsRequest]) (*connect_go.Response[v1alpha1.ListTemplateVersionsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.ListTemplateVersions is not implemented"))
}

func (UnimplementedPluginServiceHandler) CreateTemplate(context.Context, *connect_go.Request[v1alpha1.CreateTemplateRequest]) (*connect_go.Response[v1alpha1.CreateTemplateResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.CreateTemplate is not implemented"))
}

func (UnimplementedPluginServiceHandler) DeleteTemplate(context.Context, *connect_go.Request[v1alpha1.DeleteTemplateRequest]) (*connect_go.Response[v1alpha1.DeleteTemplateResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.DeleteTemplate is not implemented"))
}

func (UnimplementedPluginServiceHandler) CreateTemplateVersion(context.Context, *connect_go.Request[v1alpha1.CreateTemplateVersionRequest]) (*connect_go.Response[v1alpha1.CreateTemplateVersionResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.CreateTemplateVersion is not implemented"))
}

func (UnimplementedPluginServiceHandler) SetTemplateContributor(context.Context, *connect_go.Request[v1alpha1.SetTemplateContributorRequest]) (*connect_go.Response[v1alpha1.SetTemplateContributorResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.SetTemplateContributor is not implemented"))
}

func (UnimplementedPluginServiceHandler) ListTemplateContributors(context.Context, *connect_go.Request[v1alpha1.ListTemplateContributorsRequest]) (*connect_go.Response[v1alpha1.ListTemplateContributorsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.ListTemplateContributors is not implemented"))
}

func (UnimplementedPluginServiceHandler) DeprecateTemplate(context.Context, *connect_go.Request[v1alpha1.DeprecateTemplateRequest]) (*connect_go.Response[v1alpha1.DeprecateTemplateResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.DeprecateTemplate is not implemented"))
}

func (UnimplementedPluginServiceHandler) UndeprecateTemplate(context.Context, *connect_go.Request[v1alpha1.UndeprecateTemplateRequest]) (*connect_go.Response[v1alpha1.UndeprecateTemplateResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.PluginService.UndeprecateTemplate is not implemented"))
}
