// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/alpha/registry/v1alpha1/organization.proto

package registryv1alpha1connect

import (
	context "context"
	errors "errors"
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	connect_go "github.com/bufbuild/connect-go"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect_go.IsAtLeastVersion0_1_0

const (
	// OrganizationServiceName is the fully-qualified name of the OrganizationService service.
	OrganizationServiceName = "buf.alpha.registry.v1alpha1.OrganizationService"
)

// OrganizationServiceClient is a client for the buf.alpha.registry.v1alpha1.OrganizationService
// service.
type OrganizationServiceClient interface {
	// GetOrganization gets a organization by ID.
	GetOrganization(context.Context, *connect_go.Request[v1alpha1.GetOrganizationRequest]) (*connect_go.Response[v1alpha1.GetOrganizationResponse], error)
	// GetOrganizationByName gets a organization by name.
	GetOrganizationByName(context.Context, *connect_go.Request[v1alpha1.GetOrganizationByNameRequest]) (*connect_go.Response[v1alpha1.GetOrganizationByNameResponse], error)
	// ListOrganizations lists all organizations.
	ListOrganizations(context.Context, *connect_go.Request[v1alpha1.ListOrganizationsRequest]) (*connect_go.Response[v1alpha1.ListOrganizationsResponse], error)
	// ListUserOrganizations lists all organizations a user is member of.
	ListUserOrganizations(context.Context, *connect_go.Request[v1alpha1.ListUserOrganizationsRequest]) (*connect_go.Response[v1alpha1.ListUserOrganizationsResponse], error)
	// CreateOrganization creates a new organization.
	CreateOrganization(context.Context, *connect_go.Request[v1alpha1.CreateOrganizationRequest]) (*connect_go.Response[v1alpha1.CreateOrganizationResponse], error)
	// DeleteOrganization deletes a organization.
	DeleteOrganization(context.Context, *connect_go.Request[v1alpha1.DeleteOrganizationRequest]) (*connect_go.Response[v1alpha1.DeleteOrganizationResponse], error)
	// DeleteOrganizationByName deletes a organization by name.
	DeleteOrganizationByName(context.Context, *connect_go.Request[v1alpha1.DeleteOrganizationByNameRequest]) (*connect_go.Response[v1alpha1.DeleteOrganizationByNameResponse], error)
	// AddOrganizationMember add a role to an user in the organization.
	AddOrganizationMember(context.Context, *connect_go.Request[v1alpha1.AddOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.AddOrganizationMemberResponse], error)
	// UpdateOrganizationMember update the user's membership information in the organization.
	UpdateOrganizationMember(context.Context, *connect_go.Request[v1alpha1.UpdateOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UpdateOrganizationMemberResponse], error)
	// RemoveOrganizationMember remove the role of an user in the organization.
	RemoveOrganizationMember(context.Context, *connect_go.Request[v1alpha1.RemoveOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.RemoveOrganizationMemberResponse], error)
	// SetOrganizationMember sets the role of a user in the organization.
	SetOrganizationMember(context.Context, *connect_go.Request[v1alpha1.SetOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.SetOrganizationMemberResponse], error)
	// GetOrganizationSettings gets the settings of an organization, including organization base roles.
	GetOrganizationSettings(context.Context, *connect_go.Request[v1alpha1.GetOrganizationSettingsRequest]) (*connect_go.Response[v1alpha1.GetOrganizationSettingsResponse], error)
	// UpdateOrganizationSettings update the organization settings including base roles.
	UpdateOrganizationSettings(context.Context, *connect_go.Request[v1alpha1.UpdateOrganizationSettingsRequest]) (*connect_go.Response[v1alpha1.UpdateOrganizationSettingsResponse], error)
}

// NewOrganizationServiceClient constructs a client for the
// buf.alpha.registry.v1alpha1.OrganizationService service. By default, it uses the Connect protocol
// with the binary Protobuf Codec, asks for gzipped responses, and sends uncompressed requests. To
// use the gRPC or gRPC-Web protocols, supply the connect.WithGRPC() or connect.WithGRPCWeb()
// options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewOrganizationServiceClient(httpClient connect_go.HTTPClient, baseURL string, opts ...connect_go.ClientOption) OrganizationServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &organizationServiceClient{
		getOrganization: connect_go.NewClient[v1alpha1.GetOrganizationRequest, v1alpha1.GetOrganizationResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.OrganizationService/GetOrganization",
			opts...,
		),
		getOrganizationByName: connect_go.NewClient[v1alpha1.GetOrganizationByNameRequest, v1alpha1.GetOrganizationByNameResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.OrganizationService/GetOrganizationByName",
			opts...,
		),
		listOrganizations: connect_go.NewClient[v1alpha1.ListOrganizationsRequest, v1alpha1.ListOrganizationsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.OrganizationService/ListOrganizations",
			opts...,
		),
		listUserOrganizations: connect_go.NewClient[v1alpha1.ListUserOrganizationsRequest, v1alpha1.ListUserOrganizationsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.OrganizationService/ListUserOrganizations",
			opts...,
		),
		createOrganization: connect_go.NewClient[v1alpha1.CreateOrganizationRequest, v1alpha1.CreateOrganizationResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.OrganizationService/CreateOrganization",
			opts...,
		),
		deleteOrganization: connect_go.NewClient[v1alpha1.DeleteOrganizationRequest, v1alpha1.DeleteOrganizationResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.OrganizationService/DeleteOrganization",
			opts...,
		),
		deleteOrganizationByName: connect_go.NewClient[v1alpha1.DeleteOrganizationByNameRequest, v1alpha1.DeleteOrganizationByNameResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.OrganizationService/DeleteOrganizationByName",
			opts...,
		),
		addOrganizationMember: connect_go.NewClient[v1alpha1.AddOrganizationMemberRequest, v1alpha1.AddOrganizationMemberResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.OrganizationService/AddOrganizationMember",
			opts...,
		),
		updateOrganizationMember: connect_go.NewClient[v1alpha1.UpdateOrganizationMemberRequest, v1alpha1.UpdateOrganizationMemberResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.OrganizationService/UpdateOrganizationMember",
			opts...,
		),
		removeOrganizationMember: connect_go.NewClient[v1alpha1.RemoveOrganizationMemberRequest, v1alpha1.RemoveOrganizationMemberResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.OrganizationService/RemoveOrganizationMember",
			opts...,
		),
		setOrganizationMember: connect_go.NewClient[v1alpha1.SetOrganizationMemberRequest, v1alpha1.SetOrganizationMemberResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.OrganizationService/SetOrganizationMember",
			opts...,
		),
		getOrganizationSettings: connect_go.NewClient[v1alpha1.GetOrganizationSettingsRequest, v1alpha1.GetOrganizationSettingsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.OrganizationService/GetOrganizationSettings",
			opts...,
		),
		updateOrganizationSettings: connect_go.NewClient[v1alpha1.UpdateOrganizationSettingsRequest, v1alpha1.UpdateOrganizationSettingsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.OrganizationService/UpdateOrganizationSettings",
			opts...,
		),
	}
}

// organizationServiceClient implements OrganizationServiceClient.
type organizationServiceClient struct {
	getOrganization            *connect_go.Client[v1alpha1.GetOrganizationRequest, v1alpha1.GetOrganizationResponse]
	getOrganizationByName      *connect_go.Client[v1alpha1.GetOrganizationByNameRequest, v1alpha1.GetOrganizationByNameResponse]
	listOrganizations          *connect_go.Client[v1alpha1.ListOrganizationsRequest, v1alpha1.ListOrganizationsResponse]
	listUserOrganizations      *connect_go.Client[v1alpha1.ListUserOrganizationsRequest, v1alpha1.ListUserOrganizationsResponse]
	createOrganization         *connect_go.Client[v1alpha1.CreateOrganizationRequest, v1alpha1.CreateOrganizationResponse]
	deleteOrganization         *connect_go.Client[v1alpha1.DeleteOrganizationRequest, v1alpha1.DeleteOrganizationResponse]
	deleteOrganizationByName   *connect_go.Client[v1alpha1.DeleteOrganizationByNameRequest, v1alpha1.DeleteOrganizationByNameResponse]
	addOrganizationMember      *connect_go.Client[v1alpha1.AddOrganizationMemberRequest, v1alpha1.AddOrganizationMemberResponse]
	updateOrganizationMember   *connect_go.Client[v1alpha1.UpdateOrganizationMemberRequest, v1alpha1.UpdateOrganizationMemberResponse]
	removeOrganizationMember   *connect_go.Client[v1alpha1.RemoveOrganizationMemberRequest, v1alpha1.RemoveOrganizationMemberResponse]
	setOrganizationMember      *connect_go.Client[v1alpha1.SetOrganizationMemberRequest, v1alpha1.SetOrganizationMemberResponse]
	getOrganizationSettings    *connect_go.Client[v1alpha1.GetOrganizationSettingsRequest, v1alpha1.GetOrganizationSettingsResponse]
	updateOrganizationSettings *connect_go.Client[v1alpha1.UpdateOrganizationSettingsRequest, v1alpha1.UpdateOrganizationSettingsResponse]
}

// GetOrganization calls buf.alpha.registry.v1alpha1.OrganizationService.GetOrganization.
func (c *organizationServiceClient) GetOrganization(ctx context.Context, req *connect_go.Request[v1alpha1.GetOrganizationRequest]) (*connect_go.Response[v1alpha1.GetOrganizationResponse], error) {
	return c.getOrganization.CallUnary(ctx, req)
}

// GetOrganizationByName calls
// buf.alpha.registry.v1alpha1.OrganizationService.GetOrganizationByName.
func (c *organizationServiceClient) GetOrganizationByName(ctx context.Context, req *connect_go.Request[v1alpha1.GetOrganizationByNameRequest]) (*connect_go.Response[v1alpha1.GetOrganizationByNameResponse], error) {
	return c.getOrganizationByName.CallUnary(ctx, req)
}

// ListOrganizations calls buf.alpha.registry.v1alpha1.OrganizationService.ListOrganizations.
func (c *organizationServiceClient) ListOrganizations(ctx context.Context, req *connect_go.Request[v1alpha1.ListOrganizationsRequest]) (*connect_go.Response[v1alpha1.ListOrganizationsResponse], error) {
	return c.listOrganizations.CallUnary(ctx, req)
}

// ListUserOrganizations calls
// buf.alpha.registry.v1alpha1.OrganizationService.ListUserOrganizations.
func (c *organizationServiceClient) ListUserOrganizations(ctx context.Context, req *connect_go.Request[v1alpha1.ListUserOrganizationsRequest]) (*connect_go.Response[v1alpha1.ListUserOrganizationsResponse], error) {
	return c.listUserOrganizations.CallUnary(ctx, req)
}

// CreateOrganization calls buf.alpha.registry.v1alpha1.OrganizationService.CreateOrganization.
func (c *organizationServiceClient) CreateOrganization(ctx context.Context, req *connect_go.Request[v1alpha1.CreateOrganizationRequest]) (*connect_go.Response[v1alpha1.CreateOrganizationResponse], error) {
	return c.createOrganization.CallUnary(ctx, req)
}

// DeleteOrganization calls buf.alpha.registry.v1alpha1.OrganizationService.DeleteOrganization.
func (c *organizationServiceClient) DeleteOrganization(ctx context.Context, req *connect_go.Request[v1alpha1.DeleteOrganizationRequest]) (*connect_go.Response[v1alpha1.DeleteOrganizationResponse], error) {
	return c.deleteOrganization.CallUnary(ctx, req)
}

// DeleteOrganizationByName calls
// buf.alpha.registry.v1alpha1.OrganizationService.DeleteOrganizationByName.
func (c *organizationServiceClient) DeleteOrganizationByName(ctx context.Context, req *connect_go.Request[v1alpha1.DeleteOrganizationByNameRequest]) (*connect_go.Response[v1alpha1.DeleteOrganizationByNameResponse], error) {
	return c.deleteOrganizationByName.CallUnary(ctx, req)
}

// AddOrganizationMember calls
// buf.alpha.registry.v1alpha1.OrganizationService.AddOrganizationMember.
func (c *organizationServiceClient) AddOrganizationMember(ctx context.Context, req *connect_go.Request[v1alpha1.AddOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.AddOrganizationMemberResponse], error) {
	return c.addOrganizationMember.CallUnary(ctx, req)
}

// UpdateOrganizationMember calls
// buf.alpha.registry.v1alpha1.OrganizationService.UpdateOrganizationMember.
func (c *organizationServiceClient) UpdateOrganizationMember(ctx context.Context, req *connect_go.Request[v1alpha1.UpdateOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UpdateOrganizationMemberResponse], error) {
	return c.updateOrganizationMember.CallUnary(ctx, req)
}

// RemoveOrganizationMember calls
// buf.alpha.registry.v1alpha1.OrganizationService.RemoveOrganizationMember.
func (c *organizationServiceClient) RemoveOrganizationMember(ctx context.Context, req *connect_go.Request[v1alpha1.RemoveOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.RemoveOrganizationMemberResponse], error) {
	return c.removeOrganizationMember.CallUnary(ctx, req)
}

// SetOrganizationMember calls
// buf.alpha.registry.v1alpha1.OrganizationService.SetOrganizationMember.
func (c *organizationServiceClient) SetOrganizationMember(ctx context.Context, req *connect_go.Request[v1alpha1.SetOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.SetOrganizationMemberResponse], error) {
	return c.setOrganizationMember.CallUnary(ctx, req)
}

// GetOrganizationSettings calls
// buf.alpha.registry.v1alpha1.OrganizationService.GetOrganizationSettings.
func (c *organizationServiceClient) GetOrganizationSettings(ctx context.Context, req *connect_go.Request[v1alpha1.GetOrganizationSettingsRequest]) (*connect_go.Response[v1alpha1.GetOrganizationSettingsResponse], error) {
	return c.getOrganizationSettings.CallUnary(ctx, req)
}

// UpdateOrganizationSettings calls
// buf.alpha.registry.v1alpha1.OrganizationService.UpdateOrganizationSettings.
func (c *organizationServiceClient) UpdateOrganizationSettings(ctx context.Context, req *connect_go.Request[v1alpha1.UpdateOrganizationSettingsRequest]) (*connect_go.Response[v1alpha1.UpdateOrganizationSettingsResponse], error) {
	return c.updateOrganizationSettings.CallUnary(ctx, req)
}

// OrganizationServiceHandler is an implementation of the
// buf.alpha.registry.v1alpha1.OrganizationService service.
type OrganizationServiceHandler interface {
	// GetOrganization gets a organization by ID.
	GetOrganization(context.Context, *connect_go.Request[v1alpha1.GetOrganizationRequest]) (*connect_go.Response[v1alpha1.GetOrganizationResponse], error)
	// GetOrganizationByName gets a organization by name.
	GetOrganizationByName(context.Context, *connect_go.Request[v1alpha1.GetOrganizationByNameRequest]) (*connect_go.Response[v1alpha1.GetOrganizationByNameResponse], error)
	// ListOrganizations lists all organizations.
	ListOrganizations(context.Context, *connect_go.Request[v1alpha1.ListOrganizationsRequest]) (*connect_go.Response[v1alpha1.ListOrganizationsResponse], error)
	// ListUserOrganizations lists all organizations a user is member of.
	ListUserOrganizations(context.Context, *connect_go.Request[v1alpha1.ListUserOrganizationsRequest]) (*connect_go.Response[v1alpha1.ListUserOrganizationsResponse], error)
	// CreateOrganization creates a new organization.
	CreateOrganization(context.Context, *connect_go.Request[v1alpha1.CreateOrganizationRequest]) (*connect_go.Response[v1alpha1.CreateOrganizationResponse], error)
	// DeleteOrganization deletes a organization.
	DeleteOrganization(context.Context, *connect_go.Request[v1alpha1.DeleteOrganizationRequest]) (*connect_go.Response[v1alpha1.DeleteOrganizationResponse], error)
	// DeleteOrganizationByName deletes a organization by name.
	DeleteOrganizationByName(context.Context, *connect_go.Request[v1alpha1.DeleteOrganizationByNameRequest]) (*connect_go.Response[v1alpha1.DeleteOrganizationByNameResponse], error)
	// AddOrganizationMember add a role to an user in the organization.
	AddOrganizationMember(context.Context, *connect_go.Request[v1alpha1.AddOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.AddOrganizationMemberResponse], error)
	// UpdateOrganizationMember update the user's membership information in the organization.
	UpdateOrganizationMember(context.Context, *connect_go.Request[v1alpha1.UpdateOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UpdateOrganizationMemberResponse], error)
	// RemoveOrganizationMember remove the role of an user in the organization.
	RemoveOrganizationMember(context.Context, *connect_go.Request[v1alpha1.RemoveOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.RemoveOrganizationMemberResponse], error)
	// SetOrganizationMember sets the role of a user in the organization.
	SetOrganizationMember(context.Context, *connect_go.Request[v1alpha1.SetOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.SetOrganizationMemberResponse], error)
	// GetOrganizationSettings gets the settings of an organization, including organization base roles.
	GetOrganizationSettings(context.Context, *connect_go.Request[v1alpha1.GetOrganizationSettingsRequest]) (*connect_go.Response[v1alpha1.GetOrganizationSettingsResponse], error)
	// UpdateOrganizationSettings update the organization settings including base roles.
	UpdateOrganizationSettings(context.Context, *connect_go.Request[v1alpha1.UpdateOrganizationSettingsRequest]) (*connect_go.Response[v1alpha1.UpdateOrganizationSettingsResponse], error)
}

// NewOrganizationServiceHandler builds an HTTP handler from the service implementation. It returns
// the path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewOrganizationServiceHandler(svc OrganizationServiceHandler, opts ...connect_go.HandlerOption) (string, http.Handler) {
	mux := http.NewServeMux()
	mux.Handle("/buf.alpha.registry.v1alpha1.OrganizationService/GetOrganization", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.OrganizationService/GetOrganization",
		svc.GetOrganization,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.OrganizationService/GetOrganizationByName", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.OrganizationService/GetOrganizationByName",
		svc.GetOrganizationByName,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.OrganizationService/ListOrganizations", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.OrganizationService/ListOrganizations",
		svc.ListOrganizations,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.OrganizationService/ListUserOrganizations", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.OrganizationService/ListUserOrganizations",
		svc.ListUserOrganizations,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.OrganizationService/CreateOrganization", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.OrganizationService/CreateOrganization",
		svc.CreateOrganization,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.OrganizationService/DeleteOrganization", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.OrganizationService/DeleteOrganization",
		svc.DeleteOrganization,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.OrganizationService/DeleteOrganizationByName", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.OrganizationService/DeleteOrganizationByName",
		svc.DeleteOrganizationByName,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.OrganizationService/AddOrganizationMember", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.OrganizationService/AddOrganizationMember",
		svc.AddOrganizationMember,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.OrganizationService/UpdateOrganizationMember", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.OrganizationService/UpdateOrganizationMember",
		svc.UpdateOrganizationMember,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.OrganizationService/RemoveOrganizationMember", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.OrganizationService/RemoveOrganizationMember",
		svc.RemoveOrganizationMember,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.OrganizationService/SetOrganizationMember", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.OrganizationService/SetOrganizationMember",
		svc.SetOrganizationMember,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.OrganizationService/GetOrganizationSettings", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.OrganizationService/GetOrganizationSettings",
		svc.GetOrganizationSettings,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.OrganizationService/UpdateOrganizationSettings", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.OrganizationService/UpdateOrganizationSettings",
		svc.UpdateOrganizationSettings,
		opts...,
	))
	return "/buf.alpha.registry.v1alpha1.OrganizationService/", mux
}

// UnimplementedOrganizationServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedOrganizationServiceHandler struct{}

func (UnimplementedOrganizationServiceHandler) GetOrganization(context.Context, *connect_go.Request[v1alpha1.GetOrganizationRequest]) (*connect_go.Response[v1alpha1.GetOrganizationResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.OrganizationService.GetOrganization is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) GetOrganizationByName(context.Context, *connect_go.Request[v1alpha1.GetOrganizationByNameRequest]) (*connect_go.Response[v1alpha1.GetOrganizationByNameResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.OrganizationService.GetOrganizationByName is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) ListOrganizations(context.Context, *connect_go.Request[v1alpha1.ListOrganizationsRequest]) (*connect_go.Response[v1alpha1.ListOrganizationsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.OrganizationService.ListOrganizations is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) ListUserOrganizations(context.Context, *connect_go.Request[v1alpha1.ListUserOrganizationsRequest]) (*connect_go.Response[v1alpha1.ListUserOrganizationsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.OrganizationService.ListUserOrganizations is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) CreateOrganization(context.Context, *connect_go.Request[v1alpha1.CreateOrganizationRequest]) (*connect_go.Response[v1alpha1.CreateOrganizationResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.OrganizationService.CreateOrganization is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) DeleteOrganization(context.Context, *connect_go.Request[v1alpha1.DeleteOrganizationRequest]) (*connect_go.Response[v1alpha1.DeleteOrganizationResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.OrganizationService.DeleteOrganization is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) DeleteOrganizationByName(context.Context, *connect_go.Request[v1alpha1.DeleteOrganizationByNameRequest]) (*connect_go.Response[v1alpha1.DeleteOrganizationByNameResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.OrganizationService.DeleteOrganizationByName is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) AddOrganizationMember(context.Context, *connect_go.Request[v1alpha1.AddOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.AddOrganizationMemberResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.OrganizationService.AddOrganizationMember is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) UpdateOrganizationMember(context.Context, *connect_go.Request[v1alpha1.UpdateOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UpdateOrganizationMemberResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.OrganizationService.UpdateOrganizationMember is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) RemoveOrganizationMember(context.Context, *connect_go.Request[v1alpha1.RemoveOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.RemoveOrganizationMemberResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.OrganizationService.RemoveOrganizationMember is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) SetOrganizationMember(context.Context, *connect_go.Request[v1alpha1.SetOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.SetOrganizationMemberResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.OrganizationService.SetOrganizationMember is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) GetOrganizationSettings(context.Context, *connect_go.Request[v1alpha1.GetOrganizationSettingsRequest]) (*connect_go.Response[v1alpha1.GetOrganizationSettingsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.OrganizationService.GetOrganizationSettings is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) UpdateOrganizationSettings(context.Context, *connect_go.Request[v1alpha1.UpdateOrganizationSettingsRequest]) (*connect_go.Response[v1alpha1.UpdateOrganizationSettingsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.OrganizationService.UpdateOrganizationSettings is not implemented"))
}
