// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/alpha/registry/v1alpha1/authz.proto

package registryv1alpha1connect

import (
	context "context"
	errors "errors"
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	connect_go "github.com/bufbuild/connect-go"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect_go.IsAtLeastVersion0_1_0

const (
	// AuthzServiceName is the fully-qualified name of the AuthzService service.
	AuthzServiceName = "buf.alpha.registry.v1alpha1.AuthzService"
)

// AuthzServiceClient is a client for the buf.alpha.registry.v1alpha1.AuthzService service.
type AuthzServiceClient interface {
	// UserCanCreateOrganizationRepository returns whether the user is authorized
	// to create repositories in an organization.
	UserCanCreateOrganizationRepository(context.Context, *connect_go.Request[v1alpha1.UserCanCreateOrganizationRepositoryRequest]) (*connect_go.Response[v1alpha1.UserCanCreateOrganizationRepositoryResponse], error)
	// UserCanSeeRepositorySettings returns whether the user is authorized
	// to see repository settings.
	UserCanSeeRepositorySettings(context.Context, *connect_go.Request[v1alpha1.UserCanSeeRepositorySettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeeRepositorySettingsResponse], error)
	// UserCanSeeOrganizationSettings returns whether the user is authorized
	// to see organization settings.
	UserCanSeeOrganizationSettings(context.Context, *connect_go.Request[v1alpha1.UserCanSeeOrganizationSettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeeOrganizationSettingsResponse], error)
	// UserCanReadPlugin returns whether the user has read access to the specified plugin.
	//
	// Deprecated: do not use.
	UserCanReadPlugin(context.Context, *connect_go.Request[v1alpha1.UserCanReadPluginRequest]) (*connect_go.Response[v1alpha1.UserCanReadPluginResponse], error)
	// UserCanCreatePluginVersion returns whether the user is authorized
	// to create a plugin version under the specified plugin.
	//
	// Deprecated: do not use.
	UserCanCreatePluginVersion(context.Context, *connect_go.Request[v1alpha1.UserCanCreatePluginVersionRequest]) (*connect_go.Response[v1alpha1.UserCanCreatePluginVersionResponse], error)
	// UserCanCreateTemplateVersion returns whether the user is authorized
	// to create a template version under the specified template.
	//
	// Deprecated: do not use.
	UserCanCreateTemplateVersion(context.Context, *connect_go.Request[v1alpha1.UserCanCreateTemplateVersionRequest]) (*connect_go.Response[v1alpha1.UserCanCreateTemplateVersionResponse], error)
	// UserCanCreateOrganizationPlugin returns whether the user is authorized to create
	// a plugin in an organization.
	//
	// Deprecated: do not use.
	UserCanCreateOrganizationPlugin(context.Context, *connect_go.Request[v1alpha1.UserCanCreateOrganizationPluginRequest]) (*connect_go.Response[v1alpha1.UserCanCreateOrganizationPluginResponse], error)
	// UserCanCreateOrganizationPlugin returns whether the user is authorized to create
	// a template in an organization.
	//
	// Deprecated: do not use.
	UserCanCreateOrganizationTemplate(context.Context, *connect_go.Request[v1alpha1.UserCanCreateOrganizationTemplateRequest]) (*connect_go.Response[v1alpha1.UserCanCreateOrganizationTemplateResponse], error)
	// UserCanSeePluginSettings returns whether the user is authorized
	// to see plugin settings.
	//
	// Deprecated: do not use.
	UserCanSeePluginSettings(context.Context, *connect_go.Request[v1alpha1.UserCanSeePluginSettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeePluginSettingsResponse], error)
	// UserCanSeeTemplateSettings returns whether the user is authorized
	// to see template settings.
	//
	// Deprecated: do not use.
	UserCanSeeTemplateSettings(context.Context, *connect_go.Request[v1alpha1.UserCanSeeTemplateSettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeeTemplateSettingsResponse], error)
	// UserCanAddOrganizationMember returns whether the user is authorized to add
	// any members to the organization and the list of roles they can add.
	UserCanAddOrganizationMember(context.Context, *connect_go.Request[v1alpha1.UserCanAddOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UserCanAddOrganizationMemberResponse], error)
	// UserCanUpdateOrganizationMember returns whether the user is authorized to update
	// any members' membership information in the organization and the list of roles they can update.
	UserCanUpdateOrganizationMember(context.Context, *connect_go.Request[v1alpha1.UserCanUpdateOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UserCanUpdateOrganizationMemberResponse], error)
	// UserCanRemoveOrganizationMember returns whether the user is authorized to remove
	// any members from the organization and the list of roles they can remove.
	UserCanRemoveOrganizationMember(context.Context, *connect_go.Request[v1alpha1.UserCanRemoveOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UserCanRemoveOrganizationMemberResponse], error)
	// UserCanDeleteOrganization returns whether the user is authorized
	// to delete an organization.
	UserCanDeleteOrganization(context.Context, *connect_go.Request[v1alpha1.UserCanDeleteOrganizationRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteOrganizationResponse], error)
	// UserCanDeleteRepository returns whether the user is authorized
	// to delete a repository.
	UserCanDeleteRepository(context.Context, *connect_go.Request[v1alpha1.UserCanDeleteRepositoryRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteRepositoryResponse], error)
	// UserCanDeleteTemplate returns whether the user is authorized
	// to delete a template.
	//
	// Deprecated: do not use.
	UserCanDeleteTemplate(context.Context, *connect_go.Request[v1alpha1.UserCanDeleteTemplateRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteTemplateResponse], error)
	// UserCanDeletePlugin returns whether the user is authorized
	// to delete a plugin.
	//
	// Deprecated: do not use.
	UserCanDeletePlugin(context.Context, *connect_go.Request[v1alpha1.UserCanDeletePluginRequest]) (*connect_go.Response[v1alpha1.UserCanDeletePluginResponse], error)
	// UserCanDeleteUser returns whether the user is authorized
	// to delete a user.
	UserCanDeleteUser(context.Context, *connect_go.Request[v1alpha1.UserCanDeleteUserRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteUserResponse], error)
	// UserCanSeeServerAdminPanel returns whether the user is authorized
	// to see server admin panel.
	UserCanSeeServerAdminPanel(context.Context, *connect_go.Request[v1alpha1.UserCanSeeServerAdminPanelRequest]) (*connect_go.Response[v1alpha1.UserCanSeeServerAdminPanelResponse], error)
	// UserCanManageRepositoryContributors returns whether the user is authorized to manage
	// any contributors to the repository and the list of roles they can manage.
	UserCanManageRepositoryContributors(context.Context, *connect_go.Request[v1alpha1.UserCanManageRepositoryContributorsRequest]) (*connect_go.Response[v1alpha1.UserCanManageRepositoryContributorsResponse], error)
	// UserCanManagePluginContributors returns whether the user is authorized to manage
	// any contributors to the plugin and the list of roles they can manage.
	//
	// Deprecated: do not use.
	UserCanManagePluginContributors(context.Context, *connect_go.Request[v1alpha1.UserCanManagePluginContributorsRequest]) (*connect_go.Response[v1alpha1.UserCanManagePluginContributorsResponse], error)
	// UserCanManageTemplateContributors returns whether the user is authorized to manage
	// any contributors to the template and the list of roles they can manage.
	//
	// Deprecated: do not use.
	UserCanManageTemplateContributors(context.Context, *connect_go.Request[v1alpha1.UserCanManageTemplateContributorsRequest]) (*connect_go.Response[v1alpha1.UserCanManageTemplateContributorsResponse], error)
}

// NewAuthzServiceClient constructs a client for the buf.alpha.registry.v1alpha1.AuthzService
// service. By default, it uses the Connect protocol with the binary Protobuf Codec, asks for
// gzipped responses, and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply
// the connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewAuthzServiceClient(httpClient connect_go.HTTPClient, baseURL string, opts ...connect_go.ClientOption) AuthzServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &authzServiceClient{
		userCanCreateOrganizationRepository: connect_go.NewClient[v1alpha1.UserCanCreateOrganizationRepositoryRequest, v1alpha1.UserCanCreateOrganizationRepositoryResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationRepository",
			opts...,
		),
		userCanSeeRepositorySettings: connect_go.NewClient[v1alpha1.UserCanSeeRepositorySettingsRequest, v1alpha1.UserCanSeeRepositorySettingsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeRepositorySettings",
			opts...,
		),
		userCanSeeOrganizationSettings: connect_go.NewClient[v1alpha1.UserCanSeeOrganizationSettingsRequest, v1alpha1.UserCanSeeOrganizationSettingsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeOrganizationSettings",
			opts...,
		),
		userCanReadPlugin: connect_go.NewClient[v1alpha1.UserCanReadPluginRequest, v1alpha1.UserCanReadPluginResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanReadPlugin",
			opts...,
		),
		userCanCreatePluginVersion: connect_go.NewClient[v1alpha1.UserCanCreatePluginVersionRequest, v1alpha1.UserCanCreatePluginVersionResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreatePluginVersion",
			opts...,
		),
		userCanCreateTemplateVersion: connect_go.NewClient[v1alpha1.UserCanCreateTemplateVersionRequest, v1alpha1.UserCanCreateTemplateVersionResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateTemplateVersion",
			opts...,
		),
		userCanCreateOrganizationPlugin: connect_go.NewClient[v1alpha1.UserCanCreateOrganizationPluginRequest, v1alpha1.UserCanCreateOrganizationPluginResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationPlugin",
			opts...,
		),
		userCanCreateOrganizationTemplate: connect_go.NewClient[v1alpha1.UserCanCreateOrganizationTemplateRequest, v1alpha1.UserCanCreateOrganizationTemplateResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationTemplate",
			opts...,
		),
		userCanSeePluginSettings: connect_go.NewClient[v1alpha1.UserCanSeePluginSettingsRequest, v1alpha1.UserCanSeePluginSettingsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeePluginSettings",
			opts...,
		),
		userCanSeeTemplateSettings: connect_go.NewClient[v1alpha1.UserCanSeeTemplateSettingsRequest, v1alpha1.UserCanSeeTemplateSettingsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeTemplateSettings",
			opts...,
		),
		userCanAddOrganizationMember: connect_go.NewClient[v1alpha1.UserCanAddOrganizationMemberRequest, v1alpha1.UserCanAddOrganizationMemberResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanAddOrganizationMember",
			opts...,
		),
		userCanUpdateOrganizationMember: connect_go.NewClient[v1alpha1.UserCanUpdateOrganizationMemberRequest, v1alpha1.UserCanUpdateOrganizationMemberResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanUpdateOrganizationMember",
			opts...,
		),
		userCanRemoveOrganizationMember: connect_go.NewClient[v1alpha1.UserCanRemoveOrganizationMemberRequest, v1alpha1.UserCanRemoveOrganizationMemberResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanRemoveOrganizationMember",
			opts...,
		),
		userCanDeleteOrganization: connect_go.NewClient[v1alpha1.UserCanDeleteOrganizationRequest, v1alpha1.UserCanDeleteOrganizationResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteOrganization",
			opts...,
		),
		userCanDeleteRepository: connect_go.NewClient[v1alpha1.UserCanDeleteRepositoryRequest, v1alpha1.UserCanDeleteRepositoryResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteRepository",
			opts...,
		),
		userCanDeleteTemplate: connect_go.NewClient[v1alpha1.UserCanDeleteTemplateRequest, v1alpha1.UserCanDeleteTemplateResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteTemplate",
			opts...,
		),
		userCanDeletePlugin: connect_go.NewClient[v1alpha1.UserCanDeletePluginRequest, v1alpha1.UserCanDeletePluginResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeletePlugin",
			opts...,
		),
		userCanDeleteUser: connect_go.NewClient[v1alpha1.UserCanDeleteUserRequest, v1alpha1.UserCanDeleteUserResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteUser",
			opts...,
		),
		userCanSeeServerAdminPanel: connect_go.NewClient[v1alpha1.UserCanSeeServerAdminPanelRequest, v1alpha1.UserCanSeeServerAdminPanelResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeServerAdminPanel",
			opts...,
		),
		userCanManageRepositoryContributors: connect_go.NewClient[v1alpha1.UserCanManageRepositoryContributorsRequest, v1alpha1.UserCanManageRepositoryContributorsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanManageRepositoryContributors",
			opts...,
		),
		userCanManagePluginContributors: connect_go.NewClient[v1alpha1.UserCanManagePluginContributorsRequest, v1alpha1.UserCanManagePluginContributorsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanManagePluginContributors",
			opts...,
		),
		userCanManageTemplateContributors: connect_go.NewClient[v1alpha1.UserCanManageTemplateContributorsRequest, v1alpha1.UserCanManageTemplateContributorsResponse](
			httpClient,
			baseURL+"/buf.alpha.registry.v1alpha1.AuthzService/UserCanManageTemplateContributors",
			opts...,
		),
	}
}

// authzServiceClient implements AuthzServiceClient.
type authzServiceClient struct {
	userCanCreateOrganizationRepository *connect_go.Client[v1alpha1.UserCanCreateOrganizationRepositoryRequest, v1alpha1.UserCanCreateOrganizationRepositoryResponse]
	userCanSeeRepositorySettings        *connect_go.Client[v1alpha1.UserCanSeeRepositorySettingsRequest, v1alpha1.UserCanSeeRepositorySettingsResponse]
	userCanSeeOrganizationSettings      *connect_go.Client[v1alpha1.UserCanSeeOrganizationSettingsRequest, v1alpha1.UserCanSeeOrganizationSettingsResponse]
	userCanReadPlugin                   *connect_go.Client[v1alpha1.UserCanReadPluginRequest, v1alpha1.UserCanReadPluginResponse]
	userCanCreatePluginVersion          *connect_go.Client[v1alpha1.UserCanCreatePluginVersionRequest, v1alpha1.UserCanCreatePluginVersionResponse]
	userCanCreateTemplateVersion        *connect_go.Client[v1alpha1.UserCanCreateTemplateVersionRequest, v1alpha1.UserCanCreateTemplateVersionResponse]
	userCanCreateOrganizationPlugin     *connect_go.Client[v1alpha1.UserCanCreateOrganizationPluginRequest, v1alpha1.UserCanCreateOrganizationPluginResponse]
	userCanCreateOrganizationTemplate   *connect_go.Client[v1alpha1.UserCanCreateOrganizationTemplateRequest, v1alpha1.UserCanCreateOrganizationTemplateResponse]
	userCanSeePluginSettings            *connect_go.Client[v1alpha1.UserCanSeePluginSettingsRequest, v1alpha1.UserCanSeePluginSettingsResponse]
	userCanSeeTemplateSettings          *connect_go.Client[v1alpha1.UserCanSeeTemplateSettingsRequest, v1alpha1.UserCanSeeTemplateSettingsResponse]
	userCanAddOrganizationMember        *connect_go.Client[v1alpha1.UserCanAddOrganizationMemberRequest, v1alpha1.UserCanAddOrganizationMemberResponse]
	userCanUpdateOrganizationMember     *connect_go.Client[v1alpha1.UserCanUpdateOrganizationMemberRequest, v1alpha1.UserCanUpdateOrganizationMemberResponse]
	userCanRemoveOrganizationMember     *connect_go.Client[v1alpha1.UserCanRemoveOrganizationMemberRequest, v1alpha1.UserCanRemoveOrganizationMemberResponse]
	userCanDeleteOrganization           *connect_go.Client[v1alpha1.UserCanDeleteOrganizationRequest, v1alpha1.UserCanDeleteOrganizationResponse]
	userCanDeleteRepository             *connect_go.Client[v1alpha1.UserCanDeleteRepositoryRequest, v1alpha1.UserCanDeleteRepositoryResponse]
	userCanDeleteTemplate               *connect_go.Client[v1alpha1.UserCanDeleteTemplateRequest, v1alpha1.UserCanDeleteTemplateResponse]
	userCanDeletePlugin                 *connect_go.Client[v1alpha1.UserCanDeletePluginRequest, v1alpha1.UserCanDeletePluginResponse]
	userCanDeleteUser                   *connect_go.Client[v1alpha1.UserCanDeleteUserRequest, v1alpha1.UserCanDeleteUserResponse]
	userCanSeeServerAdminPanel          *connect_go.Client[v1alpha1.UserCanSeeServerAdminPanelRequest, v1alpha1.UserCanSeeServerAdminPanelResponse]
	userCanManageRepositoryContributors *connect_go.Client[v1alpha1.UserCanManageRepositoryContributorsRequest, v1alpha1.UserCanManageRepositoryContributorsResponse]
	userCanManagePluginContributors     *connect_go.Client[v1alpha1.UserCanManagePluginContributorsRequest, v1alpha1.UserCanManagePluginContributorsResponse]
	userCanManageTemplateContributors   *connect_go.Client[v1alpha1.UserCanManageTemplateContributorsRequest, v1alpha1.UserCanManageTemplateContributorsResponse]
}

// UserCanCreateOrganizationRepository calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateOrganizationRepository.
func (c *authzServiceClient) UserCanCreateOrganizationRepository(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanCreateOrganizationRepositoryRequest]) (*connect_go.Response[v1alpha1.UserCanCreateOrganizationRepositoryResponse], error) {
	return c.userCanCreateOrganizationRepository.CallUnary(ctx, req)
}

// UserCanSeeRepositorySettings calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeRepositorySettings.
func (c *authzServiceClient) UserCanSeeRepositorySettings(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanSeeRepositorySettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeeRepositorySettingsResponse], error) {
	return c.userCanSeeRepositorySettings.CallUnary(ctx, req)
}

// UserCanSeeOrganizationSettings calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeOrganizationSettings.
func (c *authzServiceClient) UserCanSeeOrganizationSettings(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanSeeOrganizationSettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeeOrganizationSettingsResponse], error) {
	return c.userCanSeeOrganizationSettings.CallUnary(ctx, req)
}

// UserCanReadPlugin calls buf.alpha.registry.v1alpha1.AuthzService.UserCanReadPlugin.
//
// Deprecated: do not use.
func (c *authzServiceClient) UserCanReadPlugin(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanReadPluginRequest]) (*connect_go.Response[v1alpha1.UserCanReadPluginResponse], error) {
	return c.userCanReadPlugin.CallUnary(ctx, req)
}

// UserCanCreatePluginVersion calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanCreatePluginVersion.
//
// Deprecated: do not use.
func (c *authzServiceClient) UserCanCreatePluginVersion(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanCreatePluginVersionRequest]) (*connect_go.Response[v1alpha1.UserCanCreatePluginVersionResponse], error) {
	return c.userCanCreatePluginVersion.CallUnary(ctx, req)
}

// UserCanCreateTemplateVersion calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateTemplateVersion.
//
// Deprecated: do not use.
func (c *authzServiceClient) UserCanCreateTemplateVersion(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanCreateTemplateVersionRequest]) (*connect_go.Response[v1alpha1.UserCanCreateTemplateVersionResponse], error) {
	return c.userCanCreateTemplateVersion.CallUnary(ctx, req)
}

// UserCanCreateOrganizationPlugin calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateOrganizationPlugin.
//
// Deprecated: do not use.
func (c *authzServiceClient) UserCanCreateOrganizationPlugin(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanCreateOrganizationPluginRequest]) (*connect_go.Response[v1alpha1.UserCanCreateOrganizationPluginResponse], error) {
	return c.userCanCreateOrganizationPlugin.CallUnary(ctx, req)
}

// UserCanCreateOrganizationTemplate calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateOrganizationTemplate.
//
// Deprecated: do not use.
func (c *authzServiceClient) UserCanCreateOrganizationTemplate(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanCreateOrganizationTemplateRequest]) (*connect_go.Response[v1alpha1.UserCanCreateOrganizationTemplateResponse], error) {
	return c.userCanCreateOrganizationTemplate.CallUnary(ctx, req)
}

// UserCanSeePluginSettings calls buf.alpha.registry.v1alpha1.AuthzService.UserCanSeePluginSettings.
//
// Deprecated: do not use.
func (c *authzServiceClient) UserCanSeePluginSettings(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanSeePluginSettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeePluginSettingsResponse], error) {
	return c.userCanSeePluginSettings.CallUnary(ctx, req)
}

// UserCanSeeTemplateSettings calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeTemplateSettings.
//
// Deprecated: do not use.
func (c *authzServiceClient) UserCanSeeTemplateSettings(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanSeeTemplateSettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeeTemplateSettingsResponse], error) {
	return c.userCanSeeTemplateSettings.CallUnary(ctx, req)
}

// UserCanAddOrganizationMember calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanAddOrganizationMember.
func (c *authzServiceClient) UserCanAddOrganizationMember(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanAddOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UserCanAddOrganizationMemberResponse], error) {
	return c.userCanAddOrganizationMember.CallUnary(ctx, req)
}

// UserCanUpdateOrganizationMember calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanUpdateOrganizationMember.
func (c *authzServiceClient) UserCanUpdateOrganizationMember(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanUpdateOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UserCanUpdateOrganizationMemberResponse], error) {
	return c.userCanUpdateOrganizationMember.CallUnary(ctx, req)
}

// UserCanRemoveOrganizationMember calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanRemoveOrganizationMember.
func (c *authzServiceClient) UserCanRemoveOrganizationMember(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanRemoveOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UserCanRemoveOrganizationMemberResponse], error) {
	return c.userCanRemoveOrganizationMember.CallUnary(ctx, req)
}

// UserCanDeleteOrganization calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteOrganization.
func (c *authzServiceClient) UserCanDeleteOrganization(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanDeleteOrganizationRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteOrganizationResponse], error) {
	return c.userCanDeleteOrganization.CallUnary(ctx, req)
}

// UserCanDeleteRepository calls buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteRepository.
func (c *authzServiceClient) UserCanDeleteRepository(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanDeleteRepositoryRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteRepositoryResponse], error) {
	return c.userCanDeleteRepository.CallUnary(ctx, req)
}

// UserCanDeleteTemplate calls buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteTemplate.
//
// Deprecated: do not use.
func (c *authzServiceClient) UserCanDeleteTemplate(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanDeleteTemplateRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteTemplateResponse], error) {
	return c.userCanDeleteTemplate.CallUnary(ctx, req)
}

// UserCanDeletePlugin calls buf.alpha.registry.v1alpha1.AuthzService.UserCanDeletePlugin.
//
// Deprecated: do not use.
func (c *authzServiceClient) UserCanDeletePlugin(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanDeletePluginRequest]) (*connect_go.Response[v1alpha1.UserCanDeletePluginResponse], error) {
	return c.userCanDeletePlugin.CallUnary(ctx, req)
}

// UserCanDeleteUser calls buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteUser.
func (c *authzServiceClient) UserCanDeleteUser(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanDeleteUserRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteUserResponse], error) {
	return c.userCanDeleteUser.CallUnary(ctx, req)
}

// UserCanSeeServerAdminPanel calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeServerAdminPanel.
func (c *authzServiceClient) UserCanSeeServerAdminPanel(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanSeeServerAdminPanelRequest]) (*connect_go.Response[v1alpha1.UserCanSeeServerAdminPanelResponse], error) {
	return c.userCanSeeServerAdminPanel.CallUnary(ctx, req)
}

// UserCanManageRepositoryContributors calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanManageRepositoryContributors.
func (c *authzServiceClient) UserCanManageRepositoryContributors(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanManageRepositoryContributorsRequest]) (*connect_go.Response[v1alpha1.UserCanManageRepositoryContributorsResponse], error) {
	return c.userCanManageRepositoryContributors.CallUnary(ctx, req)
}

// UserCanManagePluginContributors calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanManagePluginContributors.
//
// Deprecated: do not use.
func (c *authzServiceClient) UserCanManagePluginContributors(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanManagePluginContributorsRequest]) (*connect_go.Response[v1alpha1.UserCanManagePluginContributorsResponse], error) {
	return c.userCanManagePluginContributors.CallUnary(ctx, req)
}

// UserCanManageTemplateContributors calls
// buf.alpha.registry.v1alpha1.AuthzService.UserCanManageTemplateContributors.
//
// Deprecated: do not use.
func (c *authzServiceClient) UserCanManageTemplateContributors(ctx context.Context, req *connect_go.Request[v1alpha1.UserCanManageTemplateContributorsRequest]) (*connect_go.Response[v1alpha1.UserCanManageTemplateContributorsResponse], error) {
	return c.userCanManageTemplateContributors.CallUnary(ctx, req)
}

// AuthzServiceHandler is an implementation of the buf.alpha.registry.v1alpha1.AuthzService service.
type AuthzServiceHandler interface {
	// UserCanCreateOrganizationRepository returns whether the user is authorized
	// to create repositories in an organization.
	UserCanCreateOrganizationRepository(context.Context, *connect_go.Request[v1alpha1.UserCanCreateOrganizationRepositoryRequest]) (*connect_go.Response[v1alpha1.UserCanCreateOrganizationRepositoryResponse], error)
	// UserCanSeeRepositorySettings returns whether the user is authorized
	// to see repository settings.
	UserCanSeeRepositorySettings(context.Context, *connect_go.Request[v1alpha1.UserCanSeeRepositorySettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeeRepositorySettingsResponse], error)
	// UserCanSeeOrganizationSettings returns whether the user is authorized
	// to see organization settings.
	UserCanSeeOrganizationSettings(context.Context, *connect_go.Request[v1alpha1.UserCanSeeOrganizationSettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeeOrganizationSettingsResponse], error)
	// UserCanReadPlugin returns whether the user has read access to the specified plugin.
	//
	// Deprecated: do not use.
	UserCanReadPlugin(context.Context, *connect_go.Request[v1alpha1.UserCanReadPluginRequest]) (*connect_go.Response[v1alpha1.UserCanReadPluginResponse], error)
	// UserCanCreatePluginVersion returns whether the user is authorized
	// to create a plugin version under the specified plugin.
	//
	// Deprecated: do not use.
	UserCanCreatePluginVersion(context.Context, *connect_go.Request[v1alpha1.UserCanCreatePluginVersionRequest]) (*connect_go.Response[v1alpha1.UserCanCreatePluginVersionResponse], error)
	// UserCanCreateTemplateVersion returns whether the user is authorized
	// to create a template version under the specified template.
	//
	// Deprecated: do not use.
	UserCanCreateTemplateVersion(context.Context, *connect_go.Request[v1alpha1.UserCanCreateTemplateVersionRequest]) (*connect_go.Response[v1alpha1.UserCanCreateTemplateVersionResponse], error)
	// UserCanCreateOrganizationPlugin returns whether the user is authorized to create
	// a plugin in an organization.
	//
	// Deprecated: do not use.
	UserCanCreateOrganizationPlugin(context.Context, *connect_go.Request[v1alpha1.UserCanCreateOrganizationPluginRequest]) (*connect_go.Response[v1alpha1.UserCanCreateOrganizationPluginResponse], error)
	// UserCanCreateOrganizationPlugin returns whether the user is authorized to create
	// a template in an organization.
	//
	// Deprecated: do not use.
	UserCanCreateOrganizationTemplate(context.Context, *connect_go.Request[v1alpha1.UserCanCreateOrganizationTemplateRequest]) (*connect_go.Response[v1alpha1.UserCanCreateOrganizationTemplateResponse], error)
	// UserCanSeePluginSettings returns whether the user is authorized
	// to see plugin settings.
	//
	// Deprecated: do not use.
	UserCanSeePluginSettings(context.Context, *connect_go.Request[v1alpha1.UserCanSeePluginSettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeePluginSettingsResponse], error)
	// UserCanSeeTemplateSettings returns whether the user is authorized
	// to see template settings.
	//
	// Deprecated: do not use.
	UserCanSeeTemplateSettings(context.Context, *connect_go.Request[v1alpha1.UserCanSeeTemplateSettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeeTemplateSettingsResponse], error)
	// UserCanAddOrganizationMember returns whether the user is authorized to add
	// any members to the organization and the list of roles they can add.
	UserCanAddOrganizationMember(context.Context, *connect_go.Request[v1alpha1.UserCanAddOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UserCanAddOrganizationMemberResponse], error)
	// UserCanUpdateOrganizationMember returns whether the user is authorized to update
	// any members' membership information in the organization and the list of roles they can update.
	UserCanUpdateOrganizationMember(context.Context, *connect_go.Request[v1alpha1.UserCanUpdateOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UserCanUpdateOrganizationMemberResponse], error)
	// UserCanRemoveOrganizationMember returns whether the user is authorized to remove
	// any members from the organization and the list of roles they can remove.
	UserCanRemoveOrganizationMember(context.Context, *connect_go.Request[v1alpha1.UserCanRemoveOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UserCanRemoveOrganizationMemberResponse], error)
	// UserCanDeleteOrganization returns whether the user is authorized
	// to delete an organization.
	UserCanDeleteOrganization(context.Context, *connect_go.Request[v1alpha1.UserCanDeleteOrganizationRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteOrganizationResponse], error)
	// UserCanDeleteRepository returns whether the user is authorized
	// to delete a repository.
	UserCanDeleteRepository(context.Context, *connect_go.Request[v1alpha1.UserCanDeleteRepositoryRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteRepositoryResponse], error)
	// UserCanDeleteTemplate returns whether the user is authorized
	// to delete a template.
	//
	// Deprecated: do not use.
	UserCanDeleteTemplate(context.Context, *connect_go.Request[v1alpha1.UserCanDeleteTemplateRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteTemplateResponse], error)
	// UserCanDeletePlugin returns whether the user is authorized
	// to delete a plugin.
	//
	// Deprecated: do not use.
	UserCanDeletePlugin(context.Context, *connect_go.Request[v1alpha1.UserCanDeletePluginRequest]) (*connect_go.Response[v1alpha1.UserCanDeletePluginResponse], error)
	// UserCanDeleteUser returns whether the user is authorized
	// to delete a user.
	UserCanDeleteUser(context.Context, *connect_go.Request[v1alpha1.UserCanDeleteUserRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteUserResponse], error)
	// UserCanSeeServerAdminPanel returns whether the user is authorized
	// to see server admin panel.
	UserCanSeeServerAdminPanel(context.Context, *connect_go.Request[v1alpha1.UserCanSeeServerAdminPanelRequest]) (*connect_go.Response[v1alpha1.UserCanSeeServerAdminPanelResponse], error)
	// UserCanManageRepositoryContributors returns whether the user is authorized to manage
	// any contributors to the repository and the list of roles they can manage.
	UserCanManageRepositoryContributors(context.Context, *connect_go.Request[v1alpha1.UserCanManageRepositoryContributorsRequest]) (*connect_go.Response[v1alpha1.UserCanManageRepositoryContributorsResponse], error)
	// UserCanManagePluginContributors returns whether the user is authorized to manage
	// any contributors to the plugin and the list of roles they can manage.
	//
	// Deprecated: do not use.
	UserCanManagePluginContributors(context.Context, *connect_go.Request[v1alpha1.UserCanManagePluginContributorsRequest]) (*connect_go.Response[v1alpha1.UserCanManagePluginContributorsResponse], error)
	// UserCanManageTemplateContributors returns whether the user is authorized to manage
	// any contributors to the template and the list of roles they can manage.
	//
	// Deprecated: do not use.
	UserCanManageTemplateContributors(context.Context, *connect_go.Request[v1alpha1.UserCanManageTemplateContributorsRequest]) (*connect_go.Response[v1alpha1.UserCanManageTemplateContributorsResponse], error)
}

// NewAuthzServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewAuthzServiceHandler(svc AuthzServiceHandler, opts ...connect_go.HandlerOption) (string, http.Handler) {
	mux := http.NewServeMux()
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationRepository", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationRepository",
		svc.UserCanCreateOrganizationRepository,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeRepositorySettings", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeRepositorySettings",
		svc.UserCanSeeRepositorySettings,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeOrganizationSettings", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeOrganizationSettings",
		svc.UserCanSeeOrganizationSettings,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanReadPlugin", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanReadPlugin",
		svc.UserCanReadPlugin,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreatePluginVersion", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreatePluginVersion",
		svc.UserCanCreatePluginVersion,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateTemplateVersion", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateTemplateVersion",
		svc.UserCanCreateTemplateVersion,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationPlugin", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationPlugin",
		svc.UserCanCreateOrganizationPlugin,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationTemplate", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationTemplate",
		svc.UserCanCreateOrganizationTemplate,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeePluginSettings", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeePluginSettings",
		svc.UserCanSeePluginSettings,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeTemplateSettings", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeTemplateSettings",
		svc.UserCanSeeTemplateSettings,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanAddOrganizationMember", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanAddOrganizationMember",
		svc.UserCanAddOrganizationMember,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanUpdateOrganizationMember", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanUpdateOrganizationMember",
		svc.UserCanUpdateOrganizationMember,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanRemoveOrganizationMember", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanRemoveOrganizationMember",
		svc.UserCanRemoveOrganizationMember,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteOrganization", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteOrganization",
		svc.UserCanDeleteOrganization,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteRepository", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteRepository",
		svc.UserCanDeleteRepository,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteTemplate", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteTemplate",
		svc.UserCanDeleteTemplate,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeletePlugin", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeletePlugin",
		svc.UserCanDeletePlugin,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteUser", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteUser",
		svc.UserCanDeleteUser,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeServerAdminPanel", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeServerAdminPanel",
		svc.UserCanSeeServerAdminPanel,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanManageRepositoryContributors", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanManageRepositoryContributors",
		svc.UserCanManageRepositoryContributors,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanManagePluginContributors", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanManagePluginContributors",
		svc.UserCanManagePluginContributors,
		opts...,
	))
	mux.Handle("/buf.alpha.registry.v1alpha1.AuthzService/UserCanManageTemplateContributors", connect_go.NewUnaryHandler(
		"/buf.alpha.registry.v1alpha1.AuthzService/UserCanManageTemplateContributors",
		svc.UserCanManageTemplateContributors,
		opts...,
	))
	return "/buf.alpha.registry.v1alpha1.AuthzService/", mux
}

// UnimplementedAuthzServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedAuthzServiceHandler struct{}

func (UnimplementedAuthzServiceHandler) UserCanCreateOrganizationRepository(context.Context, *connect_go.Request[v1alpha1.UserCanCreateOrganizationRepositoryRequest]) (*connect_go.Response[v1alpha1.UserCanCreateOrganizationRepositoryResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateOrganizationRepository is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanSeeRepositorySettings(context.Context, *connect_go.Request[v1alpha1.UserCanSeeRepositorySettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeeRepositorySettingsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeRepositorySettings is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanSeeOrganizationSettings(context.Context, *connect_go.Request[v1alpha1.UserCanSeeOrganizationSettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeeOrganizationSettingsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeOrganizationSettings is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanReadPlugin(context.Context, *connect_go.Request[v1alpha1.UserCanReadPluginRequest]) (*connect_go.Response[v1alpha1.UserCanReadPluginResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanReadPlugin is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanCreatePluginVersion(context.Context, *connect_go.Request[v1alpha1.UserCanCreatePluginVersionRequest]) (*connect_go.Response[v1alpha1.UserCanCreatePluginVersionResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanCreatePluginVersion is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanCreateTemplateVersion(context.Context, *connect_go.Request[v1alpha1.UserCanCreateTemplateVersionRequest]) (*connect_go.Response[v1alpha1.UserCanCreateTemplateVersionResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateTemplateVersion is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanCreateOrganizationPlugin(context.Context, *connect_go.Request[v1alpha1.UserCanCreateOrganizationPluginRequest]) (*connect_go.Response[v1alpha1.UserCanCreateOrganizationPluginResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateOrganizationPlugin is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanCreateOrganizationTemplate(context.Context, *connect_go.Request[v1alpha1.UserCanCreateOrganizationTemplateRequest]) (*connect_go.Response[v1alpha1.UserCanCreateOrganizationTemplateResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateOrganizationTemplate is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanSeePluginSettings(context.Context, *connect_go.Request[v1alpha1.UserCanSeePluginSettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeePluginSettingsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanSeePluginSettings is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanSeeTemplateSettings(context.Context, *connect_go.Request[v1alpha1.UserCanSeeTemplateSettingsRequest]) (*connect_go.Response[v1alpha1.UserCanSeeTemplateSettingsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeTemplateSettings is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanAddOrganizationMember(context.Context, *connect_go.Request[v1alpha1.UserCanAddOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UserCanAddOrganizationMemberResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanAddOrganizationMember is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanUpdateOrganizationMember(context.Context, *connect_go.Request[v1alpha1.UserCanUpdateOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UserCanUpdateOrganizationMemberResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanUpdateOrganizationMember is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanRemoveOrganizationMember(context.Context, *connect_go.Request[v1alpha1.UserCanRemoveOrganizationMemberRequest]) (*connect_go.Response[v1alpha1.UserCanRemoveOrganizationMemberResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanRemoveOrganizationMember is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanDeleteOrganization(context.Context, *connect_go.Request[v1alpha1.UserCanDeleteOrganizationRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteOrganizationResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteOrganization is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanDeleteRepository(context.Context, *connect_go.Request[v1alpha1.UserCanDeleteRepositoryRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteRepositoryResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteRepository is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanDeleteTemplate(context.Context, *connect_go.Request[v1alpha1.UserCanDeleteTemplateRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteTemplateResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteTemplate is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanDeletePlugin(context.Context, *connect_go.Request[v1alpha1.UserCanDeletePluginRequest]) (*connect_go.Response[v1alpha1.UserCanDeletePluginResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanDeletePlugin is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanDeleteUser(context.Context, *connect_go.Request[v1alpha1.UserCanDeleteUserRequest]) (*connect_go.Response[v1alpha1.UserCanDeleteUserResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteUser is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanSeeServerAdminPanel(context.Context, *connect_go.Request[v1alpha1.UserCanSeeServerAdminPanelRequest]) (*connect_go.Response[v1alpha1.UserCanSeeServerAdminPanelResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeServerAdminPanel is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanManageRepositoryContributors(context.Context, *connect_go.Request[v1alpha1.UserCanManageRepositoryContributorsRequest]) (*connect_go.Response[v1alpha1.UserCanManageRepositoryContributorsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanManageRepositoryContributors is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanManagePluginContributors(context.Context, *connect_go.Request[v1alpha1.UserCanManagePluginContributorsRequest]) (*connect_go.Response[v1alpha1.UserCanManagePluginContributorsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanManagePluginContributors is not implemented"))
}

func (UnimplementedAuthzServiceHandler) UserCanManageTemplateContributors(context.Context, *connect_go.Request[v1alpha1.UserCanManageTemplateContributorsRequest]) (*connect_go.Response[v1alpha1.UserCanManageTemplateContributorsResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.AuthzService.UserCanManageTemplateContributors is not implemented"))
}
