// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: event.proto

package f5_nginx_agent_sdk_events

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	common "github.com/nginx/agent/sdk/v2/proto/common"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Represents the metadata for an event
type Metadata struct {
	// Module is the process that generate the event
	Module string `protobuf:"bytes,1,opt,name=Module,proto3" json:"module"`
	// UUID is a unique identifier for each event
	UUID string `protobuf:"bytes,2,opt,name=UUID,proto3" json:"uuid"`
	// CorrelationID is an ID used by the producer of the message to track the flow of events
	CorrelationID string `protobuf:"bytes,3,opt,name=CorrelationID,proto3" json:"correlation_id"`
	// Timestamp defines the time of event generation
	Timestamp *types.Timestamp `protobuf:"bytes,4,opt,name=Timestamp,proto3" json:"timestamp"`
	// EventLevel defines the criticality of event
	EventLevel string `protobuf:"bytes,5,opt,name=EventLevel,proto3" json:"event_level"`
	// Type is used to identify the event type for further processing
	Type string `protobuf:"bytes,6,opt,name=Type,proto3" json:"type"`
	// Category is used for classifying the event type into a higher level entity
	Category             string   `protobuf:"bytes,7,opt,name=Category,proto3" json:"category"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metadata) Reset()         { *m = Metadata{} }
func (m *Metadata) String() string { return proto.CompactTextString(m) }
func (*Metadata) ProtoMessage()    {}
func (*Metadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d17a9d3f0ddf27e, []int{0}
}
func (m *Metadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Metadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Metadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Metadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metadata.Merge(m, src)
}
func (m *Metadata) XXX_Size() int {
	return m.Size()
}
func (m *Metadata) XXX_DiscardUnknown() {
	xxx_messageInfo_Metadata.DiscardUnknown(m)
}

var xxx_messageInfo_Metadata proto.InternalMessageInfo

func (m *Metadata) GetModule() string {
	if m != nil {
		return m.Module
	}
	return ""
}

func (m *Metadata) GetUUID() string {
	if m != nil {
		return m.UUID
	}
	return ""
}

func (m *Metadata) GetCorrelationID() string {
	if m != nil {
		return m.CorrelationID
	}
	return ""
}

func (m *Metadata) GetTimestamp() *types.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *Metadata) GetEventLevel() string {
	if m != nil {
		return m.EventLevel
	}
	return ""
}

func (m *Metadata) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Metadata) GetCategory() string {
	if m != nil {
		return m.Category
	}
	return ""
}

// Represents an event
type Event struct {
	// Event metadata
	Metadata *Metadata `protobuf:"bytes,1,opt,name=Metadata,proto3" json:"metadata"`
	// Types that are valid to be assigned to Data:
	//
	//	*Event_ActivityEvent
	//	*Event_SecurityViolationEvent
	Data                 isEvent_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d17a9d3f0ddf27e, []int{1}
}
func (m *Event) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Event.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return m.Size()
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

type isEvent_Data interface {
	isEvent_Data()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Event_ActivityEvent struct {
	ActivityEvent *ActivityEvent `protobuf:"bytes,2,opt,name=ActivityEvent,proto3,oneof" json:"activity_event"`
}
type Event_SecurityViolationEvent struct {
	SecurityViolationEvent *SecurityViolationEvent `protobuf:"bytes,3,opt,name=SecurityViolationEvent,proto3,oneof" json:"security_violation_event"`
}

func (*Event_ActivityEvent) isEvent_Data()          {}
func (*Event_SecurityViolationEvent) isEvent_Data() {}

func (m *Event) GetData() isEvent_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Event) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Event) GetActivityEvent() *ActivityEvent {
	if x, ok := m.GetData().(*Event_ActivityEvent); ok {
		return x.ActivityEvent
	}
	return nil
}

func (m *Event) GetSecurityViolationEvent() *SecurityViolationEvent {
	if x, ok := m.GetData().(*Event_SecurityViolationEvent); ok {
		return x.SecurityViolationEvent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Event) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Event_ActivityEvent)(nil),
		(*Event_SecurityViolationEvent)(nil),
	}
}

// Represents an event report
type EventReport struct {
	// Array of events
	Events               []*Event `protobuf:"bytes,1,rep,name=Events,proto3" json:"events"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventReport) Reset()         { *m = EventReport{} }
func (m *EventReport) String() string { return proto.CompactTextString(m) }
func (*EventReport) ProtoMessage()    {}
func (*EventReport) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d17a9d3f0ddf27e, []int{2}
}
func (m *EventReport) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EventReport) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EventReport.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EventReport) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventReport.Merge(m, src)
}
func (m *EventReport) XXX_Size() int {
	return m.Size()
}
func (m *EventReport) XXX_DiscardUnknown() {
	xxx_messageInfo_EventReport.DiscardUnknown(m)
}

var xxx_messageInfo_EventReport proto.InternalMessageInfo

func (m *EventReport) GetEvents() []*Event {
	if m != nil {
		return m.Events
	}
	return nil
}

// Represents an activity event
type ActivityEvent struct {
	// Activtiy event message
	Message string `protobuf:"bytes,1,opt,name=Message,proto3" json:"message"`
	// Array of dimensions
	Dimensions           []*common.Dimension `protobuf:"bytes,2,rep,name=Dimensions,proto3" json:"dimensions"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ActivityEvent) Reset()         { *m = ActivityEvent{} }
func (m *ActivityEvent) String() string { return proto.CompactTextString(m) }
func (*ActivityEvent) ProtoMessage()    {}
func (*ActivityEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d17a9d3f0ddf27e, []int{3}
}
func (m *ActivityEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ActivityEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ActivityEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ActivityEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActivityEvent.Merge(m, src)
}
func (m *ActivityEvent) XXX_Size() int {
	return m.Size()
}
func (m *ActivityEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_ActivityEvent.DiscardUnknown(m)
}

var xxx_messageInfo_ActivityEvent proto.InternalMessageInfo

func (m *ActivityEvent) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ActivityEvent) GetDimensions() []*common.Dimension {
	if m != nil {
		return m.Dimensions
	}
	return nil
}

// Represents a security violation that is emitted by the agent
type SecurityViolationEvent struct {
	PolicyName               string           `protobuf:"bytes,1,opt,name=PolicyName,proto3" json:"policy_name"`
	SupportID                string           `protobuf:"bytes,2,opt,name=SupportID,proto3" json:"support_id"`
	Outcome                  string           `protobuf:"bytes,3,opt,name=Outcome,proto3" json:"outcome"`
	OutcomeReason            string           `protobuf:"bytes,4,opt,name=OutcomeReason,proto3" json:"outcome_reason"`
	BlockingExceptionReason  string           `protobuf:"bytes,5,opt,name=BlockingExceptionReason,proto3" json:"blocking_exception_reason"`
	Method                   string           `protobuf:"bytes,6,opt,name=Method,proto3" json:"method"`
	Protocol                 string           `protobuf:"bytes,7,opt,name=Protocol,proto3" json:"protocol"`
	XForwardedForHeaderValue string           `protobuf:"bytes,8,opt,name=XForwardedForHeaderValue,proto3" json:"xff_header_value"`
	URI                      string           `protobuf:"bytes,9,opt,name=URI,proto3" json:"uri"`
	Request                  string           `protobuf:"bytes,10,opt,name=Request,proto3" json:"request"`
	IsTruncated              string           `protobuf:"bytes,11,opt,name=IsTruncated,proto3" json:"is_truncated"`
	RequestStatus            string           `protobuf:"bytes,12,opt,name=RequestStatus,proto3" json:"request_status"`
	ResponseCode             string           `protobuf:"bytes,13,opt,name=ResponseCode,proto3" json:"response_code"`
	ServerAddr               string           `protobuf:"bytes,14,opt,name=ServerAddr,proto3" json:"server_addr"`
	VSName                   string           `protobuf:"bytes,15,opt,name=VSName,proto3" json:"vs_name"`
	RemoteAddr               string           `protobuf:"bytes,16,opt,name=RemoteAddr,proto3" json:"remote_addr"`
	RemotePort               string           `protobuf:"bytes,17,opt,name=RemotePort,proto3" json:"destination_port"`
	ServerPort               string           `protobuf:"bytes,18,opt,name=ServerPort,proto3" json:"server_port"`
	Violations               string           `protobuf:"bytes,19,opt,name=Violations,proto3" json:"violations"`
	SubViolations            string           `protobuf:"bytes,20,opt,name=SubViolations,proto3" json:"sub_violations"`
	ViolationRating          string           `protobuf:"bytes,21,opt,name=ViolationRating,proto3" json:"violation_rating"`
	SigSetNames              string           `protobuf:"bytes,22,opt,name=SigSetNames,proto3" json:"sig_set_names"`
	SigCVEs                  string           `protobuf:"bytes,23,opt,name=SigCVEs,proto3" json:"sig_cves"`
	ClientClass              string           `protobuf:"bytes,24,opt,name=ClientClass,proto3" json:"client_class"`
	ClientApplication        string           `protobuf:"bytes,25,opt,name=ClientApplication,proto3" json:"client_application"`
	ClientApplicationVersion string           `protobuf:"bytes,26,opt,name=ClientApplicationVersion,proto3" json:"client_application_version"`
	Severity                 string           `protobuf:"bytes,27,opt,name=Severity,proto3" json:"severity"`
	ThreatCampaignNames      string           `protobuf:"bytes,28,opt,name=ThreatCampaignNames,proto3" json:"threat_campaign_names"`
	BotAnomalies             string           `protobuf:"bytes,29,opt,name=BotAnomalies,proto3" json:"bot_anomalies"`
	BotCategory              string           `protobuf:"bytes,30,opt,name=BotCategory,proto3" json:"bot_category"`
	EnforcedBotAnomalies     string           `protobuf:"bytes,31,opt,name=EnforcedBotAnomalies,proto3" json:"enforced_bot_anomalies"`
	BotSignatureName         string           `protobuf:"bytes,32,opt,name=BotSignatureName,proto3" json:"bot_signature_name"`
	ViolationContexts        string           `protobuf:"bytes,33,opt,name=ViolationContexts,proto3" json:"violation_contexts"`
	ViolationsData           []*ViolationData `protobuf:"bytes,34,rep,name=ViolationsData,proto3" json:"violations_data"`
	SystemID                 string           `protobuf:"bytes,35,opt,name=SystemID,proto3" json:"system_id"`
	InstanceTags             string           `protobuf:"bytes,36,opt,name=InstanceTags,proto3" json:"instance_tags"`
	InstanceGroup            string           `protobuf:"bytes,37,opt,name=InstanceGroup,proto3" json:"instance_group"`
	DisplayName              string           `protobuf:"bytes,38,opt,name=DisplayName,proto3" json:"display_name"`
	NginxID                  string           `protobuf:"bytes,39,opt,name=NginxID,proto3" json:"nginx_id"`
	ParentHostname           string           `protobuf:"bytes,40,opt,name=ParentHostname,proto3" json:"parent_hostname"`
	XXX_NoUnkeyedLiteral     struct{}         `json:"-"`
	XXX_unrecognized         []byte           `json:"-"`
	XXX_sizecache            int32            `json:"-"`
}

func (m *SecurityViolationEvent) Reset()         { *m = SecurityViolationEvent{} }
func (m *SecurityViolationEvent) String() string { return proto.CompactTextString(m) }
func (*SecurityViolationEvent) ProtoMessage()    {}
func (*SecurityViolationEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d17a9d3f0ddf27e, []int{4}
}
func (m *SecurityViolationEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecurityViolationEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecurityViolationEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecurityViolationEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityViolationEvent.Merge(m, src)
}
func (m *SecurityViolationEvent) XXX_Size() int {
	return m.Size()
}
func (m *SecurityViolationEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityViolationEvent.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityViolationEvent proto.InternalMessageInfo

func (m *SecurityViolationEvent) GetPolicyName() string {
	if m != nil {
		return m.PolicyName
	}
	return ""
}

func (m *SecurityViolationEvent) GetSupportID() string {
	if m != nil {
		return m.SupportID
	}
	return ""
}

func (m *SecurityViolationEvent) GetOutcome() string {
	if m != nil {
		return m.Outcome
	}
	return ""
}

func (m *SecurityViolationEvent) GetOutcomeReason() string {
	if m != nil {
		return m.OutcomeReason
	}
	return ""
}

func (m *SecurityViolationEvent) GetBlockingExceptionReason() string {
	if m != nil {
		return m.BlockingExceptionReason
	}
	return ""
}

func (m *SecurityViolationEvent) GetMethod() string {
	if m != nil {
		return m.Method
	}
	return ""
}

func (m *SecurityViolationEvent) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *SecurityViolationEvent) GetXForwardedForHeaderValue() string {
	if m != nil {
		return m.XForwardedForHeaderValue
	}
	return ""
}

func (m *SecurityViolationEvent) GetURI() string {
	if m != nil {
		return m.URI
	}
	return ""
}

func (m *SecurityViolationEvent) GetRequest() string {
	if m != nil {
		return m.Request
	}
	return ""
}

func (m *SecurityViolationEvent) GetIsTruncated() string {
	if m != nil {
		return m.IsTruncated
	}
	return ""
}

func (m *SecurityViolationEvent) GetRequestStatus() string {
	if m != nil {
		return m.RequestStatus
	}
	return ""
}

func (m *SecurityViolationEvent) GetResponseCode() string {
	if m != nil {
		return m.ResponseCode
	}
	return ""
}

func (m *SecurityViolationEvent) GetServerAddr() string {
	if m != nil {
		return m.ServerAddr
	}
	return ""
}

func (m *SecurityViolationEvent) GetVSName() string {
	if m != nil {
		return m.VSName
	}
	return ""
}

func (m *SecurityViolationEvent) GetRemoteAddr() string {
	if m != nil {
		return m.RemoteAddr
	}
	return ""
}

func (m *SecurityViolationEvent) GetRemotePort() string {
	if m != nil {
		return m.RemotePort
	}
	return ""
}

func (m *SecurityViolationEvent) GetServerPort() string {
	if m != nil {
		return m.ServerPort
	}
	return ""
}

func (m *SecurityViolationEvent) GetViolations() string {
	if m != nil {
		return m.Violations
	}
	return ""
}

func (m *SecurityViolationEvent) GetSubViolations() string {
	if m != nil {
		return m.SubViolations
	}
	return ""
}

func (m *SecurityViolationEvent) GetViolationRating() string {
	if m != nil {
		return m.ViolationRating
	}
	return ""
}

func (m *SecurityViolationEvent) GetSigSetNames() string {
	if m != nil {
		return m.SigSetNames
	}
	return ""
}

func (m *SecurityViolationEvent) GetSigCVEs() string {
	if m != nil {
		return m.SigCVEs
	}
	return ""
}

func (m *SecurityViolationEvent) GetClientClass() string {
	if m != nil {
		return m.ClientClass
	}
	return ""
}

func (m *SecurityViolationEvent) GetClientApplication() string {
	if m != nil {
		return m.ClientApplication
	}
	return ""
}

func (m *SecurityViolationEvent) GetClientApplicationVersion() string {
	if m != nil {
		return m.ClientApplicationVersion
	}
	return ""
}

func (m *SecurityViolationEvent) GetSeverity() string {
	if m != nil {
		return m.Severity
	}
	return ""
}

func (m *SecurityViolationEvent) GetThreatCampaignNames() string {
	if m != nil {
		return m.ThreatCampaignNames
	}
	return ""
}

func (m *SecurityViolationEvent) GetBotAnomalies() string {
	if m != nil {
		return m.BotAnomalies
	}
	return ""
}

func (m *SecurityViolationEvent) GetBotCategory() string {
	if m != nil {
		return m.BotCategory
	}
	return ""
}

func (m *SecurityViolationEvent) GetEnforcedBotAnomalies() string {
	if m != nil {
		return m.EnforcedBotAnomalies
	}
	return ""
}

func (m *SecurityViolationEvent) GetBotSignatureName() string {
	if m != nil {
		return m.BotSignatureName
	}
	return ""
}

func (m *SecurityViolationEvent) GetViolationContexts() string {
	if m != nil {
		return m.ViolationContexts
	}
	return ""
}

func (m *SecurityViolationEvent) GetViolationsData() []*ViolationData {
	if m != nil {
		return m.ViolationsData
	}
	return nil
}

func (m *SecurityViolationEvent) GetSystemID() string {
	if m != nil {
		return m.SystemID
	}
	return ""
}

func (m *SecurityViolationEvent) GetInstanceTags() string {
	if m != nil {
		return m.InstanceTags
	}
	return ""
}

func (m *SecurityViolationEvent) GetInstanceGroup() string {
	if m != nil {
		return m.InstanceGroup
	}
	return ""
}

func (m *SecurityViolationEvent) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *SecurityViolationEvent) GetNginxID() string {
	if m != nil {
		return m.NginxID
	}
	return ""
}

func (m *SecurityViolationEvent) GetParentHostname() string {
	if m != nil {
		return m.ParentHostname
	}
	return ""
}

type SignatureData struct {
	ID                   string   `protobuf:"bytes,1,opt,name=ID,proto3" json:"sig_data_id"`
	BlockingMask         string   `protobuf:"bytes,2,opt,name=BlockingMask,proto3" json:"sig_data_blocking_mask"`
	Buffer               string   `protobuf:"bytes,3,opt,name=Buffer,proto3" json:"sig_data_buffer"`
	Offset               string   `protobuf:"bytes,4,opt,name=Offset,proto3" json:"sig_data_offset"`
	Length               string   `protobuf:"bytes,5,opt,name=Length,proto3" json:"sig_data_length"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SignatureData) Reset()         { *m = SignatureData{} }
func (m *SignatureData) String() string { return proto.CompactTextString(m) }
func (*SignatureData) ProtoMessage()    {}
func (*SignatureData) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d17a9d3f0ddf27e, []int{5}
}
func (m *SignatureData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SignatureData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SignatureData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SignatureData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignatureData.Merge(m, src)
}
func (m *SignatureData) XXX_Size() int {
	return m.Size()
}
func (m *SignatureData) XXX_DiscardUnknown() {
	xxx_messageInfo_SignatureData.DiscardUnknown(m)
}

var xxx_messageInfo_SignatureData proto.InternalMessageInfo

func (m *SignatureData) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *SignatureData) GetBlockingMask() string {
	if m != nil {
		return m.BlockingMask
	}
	return ""
}

func (m *SignatureData) GetBuffer() string {
	if m != nil {
		return m.Buffer
	}
	return ""
}

func (m *SignatureData) GetOffset() string {
	if m != nil {
		return m.Offset
	}
	return ""
}

func (m *SignatureData) GetLength() string {
	if m != nil {
		return m.Length
	}
	return ""
}

type ContextData struct {
	Name                 string   `protobuf:"bytes,1,opt,name=Name,proto3" json:"parameter_data_name"`
	Value                string   `protobuf:"bytes,2,opt,name=Value,proto3" json:"parameter_data_value"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContextData) Reset()         { *m = ContextData{} }
func (m *ContextData) String() string { return proto.CompactTextString(m) }
func (*ContextData) ProtoMessage()    {}
func (*ContextData) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d17a9d3f0ddf27e, []int{6}
}
func (m *ContextData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContextData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContextData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContextData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContextData.Merge(m, src)
}
func (m *ContextData) XXX_Size() int {
	return m.Size()
}
func (m *ContextData) XXX_DiscardUnknown() {
	xxx_messageInfo_ContextData.DiscardUnknown(m)
}

var xxx_messageInfo_ContextData proto.InternalMessageInfo

func (m *ContextData) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ContextData) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type ViolationData struct {
	Name                 string           `protobuf:"bytes,1,opt,name=Name,proto3" json:"violation_data_name"`
	Context              string           `protobuf:"bytes,2,opt,name=Context,proto3" json:"violation_data_context"`
	ContextData          *ContextData     `protobuf:"bytes,3,opt,name=ContextData,proto3" json:"violation_data_context_data"`
	Signatures           []*SignatureData `protobuf:"bytes,4,rep,name=Signatures,proto3" json:"violation_data_signatures"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ViolationData) Reset()         { *m = ViolationData{} }
func (m *ViolationData) String() string { return proto.CompactTextString(m) }
func (*ViolationData) ProtoMessage()    {}
func (*ViolationData) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d17a9d3f0ddf27e, []int{7}
}
func (m *ViolationData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ViolationData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ViolationData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ViolationData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ViolationData.Merge(m, src)
}
func (m *ViolationData) XXX_Size() int {
	return m.Size()
}
func (m *ViolationData) XXX_DiscardUnknown() {
	xxx_messageInfo_ViolationData.DiscardUnknown(m)
}

var xxx_messageInfo_ViolationData proto.InternalMessageInfo

func (m *ViolationData) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ViolationData) GetContext() string {
	if m != nil {
		return m.Context
	}
	return ""
}

func (m *ViolationData) GetContextData() *ContextData {
	if m != nil {
		return m.ContextData
	}
	return nil
}

func (m *ViolationData) GetSignatures() []*SignatureData {
	if m != nil {
		return m.Signatures
	}
	return nil
}

func init() {
	proto.RegisterType((*Metadata)(nil), "f5.nginx.agent.sdk.events.Metadata")
	proto.RegisterType((*Event)(nil), "f5.nginx.agent.sdk.events.Event")
	proto.RegisterType((*EventReport)(nil), "f5.nginx.agent.sdk.events.EventReport")
	proto.RegisterType((*ActivityEvent)(nil), "f5.nginx.agent.sdk.events.ActivityEvent")
	proto.RegisterType((*SecurityViolationEvent)(nil), "f5.nginx.agent.sdk.events.SecurityViolationEvent")
	proto.RegisterType((*SignatureData)(nil), "f5.nginx.agent.sdk.events.SignatureData")
	proto.RegisterType((*ContextData)(nil), "f5.nginx.agent.sdk.events.ContextData")
	proto.RegisterType((*ViolationData)(nil), "f5.nginx.agent.sdk.events.ViolationData")
}

func init() { proto.RegisterFile("event.proto", fileDescriptor_2d17a9d3f0ddf27e) }

var fileDescriptor_2d17a9d3f0ddf27e = []byte{
	// 1647 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x57, 0xdd, 0x6e, 0xdc, 0xc6,
	0x15, 0xee, 0xca, 0xb2, 0x7e, 0x66, 0x25, 0xd9, 0x1e, 0x39, 0xf6, 0x48, 0x71, 0x44, 0x75, 0x9d,
	0xb8, 0x2a, 0x52, 0xec, 0xa2, 0x4a, 0x02, 0x14, 0x08, 0x10, 0xc0, 0xab, 0x75, 0x92, 0x45, 0x23,
	0x47, 0x98, 0x95, 0xd5, 0x22, 0x37, 0xc4, 0x88, 0x9c, 0xa5, 0x58, 0xed, 0x72, 0x58, 0xce, 0x70,
	0x6b, 0x3d, 0x42, 0x81, 0x3e, 0x57, 0x91, 0xcb, 0xdc, 0x17, 0x20, 0x0a, 0x5f, 0xf2, 0x05, 0x7a,
	0x5b, 0xcc, 0x99, 0x21, 0x87, 0xd4, 0x5f, 0xae, 0x6c, 0x9e, 0xef, 0xfb, 0xce, 0x99, 0x39, 0x3f,
	0xb3, 0x47, 0xa8, 0xcb, 0x17, 0x3c, 0x51, 0xfd, 0x34, 0x13, 0x4a, 0xe0, 0x9d, 0xe9, 0x57, 0xfd,
	0x24, 0x8a, 0x93, 0xf7, 0x7d, 0x16, 0x69, 0xab, 0x0c, 0x2f, 0xfb, 0x80, 0xcb, 0xdd, 0xed, 0x40,
	0xcc, 0xe7, 0x22, 0x19, 0x98, 0x7f, 0x0c, 0x7f, 0x17, 0x45, 0x22, 0x12, 0xf6, 0xff, 0x5e, 0x24,
	0x44, 0x34, 0xe3, 0x03, 0xf8, 0x3a, 0xcf, 0xa7, 0x03, 0x15, 0xcf, 0xb9, 0x54, 0x6c, 0x9e, 0x1a,
	0x42, 0xef, 0xe7, 0x25, 0xb4, 0x76, 0xcc, 0x15, 0x0b, 0x99, 0x62, 0xb8, 0x87, 0x56, 0x8e, 0x45,
	0x98, 0xcf, 0x38, 0xe9, 0xec, 0x77, 0x0e, 0xd6, 0x87, 0xa8, 0x2c, 0xbc, 0x95, 0x39, 0x58, 0xa8,
	0x45, 0xf0, 0x0b, 0xb4, 0xfc, 0xee, 0xdd, 0x78, 0x44, 0x96, 0x80, 0xb1, 0x56, 0x16, 0xde, 0x72,
	0x9e, 0xc7, 0x21, 0x05, 0x2b, 0xfe, 0x13, 0xda, 0x3c, 0x12, 0x59, 0xc6, 0x67, 0x4c, 0xc5, 0x22,
	0x19, 0x8f, 0xc8, 0x03, 0xa0, 0xe1, 0xb2, 0xf0, 0xb6, 0x02, 0x07, 0xf8, 0x71, 0x48, 0xdb, 0x44,
	0xfc, 0x1d, 0x5a, 0x3f, 0xad, 0xce, 0x46, 0x96, 0xf7, 0x3b, 0x07, 0xdd, 0xc3, 0xdd, 0xbe, 0x39,
	0x7d, 0xbf, 0x3a, 0x7d, 0xbf, 0x66, 0x0c, 0x37, 0xcb, 0xc2, 0x5b, 0xaf, 0x2f, 0x43, 0x9d, 0x16,
	0x0f, 0x10, 0x7a, 0xa3, 0xb3, 0xf3, 0x03, 0x5f, 0xf0, 0x19, 0x79, 0x08, 0xf1, 0x1f, 0x95, 0x85,
	0x67, 0x72, 0xea, 0xcf, 0xb4, 0x99, 0x36, 0x28, 0xfa, 0x46, 0xa7, 0x57, 0x29, 0x27, 0x2b, 0xee,
	0x46, 0xea, 0x2a, 0xe5, 0x14, 0xac, 0xf8, 0x00, 0xad, 0x1d, 0x31, 0xc5, 0x23, 0x91, 0x5d, 0x91,
	0x55, 0x60, 0x6c, 0x94, 0x85, 0xb7, 0x16, 0x58, 0x1b, 0xad, 0xd1, 0xde, 0x2f, 0x4b, 0xe8, 0x21,
	0xb8, 0xc5, 0xc7, 0x2e, 0xa7, 0x90, 0xc9, 0xee, 0xe1, 0xcb, 0xfe, 0x9d, 0x45, 0xec, 0x57, 0x54,
	0xe3, 0x78, 0x6e, 0xbf, 0xa8, 0x2b, 0x4b, 0x88, 0x36, 0x5f, 0x07, 0x2a, 0x5e, 0xc4, 0xea, 0x0a,
	0xfc, 0x43, 0xee, 0xbb, 0x87, 0x07, 0xf7, 0xf8, 0x6c, 0xf1, 0x4d, 0xfa, 0x99, 0x35, 0xf9, 0x40,
	0xf9, 0xfe, 0x37, 0xb4, 0xed, 0x14, 0xff, 0xb3, 0x83, 0x9e, 0x4d, 0x78, 0x90, 0x67, 0xb1, 0xba,
	0x3a, 0x8b, 0x85, 0x29, 0x8c, 0x89, 0xf7, 0x00, 0xe2, 0xfd, 0xf1, 0x9e, 0x78, 0xb7, 0x0b, 0x87,
	0x2f, 0xca, 0xc2, 0x23, 0xd2, 0x62, 0xfe, 0xa2, 0x02, 0xeb, 0x23, 0xdc, 0x11, 0x70, 0xb8, 0x82,
	0x96, 0xf5, 0xcd, 0x7b, 0x13, 0xd4, 0x05, 0x03, 0xe5, 0xa9, 0xc8, 0x14, 0x1e, 0xa1, 0x15, 0xf8,
	0x94, 0xa4, 0xb3, 0xff, 0xe0, 0xa0, 0x7b, 0xb8, 0x7f, 0xcf, 0x89, 0x8c, 0x23, 0xe8, 0x60, 0x63,
	0xa1, 0x56, 0xdb, 0xfb, 0x57, 0xe7, 0x5a, 0x3e, 0xf1, 0x67, 0x68, 0xf5, 0x98, 0x4b, 0xc9, 0xa2,
	0xaa, 0xf1, 0xbb, 0x65, 0xe1, 0xad, 0xce, 0x8d, 0x89, 0x56, 0x18, 0x3e, 0x45, 0x68, 0x14, 0xcf,
	0x79, 0x22, 0x63, 0x91, 0x48, 0xb2, 0x04, 0x47, 0xf8, 0xf4, 0xb6, 0x23, 0xd8, 0x71, 0xac, 0xc9,
	0xc3, 0xad, 0xb2, 0xf0, 0x50, 0x58, 0x6b, 0x69, 0xc3, 0x4f, 0xef, 0x3f, 0x4f, 0xee, 0xca, 0xbb,
	0x6e, 0xe5, 0x13, 0x31, 0x8b, 0x83, 0xab, 0xb7, 0x6c, 0x5e, 0x1d, 0x0d, 0x5a, 0x39, 0x05, 0xab,
	0x9f, 0xb0, 0x39, 0xa7, 0x0d, 0x0a, 0xfe, 0x03, 0x5a, 0x9f, 0xe4, 0xa9, 0xce, 0x55, 0x3d, 0xa1,
	0x10, 0x5a, 0x1a, 0xa3, 0x1e, 0x3b, 0x47, 0xd0, 0xd7, 0xfe, 0x31, 0x57, 0x81, 0x98, 0x73, 0x3b,
	0xa6, 0x70, 0x6d, 0x61, 0x4c, 0xb4, 0xc2, 0xf4, 0x4c, 0xdb, 0xff, 0x52, 0xce, 0xa4, 0x48, 0x60,
	0x3a, 0xed, 0x4c, 0x5b, 0xb2, 0x9f, 0x01, 0x42, 0xdb, 0x44, 0xfc, 0x17, 0xf4, 0x7c, 0x38, 0x13,
	0xc1, 0x65, 0x9c, 0x44, 0x6f, 0xde, 0x07, 0x3c, 0xd5, 0x37, 0xb3, 0x3e, 0xcc, 0x5c, 0x7e, 0x52,
	0x16, 0xde, 0xce, 0xb9, 0xa5, 0xf8, 0xbc, 0xe2, 0x54, 0xee, 0xee, 0x52, 0xc3, 0x43, 0xc5, 0xd5,
	0x85, 0x08, 0xed, 0xd0, 0x9a, 0x87, 0x0a, 0x2c, 0xd4, 0x22, 0x7a, 0x70, 0x4f, 0xf4, 0xbb, 0x11,
	0x88, 0x59, 0x73, 0x70, 0x53, 0x6b, 0xa3, 0x35, 0x8a, 0x4f, 0x10, 0xf9, 0xeb, 0xb7, 0x22, 0xfb,
	0x07, 0xcb, 0x42, 0x1e, 0x7e, 0x2b, 0xb2, 0xef, 0x39, 0x0b, 0x79, 0x76, 0xc6, 0x66, 0x39, 0x27,
	0x6b, 0xa0, 0x7c, 0x5a, 0x16, 0xde, 0xe3, 0xf7, 0xd3, 0xa9, 0x7f, 0x01, 0x90, 0xbf, 0xd0, 0x18,
	0xbd, 0x53, 0x85, 0x77, 0xd0, 0x83, 0x77, 0x74, 0x4c, 0xd6, 0x41, 0xbc, 0x5a, 0x16, 0xde, 0x83,
	0x3c, 0x8b, 0xa9, 0xb6, 0xe9, 0xa4, 0x53, 0xfe, 0xf7, 0x9c, 0x4b, 0x45, 0x90, 0x4b, 0x7a, 0x66,
	0x4c, 0xb4, 0xc2, 0xf0, 0x21, 0xea, 0x8e, 0xe5, 0x69, 0x96, 0x27, 0xfa, 0xa1, 0x09, 0x49, 0x17,
	0xa8, 0x8f, 0xcb, 0xc2, 0xdb, 0x88, 0xa5, 0xaf, 0x2a, 0x3b, 0x6d, 0x92, 0x74, 0xa1, 0xac, 0x7c,
	0xa2, 0x98, 0xca, 0x25, 0xd9, 0x70, 0x85, 0xb2, 0x01, 0x7c, 0x09, 0x08, 0x6d, 0x13, 0xf1, 0x57,
	0x68, 0x83, 0x72, 0x99, 0x8a, 0x44, 0xf2, 0x23, 0x11, 0x72, 0xb2, 0x09, 0xc2, 0x27, 0x65, 0xe1,
	0x6d, 0x66, 0xd6, 0xee, 0x07, 0x22, 0xe4, 0xb4, 0x45, 0xd3, 0xfd, 0x39, 0xe1, 0xd9, 0x82, 0x67,
	0xaf, 0xc3, 0x30, 0x23, 0x5b, 0xae, 0x3f, 0x25, 0x58, 0x7d, 0x16, 0x86, 0x19, 0x6d, 0x50, 0xf0,
	0x4b, 0xb4, 0x72, 0x36, 0x81, 0x66, 0x7e, 0xe4, 0xee, 0xbe, 0x90, 0xa6, 0x91, 0x2d, 0xa4, 0xbd,
	0x52, 0x3e, 0x17, 0x8a, 0x83, 0xd7, 0xc7, 0xce, 0x6b, 0x06, 0x56, 0xeb, 0xd5, 0x51, 0xf0, 0x97,
	0x95, 0xe0, 0x44, 0x64, 0x8a, 0x3c, 0x71, 0x15, 0x0b, 0xb9, 0x54, 0x71, 0x62, 0x9e, 0x1c, 0xdd,
	0xf3, 0xb4, 0xc1, 0x73, 0x87, 0x07, 0x15, 0xbe, 0x71, 0x78, 0x23, 0x70, 0x14, 0xdc, 0x47, 0xa8,
	0x9e, 0x4f, 0x49, 0xb6, 0xdd, 0x74, 0xd5, 0xef, 0x9a, 0xa4, 0x0d, 0x86, 0x2e, 0xc7, 0x24, 0x3f,
	0x6f, 0x48, 0x9e, 0xba, 0x72, 0xc8, 0xfc, 0xdc, 0x6f, 0xc8, 0xda, 0x44, 0xfc, 0x0d, 0x7a, 0x54,
	0x7f, 0x51, 0xa6, 0xe2, 0x24, 0x22, 0x1f, 0xb9, 0x5b, 0xb9, 0x67, 0x34, 0x03, 0x8c, 0x5e, 0x27,
	0xe3, 0x2f, 0x50, 0x77, 0x12, 0x47, 0x13, 0xae, 0x74, 0x3e, 0x25, 0x79, 0xe6, 0xaa, 0x29, 0xe3,
	0xc8, 0x97, 0x5c, 0x41, 0xc2, 0x25, 0x6d, 0xb2, 0xf0, 0x2b, 0xb4, 0x3a, 0x89, 0xa3, 0xa3, 0xb3,
	0x37, 0x92, 0x3c, 0x77, 0xe3, 0xa2, 0x05, 0xc1, 0x82, 0x4b, 0x5a, 0x81, 0xba, 0x33, 0x8f, 0x66,
	0x31, 0x4f, 0xd4, 0xd1, 0x8c, 0x49, 0x49, 0x88, 0xeb, 0xcc, 0x00, 0xcc, 0x7e, 0xa0, 0xed, 0xb4,
	0x49, 0xc2, 0x23, 0xf4, 0xc4, 0x7c, 0xbe, 0x4e, 0xd3, 0x59, 0x1c, 0xc0, 0x59, 0xc9, 0x0e, 0x28,
	0x9f, 0x95, 0x85, 0x87, 0xad, 0x92, 0x39, 0x94, 0xde, 0x14, 0xe0, 0x9f, 0x10, 0xb9, 0x61, 0x3c,
	0xe3, 0x99, 0x7e, 0x46, 0xc9, 0x2e, 0x38, 0xdb, 0x2b, 0x0b, 0x6f, 0xf7, 0xa6, 0x33, 0x7f, 0x61,
	0x58, 0xf4, 0x4e, 0xbd, 0x7e, 0x2d, 0x26, 0x7c, 0xc1, 0xf5, 0x23, 0x4c, 0x3e, 0x6e, 0x5c, 0xdf,
	0xda, 0x68, 0x8d, 0xe2, 0x3f, 0xa3, 0xed, 0xd3, 0x8b, 0x8c, 0x33, 0x75, 0xc4, 0xe6, 0x29, 0x8b,
	0xa3, 0xc4, 0x24, 0xf9, 0x05, 0x88, 0x76, 0xca, 0xc2, 0xfb, 0x48, 0x01, 0xec, 0x07, 0x16, 0xb7,
	0xc9, 0xbe, 0x4d, 0xa5, 0x07, 0x6f, 0x28, 0xd4, 0xeb, 0x44, 0xcc, 0xd9, 0x2c, 0xe6, 0x92, 0x7c,
	0xe2, 0x4a, 0x75, 0x2e, 0x94, 0xcf, 0x2a, 0x80, 0xb6, 0x68, 0xba, 0x06, 0x43, 0xa1, 0xea, 0xbd,
	0x64, 0xcf, 0xd5, 0x40, 0xab, 0xea, 0xdd, 0xa4, 0x49, 0xc2, 0x6f, 0xd1, 0xd3, 0x37, 0xc9, 0x54,
	0x64, 0x01, 0x0f, 0x5b, 0x21, 0x3d, 0x10, 0xef, 0x96, 0x85, 0xf7, 0x8c, 0x5b, 0xdc, 0x6f, 0xc7,
	0xbe, 0x55, 0x87, 0x87, 0xe8, 0xf1, 0x50, 0xa8, 0x49, 0x1c, 0x25, 0x4c, 0xe5, 0x19, 0x87, 0xa9,
	0xde, 0x77, 0x25, 0xd5, 0x2e, 0x64, 0x05, 0x9a, 0x01, 0xbf, 0xc1, 0xd7, 0x7d, 0x51, 0xf7, 0xee,
	0x91, 0x48, 0x14, 0x7f, 0xaf, 0x24, 0xf9, 0xad, 0x73, 0xe2, 0x5a, 0x3d, 0xb0, 0x28, 0xbd, 0x29,
	0xc0, 0x1c, 0x6d, 0xb9, 0xe1, 0x19, 0xe9, 0xa5, 0xab, 0x07, 0xbf, 0xcd, 0xf7, 0x2d, 0x48, 0xb5,
	0x40, 0xf3, 0x87, 0xdb, 0x65, 0xe1, 0x3d, 0x72, 0xf3, 0xe8, 0xc3, 0x02, 0x76, 0xcd, 0x29, 0xfe,
	0x3d, 0x5a, 0x9b, 0x5c, 0x49, 0xc5, 0xe7, 0xe3, 0x11, 0x79, 0x09, 0x67, 0x84, 0x25, 0x54, 0x82,
	0x4d, 0xff, 0xb4, 0xd6, 0xb0, 0x2e, 0xeb, 0x38, 0x91, 0x8a, 0x25, 0x01, 0x3f, 0x65, 0x91, 0x24,
	0x9f, 0xba, 0xb2, 0xc6, 0xd6, 0xee, 0x2b, 0x16, 0x49, 0xda, 0xa2, 0xe9, 0x17, 0xa3, 0xfa, 0xfe,
	0x2e, 0x13, 0x79, 0x4a, 0x3e, 0x73, 0x2f, 0x46, 0xad, 0x8b, 0x34, 0x42, 0xdb, 0x44, 0xdd, 0x10,
	0xa3, 0x58, 0xa6, 0x33, 0x66, 0x56, 0x85, 0x57, 0xae, 0x21, 0x42, 0x63, 0x36, 0x15, 0x68, 0x92,
	0xf4, 0xc0, 0xbf, 0xd5, 0xc9, 0x19, 0x8f, 0xc8, 0xef, 0x5c, 0xc7, 0x43, 0xbe, 0xf4, 0x6d, 0x2a,
	0x10, 0x7f, 0x8d, 0xb6, 0x4e, 0x58, 0xa6, 0x17, 0x36, 0x21, 0x95, 0x76, 0x43, 0x0e, 0x80, 0x0e,
	0x49, 0x4b, 0x01, 0xf1, 0x2f, 0x2c, 0x44, 0xaf, 0x51, 0x7b, 0xff, 0xeb, 0xa0, 0xcd, 0xba, 0xe6,
	0x90, 0x46, 0x0f, 0x2d, 0x8d, 0x47, 0xcd, 0x65, 0x46, 0x3f, 0x31, 0x3a, 0xe1, 0x3a, 0xe8, 0xd2,
	0x78, 0x84, 0xbf, 0x41, 0x1b, 0xd5, 0xef, 0xfe, 0x31, 0x93, 0x97, 0x76, 0x8f, 0x81, 0x06, 0xad,
	0xa9, 0xf5, 0xce, 0x30, 0x67, 0xf2, 0x92, 0xb6, 0xf8, 0xf8, 0x73, 0xb4, 0x32, 0xcc, 0xa7, 0x53,
	0x9e, 0xd9, 0xad, 0x06, 0xce, 0xe9, 0x94, 0x00, 0x51, 0x4b, 0xd1, 0xe4, 0x1f, 0xa7, 0x53, 0xc9,
	0x95, 0xdd, 0x6a, 0xda, 0x64, 0x01, 0x10, 0xb5, 0x14, 0x4d, 0xfe, 0x81, 0x27, 0x91, 0xba, 0xb0,
	0xeb, 0x4b, 0x9b, 0x3c, 0x03, 0x88, 0x5a, 0x4a, 0xef, 0x6f, 0xa8, 0x6b, 0x3b, 0x14, 0xae, 0xfd,
	0x39, 0x5a, 0x6e, 0x6c, 0x71, 0xcf, 0xcb, 0xc2, 0xdb, 0x4e, 0x59, 0xc6, 0xe6, 0x5c, 0xf1, 0xcc,
	0xe8, 0x21, 0x7f, 0x40, 0xc2, 0x7d, 0xf4, 0xd0, 0xac, 0x1f, 0xe6, 0xee, 0xa4, 0x2c, 0xbc, 0xa7,
	0xd7, 0xd8, 0x66, 0x05, 0x31, 0xb4, 0xde, 0xbf, 0x97, 0xd0, 0x66, 0xab, 0xa3, 0x6f, 0x0b, 0xe7,
	0x86, 0xe9, 0x7a, 0xb8, 0x2f, 0xd1, 0xaa, 0x3d, 0x6a, 0x33, 0xd9, 0xd7, 0xf8, 0x76, 0x02, 0x69,
	0x45, 0xc5, 0x71, 0xeb, 0x82, 0xf6, 0x8f, 0x84, 0x57, 0xf7, 0xcc, 0x5c, 0x83, 0x3d, 0xf4, 0xca,
	0xc2, 0xfb, 0xf8, 0xf6, 0x08, 0x66, 0xfa, 0x5a, 0xc9, 0x8b, 0x10, 0xaa, 0x9b, 0x48, 0x92, 0xe5,
	0x5f, 0x9d, 0xee, 0x56, 0xc7, 0x99, 0x2d, 0xf3, 0x5a, 0xac, 0xfa, 0x69, 0x92, 0xb4, 0xe1, 0x7a,
	0x48, 0x7f, 0xfe, 0xb0, 0xd7, 0xf9, 0xe5, 0xc3, 0x5e, 0xe7, 0xbf, 0x1f, 0xf6, 0x3a, 0x3f, 0x8d,
	0xa2, 0x58, 0x5d, 0xe4, 0xe7, 0x7a, 0x9f, 0x1f, 0x40, 0xa4, 0x01, 0x44, 0x1a, 0xc8, 0xf0, 0x72,
	0xb0, 0x38, 0x34, 0x7f, 0x54, 0x0f, 0x4c, 0xc8, 0xaf, 0xef, 0x3c, 0xcc, 0xf9, 0x0a, 0xf0, 0xbe,
	0xf8, 0x7f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa3, 0xb3, 0x5c, 0xb5, 0xd5, 0x0f, 0x00, 0x00,
}

func (m *Metadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Metadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Category) > 0 {
		i -= len(m.Category)
		copy(dAtA[i:], m.Category)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Category)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.EventLevel) > 0 {
		i -= len(m.EventLevel)
		copy(dAtA[i:], m.EventLevel)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.EventLevel)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Timestamp != nil {
		{
			size, err := m.Timestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.CorrelationID) > 0 {
		i -= len(m.CorrelationID)
		copy(dAtA[i:], m.CorrelationID)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.CorrelationID)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.UUID) > 0 {
		i -= len(m.UUID)
		copy(dAtA[i:], m.UUID)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.UUID)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Module) > 0 {
		i -= len(m.Module)
		copy(dAtA[i:], m.Module)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Module)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Event) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Data != nil {
		{
			size := m.Data.Size()
			i -= size
			if _, err := m.Data.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Event_ActivityEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Event_ActivityEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ActivityEvent != nil {
		{
			size, err := m.ActivityEvent.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Event_SecurityViolationEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Event_SecurityViolationEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.SecurityViolationEvent != nil {
		{
			size, err := m.SecurityViolationEvent.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *EventReport) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventReport) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EventReport) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Events) > 0 {
		for iNdEx := len(m.Events) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Events[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintEvent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ActivityEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ActivityEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ActivityEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Dimensions) > 0 {
		for iNdEx := len(m.Dimensions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Dimensions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintEvent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SecurityViolationEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecurityViolationEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SecurityViolationEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ParentHostname) > 0 {
		i -= len(m.ParentHostname)
		copy(dAtA[i:], m.ParentHostname)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.ParentHostname)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xc2
	}
	if len(m.NginxID) > 0 {
		i -= len(m.NginxID)
		copy(dAtA[i:], m.NginxID)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.NginxID)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xba
	}
	if len(m.DisplayName) > 0 {
		i -= len(m.DisplayName)
		copy(dAtA[i:], m.DisplayName)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.DisplayName)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xb2
	}
	if len(m.InstanceGroup) > 0 {
		i -= len(m.InstanceGroup)
		copy(dAtA[i:], m.InstanceGroup)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.InstanceGroup)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xaa
	}
	if len(m.InstanceTags) > 0 {
		i -= len(m.InstanceTags)
		copy(dAtA[i:], m.InstanceTags)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.InstanceTags)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xa2
	}
	if len(m.SystemID) > 0 {
		i -= len(m.SystemID)
		copy(dAtA[i:], m.SystemID)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.SystemID)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x9a
	}
	if len(m.ViolationsData) > 0 {
		for iNdEx := len(m.ViolationsData) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ViolationsData[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintEvent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x92
		}
	}
	if len(m.ViolationContexts) > 0 {
		i -= len(m.ViolationContexts)
		copy(dAtA[i:], m.ViolationContexts)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.ViolationContexts)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x8a
	}
	if len(m.BotSignatureName) > 0 {
		i -= len(m.BotSignatureName)
		copy(dAtA[i:], m.BotSignatureName)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.BotSignatureName)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x82
	}
	if len(m.EnforcedBotAnomalies) > 0 {
		i -= len(m.EnforcedBotAnomalies)
		copy(dAtA[i:], m.EnforcedBotAnomalies)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.EnforcedBotAnomalies)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xfa
	}
	if len(m.BotCategory) > 0 {
		i -= len(m.BotCategory)
		copy(dAtA[i:], m.BotCategory)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.BotCategory)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf2
	}
	if len(m.BotAnomalies) > 0 {
		i -= len(m.BotAnomalies)
		copy(dAtA[i:], m.BotAnomalies)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.BotAnomalies)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xea
	}
	if len(m.ThreatCampaignNames) > 0 {
		i -= len(m.ThreatCampaignNames)
		copy(dAtA[i:], m.ThreatCampaignNames)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.ThreatCampaignNames)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe2
	}
	if len(m.Severity) > 0 {
		i -= len(m.Severity)
		copy(dAtA[i:], m.Severity)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Severity)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xda
	}
	if len(m.ClientApplicationVersion) > 0 {
		i -= len(m.ClientApplicationVersion)
		copy(dAtA[i:], m.ClientApplicationVersion)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.ClientApplicationVersion)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd2
	}
	if len(m.ClientApplication) > 0 {
		i -= len(m.ClientApplication)
		copy(dAtA[i:], m.ClientApplication)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.ClientApplication)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xca
	}
	if len(m.ClientClass) > 0 {
		i -= len(m.ClientClass)
		copy(dAtA[i:], m.ClientClass)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.ClientClass)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc2
	}
	if len(m.SigCVEs) > 0 {
		i -= len(m.SigCVEs)
		copy(dAtA[i:], m.SigCVEs)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.SigCVEs)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xba
	}
	if len(m.SigSetNames) > 0 {
		i -= len(m.SigSetNames)
		copy(dAtA[i:], m.SigSetNames)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.SigSetNames)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if len(m.ViolationRating) > 0 {
		i -= len(m.ViolationRating)
		copy(dAtA[i:], m.ViolationRating)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.ViolationRating)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if len(m.SubViolations) > 0 {
		i -= len(m.SubViolations)
		copy(dAtA[i:], m.SubViolations)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.SubViolations)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if len(m.Violations) > 0 {
		i -= len(m.Violations)
		copy(dAtA[i:], m.Violations)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Violations)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if len(m.ServerPort) > 0 {
		i -= len(m.ServerPort)
		copy(dAtA[i:], m.ServerPort)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.ServerPort)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if len(m.RemotePort) > 0 {
		i -= len(m.RemotePort)
		copy(dAtA[i:], m.RemotePort)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.RemotePort)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if len(m.RemoteAddr) > 0 {
		i -= len(m.RemoteAddr)
		copy(dAtA[i:], m.RemoteAddr)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.RemoteAddr)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if len(m.VSName) > 0 {
		i -= len(m.VSName)
		copy(dAtA[i:], m.VSName)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.VSName)))
		i--
		dAtA[i] = 0x7a
	}
	if len(m.ServerAddr) > 0 {
		i -= len(m.ServerAddr)
		copy(dAtA[i:], m.ServerAddr)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.ServerAddr)))
		i--
		dAtA[i] = 0x72
	}
	if len(m.ResponseCode) > 0 {
		i -= len(m.ResponseCode)
		copy(dAtA[i:], m.ResponseCode)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.ResponseCode)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.RequestStatus) > 0 {
		i -= len(m.RequestStatus)
		copy(dAtA[i:], m.RequestStatus)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.RequestStatus)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.IsTruncated) > 0 {
		i -= len(m.IsTruncated)
		copy(dAtA[i:], m.IsTruncated)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.IsTruncated)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Request) > 0 {
		i -= len(m.Request)
		copy(dAtA[i:], m.Request)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Request)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.URI) > 0 {
		i -= len(m.URI)
		copy(dAtA[i:], m.URI)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.URI)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.XForwardedForHeaderValue) > 0 {
		i -= len(m.XForwardedForHeaderValue)
		copy(dAtA[i:], m.XForwardedForHeaderValue)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.XForwardedForHeaderValue)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Method) > 0 {
		i -= len(m.Method)
		copy(dAtA[i:], m.Method)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Method)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.BlockingExceptionReason) > 0 {
		i -= len(m.BlockingExceptionReason)
		copy(dAtA[i:], m.BlockingExceptionReason)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.BlockingExceptionReason)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.OutcomeReason) > 0 {
		i -= len(m.OutcomeReason)
		copy(dAtA[i:], m.OutcomeReason)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.OutcomeReason)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Outcome) > 0 {
		i -= len(m.Outcome)
		copy(dAtA[i:], m.Outcome)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Outcome)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.SupportID) > 0 {
		i -= len(m.SupportID)
		copy(dAtA[i:], m.SupportID)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.SupportID)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.PolicyName) > 0 {
		i -= len(m.PolicyName)
		copy(dAtA[i:], m.PolicyName)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.PolicyName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SignatureData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SignatureData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SignatureData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Length) > 0 {
		i -= len(m.Length)
		copy(dAtA[i:], m.Length)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Length)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Offset) > 0 {
		i -= len(m.Offset)
		copy(dAtA[i:], m.Offset)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Offset)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Buffer) > 0 {
		i -= len(m.Buffer)
		copy(dAtA[i:], m.Buffer)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Buffer)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.BlockingMask) > 0 {
		i -= len(m.BlockingMask)
		copy(dAtA[i:], m.BlockingMask)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.BlockingMask)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ID) > 0 {
		i -= len(m.ID)
		copy(dAtA[i:], m.ID)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.ID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContextData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContextData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContextData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ViolationData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ViolationData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ViolationData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Signatures) > 0 {
		for iNdEx := len(m.Signatures) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Signatures[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintEvent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.ContextData != nil {
		{
			size, err := m.ContextData.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Context) > 0 {
		i -= len(m.Context)
		copy(dAtA[i:], m.Context)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Context)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintEvent(dAtA []byte, offset int, v uint64) int {
	offset -= sovEvent(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Metadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Module)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.UUID)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.CorrelationID)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.EventLevel)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.Category)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Event) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovEvent(uint64(l))
	}
	if m.Data != nil {
		n += m.Data.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Event_ActivityEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ActivityEvent != nil {
		l = m.ActivityEvent.Size()
		n += 1 + l + sovEvent(uint64(l))
	}
	return n
}
func (m *Event_SecurityViolationEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SecurityViolationEvent != nil {
		l = m.SecurityViolationEvent.Size()
		n += 1 + l + sovEvent(uint64(l))
	}
	return n
}
func (m *EventReport) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovEvent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ActivityEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	if len(m.Dimensions) > 0 {
		for _, e := range m.Dimensions {
			l = e.Size()
			n += 1 + l + sovEvent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SecurityViolationEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PolicyName)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.SupportID)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.Outcome)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.OutcomeReason)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.BlockingExceptionReason)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.Method)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.Protocol)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.XForwardedForHeaderValue)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.URI)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.Request)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.IsTruncated)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.RequestStatus)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.ResponseCode)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.ServerAddr)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.VSName)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.RemoteAddr)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.RemotePort)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.ServerPort)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.Violations)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.SubViolations)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.ViolationRating)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.SigSetNames)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.SigCVEs)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.ClientClass)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.ClientApplication)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.ClientApplicationVersion)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.Severity)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.ThreatCampaignNames)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.BotAnomalies)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.BotCategory)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.EnforcedBotAnomalies)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.BotSignatureName)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.ViolationContexts)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	if len(m.ViolationsData) > 0 {
		for _, e := range m.ViolationsData {
			l = e.Size()
			n += 2 + l + sovEvent(uint64(l))
		}
	}
	l = len(m.SystemID)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.InstanceTags)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.InstanceGroup)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.DisplayName)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.NginxID)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	l = len(m.ParentHostname)
	if l > 0 {
		n += 2 + l + sovEvent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SignatureData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.BlockingMask)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.Buffer)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.Offset)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.Length)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContextData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ViolationData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	l = len(m.Context)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	if m.ContextData != nil {
		l = m.ContextData.Size()
		n += 1 + l + sovEvent(uint64(l))
	}
	if len(m.Signatures) > 0 {
		for _, e := range m.Signatures {
			l = e.Size()
			n += 1 + l + sovEvent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovEvent(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozEvent(x uint64) (n int) {
	return sovEvent(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Metadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Metadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Metadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Module", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Module = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UUID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UUID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CorrelationID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CorrelationID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &types.Timestamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventLevel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EventLevel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Category", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Category = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &Metadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActivityEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ActivityEvent{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Event_ActivityEvent{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecurityViolationEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SecurityViolationEvent{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Event_SecurityViolationEvent{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventReport) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventReport: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventReport: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, &Event{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ActivityEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ActivityEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ActivityEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Dimensions = append(m.Dimensions, &common.Dimension{})
			if err := m.Dimensions[len(m.Dimensions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SecurityViolationEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SecurityViolationEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SecurityViolationEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SupportID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Outcome", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Outcome = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutcomeReason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OutcomeReason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockingExceptionReason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BlockingExceptionReason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Method = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Protocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field XForwardedForHeaderValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.XForwardedForHeaderValue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field URI", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.URI = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Request = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsTruncated", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IsTruncated = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestStatus", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestStatus = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseCode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseCode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VSName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VSName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoteAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemotePort", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemotePort = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerPort", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerPort = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Violations", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Violations = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubViolations", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubViolations = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ViolationRating", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ViolationRating = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SigSetNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SigSetNames = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SigCVEs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SigCVEs = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientClass = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientApplication", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientApplication = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientApplicationVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientApplicationVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Severity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ThreatCampaignNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ThreatCampaignNames = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BotAnomalies", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BotAnomalies = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BotCategory", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BotCategory = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnforcedBotAnomalies", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EnforcedBotAnomalies = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BotSignatureName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BotSignatureName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ViolationContexts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ViolationContexts = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ViolationsData", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ViolationsData = append(m.ViolationsData, &ViolationData{})
			if err := m.ViolationsData[len(m.ViolationsData)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SystemID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstanceTags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InstanceTags = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstanceGroup", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InstanceGroup = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 38:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisplayName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DisplayName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 39:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NginxID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NginxID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 40:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentHostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentHostname = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SignatureData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SignatureData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SignatureData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockingMask", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BlockingMask = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Buffer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Buffer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Offset = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Length", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Length = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContextData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContextData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContextData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ViolationData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ViolationData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ViolationData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Context = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContextData", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContextData == nil {
				m.ContextData = &ContextData{}
			}
			if err := m.ContextData.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Signatures", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Signatures = append(m.Signatures, &SignatureData{})
			if err := m.Signatures[len(m.Signatures)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipEvent(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowEvent
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthEvent
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupEvent
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthEvent
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthEvent        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowEvent          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupEvent = fmt.Errorf("proto: unexpected end of group")
)
