# Use Cases

The tw-did project offers a decentralized identity that brings several benefits. Users can manage their own decentralized identities, while Verifiable Credentials provide information endorsed by the issuer, which is linked to these user-managed identities. Users can choose their form of decentralized identity, like Ethereum's key pairs, and use the tw-did issued certificates to verify their claims.

There are two types of Verifiable Credentials provided: Ethereum Address and Semaphore Identity. Let's look at their use cases.

## Ethereum Address

The Ethereum Address credential is tied to a user's Ethereum Address. This is particularly useful for cryptocurrency exchanges that need to confirm not only the user's Taiwanese residency but also the link between a Taiwanese resident and a specific Ethereum address. By verifying the credential and confirming tw-did as the issuer, exchanges can be assured that tw-did has authenticated the user's Taiwanese residency using TW FidO and the Ethereum address associated with them.

## Semaphore Identity

After verifying their Taiwanese residency using TW FidO, users are added to a Semaphore group. They can then prove their Taiwanese residency without revealing any personal details.

For example, this verification can be used for anonymous national online surveys, such as national identity survey or political party support survey. Users can confirm they are Taiwanese residents, and the system ensures they can't vote more than once on a single topic.

Another use case is for digital content subscription services that offer different pricing and content in multiple countries. The service can use this method to confirm if the user is a resident of a specific country, ensuring they have access to the correct pricing and content, all without needing to collect any personal data.

If tw-did can acquire and verify more information, we can offer even more versatile methods. For example, if we could integrate data from the Ministry of the Interior, we could create groups based on a user's city of residence. Then, when purchasing transit cards online, if a city offers a discount for its residents, those residents could prove their eligibility without revealing any private information.
