---
layout: default
---

## Centralized Logging

Semantic Logger directly supports a centralized logging system consisting of:

* Semantic Logger
* Elasticsearch
    * Distributed, scalable, and highly available data store
* Kibana
    * Analytics and search dashboard for Elasticsearch

### Installation

For simplicity these installation notes use [homebrew](http://brew.sh) on Mac OSX.
Following the product links for information on installing on other platforms.

#### Elasticsearch

Install [Elasticsearch](https://www.elastic.co/downloads/elasticsearch):

```
brew install elasticsearch
```

Follow the on-screen instructions to auto-start elasticsearch.

#### Kibana

Install [Kibana](https://www.elastic.co/downloads/kibana):

```
brew install kibana
```

Follow the on-screen instructions to auto-start kibana.

#### Semantic Logger

Configure the application to forward all log messages to Elasticsearch.

Add the following code to a Rails initializer if running rails with the `rails_semantic_logger` gem,
or add the code directly to your application:

~~~ruby
SemanticLogger.add_appender(
  appender: :elasticsearch,
  url:      'http://localhost:9200'
)
~~~

Restart the application and let it run to generate several log messages.

Check the text file for any errors. For example: `log/development.log`

#### Configure Kibana

Assuming Kibana was installed locally with its default port.
Open a browser for Kibana [http://localhost:5601/](http://localhost:5601/).

Add a new index pattern to view in Kibana:

Select `Settings` -> `Indices` -> `Add New`

Select checkbox `Index contains time-based events`.

Enter Index name: `semantic_logger-*`

Give Kibana a moment to scan the index, then select `Time-field name` and choose `timestamp`,
then press the `Create` button.

#### View logs in browser

If not already open, open Kibana in the browser [http://localhost:5601/](http://localhost:5601/).

Select `Discover`.

The log entries generated by the application should now be displayed. If not, change the time interval
on the top right of the screen.

On the left under `Available Fields` add the following columns to the view:

* host
* level
* name
* message

### Example Searches

Some example searches:

Only show `error` level messages:

```
level: error
```

Only show messages from host `mymachine`

```
host: mymachine
```

Search logging tags for the string `17262353`

```
tags: 17262353
```

### Other solutions

Semantic Logger also supports several other centralized logging solutions:

* Logstash
* Graylog
* Splunk
* Loggly
* Syslog

See [appenders](appenders.html) to configure appenders to forward log messages to the centralized logging solutions / log aggregrators.

### [Next: Programmers Guide ==>](api.html)
