### Environment

Provide at least:
* Ruby Version.
* Semantic Logger Version.
* Application/framework names and versions (e.g. Rails, Sinatra, Puma, etc.).
* Rails Semantic Logger Version, if applicable.
* Rails configuration. Only need the settings related to Rails Semantic Logger and Semantic Logger.
* Full Stack Trace, if an exception is being raised.

Note:
* If the issue is with extensions to Rails to make it use Semantic Logger, please report the issue at [Rails Semantic Logger](https://github.com/rocketjob/rails_semantic_logger/issues).
* All appender issues should be reported here.

### Expected Behavior

* Describe your expectation of how Semantic Logger should behave, perhaps by showing how the builtin Ruby logger behaves.
* Provide a standalone Ruby script or a link to an example repository that helps reproduce the issue.

### Actual Behavior

* Describe or show the actual behavior.
* Provide text or screen capture showing the behavior.

### Even Better

* Consider submitting a Pull Request with a fix for the issue.
    * This is particularly helpful for appender changes/fixes since we don't have access to some appenders.
