<?php
/**
 * Mageplaza
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the mageplaza.com license that is
 * available through the world-wide-web at this URL:
 * https://mageplaza.com/LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Mageplaza
 * @package     Mageplaza_Smtp
 * @copyright   Copyright (c) 2017 Mageplaza (https://www.mageplaza.com/)
 * @license     http://mageplaza.com/LICENSE.txt
 */

namespace Mageplaza\Smtp\Controller\Adminhtml\Index;

/**
 * Class View
 * @package Mageplaza\Smtp\Controller\Adminhtml\Index
 */
class View extends \Magento\Backend\App\Action
{
	/**
	 * Authorization level of a basic admin session
	 *
	 * @see _isAllowed()
	 */
	const ADMIN_RESOURCE = 'Mageplaza_Smtp::smtp';

	/**
	 * @var \Magento\Framework\View\Result\PageFactory
	 */
	private $resultPageFactory;

	/**
	 * Constructor
	 *
	 * @param \Magento\Backend\App\Action\Context $context
	 * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
	 */
	public function __construct(
		\Magento\Backend\App\Action\Context $context,
		\Magento\Framework\View\Result\PageFactory $resultPageFactory
	)
	{
		$this->resultPageFactory = $resultPageFactory;
		parent::__construct($context);
	}

	/**
	 * @return \Magento\Framework\View\Result\Page
	 */
	public function execute()
	{
		$resultPage = $this->resultPageFactory->create();
		$resultPage->getLayout();
		$resultPage->setActiveMenu('Mageplaza_Smtp::log');
		//Add bread crumb
		$resultPage->addBreadcrumb(__('Mageplaza'), __('Mageplaza'));
		$resultPage->addBreadcrumb(__('Smtp'), __('Emails Log'));
		$resultPage->addContent(
			$resultPage->getLayout()->createBlock('Mageplaza\Smtp\Block\Adminhtml\View\Email')
		);
		$resultPage->getConfig()->getTitle()->prepend(__('Email'));

		return $resultPage;
	}
}
