// Copyright (c) Aptos
// SPDX-License-Identifier: Apache-2.0

use super::*;
use proptest::prelude::*;
use schemadb::{schema::fuzzing::assert_encode_decode, test_no_panic_decoding};

proptest! {
    #[test]
    fn test_encode_decode(counters in any::<LedgerCounters>()) {
        assert_encode_decode::<LedgerCountersSchema>(&0, &counters);
    }
}

test_no_panic_decoding!(LedgerCountersSchema);
