# Contributing

This file is intended to be a guide for those interested in contributing to FL Chart.

## Getting Started

Make sure you have Flutter installed and on your path.

Follow these steps to clone FL Chart and set up the development environment:

1. Clone the project: `git clone https://github.com/imaNNeoFighT/fl_chart.git`

2. Go into the cloned directory: `cd fl_chart`

3. Install all packages: `flutter packages get`

## Before Modifying the Code

If the work you intend to do is non-trivial, it is necessary to open
an issue before starting writing your code. This helps us and the
community to discuss the issue and choose what is deemed to be the
best solution.

## Checking Your Code's Quality

After you have made your changes, you have to make sure your code works
correctly and meets our guidelines. Our guidelines are:

- Make sure the code passes the tests. To run tests, run `flutter test`.

- Make sure to run `flutter analyze` and resolve any warnings or errors.

- The code should be formatted correctly. For Visual Studio Code users, this is
  automatically enforced. Otherwise, you can run this command inside the
  project from the command line: `flutter format --line-length 100 .`.

## Creating a Pull Request

Congratulations! Your code works meets our guidelines :100:. Now you have to
submit a pull request (or PR for short) to us. These are the steps you should
follow when creating a PR:

- Make a descriptive title that summarizes what changes were in the PR.

- Link to issues that this PR will fix (if any).

- If your PR adds a feature or fixes a bug, it must add one or more tests.

- Change your code according to feedback (if any).

After you follow the above steps, your PR will be hopefully be merged. Thanks
for contributing!
