require 'spec_helper'

describe 'logstash::input::udp', :type => 'define' do

  let(:facts) { {:operatingsystem => 'CentOS' }}
  let(:pre_condition) { 'class {"logstash": }'}
  let(:title) { 'test' }

  context "Input test" do

    let :params do {
      :add_field => { 'field1' => 'value1' },
      :buffer_size => 2,
      :charset => 'ASCII-8BIT',
      :debug => false,
      :format => 'plain',
      :host => 'value6',
      :message_format => 'value7',
      :port => 8,
      :tags => ['value9'],
      :type => 'value10',
    } end

    it { should contain_file('/etc/logstash/agent/config/input_udp_test').with(:content => "input {\n udp {\n  add_field => [\"field1\", \"value1\"]\n  buffer_size => 2\n  charset => \"ASCII-8BIT\"\n  debug => false\n  format => \"plain\"\n  host => \"value6\"\n  message_format => \"value7\"\n  port => 8\n  tags => ['value9']\n  type => \"value10\"\n }\n}\n") }
  end

  context "Instance test" do

    let :params do {
      :add_field => { 'field1' => 'value1' },
      :buffer_size => 2,
      :charset => 'ASCII-8BIT',
      :debug => false,
      :format => 'plain',
      :host => 'value6',
      :message_format => 'value7',
      :port => 8,
      :tags => ['value9'],
      :type => 'value10',
      :instances => [ 'agent1', 'agent2' ]
    } end
  
    it { should contain_file('/etc/logstash/agent1/config/input_udp_test') }
    it { should contain_file('/etc/logstash/agent2/config/input_udp_test') }

  end

end
