// Copyright (c) 2003-2012, Jodd Team (jodd.org). All Rights Reserved.

/* The following code was generated by JFlex 1.4.3 on 12/25/11 1:43 AM */

package jodd.lagarto.csselly;

import java.util.LinkedList;
import java.nio.CharBuffer;

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 12/25/11 1:43 AM from the specification file
 * <tt>csselly.flex</tt>
 */
final class CSSellyLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 4096;

  /** lexical states */
  public static final int COMBINATOR = 6;
  public static final int YYINITIAL = 0;
  public static final int ATTR = 4;
  public static final int SELECTOR = 2;
  public static final int PSEUDO_FN = 8;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4, 4
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\2\1\10\1\7\1\2\1\11\1\6\22\2\1\10\1\2\1\13"+
    "\1\17\1\24\2\2\1\14\1\21\1\30\1\15\1\27\1\2\1\1"+
    "\1\12\1\2\12\5\1\20\2\2\1\22\1\26\2\2\32\0\1\16"+
    "\1\3\1\25\1\24\1\0\1\2\6\4\24\0\1\2\1\24\1\2"+
    "\1\23\1\2\uff80\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\1\2\1\0\1\3\1\0\1\4\3\5\1\1"+
    "\1\6\1\2\1\7\1\2\1\10\2\2\1\11\3\7"+
    "\1\12\1\13\1\3\1\14\1\15\1\16\1\7\1\17"+
    "\1\0\1\4\1\20\2\0\1\21\1\0\1\22\3\0"+
    "\1\11\2\0\1\11\3\0\2\4\1\20\1\21\1\23"+
    "\1\22\1\11\4\0\2\11\1\4\2\20\2\21\2\22"+
    "\2\11\2\0\1\11\1\4\1\20\1\21\1\22\2\11"+
    "\2\0\1\11\2\0\2\11\1\4\1\20\1\21\1\22"+
    "\1\11\2\0\1\11\1\4\1\20\1\21\1\22\1\11"+
    "\2\0\1\11\1\20\1\21\1\22\1\11\2\0\1\11"+
    "\4\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[112];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
	// position methods
	public int position() { return yychar; }
	public int length()   { return yylength(); }
	public int line()     { return -1; /*yyline;*/ }   	// for debugging
	public int column()   { return -1; /*yycolumn;*/ } 	// for debugging

	// state methods
	public void stateReset() 		{ yybegin(YYINITIAL); }
	public void stateSelector() 	{ yybegin(SELECTOR); }
	public void stateAttr()			{ yybegin(ATTR); }
	public void stateCombinator()	{ yybegin(COMBINATOR); }
	public void statePseudoFn()		{ yybegin(PSEUDO_FN); }

	// fast methods
	public final CharSequence xxtext() {
		return CharBuffer.wrap(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead);
	}

	public final String yytext(int startIndex) {
		startIndex += zzStartRead;
		return new String(zzBuffer, startIndex, zzMarkedPos - startIndex);
	}
	public final String yytext(int startIndex, int endIndexOffset) {
		startIndex += zzStartRead;
		return new String(zzBuffer, startIndex, zzMarkedPos - endIndexOffset - startIndex);
	}

	LinkedList<CssSelector> selectors = new LinkedList<CssSelector>();
	CssSelector cssSelector;
	String pseudoFnName;


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  CSSellyLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  CSSellyLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 86) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;


    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          zzInput = zzCMapL[zzInput];

          boolean zzIsFinal = false;
          boolean zzNoLookAhead = false;

          zzForNext: { switch (zzState) {
            case 0:
              switch (zzInput) {
                case 0: 
                case 4: zzIsFinal = true; zzState = 5; break zzForNext;
                case 1: zzIsFinal = true; zzState = 6; break zzForNext;
                case 3: zzIsFinal = true; zzState = 8; break zzForNext;
                case 6: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 9; break zzForNext;
                case 13: zzIsFinal = true; zzNoLookAhead = true; zzState = 10; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 7; break zzForNext;
              }

            case 1:
              switch (zzInput) {
                case 7: zzIsFinal = true; zzNoLookAhead = true; zzState = 12; break zzForNext;
                case 10: zzIsFinal = true; zzState = 13; break zzForNext;
                case 14: zzIsFinal = true; zzNoLookAhead = true; zzState = 14; break zzForNext;
                case 15: zzIsFinal = true; zzState = 15; break zzForNext;
                case 16: zzIsFinal = true; zzState = 16; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 11; break zzForNext;
              }

            case 2:
              switch (zzInput) {
                case 0: 
                case 4: zzIsFinal = true; zzState = 17; break zzForNext;
                case 1: zzIsFinal = true; zzState = 18; break zzForNext;
                case 3: zzIsFinal = true; zzState = 19; break zzForNext;
                case 6: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 20; break zzForNext;
                case 21: zzIsFinal = true; zzNoLookAhead = true; zzState = 21; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 12; break zzForNext;
              }

            case 3:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 23; break zzForNext;
                case 19: zzIsFinal = true; zzState = 24; break zzForNext;
                case 22: zzIsFinal = true; zzState = 25; break zzForNext;
                case 23: zzIsFinal = true; zzState = 26; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 22; break zzForNext;
              }

            case 4:
              switch (zzInput) {
                case 24: zzIsFinal = true; zzNoLookAhead = true; zzState = 28; break zzForNext;
                default: zzIsFinal = true; zzState = 27; break zzForNext;
              }

            case 5:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: zzIsFinal = true; break zzForNext;
                case 3: zzState = 29; break zzForNext;
                default: break zzForAction;
              }

            case 6:
              switch (zzInput) {
                case 0: 
                case 4: zzIsFinal = true; zzState = 5; break zzForNext;
                case 3: zzState = 29; break zzForNext;
                default: break zzForAction;
              }

            case 8:
              switch (zzInput) {
                case 4: 
                case 5: zzIsFinal = true; zzState = 30; break zzForNext;
                case 6: 
                case 7: 
                case 9: break zzForAction;
                default: zzIsFinal = true; zzState = 5; break zzForNext;
              }

            case 9:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 13:
              switch (zzInput) {
                case 0: 
                case 4: zzIsFinal = true; zzState = 31; break zzForNext;
                case 1: zzState = 32; break zzForNext;
                case 3: zzState = 33; break zzForNext;
                default: break zzForAction;
              }

            case 15:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: zzIsFinal = true; zzState = 34; break zzForNext;
                case 3: zzState = 35; break zzForNext;
                default: break zzForAction;
              }

            case 16:
              switch (zzInput) {
                case 0: 
                case 4: zzIsFinal = true; zzState = 36; break zzForNext;
                case 1: zzState = 37; break zzForNext;
                case 3: zzState = 38; break zzForNext;
                default: break zzForAction;
              }

            case 17:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: zzIsFinal = true; break zzForNext;
                case 3: zzState = 39; break zzForNext;
                case 6: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 40; break zzForNext;
                case 13: 
                case 19: 
                case 20: zzState = 41; break zzForNext;
                case 18: zzState = 42; break zzForNext;
                default: break zzForAction;
              }

            case 18:
              switch (zzInput) {
                case 0: 
                case 4: zzIsFinal = true; zzState = 17; break zzForNext;
                case 3: zzState = 39; break zzForNext;
                default: break zzForAction;
              }

            case 19:
              switch (zzInput) {
                case 4: 
                case 5: zzIsFinal = true; zzState = 43; break zzForNext;
                case 6: 
                case 7: 
                case 9: break zzForAction;
                default: zzIsFinal = true; zzState = 17; break zzForNext;
              }

            case 20:
              switch (zzInput) {
                case 0: 
                case 4: zzIsFinal = true; zzState = 17; break zzForNext;
                case 3: zzState = 39; break zzForNext;
                case 1: zzState = 44; break zzForNext;
                case 6: 
                case 7: 
                case 8: 
                case 9: zzState = 45; break zzForNext;
                default: break zzForAction;
              }

            case 23:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; break zzForNext;
                case 19: zzIsFinal = true; zzState = 24; break zzForNext;
                case 22: zzIsFinal = true; zzState = 25; break zzForNext;
                case 23: zzIsFinal = true; zzState = 26; break zzForNext;
                default: break zzForAction;
              }

            case 24:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 25:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 26:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 27:
              switch (zzInput) {
                case 24: zzIsFinal = true; zzNoLookAhead = true; zzState = 28; break zzForNext;
                default: zzState = 46; break zzForNext;
              }

            case 29:
              switch (zzInput) {
                case 4: 
                case 5: zzIsFinal = true; zzState = 30; break zzForNext;
                case 6: 
                case 7: 
                case 9: break zzForAction;
                default: zzIsFinal = true; zzState = 5; break zzForNext;
              }

            case 30:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 5; break zzForNext;
                case 3: zzState = 29; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 47; break zzForNext;
                case 6: zzIsFinal = true; zzState = 48; break zzForNext;
                default: break zzForAction;
              }

            case 31:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: zzIsFinal = true; break zzForNext;
                case 3: zzState = 33; break zzForNext;
                default: break zzForAction;
              }

            case 32:
              switch (zzInput) {
                case 0: 
                case 4: zzIsFinal = true; zzState = 31; break zzForNext;
                case 3: zzState = 33; break zzForNext;
                default: break zzForAction;
              }

            case 33:
              switch (zzInput) {
                case 4: 
                case 5: zzIsFinal = true; zzState = 49; break zzForNext;
                case 6: 
                case 7: 
                case 9: break zzForAction;
                default: zzIsFinal = true; zzState = 31; break zzForNext;
              }

            case 34:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: zzIsFinal = true; break zzForNext;
                case 3: zzState = 35; break zzForNext;
                default: break zzForAction;
              }

            case 35:
              switch (zzInput) {
                case 4: 
                case 5: zzIsFinal = true; zzState = 50; break zzForNext;
                case 6: 
                case 7: 
                case 9: break zzForAction;
                default: zzIsFinal = true; zzState = 34; break zzForNext;
              }

            case 36:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: zzIsFinal = true; break zzForNext;
                case 3: zzState = 38; break zzForNext;
                case 17: zzIsFinal = true; zzNoLookAhead = true; zzState = 51; break zzForNext;
                default: break zzForAction;
              }

            case 37:
              switch (zzInput) {
                case 0: 
                case 4: zzIsFinal = true; zzState = 36; break zzForNext;
                case 3: zzState = 38; break zzForNext;
                default: break zzForAction;
              }

            case 38:
              switch (zzInput) {
                case 4: 
                case 5: zzIsFinal = true; zzState = 52; break zzForNext;
                case 6: 
                case 7: 
                case 9: break zzForAction;
                default: zzIsFinal = true; zzState = 36; break zzForNext;
              }

            case 39:
              switch (zzInput) {
                case 4: 
                case 5: zzIsFinal = true; zzState = 43; break zzForNext;
                case 6: 
                case 7: 
                case 9: break zzForAction;
                default: zzIsFinal = true; zzState = 17; break zzForNext;
              }

            case 40:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; break zzForNext;
                case 13: 
                case 19: 
                case 20: zzState = 41; break zzForNext;
                case 18: zzState = 42; break zzForNext;
                default: break zzForAction;
              }

            case 41:
              switch (zzInput) {
                case 18: zzState = 42; break zzForNext;
                default: break zzForAction;
              }

            case 42:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: 
                case 9: break zzForNext;
                case 0: 
                case 4: zzIsFinal = true; zzState = 53; break zzForNext;
                case 1: zzState = 54; break zzForNext;
                case 3: zzState = 55; break zzForNext;
                case 11: zzState = 56; break zzForNext;
                case 12: zzState = 57; break zzForNext;
                default: break zzForAction;
              }

            case 43:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 17; break zzForNext;
                case 3: zzState = 39; break zzForNext;
                case 13: 
                case 19: 
                case 20: zzState = 41; break zzForNext;
                case 18: zzState = 42; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 58; break zzForNext;
                case 6: zzIsFinal = true; zzState = 59; break zzForNext;
                default: break zzForAction;
              }

            case 44:
              switch (zzInput) {
                case 0: 
                case 4: zzIsFinal = true; zzState = 17; break zzForNext;
                case 3: zzState = 39; break zzForNext;
                default: break zzForAction;
              }

            case 45:
              switch (zzInput) {
                case 0: 
                case 4: zzIsFinal = true; zzState = 17; break zzForNext;
                case 3: zzState = 39; break zzForNext;
                case 1: zzState = 44; break zzForNext;
                case 6: 
                case 7: 
                case 8: 
                case 9: break zzForNext;
                default: break zzForAction;
              }

            case 46:
              switch (zzInput) {
                case 24: zzIsFinal = true; zzNoLookAhead = true; zzState = 28; break zzForNext;
                default: break zzForNext;
              }

            case 47:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 5; break zzForNext;
                case 3: zzState = 29; break zzForNext;
                case 6: zzIsFinal = true; zzState = 48; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 60; break zzForNext;
                default: break zzForAction;
              }

            case 48:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: zzIsFinal = true; zzState = 5; break zzForNext;
                case 3: zzState = 29; break zzForNext;
                default: break zzForAction;
              }

            case 49:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 31; break zzForNext;
                case 3: zzState = 33; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 61; break zzForNext;
                case 6: zzIsFinal = true; zzState = 62; break zzForNext;
                default: break zzForAction;
              }

            case 50:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 34; break zzForNext;
                case 3: zzState = 35; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 63; break zzForNext;
                case 6: zzIsFinal = true; zzState = 64; break zzForNext;
                default: break zzForAction;
              }

            case 52:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 36; break zzForNext;
                case 3: zzState = 38; break zzForNext;
                case 17: zzIsFinal = true; zzNoLookAhead = true; zzState = 51; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 65; break zzForNext;
                case 6: zzIsFinal = true; zzState = 66; break zzForNext;
                default: break zzForAction;
              }

            case 53:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: zzIsFinal = true; break zzForNext;
                case 3: zzState = 55; break zzForNext;
                case 6: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 67; break zzForNext;
                default: break zzForAction;
              }

            case 54:
              switch (zzInput) {
                case 0: 
                case 4: zzIsFinal = true; zzState = 53; break zzForNext;
                case 3: zzState = 55; break zzForNext;
                default: break zzForAction;
              }

            case 55:
              switch (zzInput) {
                case 4: 
                case 5: zzIsFinal = true; zzState = 68; break zzForNext;
                case 6: 
                case 7: 
                case 9: break zzForAction;
                default: zzIsFinal = true; zzState = 53; break zzForNext;
              }

            case 56:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 69; break zzForNext;
                case 6: 
                case 7: 
                case 9: break zzForAction;
                default: break zzForNext;
              }

            case 57:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 70; break zzForNext;
                case 6: 
                case 7: 
                case 9: break zzForAction;
                default: break zzForNext;
              }

            case 58:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 17; break zzForNext;
                case 3: zzState = 39; break zzForNext;
                case 13: 
                case 19: 
                case 20: zzState = 41; break zzForNext;
                case 18: zzState = 42; break zzForNext;
                case 6: zzIsFinal = true; zzState = 59; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 71; break zzForNext;
                default: break zzForAction;
              }

            case 59:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: zzIsFinal = true; zzState = 17; break zzForNext;
                case 3: zzState = 39; break zzForNext;
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 40; break zzForNext;
                case 13: 
                case 19: 
                case 20: zzState = 41; break zzForNext;
                case 18: zzState = 42; break zzForNext;
                default: break zzForAction;
              }

            case 60:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 5; break zzForNext;
                case 3: zzState = 29; break zzForNext;
                case 6: zzIsFinal = true; zzState = 48; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 72; break zzForNext;
                default: break zzForAction;
              }

            case 61:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 31; break zzForNext;
                case 3: zzState = 33; break zzForNext;
                case 6: zzIsFinal = true; zzState = 62; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 73; break zzForNext;
                default: break zzForAction;
              }

            case 62:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: zzIsFinal = true; zzState = 31; break zzForNext;
                case 3: zzState = 33; break zzForNext;
                default: break zzForAction;
              }

            case 63:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 34; break zzForNext;
                case 3: zzState = 35; break zzForNext;
                case 6: zzIsFinal = true; zzState = 64; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 74; break zzForNext;
                default: break zzForAction;
              }

            case 64:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: zzIsFinal = true; zzState = 34; break zzForNext;
                case 3: zzState = 35; break zzForNext;
                default: break zzForAction;
              }

            case 65:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 36; break zzForNext;
                case 3: zzState = 38; break zzForNext;
                case 17: zzIsFinal = true; zzNoLookAhead = true; zzState = 51; break zzForNext;
                case 6: zzIsFinal = true; zzState = 66; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 75; break zzForNext;
                default: break zzForAction;
              }

            case 66:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: zzIsFinal = true; zzState = 36; break zzForNext;
                case 3: zzState = 38; break zzForNext;
                case 17: zzIsFinal = true; zzNoLookAhead = true; zzState = 51; break zzForNext;
                default: break zzForAction;
              }

            case 67:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 68:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 53; break zzForNext;
                case 3: zzState = 55; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 76; break zzForNext;
                case 6: zzIsFinal = true; zzState = 77; break zzForNext;
                default: break zzForAction;
              }

            case 69:
              switch (zzInput) {
                case 3: break zzForNext;
                case 4: 
                case 5: zzState = 78; break zzForNext;
                case 6: zzState = 79; break zzForNext;
                case 11: zzIsFinal = true; zzState = 80; break zzForNext;
                default: zzState = 56; break zzForNext;
              }

            case 70:
              switch (zzInput) {
                case 3: break zzForNext;
                case 4: 
                case 5: zzState = 81; break zzForNext;
                case 6: zzState = 82; break zzForNext;
                case 12: zzIsFinal = true; zzState = 83; break zzForNext;
                default: zzState = 57; break zzForNext;
              }

            case 71:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 17; break zzForNext;
                case 3: zzState = 39; break zzForNext;
                case 13: 
                case 19: 
                case 20: zzState = 41; break zzForNext;
                case 18: zzState = 42; break zzForNext;
                case 6: zzIsFinal = true; zzState = 59; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 84; break zzForNext;
                default: break zzForAction;
              }

            case 72:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 5; break zzForNext;
                case 3: zzState = 29; break zzForNext;
                case 6: zzIsFinal = true; zzState = 48; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 85; break zzForNext;
                default: break zzForAction;
              }

            case 73:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 31; break zzForNext;
                case 3: zzState = 33; break zzForNext;
                case 6: zzIsFinal = true; zzState = 62; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 86; break zzForNext;
                default: break zzForAction;
              }

            case 74:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 34; break zzForNext;
                case 3: zzState = 35; break zzForNext;
                case 6: zzIsFinal = true; zzState = 64; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 87; break zzForNext;
                default: break zzForAction;
              }

            case 75:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 36; break zzForNext;
                case 3: zzState = 38; break zzForNext;
                case 17: zzIsFinal = true; zzNoLookAhead = true; zzState = 51; break zzForNext;
                case 6: zzIsFinal = true; zzState = 66; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 88; break zzForNext;
                default: break zzForAction;
              }

            case 76:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 53; break zzForNext;
                case 3: zzState = 55; break zzForNext;
                case 6: zzIsFinal = true; zzState = 77; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 89; break zzForNext;
                default: break zzForAction;
              }

            case 77:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: zzIsFinal = true; zzState = 53; break zzForNext;
                case 3: zzState = 55; break zzForNext;
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 67; break zzForNext;
                default: break zzForAction;
              }

            case 78:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 69; break zzForNext;
                case 6: zzState = 79; break zzForNext;
                case 4: 
                case 5: zzState = 90; break zzForNext;
                default: zzState = 56; break zzForNext;
              }

            case 79:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 69; break zzForNext;
                case 6: 
                case 9: break zzForAction;
                default: zzState = 56; break zzForNext;
              }

            case 80:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 9: 
                case 11: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 69; break zzForNext;
                case 8: zzIsFinal = true; break zzForNext;
                default: zzState = 56; break zzForNext;
              }

            case 81:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 70; break zzForNext;
                case 6: zzState = 82; break zzForNext;
                case 4: 
                case 5: zzState = 91; break zzForNext;
                default: zzState = 57; break zzForNext;
              }

            case 82:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 70; break zzForNext;
                case 6: 
                case 9: break zzForAction;
                default: zzState = 57; break zzForNext;
              }

            case 83:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 9: 
                case 12: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 70; break zzForNext;
                case 8: zzIsFinal = true; break zzForNext;
                default: zzState = 57; break zzForNext;
              }

            case 84:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 17; break zzForNext;
                case 3: zzState = 39; break zzForNext;
                case 13: 
                case 19: 
                case 20: zzState = 41; break zzForNext;
                case 18: zzState = 42; break zzForNext;
                case 6: zzIsFinal = true; zzState = 59; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 92; break zzForNext;
                default: break zzForAction;
              }

            case 85:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 5; break zzForNext;
                case 3: zzState = 29; break zzForNext;
                case 6: zzIsFinal = true; zzState = 48; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 93; break zzForNext;
                default: break zzForAction;
              }

            case 86:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 31; break zzForNext;
                case 3: zzState = 33; break zzForNext;
                case 6: zzIsFinal = true; zzState = 62; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 94; break zzForNext;
                default: break zzForAction;
              }

            case 87:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 34; break zzForNext;
                case 3: zzState = 35; break zzForNext;
                case 6: zzIsFinal = true; zzState = 64; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 95; break zzForNext;
                default: break zzForAction;
              }

            case 88:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 36; break zzForNext;
                case 3: zzState = 38; break zzForNext;
                case 17: zzIsFinal = true; zzNoLookAhead = true; zzState = 51; break zzForNext;
                case 6: zzIsFinal = true; zzState = 66; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 96; break zzForNext;
                default: break zzForAction;
              }

            case 89:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 53; break zzForNext;
                case 3: zzState = 55; break zzForNext;
                case 6: zzIsFinal = true; zzState = 77; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 97; break zzForNext;
                default: break zzForAction;
              }

            case 90:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 69; break zzForNext;
                case 6: zzState = 79; break zzForNext;
                case 4: 
                case 5: zzState = 98; break zzForNext;
                default: zzState = 56; break zzForNext;
              }

            case 91:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 70; break zzForNext;
                case 6: zzState = 82; break zzForNext;
                case 4: 
                case 5: zzState = 99; break zzForNext;
                default: zzState = 57; break zzForNext;
              }

            case 92:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 17; break zzForNext;
                case 3: zzState = 39; break zzForNext;
                case 13: 
                case 19: 
                case 20: zzState = 41; break zzForNext;
                case 18: zzState = 42; break zzForNext;
                case 6: zzIsFinal = true; zzState = 59; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 100; break zzForNext;
                default: break zzForAction;
              }

            case 93:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 5; break zzForNext;
                case 3: zzState = 29; break zzForNext;
                case 6: zzIsFinal = true; zzState = 48; break zzForNext;
                default: break zzForAction;
              }

            case 94:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 31; break zzForNext;
                case 3: zzState = 33; break zzForNext;
                case 6: zzIsFinal = true; zzState = 62; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 101; break zzForNext;
                default: break zzForAction;
              }

            case 95:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 34; break zzForNext;
                case 3: zzState = 35; break zzForNext;
                case 6: zzIsFinal = true; zzState = 64; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 102; break zzForNext;
                default: break zzForAction;
              }

            case 96:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 36; break zzForNext;
                case 3: zzState = 38; break zzForNext;
                case 17: zzIsFinal = true; zzNoLookAhead = true; zzState = 51; break zzForNext;
                case 6: zzIsFinal = true; zzState = 66; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 103; break zzForNext;
                default: break zzForAction;
              }

            case 97:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 53; break zzForNext;
                case 3: zzState = 55; break zzForNext;
                case 6: zzIsFinal = true; zzState = 77; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 104; break zzForNext;
                default: break zzForAction;
              }

            case 98:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 69; break zzForNext;
                case 6: zzState = 79; break zzForNext;
                case 4: 
                case 5: zzState = 105; break zzForNext;
                default: zzState = 56; break zzForNext;
              }

            case 99:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 70; break zzForNext;
                case 6: zzState = 82; break zzForNext;
                case 4: 
                case 5: zzState = 106; break zzForNext;
                default: zzState = 57; break zzForNext;
              }

            case 100:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 17; break zzForNext;
                case 3: zzState = 39; break zzForNext;
                case 13: 
                case 19: 
                case 20: zzState = 41; break zzForNext;
                case 18: zzState = 42; break zzForNext;
                case 6: zzIsFinal = true; zzState = 59; break zzForNext;
                default: break zzForAction;
              }

            case 101:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 31; break zzForNext;
                case 3: zzState = 33; break zzForNext;
                case 6: zzIsFinal = true; zzState = 62; break zzForNext;
                default: break zzForAction;
              }

            case 102:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 34; break zzForNext;
                case 3: zzState = 35; break zzForNext;
                case 6: zzIsFinal = true; zzState = 64; break zzForNext;
                default: break zzForAction;
              }

            case 103:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 36; break zzForNext;
                case 3: zzState = 38; break zzForNext;
                case 17: zzIsFinal = true; zzNoLookAhead = true; zzState = 51; break zzForNext;
                case 6: zzIsFinal = true; zzState = 66; break zzForNext;
                default: break zzForAction;
              }

            case 104:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 53; break zzForNext;
                case 3: zzState = 55; break zzForNext;
                case 6: zzIsFinal = true; zzState = 77; break zzForNext;
                case 4: 
                case 5: zzIsFinal = true; zzState = 107; break zzForNext;
                default: break zzForAction;
              }

            case 105:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 69; break zzForNext;
                case 6: zzState = 79; break zzForNext;
                case 4: 
                case 5: zzState = 108; break zzForNext;
                default: zzState = 56; break zzForNext;
              }

            case 106:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 70; break zzForNext;
                case 6: zzState = 82; break zzForNext;
                case 4: 
                case 5: zzState = 109; break zzForNext;
                default: zzState = 57; break zzForNext;
              }

            case 107:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 53; break zzForNext;
                case 3: zzState = 55; break zzForNext;
                case 6: zzIsFinal = true; zzState = 77; break zzForNext;
                default: break zzForAction;
              }

            case 108:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 69; break zzForNext;
                case 6: zzState = 79; break zzForNext;
                case 4: 
                case 5: zzState = 110; break zzForNext;
                default: zzState = 56; break zzForNext;
              }

            case 109:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 70; break zzForNext;
                case 6: zzState = 82; break zzForNext;
                case 4: 
                case 5: zzState = 111; break zzForNext;
                default: zzState = 57; break zzForNext;
              }

            case 110:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 69; break zzForNext;
                case 6: zzState = 79; break zzForNext;
                default: zzState = 56; break zzForNext;
              }

            case 111:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzState = 67; break zzForNext;
                case 3: zzState = 70; break zzForNext;
                case 6: zzState = 82; break zzForNext;
                default: zzState = 57; break zzForNext;
              }

            default:
              // if this is ever reached, there is a serious bug in JFlex
              zzScanError(ZZ_UNKNOWN_ERROR);
              break;
          } }

          if ( zzIsFinal ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( zzNoLookAhead ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 9: 
          { cssSelector.addAttributeSelector(yytext());
          }
        case 20: break;
        case 14: 
          { cssSelector.setCombinator(Combinator.ADJACENT_SIBLING); stateReset();
          }
        case 21: break;
        case 6: 
          { cssSelector = new CssSelector(); selectors.add(cssSelector); stateSelector();
          }
        case 22: break;
        case 1: 
          { /* ignore whitespaces */
          }
        case 23: break;
        case 19: 
          { pseudoFnName = yytext(1,1); statePseudoFn();
          }
        case 24: break;
        case 12: 
          { cssSelector.setCombinator(Combinator.GENERAL_SIBLING); stateReset();
          }
        case 25: break;
        case 10: 
          { stateSelector();
          }
        case 26: break;
        case 15: 
          { cssSelector.addPseudoFunctionSelector(pseudoFnName, yytext(0, 1)); stateSelector();
          }
        case 27: break;
        case 8: 
          { stateAttr();
          }
        case 28: break;
        case 18: 
          { cssSelector.addPseudoClassSelector(yytext(1));
          }
        case 29: break;
        case 7: 
          { throw new CSSellyException("Illegal character <"+ yytext() +">.", yystate(), line(), column());
          }
        case 30: break;
        case 2: 
          { yypushback(1); stateCombinator();
          }
        case 31: break;
        case 4: 
          { cssSelector = new CssSelector(yytext()); selectors.add(cssSelector); stateSelector();
          }
        case 32: break;
        case 5: 
          { cssSelector = new CssSelector(); selectors.add(cssSelector); yypushback(1); stateSelector();
          }
        case 33: break;
        case 3: 
          { cssSelector.setCombinator(Combinator.DESCENDANT); stateReset();
          }
        case 34: break;
        case 17: 
          { cssSelector.addIdSelector(yytext(1));
          }
        case 35: break;
        case 16: 
          { cssSelector.addClassSelector(yytext(1));
          }
        case 36: break;
        case 11: 
          { throw new CSSellyException("Invalid combinator <"+ yytext() +">.", yystate(), line(), column());
          }
        case 37: break;
        case 13: 
          { cssSelector.setCombinator(Combinator.CHILD); stateReset();
          }
        case 38: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              { return 0; }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
