/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ds.jdbc23;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.postgresql.Driver;
import org.postgresql.ds.PGConnectionPoolDataSource;
import org.postgresql.ds.PGPooledConnection;
import org.postgresql.ds.PGPoolingDataSource;
import org.postgresql.ds.common.BaseDataSource;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc23PoolingDataSource
extends BaseDataSource {
    protected static Map dataSources = new HashMap();
    protected String dataSourceName;
    private int initialConnections = 0;
    private int maxConnections = 0;
    private boolean initialized = false;
    private Stack available = new Stack();
    private Stack used = new Stack();
    private Object lock = new Object();
    private PGConnectionPoolDataSource source;
    private ConnectionEventListener connectionEventListener = new ConnectionEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed(ConnectionEvent event) {
            ((PooledConnection)event.getSource()).removeConnectionEventListener(this);
            Object object = AbstractJdbc23PoolingDataSource.this.lock;
            synchronized (object) {
                if (AbstractJdbc23PoolingDataSource.this.available == null) {
                    return;
                }
                boolean removed = AbstractJdbc23PoolingDataSource.this.used.remove(event.getSource());
                if (removed) {
                    AbstractJdbc23PoolingDataSource.this.available.push(event.getSource());
                    AbstractJdbc23PoolingDataSource.this.lock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionErrorOccurred(ConnectionEvent event) {
            ((PooledConnection)event.getSource()).removeConnectionEventListener(this);
            Object object = AbstractJdbc23PoolingDataSource.this.lock;
            synchronized (object) {
                if (AbstractJdbc23PoolingDataSource.this.available == null) {
                    return;
                }
                AbstractJdbc23PoolingDataSource.this.used.remove(event.getSource());
                AbstractJdbc23PoolingDataSource.this.lock.notify();
            }
        }
    };

    public static PGPoolingDataSource getDataSource(String name) {
        return (PGPoolingDataSource)dataSources.get(name);
    }

    public String getDescription() {
        return "Pooling DataSource '" + this.dataSourceName + " from " + Driver.getVersion();
    }

    public void setServerName(String serverName) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setServerName(serverName);
    }

    public void setDatabaseName(String databaseName) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setDatabaseName(databaseName);
    }

    public void setUser(String user) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setUser(user);
    }

    public void setPassword(String password) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setPassword(password);
    }

    public void setPortNumber(int portNumber) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setPortNumber(portNumber);
    }

    public int getInitialConnections() {
        return this.initialConnections;
    }

    public void setInitialConnections(int initialConnections) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        this.initialConnections = initialConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        this.maxConnections = maxConnections;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSourceName(String dataSourceName) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        if (this.dataSourceName != null && dataSourceName != null && dataSourceName.equals(this.dataSourceName)) {
            return;
        }
        Map map = dataSources;
        synchronized (map) {
            if (AbstractJdbc23PoolingDataSource.getDataSource(dataSourceName) != null) {
                throw new IllegalArgumentException("DataSource with name '" + dataSourceName + "' already exists!");
            }
            if (this.dataSourceName != null) {
                dataSources.remove(this.dataSourceName);
            }
            this.dataSourceName = dataSourceName;
            this.addDataSource(dataSourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.source = this.createConnectionPool();
            try {
                this.source.initializeFrom(this);
            }
            catch (Exception e) {
                throw new PSQLException(GT.tr("Failed to setup DataSource."), PSQLState.UNEXPECTED_ERROR, (Throwable)e);
            }
            while (this.available.size() < this.initialConnections) {
                this.available.push(this.source.getPooledConnection());
            }
            this.initialized = true;
        }
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected PGConnectionPoolDataSource createConnectionPool() {
        return new PGConnectionPoolDataSource();
    }

    public Connection getConnection(String user, String password) throws SQLException {
        if (user == null || user.equals(this.getUser()) && (password == null && this.getPassword() == null || password != null && password.equals(this.getPassword()))) {
            return this.getConnection();
        }
        if (!this.initialized) {
            this.initialize();
        }
        return super.getConnection(user, password);
    }

    public Connection getConnection() throws SQLException {
        if (!this.initialized) {
            this.initialize();
        }
        return this.getPooledConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            PGPooledConnection pci;
            while (this.available.size() > 0) {
                pci = (PGPooledConnection)this.available.pop();
                try {
                    pci.close();
                }
                catch (SQLException e) {}
            }
            this.available = null;
            while (true) {
                if (this.used.size() <= 0) {
                    this.used = null;
                    // MONITOREXIT @DISABLED, blocks:[3, 7, 8] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.removeStoredDataSource();
                    return;
                }
                pci = (PGPooledConnection)this.used.pop();
                pci.removeConnectionEventListener(this.connectionEventListener);
                try {
                    pci.close();
                }
                catch (SQLException sQLException) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeStoredDataSource() {
        Map map = dataSources;
        synchronized (map) {
            dataSources.remove(this.dataSourceName);
        }
    }

    protected abstract void addDataSource(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getPooledConnection() throws SQLException {
        PooledConnection pc = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.available == null) {
                throw new PSQLException(GT.tr("DataSource has been closed."), PSQLState.CONNECTION_DOES_NOT_EXIST);
            }
            while (true) {
                if (this.available.size() > 0) {
                    pc = (PooledConnection)this.available.pop();
                    this.used.push(pc);
                    break;
                }
                if (this.maxConnections == 0 || this.used.size() < this.maxConnections) {
                    pc = this.source.getPooledConnection();
                    this.used.push(pc);
                    break;
                }
                try {
                    this.lock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        pc.addConnectionEventListener(this.connectionEventListener);
        return pc.getConnection();
    }

    public Reference getReference() throws NamingException {
        Reference ref = super.getReference();
        ref.add(new StringRefAddr("dataSourceName", this.dataSourceName));
        if (this.initialConnections > 0) {
            ref.add(new StringRefAddr("initialConnections", Integer.toString(this.initialConnections)));
        }
        if (this.maxConnections > 0) {
            ref.add(new StringRefAddr("maxConnections", Integer.toString(this.maxConnections)));
        }
        return ref;
    }
}

