/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;

public class OracleTypeFLOAT
extends OracleType
implements Serializable {
    static final long serialVersionUID = 4088841548269771109L;
    int precision;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_18:54:30_PDT_2005";

    protected OracleTypeFLOAT() {
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(object, oracleConnection);
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(object, oracleConnection, l, n);
    }

    public int getTypeCode() {
        return 6;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.nullOffset = tDSReader.nullOffset++;
        this.ldsOffset = tDSReader.ldsOffset++;
        this.precision = tDSReader.readUnsignedByte();
    }

    public int getScale() {
        return -127;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.sizeForLds == 0) {
            this.sizeForLds = Util.fdoGetSize(byArray, 12);
            this.alignForLds = Util.fdoGetAlign(byArray, 12);
        }
        return this.sizeForLds;
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.sizeForLds == 0) {
            this.sizeForLds = Util.fdoGetSize(byArray, 12);
            this.alignForLds = Util.fdoGetAlign(byArray, 12);
        }
        return this.alignForLds;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        return OracleTypeNUMBER.numericUnpickle80rec(this.ldsOffset, this.nullOffset, unpickleContext, n, n2, map);
    }

    protected static Object unpickle80NativeArray(UnpickleContext unpickleContext, long l, int n, int n2, int n3) throws SQLException {
        return OracleTypeNUMBER.unpickle80NativeArray(unpickleContext, l, n, n2, n3);
    }

    protected static Object unpickle81NativeArray(PickleContext pickleContext, long l, int n, int n2) throws SQLException {
        return OracleTypeNUMBER.unpickle81NativeArray(pickleContext, l, n, n2);
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        return OracleTypeNUMBER.toNumericObject(byArray, n, map);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.precision);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.precision = objectInputStream.readInt();
    }
}

