/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CMAREngine;

class T4CRawAccessor
extends RawAccessor {
    T4CMAREngine mare;
    boolean underlyingLongRaw = false;
    final int[] meta = new int[1];
    final int[] escapeSequenceArr = new int[1];
    final boolean[] readHeaderArr = new boolean[1];
    final boolean[] readAsNonStreamArr = new boolean[1];
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_18:54:36_PDT_2005";

    T4CRawAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n, s, n2, bl);
        this.mare = t4CMAREngine;
    }

    T4CRawAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s, int n7, int n8, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n == -1 ? n8 : n, bl, n2, n3, n4, n5, n6, s);
        this.mare = t4CMAREngine;
        this.definedColumnType = n7;
        this.definedColumnSize = n8;
        if (n == -1) {
            this.underlyingLongRaw = true;
        }
    }

    void processIndicator(int n) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.mare.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 1 && this.statement.sqlKind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 1 || this.statement.sqlKind == 4 || this.isDMLReturnedParam) {
            this.mare.processIndicator(n <= 0, n);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        int n = this.indicatorIndex + this.lastRowProcessed;
        int n2 = this.lengthIndex + this.lastRowProcessed;
        int n3 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        if (!this.underlyingLongRaw) {
            if (this.rowSpaceIndicator == null) {
                byte[] byArray = new byte[16000];
                this.mare.unmarshalCLR(byArray, 0, this.meta);
                this.processIndicator(this.meta[0]);
                ++this.lastRowProcessed;
                return false;
            }
            if (this.isNullByDescribe) {
                this.rowSpaceIndicator[n] = -1;
                this.rowSpaceIndicator[n2] = 0;
                ++this.lastRowProcessed;
                if (this.mare.versionNumber < 9200) {
                    this.processIndicator(0);
                }
                return false;
            }
            this.mare.unmarshalCLR(this.rowSpaceByte, n3 + 2, this.meta, this.byteLength - 2);
        } else {
            this.escapeSequenceArr[0] = this.mare.unmarshalUB1();
            if (this.mare.escapeSequenceNull(this.escapeSequenceArr[0])) {
                this.meta[0] = 0;
                this.mare.processIndicator(false, 0);
                int n4 = (int)this.mare.unmarshalUB4();
            } else {
                int n5 = 0;
                int n6 = 0;
                byte[] byArray = this.rowSpaceByte;
                int n7 = n3 + 2;
                this.readHeaderArr[0] = true;
                this.readAsNonStreamArr[0] = false;
                while (n5 != -1) {
                    if (byArray == this.rowSpaceByte && n6 + 255 > this.byteLength - 2) {
                        byArray = new byte[255];
                    }
                    if (byArray != this.rowSpaceByte) {
                        n7 = 0;
                    }
                    if ((n5 = T4CLongRawAccessor.readStreamFromWire(byArray, n7, 255, this.escapeSequenceArr, this.readHeaderArr, this.readAsNonStreamArr, this.mare, ((T4CConnection)this.statement.connection).oer)) == -1) continue;
                    if (byArray == this.rowSpaceByte) {
                        n6 += n5;
                        n7 += n5;
                        continue;
                    }
                    if (this.byteLength - 2 - n6 <= 0) continue;
                    int n8 = this.byteLength - 2 - n6;
                    System.arraycopy(byArray, 0, this.rowSpaceByte, n7, n8);
                    n6 += n8;
                }
                if (byArray != this.rowSpaceByte) {
                    byArray = null;
                }
                this.meta[0] = n6;
            }
        }
        this.rowSpaceByte[n3] = (byte)((this.meta[0] & 0xFF00) >> 8);
        this.rowSpaceByte[n3 + 1] = (byte)(this.meta[0] & 0xFF);
        if (!this.underlyingLongRaw) {
            this.processIndicator(this.meta[0]);
        }
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n] = -1;
            this.rowSpaceIndicator[n2] = 0;
        } else {
            this.rowSpaceIndicator[n2] = (short)this.meta[0];
            this.rowSpaceIndicator[n] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    void copyRow() throws SQLException, IOException {
        int n = this.lastRowProcessed == 0 ? this.statement.rowPrefetch : this.lastRowProcessed;
        int n2 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int n3 = this.columnIndex + (n - 1) * this.byteLength;
        int n4 = this.indicatorIndex + this.lastRowProcessed;
        int n5 = this.indicatorIndex + n - 1;
        int n6 = this.lengthIndex + this.lastRowProcessed;
        int n7 = this.lengthIndex + n - 1;
        short s = this.rowSpaceIndicator[n7];
        this.rowSpaceIndicator[n6] = s;
        this.rowSpaceIndicator[n4] = this.rowSpaceIndicator[n5];
        System.arraycopy(this.rowSpaceByte, n3, this.rowSpaceByte, n2, s + 2);
        ++this.lastRowProcessed;
    }

    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n, int n2) throws SQLException {
        int n3 = this.columnIndex + (n2 - 1) * this.byteLength;
        int n4 = this.columnIndexLastRow + (n - 1) * this.byteLength;
        int n5 = this.indicatorIndex + n2 - 1;
        int n6 = this.indicatorIndexLastRow + n - 1;
        int n7 = this.lengthIndex + n2 - 1;
        int n8 = this.lengthIndexLastRow + n - 1;
        short s = sArray[n8];
        this.rowSpaceIndicator[n7] = s;
        this.rowSpaceIndicator[n5] = sArray[n6];
        if (s != 0) {
            System.arraycopy(byArray, n4, this.rowSpaceByte, n3, s + 2);
        }
    }

    String getString(int n) throws SQLException {
        String string = super.getString(n);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize * 2) {
            string = string.substring(0, this.definedColumnSize * 2);
        }
        return string;
    }

    Object getObject(int n) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n);
        }
        Object var2_2 = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(n);
                }
                case -2: {
                    return this.getRAW(n);
                }
            }
            DatabaseError.throwSqlException(4);
            return null;
        }
        return var2_2;
    }

    byte[] getBytes(int n) throws SQLException {
        byte[] byArray = super.getBytes(n);
        if (this.definedColumnSize > 0 && this.definedColumnSize < byArray.length) {
            byte[] byArray2 = new byte[this.definedColumnSize];
            System.arraycopy(byArray, 0, byArray2, 0, this.definedColumnSize);
            byArray = byArray2;
        }
        return byArray;
    }
}

