/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.compiler;

import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.constant.CONSTANT_Integer_info;
import com.vladium.jcd.opcodes.IOpcodes;
import com.vladium.util.ByteArrayOStream;

public abstract class CodeGen
implements IOpcodes {
    public static void load_local_object_var(ByteArrayOStream out, int index) {
        if (index <= 3) {
            out.write(42 + index);
        } else if (index <= 255) {
            out.write2(25, index);
        } else {
            out.write4(196, 25, index >>> 8, index);
        }
    }

    public static void store_local_object_var(ByteArrayOStream out, int index) {
        if (index <= 3) {
            out.write(75 + index);
        } else if (index <= 255) {
            out.write2(58, index);
        } else {
            out.write4(196, 58, index >>> 8, index);
        }
    }

    public static void push_int_value(ByteArrayOStream out, ClassDef cls, int value) {
        if (-1 <= value && value <= 5) {
            out.write(3 + value);
        } else if (-128 <= value && value <= 127) {
            out.write2(16, value);
        } else if (Short.MIN_VALUE <= value && value <= Short.MAX_VALUE) {
            out.write3(17, value >>> 8, value);
        } else {
            int index = cls.getConstants().add(new CONSTANT_Integer_info(value));
            if (index <= 255) {
                out.write2(18, index);
            } else {
                out.write3(19, index >>> 8, index);
            }
        }
    }

    public static void push_constant_index(ByteArrayOStream out, int index) {
        if (index <= 255) {
            out.write2(18, index);
        } else {
            out.write3(19, index >>> 8, index);
        }
    }

    private CodeGen() {
    }
}

