Key | Type | Description
----|------|-------------
`action`|`string` | The action performed. Can be one of: <ul><li> `created` - A new check run was created.</li><li> `completed` - The `status` of the check run is `completed`.</li><li> `rerequested` - Someone requested to re-run your check run from the pull request UI. See "[About status checks](/articles/about-status-checks#checks)" for more details about the GitHub UI. When you receive a `rerequested` action, you'll need to [create a new check run](/rest/reference/checks#create-a-check-run). Only the {% data variables.product.prodname_github_app %} that someone requests to re-run the check will receive the `rerequested` payload.</li><li> `requested_action` - Someone requested an action your app provides to be taken. Only the {% data variables.product.prodname_github_app %} someone requests to perform an action will receive the `requested_action` payload. To learn more about check runs and requested actions, see "[Check runs and requested actions](/rest/reference/checks#check-runs-and-requested-actions)."</li></ul>
`check_run`|`object` | The [check_run](/rest/reference/checks#get-a-check-run).
`check_run[status]`|`string` | The current status of the check run. Can be `queued`, `in_progress`, or `completed`.
`check_run[conclusion]`|`string` | The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`,  `action_required` or `stale`. This value will be `null` until the check run has `completed`.
`check_run[name]`|`string` | The name of the check run.
`check_run[check_suite][id]`|`integer` | The id of the check suite that this check run is part of.
`check_run[check_suite][pull_requests]`|`array`| An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_branch`.<br/><br/>**Note:**<ul><li>The `head_sha` of the check suite can differ from the `sha` of the pull request if subsequent pushes are made into the PR.</li><li>When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.</li></ul>
`check_run[check_suite][deployment]`|`object`| A deployment to a repository environment. This will only be populated if the check run was created by a {% data variables.product.prodname_actions %} workflow job that references an environment.
`requested_action`|`object` | The action requested by the user.
`requested_action[identifier]`|`string` | The integrator reference of the action requested by the user.
