Compulsory commit signoffs only apply to commits made via the web interface. For commits made via the Git command line interface, the commit author must sign off on the commit using the `--signoff` option. For more information, see the [Git documentation](https://git-scm.com/docs/git-commit).


You can determine whether a repository you are contributing to has compulsory commit signoffs enabled by checking the header of the commit form at the bottom of the file you are editing. After compulsory commit signoff has been enabled, the header will read "Sign off and commit changes."

![Screenshot of commit commit form with compulsory signoff enabled](/assets/images/help/commits/commit-form-with-signoff-enabled.png)

Before signing off on a commit, you should ensure that your commit is in compliance with the rules and licensing governing the repository you're committing to. The repository may use a sign off agreement, such as the Developer Certificate of Origin from the Linux Foundation. For more information, see the [Developer Certificate of Origin](https://developercertificate.org/).

Signing off on a commit differs from signing a commit. For more information about signing a commit, see "[About commit signature verification](/authentication/managing-commit-signature-verification/about-commit-signature-verification)."
