* Required workflows can be stored in any repository folder and are not restricted to the `.github/workflows` folder like normal workflows. If a required workflow calls a reusable workflow, the reusable workflow must be stored in the `.github/workflows` folder. When calling a reusable workflow, a required workflow must use the full path and ref to the reusable workflow. For example, `{owner}/{repo}/.github/workflows/{filename}@{ref}`.
* If the required workflow is contained in a private {% ifversion ghes or ghec or ghae %}or internal {% endif %}repository, you must ensure that workflows within the repository are accessible by other repositories in your organization. For more information, see "[Allowing access to components in a private repository](/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#managing-access-for-a-private-repository){% ifversion ghes or ghec or ghae %}" and "[Allowing access to components in an internal repository](/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-an-internal-repository){% endif %}."
* Workflows stored in a public repository can be configured as required workflows for any repository in your organization. Workflows stored in a private repository can only be configured as required workflows for other private repositories in your organization. {% ifversion ghes or ghec or ghae %} Workflows stored in internal repositories can be configured as required workflows for internal and private repositories in your organization.{% endif %}
* CodeQL is not supported in required workflows because CodeQL requires configuration at the repository level. For information on configuring code scanning, see "[Configuring code scanning for a repository](/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/configuring-code-scanning-for-a-repository)."
