# Contributing to github/docs

Check out our [contributing guide](../CONTRIBUTING.md) to see all the ways you can participate in the GitHub docs community :sparkling_heart:

Here, you'll find additional information that might be helpful as you work on a pull request in this repo.

- [development](./development.md) - steps for getting this app running on your local machine
- [codespace](./codespace.md) - use GitHub Codespaces to work on documentation markdown files
- [content markup reference](./content-markup-reference.md) - how to use markup and features specific to the GitHub Docs site 
- [content style guide](./content-style-guide.md) - style guidance specific to GitHub Docs content and additional resources for writing clear, helpful content
- [content model](./content-model.md) - the content types that make up GitHub Docs and how to write them
- [content templates](./content-templates.md) - handy templates to get you started with a new article
- [deployments](./deployments.md) - how our staging and production environments work
- [liquid helpers](./liquid-helpers.md) - using liquid helpers for versioning in our docs
- [translations guide for writers](./translations/for-writers.md) - making sure your content is ready to be translated
- [node versions](./node-versions.md) - our site runs on Node.js
- [permalinks](./permalinks.md) - permalinks for article versioning
- [redirects](./redirects.md) - configuring redirects in the site
- [search](./search.md) - our local site search functionality
- [troubleshooting](./troubleshooting.md) - some help for troubleshooting failed and stalled status checks
