---
title: Using a fiscal host to receive GitHub Sponsors payouts
intro: 'You can become a sponsored developer by joining {% data variables.product.prodname_sponsors %} and choosing a fiscal host for your payouts to come through.'
versions:
  fpt: '*'
  ghec: '*'
type: how_to
topics:
  - User account
  - Sponsors profile
shortTitle: Using a fiscal host
---

## About using a fiscal host to receive {% data variables.product.prodname_sponsors %} payouts

When you sign up for a {% data variables.product.prodname_sponsors %} profile so that you can be sponsored, you can choose whether to receive your payments in a Stripe Connect account that you control, or via a fiscal host that you already work with.

{% data reusables.sponsors.bank-info-fiscal-host-reminder %}

{% data variables.product.prodname_sponsors %} supports these fiscal hosts:

- [Open Source Collective](https://oscollective.org/)
- [NumFOCUS](http://www.numfocus.org/)
- [Open Collective Europe](https://opencollective.com/europe)
- [Software Underground](https://softwareunderground.org/)
- [Software Freedom Conservancy](https://sfconservancy.org/)

## Choosing to use a fiscal host

Once you navigate to the "Join the waitlist" profile setup page for the account you want sponsored, you will see the "How you receive payouts" or "Organization bank account" section, depending on which type of account you are setting up. For more information on how to sign up for a {% data variables.product.prodname_sponsors %} profile, see "[Setting up {% data variables.product.prodname_sponsors %} for your personal account](/sponsors/receiving-sponsorships-through-github-sponsors/setting-up-github-sponsors-for-your-personal-account)" or "[Setting up {% data variables.product.prodname_sponsors %} for your organization](/sponsors/receiving-sponsorships-through-github-sponsors/setting-up-github-sponsors-for-your-organization)."

1. Under "How you receive payouts" or "Organization bank account", select the **Use a fiscal host** or **This organization is using a fiscal host** option.

   ![Screenshot of option to choose between a bank account and a fiscal host](/assets/images/help/sponsors/user-waitlist-payout-options.png)
2. Use the **Select a fiscal host** dropdown to choose the fiscal host you want to use.
3. In the text box under "Fiscal host project profile URL", type the URL to your profile page on the fiscal host's site. This helps us verify that you are indeed registered with the fiscal host.
  
  ![Screenshot of text box for project profile URL of your fiscal host](/assets/images/help/sponsors/fiscal-host-project-profile-field.png)
