---
title: Quickstart for finding contributors to sponsor
intro: Learn some best practices for finding open source contributors to sponsor.
versions:
  fpt: '*'
  ghec: '*'
type: quick_start
topics:
  - Open Source
shortTitle: Quickstart
---

## Explore projects you depend on

As you consider where to find open source contributors to sponsor, consider starting at https://github.com/sponsors/community.

If you're logged in, the sponsors results will start with public dependencies that your repositories depend on.

![The Babel open source project with highlighted text that says "4 of your repositories depend on this"](/assets/images/help/sponsors/example-of-open-source-project-dependency.png)

You can also toggle which of your accounts to view results for and further filter or search.

![Search options on sponsors community search page](/assets/images/help/sponsors/sponsors-search-options.png)

## Explore whom others sponsor

You can see whom a user or organization sponsors on their {% data variables.product.prodname_dotcom %} profile page.

## Consider how you benefit from different contributions

Consider whether you benefit from the work of open source contributions, such as:
 - Documentation
 - Design
 - Translation
 - Newsletters
 - Code reviews
 - Tutorials
 - Mentoring
 - Triaging issues and helping with project management
 - Answering questions
 - Event planning

For more information on different types of open source contributions, see the [Open source guide](https://opensource.guide/how-to-contribute/#you-dont-have-to-contribute-code).

You can check if contributors you've benefited from have {% data variables.product.prodname_sponsors %} profiles by using search at https://github.com/sponsors/community.

## Search for a specific project or contributor

At https://github.com/sponsors/community, you can search by ecosystem, most used, recently updated, and more. You can filter search results for your personal account or for organizations that you're a member of.

## Next steps

For more information on starting your sponsorship, see "[Sponsoring an open source contributor](/sponsors/sponsoring-open-source-contributors/sponsoring-an-open-source-contributor)."
