---
title: SCIM
intro: Use the REST API to control and manage your GitHub organization members access with SCIM.
versions:
  ghec: '*'
topics:
  - API
miniTocMaxHeadingLevel: 3
redirect_from:
  - /rest/reference/scim
---

## About SCIM

### SCIM Provisioning for Organizations

These endpoints are used by SCIM-enabled Identity Providers (IdPs) to automate provisioning of {% data variables.product.product_name %} organization membership and are based on version 2.0 of the [SCIM standard](http://www.simplecloud.info/). IdPs should use the base URL `{% data variables.product.api_url_code %}/scim/v2/organizations/{org}/` for {% data variables.product.product_name %} SCIM endpoints.

{% note %}

**Notes:** 
  - These endpoints are only available for individual organizations that use [{% data variables.product.prodname_ghe_cloud %}](/billing/managing-billing-for-your-github-account/about-billing-for-github-accounts) with [SAML SSO](/rest/overview/other-authentication-methods#authenticating-for-saml-sso) enabled. For more information about SCIM, see "[About SCIM for organizations](/enterprise-cloud@latest/organizations/managing-saml-single-sign-on-for-your-organization/about-scim-for-organizations)."
  - These endpoints cannot be used with an enterprise account or with an {% data variables.enterprise.prodname_emu_org %}.

{% endnote %}

### Authentication

You must authenticate as an owner of a {% data variables.product.product_name %} organization to use these endpoints. The REST API expects an [OAuth 2.0 Bearer](/developers/apps/authenticating-with-github-apps) token to be included in the `Authorization` header. If you use a {% data variables.product.pat_v1 %} for authentication, it must have the `admin:org` scope and you must also [authorize it for use with your SAML SSO organization](/github/authenticating-to-github/authorizing-a-personal-access-token-for-use-with-saml-single-sign-on).

### Mapping of SAML and SCIM data

{% data reusables.scim.nameid-and-username-must-match %}

### Supported SCIM User attributes

Name | Type | Description
-----|------|--------------
`userName`|`string` | The username for the user.
`name.givenName`|`string` | The first name of the user.
`name.familyName`|`string` | The last name of the user.
`emails` | `array` | List of user emails.
`externalId` | `string` | This identifier is generated by the SAML provider, and is used as a unique ID by the SAML provider to match against a GitHub user. You can find the `externalID` for a user either at the SAML provider, or using the [List SCIM provisioned identities](#list-scim-provisioned-identities) endpoint and filtering on other known attributes, such as a user's GitHub username or email address.
`id` | `string` | Identifier generated by the GitHub SCIM endpoint.
`active` | `boolean` | Used to indicate whether the identity is active (true) or should be deprovisioned (false).

{% note %}

**Note:** These endpoints are case sensitive. For example, the first letter in the `Users` endpoint must be capitalized:

```shell
GET /scim/v2/organizations/{org}/Users/{scim_user_id}
```

{% endnote %}
