---
title: Libraries
intro: 'You can use the official Octokit library and other third-party libraries to extend and simplify how you use the {% ifversion fpt or ghec %}{% data variables.product.prodname_dotcom %}{% else %}{% data variables.product.product_name %}{% endif %} API.'
redirect_from:
  - /libraries
  - /v3/libraries
versions:
  fpt: '*'
  ghes: '*'
  ghae: '*'
  ghec: '*'
topics:
  - API
---

![The Gundamcat](/assets/images/gundamcat.png)

## Octokit comes in many flavors

Use the official Octokit library, or choose between any of the available third party libraries.

- Ruby: [octokit.rb](https://github.com/octokit/octokit.rb)
- .NET: [octokit.net](https://github.com/octokit/octokit.net)
- JavaScript: [octokit.js](https://github.com/octokit/octokit.js). For more information, see "[Scripting with the REST API and JavaScript](/rest/guides/scripting-with-the-rest-api-and-javascript)."

## Third-party libraries

### Clojure

| Library name | Repository |
|---|---|
|**Tentacles**| [Raynes/tentacles](https://github.com/clj-commons/tentacles)|

### Dart

| Library name | Repository |
|---|---|
|**github.dart** | [SpinlockLabs/github.dart](https://github.com/SpinlockLabs/github.dart)|

### Emacs Lisp

| Library name | Repository |
|---|---|
|**gh.el**    | [sigma/gh.el](https://github.com/sigma/gh.el)|

### Erlang

| Library name | Repository |
|---|---|
|**octo-erl** | [sdepold/octo.erl](https://github.com/sdepold/octo.erl)|

### Go

| Library name | Repository |
|---|---|
|**go-github**| [google/go-github](https://github.com/google/go-github)|

### Haskell

| Library name | Repository |
|---|---|
|**haskell-github** | [fpco/Github](https://github.com/fpco/GitHub)|

### Java

| Library name | Repository | More information |
|---|---|---|
|**GitHub API for Java**| [org.kohsuke.github (From github-api)](http://github-api.kohsuke.org/)|defines an object oriented representation of the GitHub API.|
|**JCabi GitHub API**|[github.jcabi.com (Personal Website)](http://github.jcabi.com)|is based on Java7 JSON API (JSR-353), simplifies tests with a runtime GitHub stub, and covers the entire API.|

### JavaScript

| Library name | Repository |
|---|---|
|**NodeJS GitHub library**| [pksunkara/octonode](https://github.com/pksunkara/octonode)|
|**gh3 client-side API wrapper**| [k33g/gh3](https://github.com/k33g/gh3)|
|**Github.js wrapper around the GitHub API**|[michael/github](https://github.com/michael/github)|
|**Promise-Based CoffeeScript library for the Browser or NodeJS**|[philschatz/github-client](https://github.com/philschatz/github-client)|

### Julia

| Library name | Repository |
|---|---|
|**GitHub.jl**|[JuliaWeb/GitHub.jl](https://github.com/JuliaWeb/GitHub.jl)|

### OCaml

| Library name | Repository |
|---|---|
|**ocaml-github**|[mirage/ocaml-github](https://github.com/mirage/ocaml-github)|

### Perl

| Library name | Repository | metacpan Website for the Library |
|---|---|---|
|**Pithub**|[plu/Pithub](https://github.com/plu/Pithub)|[Pithub CPAN](http://metacpan.org/module/Pithub)|
|**Net::GitHub**|[fayland/perl-net-github](https://github.com/fayland/perl-net-github)|[Net:GitHub CPAN](https://metacpan.org/pod/Net::GitHub)|

### PHP

| Library name | Repository |
|---|---|
|**PHP GitHub API**|[KnpLabs/php-github-api](https://github.com/KnpLabs/php-github-api)|
|**GitHub Joomla! Package**|[joomla-framework/github-api](https://github.com/joomla-framework/github-api)|
|**GitHub bridge for Laravel**|[GrahamCampbell/Laravel-GitHub](https://github.com/GrahamCampbell/Laravel-GitHub)|

### PowerShell

| Library name | Repository |
|---|---|
|**PowerShellForGitHub**|[microsoft/PowerShellForGitHub](https://github.com/microsoft/PowerShellForGitHub)|

### Python

| Library name | Repository |
|---|---|
|**gidgethub**|[brettcannon/gidgethub](https://github.com/brettcannon/gidgethub)|
|**ghapi**|[fastai/ghapi](https://github.com/fastai/ghapi)|
|**PyGithub**|[PyGithub/PyGithub](https://github.com/PyGithub/PyGithub)|
|**libsaas**|[duckboard/libsaas](https://github.com/ducksboard/libsaas)|
|**github3.py**|[sigmavirus24/github3.py](https://github.com/sigmavirus24/github3.py)|
|**sanction**|[demianbrecht/sanction](https://github.com/demianbrecht/sanction)|
|**agithub**|[jpaugh/agithub](https://github.com/jpaugh/agithub)|
|**octohub**|[turnkeylinux/octohub](https://github.com/turnkeylinux/octohub)|
|**github-flask**|[github-flask (Official Website)](http://github-flask.readthedocs.org)|
|**torngithub**|[jkeylu/torngithub](https://github.com/jkeylu/torngithub)|
|**githubkit**|[yanyongyu/githubkit](https://github.com/yanyongyu/githubkit)|
|**octokit.py**|[khornberg/octokit.py](https://github.com/khornberg/octokit.py)|

### Ruby

| Library name | Repository |
|---|---|
|**GitHub API Gem**|[peter-murach/github](https://github.com/peter-murach/github)|
|**Ghee**|[rauhryan/ghee](https://github.com/rauhryan/ghee)|

### Rust

| Library name | Repository |
|---|---|
|**Octocrab**|[XAMPPRocky/octocrab](https://github.com/XAMPPRocky/octocrab)|
|**Octocat**|[octocat-rs/octocat-rs](https://github.com/octocat-rs/octocat-rs)|

### Scala

| Library name | Repository |
|---|---|
|**Hubcat**|[softprops/hubcat](https://github.com/softprops/hubcat)|
|**Github4s**|[47deg/github4s](https://github.com/47deg/github4s)|

### Shell

| Library name | Repository |
|---|---|
|**ok.sh**|[whiteinge/ok.sh](https://github.com/whiteinge/ok.sh)|
