---
title: GitHub REST API
shortTitle: REST API
intro: 'To create integrations, retrieve data, and automate your workflows, build with the {% data variables.product.prodname_dotcom %} REST API.'
introLinks:
  quickstart: /rest/quickstart
  overview: /rest/guides/getting-started-with-the-rest-api
featuredLinks:
  startHere:
    - /rest/guides/getting-started-with-the-rest-api
    - /rest/guides/basics-of-authentication
    - /rest/guides/best-practices-for-integrators
    - /rest/guides/using-pagination-in-the-rest-api
  popular:
    - /rest/overview/resources-in-the-rest-api
    - /rest/overview/api-versions
    - /rest/overview/other-authentication-methods
    - /rest/overview/troubleshooting
    - /rest/guides/scripting-with-the-rest-api-and-javascript
    - /rest/overview/openapi-description
  guideCards:
    - /rest/guides/delivering-deployments
    - /rest/guides/using-the-rest-api-to-interact-with-checks
    - /rest/guides/using-pagination-in-the-rest-api
changelog:
  label: 'api, apis'
layout: product-landing
redirect_from:
  - /v3
  - /rest/reference
versions:
  fpt: '*'
  ghes: '*'
  ghae: '*'
  ghec: '*'
children:
  - /quickstart
  - /overview
  - /guides
  - /actions
  - /activity
  - /announcement-banners
  - /apps
  - /billing
  - /branches
  - /checks
  - /codes-of-conduct
  - /code-scanning
  - /codespaces
  - /collaborators
  - /commits
  - /dependabot
  - /dependency-graph
  - /deploy-keys
  - /deployments
  - /emojis
  - /enterprise-admin
  - /gists
  - /git
  - /gitignore
  - /interactions
  - /issues
  - /licenses
  - /markdown
  - /meta
  - /metrics
  - /migrations
  - /oauth-authorizations
  - /orgs
  - /packages
  - /pages
  - /projects
  - /pulls
  - /rate-limit
  - /reactions
  - /releases
  - /repos
  - /scim
  - /search
  - /secret-scanning
  - /teams
  - /users
  - /webhooks
---

