---
title: SCIM
intro: Use the REST API to automate user creation and team memberships with SCIM.
versions:
  ghes: '>=3.6'
topics:
  - API
miniTocMaxHeadingLevel: 3
---

## About SCIM

{% data reusables.scim.ghes-beta-note %}

{% data reusables.user-settings.enterprise-admin-api-classic-pat-only %}

{% data variables.product.product_name %} provides endpoints for use by SCIM-enabled Identity Providers (IdPs). An integration on the IdP can use the REST API to automatically provision, manage, or deprovision user accounts on a {% data variables.product.product_name %} instance that uses SAML single sign-on (SSO) for authentication. For more information about SAML SSO, see "[About SAML for enterprise IAM](/admin/identity-and-access-management/using-saml-for-enterprise-iam/about-saml-for-enterprise-iam)."

These endpoints are based on SCIM 2.0. For more information, see the [specification](https://www.simplecloud.info/#Specification).

### Root URLs

An IdP can use the following root URL to communicate with the endpoints in this category for a {% data variables.product.product_name %} instance.

```
{% data variables.product.api_url_code %}/scim/v2/
```

Endpoints in this category are case-sensitive. For example, the first letter in the `Users` endpoint must be capitalized.

```shell
GET /scim/v2/Users/{scim_user_id}
```

### Authentication

The SCIM integration on the IdP performs actions on behalf of an enterprise owner for the {% data variables.product.product_name %} instance. For more information, see "[Roles in an enterprise](/admin/user-management/managing-users-in-your-enterprise/roles-in-an-enterprise#enterprise-owners)."

To authenticate API requests, the person who configures SCIM on the IdP must use a {% data variables.product.pat_v1 %} with `admin:enterprise` scope, which the IdP must provide in the request's `Authorization` header. For more information about {% data variables.product.pat_v1_plural %}, see "[Creating a {% data variables.product.pat_generic %}](/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token)".

{% note %}

**Note:** Enterprise owners must generate and use a {% data variables.product.pat_v1 %} for authentication of requests to endpoints in this category. {% ifversion ghes > 3.8 %}{% data variables.product.pat_v2_caps %} and {% endif %}GitHub app callers are not supported at this time.

{% endnote %}

### Mapping of SAML and SCIM data
  
The {% data variables.product.product_name %} instance links each user who authenticates successfully with SAML SSO to a SCIM identity. To link the identities successfully, the SAML IdP and the SCIM integration must use matching SAML `NameID` and SCIM `userName` values for each user.

{% ifversion ghes > 3.7 %}
{% note %}

**Note:** If the {% data variables.product.product_name %} uses Azure AD as a SAML IdP, {% data variables.product.product_name %} will also check the SCIM `externalId` claim and SAML `http://schemas.microsoft.com/identity/claims/objectidentifier` claim to match users first, instead of using `NameID` and `userName`.

{% endnote %}
{% endif %}

### Supported SCIM user attributes

`User` endpoints in this category support the following attributes within a request's parameters.

| Name | Type | Description |
| :- | :- | :- |
| `displayName` | String | Human-readable name for a user. |
| `name.formatted` | String | The user's full name, including all middle names, titles, and suffixes, formatted for display.
| `name.givenName` | String | The first name of the user. |
| `name.familyName` | String | The last name of the user. |
| `userName` | String | The username for the user, generated by the IdP. Undergoes [normalization](/admin/identity-and-access-management/managing-iam-for-your-enterprise/username-considerations-for-external-authentication#about-username-normalization) before being used. 
| `emails` | Array | List of the user's emails. |
| `roles` | Array | List of the user's roles. |
| `externalId` | String | This identifier is generated by an IdP provider. You can find the `externalId` for a user either on the IdP, or by using the [List SCIM provisioned identities](#list-scim-provisioned-identities-for-an-enterprise) endpoint and filtering on other known attributes, such as a user's username or email address on the {% data variables.product.product_name %} instance. |
| `id` | String | Identifier generated by the instance's SCIM endpoint. |
| `active` | Boolean | Indicates whether the identity is active (`true`) or should be suspended (`false`). |
