---
title: 'Archiving items from your {% data variables.projects.project_v2 %}'
shortTitle: Archiving items
intro: 'You can archive items, keeping them available to restore, or permanently delete them.'
miniTocMaxHeadingLevel: 2
versions:
  feature: projects-v2
type: tutorial
topics:
  - Projects
allowTitleToDifferFromFilename: true
---

## Archiving items

You can archive an item to keep the context about the item in the project but remove it from the project views. {% ifversion projects-v2-auto-archive %}You can also configure your project's built-in workflows to automatically archive items that meet certain criteria. For more information, see "[Archiving items automatically](/issues/planning-and-tracking-with-projects/automating-your-project/archiving-items-automatically)."{% endif %}

{% data reusables.projects.select-an-item %}
{% data reusables.projects.open-item-menu %}
1. Click **Archive**.
   ![Screenshot showing archive option](/assets/images/help/projects-v2/archive-menu-item.png)
1. When prompted, confirm your choice by clicking **Archive**.
   ![Screenshot showing archive prompt](/assets/images/help/projects-v2/archive-item-prompt.png)

## Restoring archived items

1. Navigate to your project.
1. In the top-right, click {% octicon "kebab-horizontal" aria-label="The menu icon" %} to open the menu.
  ![Screenshot showing the menu icon](/assets/images/help/projects-v2/open-menu.png)
1. In the menu, click {% octicon "archive" aria-label="The archive icon" %} **Archived items**.
  ![Screenshot showing the 'Archived items' menu item](/assets/images/help/projects-v2/archived-items-menu-item.png)
1. Optionally, to filter the archived items displayed, type your filter into the text box above the list of items. For more information about the available filters, see "[Filtering projects](/issues/planning-and-tracking-with-projects/customizing-views-in-your-project/filtering-projects)."
   ![Screenshot showing field for filtering archived items](/assets/images/help/issues/filter-archived-items.png)   
1. To the left of each item title, select the items you would like to restore.
   ![Screenshot showing checkboxes next to archived items](/assets/images/help/issues/select-archived-item.png)   
1. To restore the selected items, above the list of items, click **Restore**. 
   ![Screenshot showing the "Restore" button](/assets/images/help/issues/restore-archived-item-button.png)

## Deleting items

You can delete an item to remove it from the project entirely.

{% data reusables.projects.select-an-item %}
{% data reusables.projects.open-item-menu %}
1. Click **Delete from project**.
   ![Screenshot showing delete option](/assets/images/help/projects-v2/delete-menu-item.png)
1. When prompted, confirm your choice by clicking **Delete**.
   ![Screenshot showing delete prompt](/assets/images/help/projects-v2/delete-item-prompt.png)
