---
title: 'Copying an existing {% data variables.projects.project_v2 %}'
shortTitle: Copying a project
intro: You can use an existing project as a template by copying it.
miniTocMaxHeadingLevel: 3
versions:
  feature: projects-v2-copy-a-project
type: tutorial
topics:
  - Projects
allowTitleToDifferFromFilename: true
---

## About copying projects

You can copy an existing project and use it as a template to save time configuring your views and custom fields.

When you copy a project, the new project will contain the same views and custom fields. You also have the option to copy existing draft issues. The new project will not contain the original project's items, workflows, insights, collaborators, or team and repository links.

## Copying an existing project

1. Navigate to the project you want to copy.
1. In the top-right, click {% octicon "kebab-horizontal" aria-label="The menu icon" %} to open the menu.

  ![Screenshot showing the menu icon](/assets/images/help/projects-v2/open-menu.png)

1. In the menu, click {% octicon "copy" aria-label="The copy icon" %} **Make a copy**.

  ![Screenshot showing the 'Make a copy' menu item](/assets/images/help/projects-v2/make-a-copy.png)
  
1. Optionally, if you want all draft issues to be copied with the project, select **Include draft issues**.

  ![Screenshot showing the checkbox for including draft issues](/assets/images/help/projects-v2/copy-include-drafts.png)

1. In the dialog, under "Owner", select either the organization that will own the new project or your personal account.

  ![Screenshot showing the owner field](/assets/images/help/projects-v2/copy-owner.png)

1. Under "New project name", type the name of the new project.

  ![Screenshot showing the project name field](/assets/images/help/projects-v2/copy-name.png)

1. Click **Copy project**.

  ![Screenshot showing the "Copy project" button](/assets/images/help/projects-v2/copy-submit.png)
