---
title: Be social
redirect_from:
  - /be-social
  - /articles/be-social
  - /github/getting-started-with-github/be-social
  - /github/getting-started-with-github/quickstart/be-social
intro: 'You can interact with people, repositories, and organizations on {% data variables.product.prodname_dotcom %}. See what others are working on and who they are connecting with from your personal dashboard.'
permissions: '{% data reusables.enterprise-accounts.emu-permission-interact %}'
versions:
  fpt: '*'
  ghes: '*'
  ghae: '*'
  ghec: '*'
topics:
  - Profile
  - Pull requests
  - Issues
  - Notifications
  - Accounts
---
To learn about accessing your personal dashboard, see "[About your personal dashboard](/account-and-profile/setting-up-and-managing-your-personal-account-on-github/managing-personal-account-settings/about-your-personal-dashboard)."

## Following people

When you follow someone on {% data variables.product.prodname_dotcom %}, you will get notifications on your personal dashboard about their public activity. If someone you follow creates a new repository, stars a repository, or follows another user, the activity will display in your dashboard. 

Click **Follow** on a person's profile page to follow them.

![Follow user button](/assets/images/help/profile/follow-user-button.png)

For more information, see "[Following people](/get-started/exploring-projects-on-github/following-people)."

## Watching a repository

You can subscribe to a repository to watch it and receive notifications for activity in it. When the owner updates the repository, you will see the changes in your personal dashboard. For more information, see "[Viewing your subscriptions](/account-and-profile/managing-subscriptions-and-notifications-on-github/managing-subscriptions-for-activity-on-github/viewing-your-subscriptions)."

Click **Watch** at the top of a repository to watch it.

![Watch repository button](/assets/images/help/repository/repo-actions-watch.png)

## Joining the conversation

{% data reusables.support.ask-and-answer-forum %}

## Communicating on {% data variables.product.product_name %}

{% data variables.product.product_name %} provides built-in collaborative communication tools, allowing you to interact closely with your community when building great software. For example, you can contribute to another user's project by creating a pull request, or use issues to track bugs or suggest ideas in a repository. You can also brainstorm new ideas with your team with discussions. 

For an overview of these tools, see "[Quickstart for communicating on {% data variables.product.prodname_dotcom %}](/get-started/quickstart/communicating-on-github)."

## Participating in organizations

Organizations are shared accounts where businesses and open-source projects can collaborate across many projects at once. Owners and administrators can establish teams with special permissions, have a public organization profile, and keep track of activity within the organization. For more information, see "[About organizations](/organizations/collaborating-with-groups-in-organizations/about-organizations)."

From your dashboard, click the drop down menu of your username on the left side of your dashboard. Here, you can view organizations that you are a part of and easily switch between them.

![Switch account context dropdown](/assets/images/help/overview/dashboard-contextswitcher.png)

{% ifversion for-you-feed %}

## Following organizations

{% data reusables.organizations.follow-organizations-beta %}

{% data reusables.organizations.about-following-organizations %}

To follow an organization, in the header of the organization's page, click **Follow**.

![Screenshot of the organization header, with the follow button highlighted](/assets/images/help/profile/organization-profile-following.png)

For more information, see "[Following organizations](/get-started/exploring-projects-on-github/following-organizations)."

{% endif %}

## Exploring other projects on {% data variables.product.prodname_dotcom %}

You can discover new and interesting projects on {% data variables.product.prodname_dotcom %}'s Explore page. You can star interesting projects to make them easy to find again later. Visit your stars page to see all your starred projects. For more information about stars, see "[Saving repositories with stars](/get-started/exploring-projects-on-github/saving-repositories-with-stars)."

Your dashboard feed displays projects based on your interests including repositories you star, people you follow, and your contributions to public repositories. From your dashboard, you can see trending projects, view topics, and check out collections. 

To explore more projects, see "{% data variables.explore.explore_github %}".

## Next steps
You are now connected to the {% data variables.product.product_name %} community. There are other ways to interact and build within {% data variables.product.product_name %}.

* {% data reusables.getting-started.set-up-git %}

* {% data reusables.getting-started.create-a-repository %}

* {% data reusables.getting-started.fork-a-repository %}

* {% data reusables.getting-started.contributing-to-projects  %}

* {% data reusables.support.connect-in-the-forum-bootcamp %}
