---
title: Finding ways to contribute to open source on GitHub
intro: 'You can find ways to contribute to open source projects on {% data variables.location.product_location %} that are relevant to you.'
permissions: '{% data reusables.enterprise-accounts.emu-permission-interact %}'
redirect_from:
  - /articles/where-can-i-find-open-source-projects-to-work-on
  - /articles/finding-interesting-projects-on-github
  - /articles/about-official-github-mirrors
  - /articles/about-github-mirrors
  - /articles/finding-open-source-projects-on-github
  - /github/getting-started-with-github/finding-open-source-projects-on-github
  - /github/getting-started-with-github/finding-ways-to-contribute-to-open-source-on-github
  - /github/getting-started-with-github/exploring-projects-on-github/finding-ways-to-contribute-to-open-source-on-github
versions:
  fpt: '*'
  ghec: '*'
topics:
  - Open Source
shortTitle: Contribute to open source
---
## Discovering relevant projects

If there's a particular topic that interests you, visit `github.com/topics/<topic>`. For example, if you are interested in machine learning, you can find relevant projects and good first issues by visiting https://github.com/topics/machine-learning. You can browse popular topics by visiting [Topics](https://github.com/topics). You can also search for repositories that match a topic you're interested in. For more information, see "[Searching for repositories](/search-github/searching-on-github/searching-for-repositories#search-by-topic)."

If you've been active on {% data variables.location.product_location %}, you can find personalized recommendations for projects and good first issues based on your past contributions, stars, and other activities in [Explore](https://github.com/explore). You can also sign up for the Explore newsletter to receive emails about opportunities to contribute to {% data variables.product.product_name %} based on your interests. To sign up, see [Explore email newsletter](https://github.com/explore/subscribe).

Keep up with recent activity from repositories you watch, as well as people and organizations you follow, with your personal dashboard. For more information, see "[About your personal dashboard](/articles/about-your-personal-dashboard)."

{% data reusables.support.ask-and-answer-forum %}

## Finding good first issues

If you already know what project you want to work on, you can find beginner-friendly issues in that repository by visiting `github.com/<owner>/<repository>/contribute`. For an example, you can find ways to make your first contribution to `electron/electron` at https://github.com/electron/electron/contribute.

## Opening an issue

If you encounter a bug in an open source project, check if the bug has already been reported. If the bug has not been reported, you can open an issue to report the bug according to the project's contribution guidelines.

## Validating an issue or pull request

There are a variety of ways that you can contribute to open source projects.

### Reproducing a reported bug
You can contribute to an open source project by validating an issue or adding additional context to an existing issue. 

### Testing a pull request
You can contribute to an open source project by merging a pull request into your local copy of the project and testing the changes. Add the outcome of your testing in a comment on the pull request.

### Updating issues
You can contribute to an open source project by adding additional information to existing issues.


## Further reading

- "[Classifying your repository with topics](/articles/classifying-your-repository-with-topics)"
- "[About your organization dashboard](/articles/about-your-organization-dashboard)"
