---
title: About GitHub Marketplace
intro: '{% data variables.product.prodname_marketplace %} contains tools that add functionality and improve your workflow.'
redirect_from:
  - /articles/about-github-marketplace
  - /github/customizing-your-github-workflow/about-github-marketplace
  - /github/customizing-your-github-workflow/exploring-integrations/about-github-marketplace
versions:
  fpt: '*'
  ghec: '*'
---
You can discover, browse, and install free and paid tools, including {% data variables.product.prodname_github_apps %}, {% data variables.product.prodname_oauth_apps %}, and {% data variables.product.prodname_actions %}, in [{% data variables.product.prodname_marketplace %}](https://github.com/marketplace).

If you purchase a paid tool, you'll pay for your tool subscription with the same billing information you use to pay for your {% data variables.product.product_name %} subscription, and receive one bill on your regular billing date. For more information, see "[About billing for {% data variables.product.prodname_marketplace %}](/billing/managing-billing-for-github-marketplace-apps/about-billing-for-github-marketplace)."

You may also have the option to select a free 14-day trial on some tools. You can cancel at any time during your trial and you won't be charged, but you will automatically lose access to the tool. Your paid subscription will start at the end of the 14-day trial. For more information, see "[About billing for {% data variables.product.prodname_marketplace %}](/billing/managing-billing-for-github-marketplace-apps/about-billing-for-github-marketplace)."

## Finding tools on {% data variables.product.prodname_marketplace %}

You can discover, browse, and install apps and actions created by others on {% data variables.product.prodname_marketplace %}, see "[Searching {% data variables.product.prodname_marketplace %}](/search-github/searching-on-github/searching-github-marketplace)."

{% data reusables.actions.actions-not-verified %}

Anyone can list a free {% data variables.product.prodname_github_app %} or {% data variables.product.prodname_oauth_app %} on {% data variables.product.prodname_marketplace %}. Publishers of paid apps are verified by {% data variables.product.company_short %} and listings for these apps are shown with a marketplace badge {% octicon "verified" aria-label="Verified creator badge" %}. You will also see badges for unverified and verified apps. These apps were published using the previous method for verifying individual apps. For more information about the current process, see "[About GitHub Marketplace](/developers/github-marketplace/github-marketplace-overview/about-github-marketplace)" and "[Requirements for listing an app](/developers/github-marketplace/creating-apps-for-github-marketplace/requirements-for-listing-an-app)."

## Building and listing a tool on {% data variables.product.prodname_marketplace %}

For more information on creating your own tool to list on {% data variables.product.prodname_marketplace %}, see "[Apps](/developers/apps)" and "[{% data variables.product.prodname_actions %}](/actions)."

## Further reading

- "[Purchasing and installing apps in {% data variables.product.prodname_marketplace %}](/get-started/customizing-your-github-workflow/purchasing-and-installing-apps-in-github-marketplace)"
- "[Managing billing for {% data variables.product.prodname_marketplace %} apps](/billing/managing-billing-for-github-marketplace-apps)"
- "[{% data variables.product.prodname_marketplace %} support](/support/learning-about-github-support/github-marketplace-support)"
- "[Differences between GitHub Apps and OAuth Apps](/developers/apps/getting-started-with-apps/differences-between-github-apps-and-oauth-apps)"
