---
title: Quickstart for GitHub Educators
intro: 'In about 15 minutes, teachers can get started with discounts, training, and tools for {% data variables.product.company_short %}, then create a classroom for the students in a software development course using {% data variables.product.prodname_classroom %}.'
allowTitleToDifferFromFilename: true
versions:
  fpt: '*'
shortTitle: Quickstart
---

## Introduction

Educators who teach a course on software development can use discounts, partnerships, training, and tools from {% data variables.product.prodname_education %} to effectively teach relevant skills to students.

In this guide, you'll get started with {% data variables.product.product_name %}, sign up for accounts and discounted services through {% data variables.product.prodname_education %}, and create a space for your course and assignment on {% data variables.product.prodname_classroom %}.

{% tip %}

**Tip**: If you're a student and you'd like to take advantage of an academic discount, see "[Apply to {% data variables.product.prodname_global_campus %} as a student](/education/explore-the-benefits-of-teaching-and-learning-with-github-education/github-global-campus-for-students/apply-to-github-global-campus-as-a-student)."

{% endtip %}

## Creating accounts on {% data variables.product.product_name %}

First, you'll need to create a free personal account on {% data variables.product.product_name %}.

{% data reusables.accounts.create-account %}
1. Follow the prompts to create your free personal account.

After you create your personal account, create a free organization account. You'll use this organization account to create and manage classrooms {% data variables.product.prodname_classroom %}.

{% data reusables.user-settings.access_settings %}
{% data reusables.user-settings.organizations %}
{% data reusables.organizations.new-organization %}
4. Follow the prompts to create a free organization.

For more information, see "[Types of {% data variables.product.prodname_dotcom %} accounts](/github/getting-started-with-github/types-of-github-accounts)."

## Applying for teacher benefits

Next, you'll sign up for teacher benefits and resources from {% data variables.product.company_short %} by applying to {% data variables.product.prodname_global_campus %}, a portal that allows you to access your education benefits all in one place.  {% data reusables.education.educator-requirements %}

{% tip %}

**Tip** In addition to individual discounts, {% data variables.product.company_short %} offers partnerships with educational institutions through the {% data variables.product.prodname_campus_program %}. For more information, see the [{% data variables.product.prodname_campus_program %}](https://education.github.com/schools) website.

{% endtip %}

{% data reusables.education.benefits-page %}
{% data reusables.education.click-get-teacher-benefits %}
{% data reusables.education.select-email-address %}
{% data reusables.education.upload-proof-status %}
{% data reusables.education.school-name %}
{% data reusables.education.plan-to-use-github %}
{% data reusables.education.submit-application %}

Once you are a verified {% data variables.product.prodname_global_campus %} educator, you can access {% data variables.product.prodname_global_campus %} anytime by going to the [{% data variables.product.prodname_education %} website](https://education.github.com).

## Set up {% data variables.product.prodname_classroom %}

With your personal account and organization account, you're ready to get started with {% data variables.product.prodname_classroom %}. {% data variables.product.prodname_classroom %} is free to use. You can track and manage assignments, grade work automatically, and provide feedback to your students.

{% data reusables.classroom.sign-into-github-classroom %}
1. To authorize {% data variables.product.prodname_classroom %} to access your personal account on {% data variables.product.prodname_dotcom %}, review the information, then click **Authorize {% data variables.product.prodname_classroom %}**.
  !["Authorize {% data variables.product.prodname_classroom %}" button for personal account](/assets/images/help/classroom/setup-click-authorize-github-classroom.png)
1. Review the information. To authorize {% data variables.product.prodname_classroom %} to access your organization account on {% data variables.product.prodname_dotcom %}, click **Grant**.
  !["Grant" button for organization](/assets/images/help/classroom/setup-click-grant.png)
  
  {% tip %}
  
  **Tip**: If you see a **Request** button instead of a **Grant** button, you are a member of the organization, not an owner. An owner must approve your request for {% data variables.product.prodname_classroom %}. You must be an organization owner to create and manage classrooms and assignments in {% data variables.product.prodname_classroom %}. For more information, see "[Authorizing OAuth Apps](/github/authenticating-to-github/authorizing-oauth-apps#oauth-apps-and-organizations)."
  
  {% endtip %}
  
1. Click **Authorize github**.
  ![Click "Authorize" button for organization](/assets/images/help/classroom/setup-click-authorize-github.png)

## Create your classroom

{% data reusables.classroom.about-classrooms %}

{% data reusables.classroom.sign-into-github-classroom %}
1. Click **Create your first classroom** or **New classroom**.
{% data reusables.classroom.guide-create-new-classroom %}

## Next steps

You've created a classroom, and you're ready to enrich your course with {% data variables.product.product_name %} and {% data variables.product.prodname_classroom %}!  🎉

- Watch some videos about {% data variables.product.prodname_classroom %}. For more information, see "[Basics of setting up {% data variables.product.prodname_classroom %}](/education/manage-coursework-with-github-classroom/basics-of-setting-up-github-classroom)."
- Manage your classrooms and classroom admins, and create a roster of students for your classroom. For more information, see "[Manage classrooms](/education/manage-coursework-with-github-classroom/manage-classrooms)."
- Use the Git and {% data variables.product.company_short %} starter assignment to give students an overview of Git and {% data variables.product.product_name %} fundamentals. For more information, see "[Use the Git and {% data variables.product.company_short %} starter assignment](/education/manage-coursework-with-github-classroom/use-the-git-and-github-starter-assignment)."
- Create an assignment for individual students or teams. {% data reusables.classroom.for-more-information-about-assignment-creation %}
- Write and implement automated tests to provide immediate feedback to students directly in assignment repositories. For more information, see "[Use autograding](/education/manage-coursework-with-github-classroom/use-autograding)."
- Participate in {% data variables.product.prodname_education_community_with_url %}.
