---
title: Applying to be a GitHub Campus Expert
intro: 'As a student, you can apply to be a {% data variables.product.prodname_student_leader_program_singular %} to gain new skills and grow your college’s technical community.'
versions:
  fpt: '*'
shortTitle: Apply to Campus Experts
---

## Applying to the {% data variables.product.prodname_student_leader_program %} program

To apply to the {% data variables.product.prodname_student_leader_program %} program, you must first submit an application form, then submit a video resume. Applications to the program open in February and August, and you’ll have a full month to apply.

{% note %}

**Note:** The application process helps us get to know the applicant. Here are some things we want to learn about you:
- Motivation: What makes you tick? What drives you?
- Interest: Why do you want to be part of the program?
- Growth and potential: What skills do you want to learn, and how will they help you grow personally and professionally?
- Contribution: What impact do you want to make on your campus?

{% endnote %}

### Eligibility criteria

To become a {% data variables.product.prodname_student_leader_program_singular %}, you must:

- Be a {% data variables.product.prodname_dotcom %} user for at least six months.
- Be at least 18 years of age.
- Be enrolled in a post-secondary formal education institution.
- Have more than one year left as a student before graduating.
- Not be enrolled in the {% data variables.product.prodname_dotcom %} Campus Advisors Program.
- Validate your student status through the [{% data variables.product.prodname_student_pack %}](https://education.github.com/pack).

### Submitting your application form

In the application form, we’re looking for students to tell us about the challenges their student community faces, what opportunities they want to build for their peers, and the potential they see for growth.
1. Go to [https://education.github.com/experts](https://education.github.com/experts).
1. To learn if applications are open, click **Become a Campus Expert** {% octicon "arrow-right" aria-label="The right arrow icon" %}.
1. If applications are open, a new page will appear titled “Your journey starts here”. To start your application, click **Apply Now**.

  Otherwise, if applications are closed, a message will appear with the dates of the next application cycle.
1. Following the prompts in the form, complete the application.
1. Click **Submit Application**.
1. Optionally, to confirm your application was submitted successfully, check the email address you provided for an email confirming your submission.
1. Two weeks after the program applications close, check for an email containing an update on your application status and instructions to submit your video resume.

### Submitting your video resume

In your video resume, we look forward to getting to know you as an individual.

{% note %}

**Note:** A video using your webcam and computer microphone is more than enough! We understand this process might not be accessible to all students. If you require an alternative method to make your submission, please reach out to the GitHub Education team.

{% endnote %}

1. Open the email you received after submitting your application form.
1. Using the guidelines included in the application status email, record your video resume.
1. Once your video is ready to be submitted, click **Upload video** at the bottom of the application status email.
1. On the video submission form, add your email address and upload your video.
1. Click **Submit** at the bottom of the form to send your video in for review.

  After your video has been submitted, we’ll take about a week to review it. If the program is the right fit, you’ll be accepted and receive invitations to start the {% data variables.product.prodname_student_leader_program %} training and join an onboarding call.
