---
title: About GitHub Campus Program
intro: '{% data variables.product.prodname_campus_program %} offers {% data variables.product.prodname_ghe_cloud %} and {% data variables.product.prodname_ghe_server %} free-of-charge for schools that want to make the most of {% data variables.product.prodname_dotcom %} for their community.'
redirect_from:
  - /education/teach-and-learn-with-github-education/about-github-education
  - /github/teaching-and-learning-with-github-education/about-github-education
  - /articles/about-github-education
  - /education/explore-the-benefits-of-teaching-and-learning-with-github-education/about-github-education
  - /education/explore-the-benefits-of-teaching-and-learning-with-github-education/about-github-campus-program
  - /education/explore-the-benefits-of-teaching-and-learning-with-github-education/use-github-at-your-educational-institution/about-campus-advisors
versions:
  fpt: '*'
shortTitle: GitHub Campus Program
---
{% data variables.product.prodname_campus_program %} is a package of premium {% data variables.product.prodname_dotcom %} access for teaching-focused institutions that grant degrees, diplomas, or certificates. {% data variables.product.prodname_campus_program %} includes:

- No-cost access to {% data variables.product.prodname_ghe_cloud %} and {% data variables.product.prodname_ghe_server %} for all of your technical and academic departments
- 50,000 {% data variables.product.prodname_actions %} minutes and 50 GB {% data variables.product.prodname_registry %} storage
- Teacher training to master Git and {% data variables.product.prodname_dotcom %}
- Exclusive access to new features, GitHub Education-specific swag, and free developer tools from {% data variables.product.prodname_dotcom %} partners
- Automated access to premium {% data variables.product.prodname_education %} features, like the {% data variables.product.prodname_student_pack %}

To read about how GitHub is used by educators, see [GitHub Education stories](https://education.github.com/stories).

## {% data variables.product.prodname_campus_program %} terms and conditions

- The license is free for one year and will automatically renew for free every 2 years. You may continue on the free license so long as you continue to operate within the terms of the agreement. Any school that can agree to the [terms of the program](https://education.github.com/schools/terms) is welcome to join.

- Please note that the licenses are for use by the whole school. Internal IT departments, academic research groups, collaborators, students, and other non-academic departments are eligible to use the licenses so long as they are not making a profit from its use. Externally funded research groups that are housed at the university may not use the free licenses.

- You must offer {% data variables.product.prodname_dotcom %} to all of your technical and academic departments and your school’s logo will be shared on the GitHub Education website as a {% data variables.product.prodname_campus_program %} Partner.

- New organizations in your enterprise are automatically added to your enterprise account. To add organizations that existed before your school joined the {% data variables.product.prodname_campus_program %}, please contact [GitHub Education Support](https://support.github.com/contact/education). For more information about administrating your enterprise, see the [enterprise administrators documentation](/admin). New organizations in your enterprise are automatically added to your enterprise account. To add organizations that existed before your school joined the {% data variables.product.prodname_campus_program %}, please contact GitHub Education Support. 

To read more about {% data variables.product.prodname_dotcom %}'s privacy practices, see "[GitHub Privacy Statement](/github/site-policy/github-privacy-statement)."

## {% data variables.product.prodname_campus_program %} Application Eligibility

- Often times, a campus CTO/CIO, Dean, Department Chair, or Technology Officer signs the terms of the program on behalf of the campus.

- If your school does not issue email addresses, {% data variables.product.prodname_dotcom %} will reach out to your account administrators with an alternative option to allow you to distribute the student developer pack to your students.

For more information, see the [official {% data variables.product.prodname_campus_program %}](https://education.github.com/schools) page.

If you're a student or academic faculty and your school isn't partnered with {% data variables.product.prodname_dotcom %} as a {% data variables.product.prodname_campus_program %} school, then you can still individually apply for discounts to use {% data variables.product.prodname_dotcom %}. To apply for the Student Developer Pack, [see the application form](https://education.github.com/pack/join).

