---
title: Apply to GitHub Global Campus as a student
intro: 'As a student, you can apply to join {% data variables.product.prodname_global_campus %} and receive access to the student resources and benefits offered by {% data variables.product.prodname_education %}'
redirect_from:
  - /education/teach-and-learn-with-github-education/apply-for-a-student-developer-pack
  - /github/teaching-and-learning-with-github-education/applying-for-a-student-developer-pack
  - /articles/applying-for-a-student-developer-pack
  - /education/explore-the-benefits-of-teaching-and-learning-with-github-education/apply-for-a-student-developer-pack
  - /education/explore-the-benefits-of-teaching-and-learning-with-github-education/use-github-for-your-schoolwork/apply-for-a-student-developer-pack
versions:
  fpt: '*'
shortTitle: Apply to Global Campus
---
{% data reusables.education.about-github-education-link %}

## Requirements

To be eligible for {% data variables.product.prodname_global_campus %}, including {% data variables.product.prodname_student_pack %} and other benefits, you must:
- Be currently enrolled in a degree or diploma granting course of study such as a high school, secondary school, college, university, homeschool, or similar educational institution
- Have a verifiable school-issued email address or upload documents that prove your current student status
- Have a [{% data variables.product.prodname_dotcom %} personal account](/articles/signing-up-for-a-new-github-account)
- Be at least 13 years old

Documents that prove your current student status include a picture of your school ID with current enrollment date, class schedule, transcript, and affiliation or enrollment verification letter.

During your tenure as a student, you may be prompted to periodically re-verify your current academic status.

{% note %}

**Note:** You cannot transfer academic discounts from one account to another. If you have more than one account you want to apply the discount to, consider [merging](/articles/merging-multiple-user-accounts) your personal accounts and [renaming](/articles/changing-your-github-username) the retained account if desired.

{% endnote %}

For information about renewing your {% data variables.product.prodname_global_campus %} access, see "[Expiration and renewals](/education/explore-the-benefits-of-teaching-and-learning-with-github-education/github-global-campus-for-students/apply-to-github-global-campus-as-a-student/#expiration-and-renewals)."

## Applying to {% data variables.product.prodname_global_campus %}

{% data reusables.education.benefits-page %}
1. Under "Individuals", click **Get student benefits**.
  !["Get student benefits" on {% data variables.product.prodname_education %} homepage](/assets/images/help/education/click-get-student-benefits.png)
1. Under "Select the academic status", select **Student**.
  ![Select academic status](/assets/images/help/education/academic-status-student.png)
{% data reusables.education.select-email-address %}
{% data reusables.education.school-name %}
{% data reusables.education.plan-to-use-github %}
{% data reusables.education.upload-proof-status %}
{% data reusables.education.submit-application %}

## Expiration and renewals

Once your {% data variables.product.prodname_global_campus %} access expires, you may reapply if you're still eligible, although some of our partner offers for {% data variables.product.prodname_student_pack %} cannot renew. Most of the timed offers from our partners start once you set them up. To reapply, simply return to https://education.github.com, click your profile picture, then click **Reverify your academic affiliation**.

![Menu option to reverify your academic affiliation](/assets/images/help/education/reverify-academic-affiliation.png)

For more information, see the [{% data variables.product.prodname_student_pack %}](https://education.github.com/pack) page.

To see when your free access to the {% data variables.product.prodname_student_pack %} expires, visit your account's [billing settings](https://github.com/settings/billing).

## Further reading

- "[Why wasn't my application for a {% data variables.product.prodname_student_pack %} approved?](/articles/why-wasn-t-my-application-for-a-student-developer-pack-approved)"
- "[Signing up for a new {% data variables.product.prodname_dotcom %} account](/articles/signing-up-for-a-new-github-account)"
- [{% data variables.product.prodname_education %}](https://education.github.com)
