---
title: About GitHub Copilot
intro: '{% data variables.product.prodname_copilot %} can help you code by offering autocomplete-style suggestions. You can learn how {% data variables.product.prodname_copilot %} works, and what to consider while using {% data variables.product.prodname_copilot %}.'
versions:
  feature: copilot
topics:
  - Copilot
shortTitle: About GitHub Copilot
---

## About {% data variables.product.prodname_copilot %}

{% data variables.product.prodname_copilot %} is an AI pair programmer that offers autocomplete-style suggestions as you code. You can receive suggestions from {% data variables.product.prodname_copilot %} either by starting to write the code you want to use, or by writing a natural language comment describing what you want the code to do. {% data variables.product.prodname_copilot %} analyzes the context in the file you are editing, as well as related files, and offers suggestions from within your text editor. {% data variables.product.prodname_copilot %} is powered by OpenAI Codex, a new AI system created by OpenAI.

{% data variables.product.prodname_copilot %} is trained on all languages that appear in public repositories. For each language, the quality of suggestions you receive may depend on the volume and diversity of training data for that language. For example, JavaScript is well-represented in public repositories and is one of {% data variables.product.prodname_copilot %}'s best supported languages. Languages with less representation in public repositories may produce fewer or less robust suggestions.

{% data variables.product.prodname_copilot %} is available as an extension in Visual Studio Code, Visual Studio, Neovim and the JetBrains suite of IDEs. For more information, see "[Getting started with {% data variables.product.prodname_copilot %}](/copilot/getting-started-with-github-copilot)."

## Using {% data variables.product.prodname_copilot %}

You can see real-world examples of {% data variables.product.prodname_copilot %} in action. For more information, see the [{% data variables.product.prodname_copilot %}](https://copilot.github.com/) website.

{% data variables.product.prodname_copilot %} offers suggestions from a model that OpenAI built from billions of lines of open source code. As a result, the training set for {% data variables.product.prodname_copilot %} may contain insecure coding patterns, bugs, or references to outdated APIs or idioms. When {% data variables.product.prodname_copilot %} produces suggestions based on this training data, those suggestions may also contain undesirable patterns.

You are responsible for ensuring the security and quality of your code. We recommend you take the same precautions when using code generated by {% data variables.product.prodname_copilot %} that you would when using any code you didn't write yourself. These precautions include rigorous testing, IP scanning, and tracking for security vulnerabilities. {% data variables.product.company_short %} provides a number of features to help you monitor and improve code quality, such as {% data variables.product.prodname_actions %}, {% data variables.product.prodname_dependabot %}, {% data variables.product.prodname_codeql %} and {% data variables.product.prodname_code_scanning %}. All these features are free to use in public repositories. For more information, see "[Understanding {% data variables.product.prodname_actions %}](/actions/learn-github-actions/understanding-github-actions)" and "[{% data variables.product.company_short %} security features](/code-security/getting-started/github-security-features)."

{% data variables.product.prodname_copilot %} uses filters to block offensive words in the prompts and avoid producing suggestions in sensitive contexts. We are committed to constantly improving the filter system to more intelligently detect and remove offensive suggestions generated by {% data variables.product.prodname_copilot %}, including biased, discriminatory, or abusive outputs. If you see an offensive suggestion generated by {% data variables.product.prodname_copilot %}, please report the suggestion directly to copilot-safety@github.com so that we can improve our safeguards.

## About billing for {% data variables.product.prodname_copilot %}

{% data variables.product.prodname_copilot %} is a paid feature, requiring a monthly or yearly subscription. {% data variables.product.prodname_copilot %} subscriptions can be paid for and managed through a personal account on {% data variables.product.prodname_dotcom_the_website %} with {% data variables.product.prodname_copilot_for_individuals %}, or paid for and managed centrally through an enterprise account on {% data variables.product.prodname_ghe_cloud %} with {% data variables.product.prodname_copilot_for_business %}.

Verified students, teachers, and maintainers of popular open source projects on {% data variables.product.prodname_dotcom %} are eligible to use {% data variables.product.prodname_copilot_individuals_short %} for free. If you meet the criteria for a free {% data variables.product.prodname_copilot_individuals_short %} subscription, you will be automatically notified when you visit the {% data variables.product.prodname_copilot %} subscription page. {% ifversion fpt %}If you do not meet the criteria for a free {% data variables.product.prodname_copilot_individuals_short %} subscription, you will be offered a 60-day free trial, after which a paid subscription is required for continued use. {% data variables.product.prodname_copilot_for_business %} does not include a free trial.{% endif %} For more information, see "[About billing for {% data variables.product.prodname_copilot %}](/billing/managing-billing-for-github-copilot/about-billing-for-github-copilot)."

## About the license for the {% data variables.product.prodname_copilot %} plugin in JetBrains IDEs

{% data variables.product.prodname_dotcom %}, Inc. is the licensor of the JetBrains plugin. The end user license agreement for this plugin is the [{% data variables.product.prodname_dotcom %} Terms for Additional Products and Features](/free-pro-team@latest/site-policy/github-terms/github-terms-for-additional-products-and-features#github-copilot) and use of this plugin is subject to those terms. JetBrains has no responsibility or liability in connection with the plugin or such agreement. By using the plugin, you agree to the foregoing terms.

## Further reading

- "[{% data variables.product.company_short %} Terms for Additional Products and Features](/free-pro-team@latest/site-policy/github-terms/github-terms-for-additional-products-and-features#github-copilot)"{% ifversion ghec %}
- "[{% data variables.product.prodname_copilot_for_business %} Privacy Statement](/free-pro-team@latest/site-policy/privacy-policies/github-copilot-for-business-privacy-statement)"{% endif %}
