---
title: Configuring private vulnerability reporting for a repository
intro: Owners and administrators of public repositories can allow security researchers to report vulnerabilities securely in the repository by enabling private vulnerability reporting.
permissions: Anyone with admin permissions to a public repository can enable and disable private vulnerability reporting for the repository.
versions:
  fpt: '*'
  ghec: '*'
type: how_to
miniTocMaxHeadingLevel: 3
topics:
  - Security advisories
  - Vulnerabilities
shortTitle: Configure for a repository
---

{% data reusables.security-advisory.private-vulnerability-reporting-beta %}

## About privately reporting a security vulnerability

Security researchers often feel responsible for alerting users to a vulnerability that could be exploited. If there are no clear instructions about contacting maintainers of the repository containing the vulnerability, security researchers may have no other choice but to post about the vulnerability on social media, send direct messages to the maintainer, or even create public issues. This situation can potentially lead to a public disclosure of the vulnerability details.

{% data reusables.security-advisory.private-vulnerability-reporting-overview %}

For maintainers, the benefits of using private vulnerability reporting are: 
{% data reusables.security-advisory.private-vulnerability-reporting-benefits %}

The instructions in this article refer to enablement at repository level. For information about enabling the feature at organization level, see "[Configuring private vulnerability reporting for an organization](/code-security/security-advisories/repository-security-advisories/configuring-private-vulnerability-reporting-for-an-organization)."

## Enabling or disabling private vulnerability reporting for a repository

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.sidebar-settings %}
{% data reusables.repositories.navigate-to-code-security-and-analysis %}
1. Under "Code security and analysis", to the right of "Private vulnerability reporting", click **Enable** or **Disable**, to enable or disable the feature, respectively.

 ![Screenshot of the "Code security and analysis" page with the "Enable" button emphasized for private vulnerability reporting](/assets/images/help/security/private-vulnerability-reporting-enable-or-disable-repo.png)

{% data reusables.security-advisory.private-vulnerability-reporting-security-researcher %}
