---
title: Troubleshooting a declined credit card charge
intro: 'If the credit card you use to pay for {% data variables.product.product_name %} is declined, you can take several steps to ensure that your payments go through and that you are not locked out of your account.'
redirect_from:
  - /github/setting-up-and-managing-billing-and-payments-on-github/troubleshooting-a-declined-credit-card-charge
  - /articles/what-do-i-do-if-my-card-is-declined
  - /articles/troubleshooting-a-declined-credit-card-charge
  - /github/setting-up-and-managing-billing-and-payments-on-github/managing-your-github-billing-settings/troubleshooting-a-declined-credit-card-charge
versions:
  fpt: '*'
  ghec: '*'
type: how_to
topics:
  - Troubleshooting
shortTitle: Declined credit card charge
---
If your card is declined, we'll send you an email about why the payment was declined. You'll have a few days to resolve the problem before we try charging you again.

## Check your card's expiration date

If your card has expired, you'll need to update your account's payment information. For more information, see "[Adding or editing a payment method](/articles/adding-or-editing-a-payment-method)."

## Verify your bank's policy on card restrictions

Some international banks place restrictions on international, e-commerce, and automatically recurring transactions. If you're having trouble making a payment with your international credit card, call your bank to see if there are any restrictions on your card.

We also support payments through PayPal. For more information, see "[Adding or editing a payment method](/articles/adding-or-editing-a-payment-method)."

## Contact your bank for details about the transaction

Your bank can provide additional information about declined payments if you specifically ask about the attempted transaction. If there are restrictions on your card and you need to call your bank, provide this information to your bank:

- **The amount you're being charged.** The amount for your subscription appears on your account's receipts. For more information, see "[Viewing your payment history and receipts](/articles/viewing-your-payment-history-and-receipts)."
- **The date when {% data variables.product.product_name %} bills you.** Your account's billing date appears on your receipts.
- **The transaction ID number.** Your account's transaction ID appears on your receipts.
- **The merchant name.** The merchant name is {% data variables.product.prodname_dotcom %}.
- **The error message your bank sent with the declined charge.** You can find your bank's error message on the email we send you when a charge is declined.
