---
title: One-time payments for customers in India
intro: Customers in India who have been impacted by the Reserve Bank of India's recurring payment regulation can now make one-time payments for their GitHub subscriptions and services.
redirect_from:
  - /early-access/billing/india-rbi-regulation
versions:
  fpt: '*'
  ghec: '*'
topics:
  - Billing
  - Sponsors
  - Policy
shortTitle: India one-time payments
---


## About the Reserve Bank of India's recurring payments regulation

A new payments regulation from the Reserve Bank of India (RBI) recently came into effect. This regulation places additional requirements on recurring online transactions and has prevented some {% data variables.product.company_short %} customers in India from making recurring payments. Customers using payment methods issued in India for any recurring transactions on {% data variables.product.product_name %} may find that their payments are declined by their banks or card issuers. For more information, see [the RBI's press release](https://www.rbi.org.in/Scripts/BS_PressReleaseDisplay.aspx?prid=51353).

The regulation applies to all recurring transactions, including:
- {% data variables.product.prodname_dotcom %} plan subscriptions (Pro, Team, Enterprise)
- {% data variables.product.prodname_marketplace %} purchases
- {% data variables.product.prodname_sponsors %} transactions
- Git Large File Storage purchases
- {% data variables.product.prodname_actions %}, {% data variables.product.prodname_registry %}, and {% data variables.product.prodname_github_codespaces %} consumption

In order to minimize disruption, recurring payments for our affected customers were paused on October 29th, 2021. Paid features and services have remained available to customers impacted by the RBI regulation.

## About one-time payments on {% data variables.product.company_short %}

As we work with our payment gateway provider to meet the new requirements, we are providing a temporary one-time payment option for impacted customers in India. From February 15th 2022, {% data variables.product.company_short %} customers in India who have been affected by the new RBI regulation will be able to make one-time payments on their regular billing cycle cadence.

### For customers on monthly billing

Customers on monthly billing plans will be able to make a one-time payment on the same day their billing cycle usually renews. For example, if you're usually billed on the 7th of each month, you will now be able to make a one-time payment from your account from the 7th of each month. Your first one-time payment will also include any accrued usage from October 2021 onwards.

If you are currently billed monthly, and would like to switch to yearly billing, you can reduce the frequency of your one-time payments. For more information, see "[Changing the duration of your billing cycle](/billing/managing-your-github-billing-settings/changing-the-duration-of-your-billing-cycle)."

### For customers on yearly billing

If you are billed yearly, and your renewal date was between October 1st, 2021 and February 14th, 2022, you will be able to make a one-time payment for your annual subscriptions from February 15th. This initial payment will include the prorated outstanding cost of your subscription for the period since your previous billing cycle ended.

If your billing cycle is due to renew after February 15th, we will attempt to take the recurring payment. If the payment attempt is declined, you will then be able to make a one-time payment through your account's billing page.

In the meantime, we are actively working with our payment partners to restore recurring payments for impacted customers. For more information or questions, you can contact [GitHub Support](https://support.github.com/contact).

### Impact to {% data variables.product.prodname_sponsors %}

Existing sponsorships will remain in place during this period and maintainers will continue to be paid out as expected. Payments for the accrued sponsorship amounts from the funding account will be collected at the same time as other accrued charges.

## Making a one-time payment for a GitHub subscription

{% note %}

**Note**: Affected customers will receive an email notification with a link to their billing settings when payment is due. Two further reminder emails will be sent 7 and 14 days later if payment has not been made. After 14 days, paid features and services will be locked until payment is made.

{% endnote %}

{% data reusables.user-settings.access_settings %}
{% data reusables.user-settings.billing_plans %}
3. At the top of the page, click **Pay now**.
  ![One-time payment pay now button](/assets/images/help/billing/pay-now-button.png)
4. Review your billing and payment information. If you need to make an edit, click **Edit** next to the relevant section. Otherwise, click **Submit payment**.
  ![One-time payment summary](/assets/images/help/billing/payment-summary.png)
5. Optionally, if you clicked **Edit**, make any necessary changes, and then click **Submit payment**.
  ![One-time payment edit summary](/assets/images/help/billing/payment-summary-edit.png)
6. Once payment for the current billing cycle has been successfully made, the **Pay now** button on your "Billing & plans" page will be disabled until your next payment is due.
  ![One-time payment pay now button disabled](/assets/images/help/billing/pay-now-button-disabled.png)
