---
title: How does upgrading or downgrading affect the billing process?
intro: 'When you upgrade the subscription for your personal account or organization, changes are applied immediately. When you downgrade your subscription, changes are applied at the end of your current billing cycle.'
redirect_from:
  - /github/setting-up-and-managing-billing-and-payments-on-github/how-does-upgrading-or-downgrading-affect-the-billing-process
  - /articles/how-does-upgrading-or-downgrading-affect-the-billing-process
  - /github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-your-github-account/how-does-upgrading-or-downgrading-affect-the-billing-process
versions:
  fpt: '*'
  ghec: '*'
type: how_to
topics:
  - Fundamentals
  - Organizations
  - Upgrades
  - User account
shortTitle: Billing process
---
Changes to your paid personal account or organization subscription does not affect subscriptions or payments for other paid {% data variables.product.prodname_dotcom %} features, such as {% data variables.large_files.product_name_long %} or paid apps purchased in {% data variables.product.prodname_marketplace %}.

For more information, see "[{% data variables.product.prodname_dotcom %}'s products](/articles/github-s-products)" and "[About billing on {% data variables.product.prodname_dotcom %}](/articles/about-billing-on-github)."

## Example of canceling a paid subscription for a personal account or organization

Kumiko pays for a monthly subscription on the 5th of every month. If Kumiko downgrades from the paid subscription to {% data variables.product.prodname_free_user %} on October 10th, her paid subscription will remain in effect until the end of her current billing cycle on November 4th. On November 5th, her account will move to {% data variables.product.prodname_free_user %}.

## Example of changing from a yearly to a monthly subscription for a personal account or organization

Ravi pays for a yearly subscription on October 5th every year. If Ravi switches from a yearly to monthly billing on December 10th, his account remains on the yearly subscription until the end of its current billing cycle on October 4th the next year. On October 5th of the next year, Ravi will be charged for a month of service. His next billing date will be November 5th.

## Example of adding paid seats to your organization

Mada's organization pays for 25 seats on the 15th of every month. If Mada adds ten paid seats on June 4th, her organization is immediately charged a prorated amount for ten additional seats for the time between June 4th and June 14th, and the seats are available to use immediately. On June 15th, Mada's organization will pay for 35 seats.

## Example of removing paid seats from your organization

Stefan's organization pays for 50 seats every year on May 20th. If Stefan removes 20 seats and downgrades to a new total of 30 paid seats on September 30, his organization can still access its 50 paid seats until the end of its current billing cycle on May 19th. On May 20th, the downgrade will take effect - Stefan's organization will pay for 30 seats and will have access to 30 paid seats.

## Further reading

- "[Managing billing for your {% data variables.product.prodname_dotcom %} account](/articles/managing-billing-for-your-github-account)"
- "[Managing billing for {% data variables.product.prodname_marketplace %} apps](/articles/managing-billing-for-github-marketplace-apps)"
- "[Managing billing for {% data variables.large_files.product_name_long %}](/articles/managing-billing-for-git-large-file-storage)"
- "[About per-user pricing](/articles/about-per-user-pricing)"
