---
title: About GitHub AE
intro: '{% data variables.product.prodname_ghe_managed %} is a security-enhanced and compliant way to use {% data variables.product.prodname_dotcom %} in the cloud.'
versions:
  ghae: '*'
type: overview
topics:
  - Enterprise
  - Fundamentals
---

## About {% data variables.product.prodname_ghe_managed %}

{% data reusables.github-ae.github-ae-enables-you %} {% data variables.product.prodname_ghe_managed %} is fully managed, reliable, and scalable, allowing you to accelerate delivery while improving your risk and compliance posture.

{% data variables.product.prodname_ghe_managed %} offers one developer platform from idea to production. You can increase development velocity with the tools that teams know and love, while you maintain industry and regulatory compliance with security and access controls, workflow automation, and policy enforcement. 

## A highly available and planet-scale cloud

{% data variables.product.prodname_ghe_managed %} is a fully managed service, hosted in a high availability architecture. {% data variables.product.prodname_ghe_managed %} is hosted globally in a cloud that can scale to support your full development lifecycle without limits. {% data variables.product.prodname_dotcom %} fully manages backups, failover, and disaster recovery, so you never need to worry about your service or data. 

## Data residency

All of your data is stored within the geographic region of your choosing. You can comply with GDPR data residency requirements and global data protection standards by keeping all of your data within your chosen region.

## Isolated accounts

By default, all developer accounts on {% data variables.product.product_name %} are fully isolated from other services, including products from {% data variables.product.company_short %}. You can control the accounts through your identity provider, with SAML single sign-on as mandatory. SCIM enables you to ensure that employees only have access to the resources they should, as defined in your central identity management system. For more information, see "[Managing identity and access for your enterprise](/admin/authentication/managing-identity-and-access-for-your-enterprise)."

Optionally, enterprise owners can enable limited integration between {% data variables.product.product_name %} and {% data variables.product.prodname_dotcom_the_website %}. For more information, see "[About {% data variables.product.prodname_github_connect %}](/admin/configuration/configuring-github-connect/about-github-connect)."

## Restricted network access

Secure access to your enterprise on {% data variables.product.prodname_ghe_managed %} with restricted network access, so that your data can only be accessed from within your network. For more information, see "[Restricting network traffic to your enterprise with an IP allow list](/admin/configuration/configuring-your-enterprise/restricting-network-traffic-to-your-enterprise-with-an-ip-allow-list)."

## Commercial and government environments

{% data variables.product.prodname_ghe_managed %} is available in the Azure Government cloud, the trusted cloud for US government agencies and their partners. {% data variables.product.prodname_ghe_managed %} is also available in the commercial cloud, so you can choose the hosting environment that is right for your organization.

## Compliance accreditations

{% data variables.product.company_short %} continues to invest in security best practices to make sure your data is safe, your developers are productive, and your team can focus on solving problems. As part of that commitment to security, {% data variables.product.prodname_ghe_managed %} maintains compliance with the following accreditations.

- FedRAMP High Authorization to Operate (ATO)
- SOC 1, SOC 2 Type II, and SOC 3
- ISO/IEC certifications
   - ISO/IEC 27001:2013 
   - ISO/IEC 27701:2019
   - ISO/IEC 9001:2015
   - ISO/IEC 22301:2019 
   - ISO/IEC 27018:2014 
   - ISO/IEC 20000-1:2018 
   - ISO/IEC 27017:2015

## Further reading

- "[About versions of {% data variables.product.prodname_docs %}](/get-started/learning-about-github/about-versions-of-github-docs)"
- "[Receiving help from {% data variables.product.company_short %} Support](/admin/enterprise-support/receiving-help-from-github-support)"
