---
title: Enabling GitHub Actions with Google Cloud Storage
intro: 'You can enable {% data variables.product.prodname_actions %} on {% data variables.product.prodname_ghe_server %} and use Google Cloud Storage to store data generated by workflow runs.'
permissions: 'Site administrators can enable {% data variables.product.prodname_actions %} and configure enterprise settings.'
versions:
  feature: actions-ghes-gcp-storage
type: how_to
topics:
  - Actions
  - Enterprise
  - Infrastructure
  - Storage
shortTitle: Google Cloud Storage
miniTocMaxHeadingLevel: 3
---

{% note %}

**Note:** {% data variables.product.prodname_actions %} support for Google Cloud Storage is currently in beta and subject to change.

{% endnote %}

{% data reusables.actions.enterprise-storage-about %}

{% ifversion ghes-actions-storage-oidc %}
{% data reusables.actions.enterprise-storage-about-oidc %}

{% data reusables.actions.ghes-storage-oidc-beta-note %}
{% endif %}

## Prerequisites

Before enabling {% data variables.product.prodname_actions %}, make sure you have completed the following steps:

* Create your Google Cloud Storage bucket for storing data generated by workflow runs.
{% data reusables.actions.enterprise-common-prereqs %}
{% data reusables.actions.enterprise-oidc-prereqs %}

{% ifversion ghes-actions-storage-oidc %}
## Enabling {% data variables.product.prodname_actions %} with Google Cloud Storage using OIDC (recommended)

{% data reusables.actions.ghes-storage-oidc-beta-note %}

To configure {% data variables.product.prodname_ghe_server %} to use OIDC with Google Cloud Storage, you must first create a Google Cloud service account, then create a Google Cloud identity pool and identity provider, and finally configure {% data variables.product.prodname_ghe_server %} to use the provider and service account to access your Google Cloud Storage bucket.

### 1. Create a service account

1. Create a service account that can access your bucket using OIDC. For more information, see [Creating and managing service accounts](https://cloud.google.com/iam/docs/creating-managing-service-accounts) in the Google Cloud documentation.

   When creating the service account, ensure that you do the following:

   * Enable the IAM API as described at the start of [Creating and managing service accounts](https://cloud.google.com/iam/docs/creating-managing-service-accounts).
   * Add the following roles to the service account:
     * Service Account Token Creator
     * Storage Object Admin
1. After creating the service account, note its email address, as it is need later. The service account email address is in the format `SERVICE-ACCOUNT-NAME@PROJECT-NAME.iam.gserviceaccount.com`.

### 2. Create an identity pool and identity provider

1. In the Google Cloud console, go to the [New workload provider and pool](https://console.cloud.google.com/iam-admin/workload-identity-pools/create) page.
1. Under "Create an identity pool", enter a name for the identity pool, and click **Continue**.
1. Under "Add a provider to pool":

   - For "Select a provider", select **OpenID Connect (OIDC)**.
   - For "Provider name", enter a name for the provider.
   - For "Issuer (URL)", enter the following URL, replacing `HOSTNAME` with the public hostname for {% data variables.location.product_location_enterprise %}:

      ```
      https://HOSTNAME/_services/token
      ```

      For example:

      ```
      https://my-ghes-host.example.com/_services/token
      ```
    - Under "Audiences", leave **Default audience** selected, but note the identity provider URL, as it is needed later. The identity provider URL is in the format `https://iam.googleapis.com/projects/PROJECT-NUMBER/locations/global/workloadIdentityPools/POOL-NAME/providers/PROVIDER-NAME`.
    - Click **Continue**.
1. Under "Configure provider attributes":

   - For the "OIDC 1" mapping, enter `assertion.sub`.
   - Under "Attribute Conditions", click **Add condition**.
   - For "Condition CEL", enter the following condition, replacing `HOSTNAME` with the public hostname for {% data variables.location.product_location_enterprise %}:

      ```
      google.subject == "HOSTNAME"
      ```

      For example:

      ```
      google.subject == "my-ghes-host.example.com"
      ```

      {% note %}

      **Note:** The hostname of {% data variables.location.product_location_enterprise %} used here _must not_ include the protocol.

      {% endnote %}
   - Click **Save**.
1. After creating the identity pool, at the top of the identity pool's page, click **Grant access**.
   - Under "Select service account", select the service account that you created in the previous procedure.
   - Under "Select principals (identities that can access the service account)", select **Only identities matching the filter**.
   - For "Attribute name", select **subject**.
   - For "Attribute value", enter your {% data variables.product.prodname_ghe_server %} hostname, without the protocol. For example, `my-ghes-host.example.com`.
   - Click **Save**.
   - You can dismiss the "Configure your application" dialog, as the configuration file is not needed.

### 3. Configure {% data variables.product.prodname_ghe_server %} to connect to Google Cloud Storage using OIDC

{% data reusables.enterprise_site_admin_settings.access-settings %}
{% data reusables.enterprise_site_admin_settings.management-console %}
{% data reusables.enterprise_management_console.actions %}
{% data reusables.actions.enterprise-enable-checkbox %}
{% data reusables.actions.enterprise-gcp-storage-setup %}
1. Under "Authentication", select **OpenID Connect (OIDC)**, and enter the values for your storage:
   * **Service URL**: The service URL for your bucket. This is usually `https://storage.googleapis.com`.
   * **Bucket name**: The name of your bucket.
   * **Workload Identity Provider ID**: The identity provider ID for your identity pool.

     This is in the format `projects/PROJECT-NUMBER/locations/global/workloadIdentityPools/POOL-NAME/providers/PROVIDER-NAME`. Note that you must remove the `https://iam.googleapis.com/` prefix from the value noted in the previous procedure.

     For example, `projects/1234567890/locations/global/workloadIdentityPools/my-pool/providers/my-provider`.
   * **Service account**: The service account email address that you noted in the previous procedure. For example, `ghes-oidc-service-account@my-project.iam.gserviceaccount.com`.
{% data reusables.enterprise_management_console.test-storage-button %}
{% data reusables.enterprise_management_console.save-settings %}

{% endif %}

## Enabling {% data variables.product.prodname_actions %} with Google Cloud Storage{% ifversion ghes-actions-storage-oidc %} using a HMAC key{% endif %}

1. Create a Google Cloud service account that can access the bucket, and create a Hash-based Message Authentication Code (HMAC) key for the service account. For more information, see "[Manage HMAC keys for service accounts](https://cloud.google.com/storage/docs/authentication/managing-hmackeys)" in the Google Cloud documentation.

   The service account must have the following [Identity and Access Management (IAM) permissions](https://cloud.google.com/storage/docs/access-control/iam-permissions) for the bucket:

   * `storage.objects.create`
   * `storage.objects.get`
   * `storage.objects.list`
   * `storage.objects.update`
   * `storage.objects.delete`
   * `storage.multipartUploads.create`
   * `storage.multipartUploads.abort`
   * `storage.multipartUploads.listParts`
   * `storage.multipartUploads.list`
{% data reusables.enterprise_site_admin_settings.access-settings %}
{% data reusables.enterprise_site_admin_settings.management-console %}
{% data reusables.enterprise_management_console.actions %}
{% data reusables.actions.enterprise-enable-checkbox %}
{%- ifversion ghes-actions-storage-oidc %}
{% data reusables.actions.enterprise-gcp-storage-setup %}
1. Under "Authentication", select **Credentials-based**, and enter your storage bucket's details:

{% indented_data_reference reusables.actions.enterprise-gcp-storage-credential-fields spaces=3 %}
{%- else %}
1. Under "Artifact & Log Storage", select **Google Cloud Storage**, and enter your bucket's details:

{% indented_data_reference reusables.actions.enterprise-gcp-storage-credential-fields spaces=3 %}
{%- endif %}
{% data reusables.enterprise_management_console.test-storage-button %}
{% data reusables.enterprise_management_console.save-settings %}

{% data reusables.actions.enterprise-postinstall-nextsteps %}
