---
title: Enabling GitHub Actions with Azure Blob storage
intro: 'You can enable {% data variables.product.prodname_actions %} on {% data variables.product.prodname_ghe_server %} and use Azure Blob storage to store data generated by workflow runs.'
permissions: 'Site administrators can enable {% data variables.product.prodname_actions %} and configure enterprise settings.'
versions:
  ghes: '*'
type: how_to
topics:
  - Actions
  - Enterprise
  - Infrastructure
  - Storage
redirect_from:
  - /admin/github-actions/enabling-github-actions-with-azure-blob-storage
shortTitle: Azure Blob storage
miniTocMaxHeadingLevel: 3
---

{% data reusables.actions.enterprise-storage-about %}

{% ifversion ghes-actions-storage-oidc %}
{% data reusables.actions.enterprise-storage-about-oidc %}

{% data reusables.actions.ghes-storage-oidc-beta-note %}
{% endif %}

## Prerequisites

Before enabling {% data variables.product.prodname_actions %}, make sure you have completed the following steps:

* Create your Azure storage account for storing workflow data. {% data variables.product.prodname_actions %} stores its data as block blobs, and two storage account types are supported:
  * A **general-purpose** storage account (also known as `general-purpose v1` or `general-purpose v2`) using the **standard** performance tier.

    {% warning %}

    **Warning:** Using the **premium** performance tier with a general-purpose storage account is not supported. The **standard** performance tier must be selected when creating the storage account, and it cannot be changed later.

    {% endwarning %}
  * A **BlockBlobStorage** storage account, which uses the **premium** performance tier.

  For more information on Azure storage account types and performance tiers, see the [Azure documentation](https://docs.microsoft.com/en-us/azure/storage/common/storage-account-overview?toc=/azure/storage/blobs/toc.json#types-of-storage-accounts).
{% data reusables.actions.enterprise-common-prereqs %}
{% data reusables.actions.enterprise-oidc-prereqs %}

{% ifversion ghes-actions-storage-oidc %}
## Enabling {% data variables.product.prodname_actions %} with Azure Blob storage using OIDC (recommended)

{% data reusables.actions.ghes-storage-oidc-beta-note %}

To configure {% data variables.product.prodname_ghe_server %} to use OIDC with an Azure storage account, you must first register an Azure Active Directory application with OIDC credentials, then configure your storage account, and finally configure {% data variables.product.prodname_ghe_server %} to access the storage container using the Azure Active Directory application.

### 1. Register an Azure Active Directory application

1. Log in to the Azure portal.
1. Register a new application in Azure Active Directory. For more information, see [Register an application](https://learn.microsoft.com/en-us/azure/active-directory/develop/quickstart-register-app#register-an-application) in the Azure documentation.
1. In your Azure application, under "Essentials", take note of the values for "Application (client) ID" and "Directory (tenant) ID". These values are used later.

   ![Screenshot of the "Overview" page in Azure. The first four items in the "Essentials" section are highlighted with an orange outline.](/assets/images/azure/azure-aad-app-storage-ids.png)
1. In your Azure application, under "Manage", click **Certificates & secrets**, select the **Federated credentials** tab, then click **Add credential**.

   ![Screenshot of the "Federated credentials" page in Azure. The "Certificates & secrets" tab, the "Federated credentials" tab, and the "Add credential" button are highlighted with orange outlines.](/assets/images/azure/azure-federated-credential.png)
1. Enter the following details for the credential:
   1. For "Federated credential scenario", select **Other issuer**.
   1. For "Issuer", enter `https://HOSTNAME/_services/token`, where `HOSTNAME` is the public hostname for {% data variables.location.product_location_enterprise %}. For example, `https://my-ghes-host.example.com/_services/token`.
   1. For "Subject identifier", enter the public hostname for {% data variables.location.product_location_enterprise %}. For example, `my-ghes-host.example.com`.

      {% note %}

      **Note:** The subject identifier must only have the hostname of {% data variables.location.product_location_enterprise %}, and _must not_ include the protocol.

      {% endnote %}
   1. For "Name", enter a name for the credential.
   1. Click **Add**.

### 2. Configure your storage account

1. In the Azure portal, navigate to your storage account.
1. Click **Access Control (IAM)**, then click **Add**, and select **Add role assignment**.
1. For the role, select "Storage Blob Data Owner", then click **Next**.
1. For members, click **Select members**, and then search for and select the name of the Azure application you created earlier. Click **Select**.
1. Click **Review + assign**, review the role assignment, then click **Review + assign** again.
1. In the left menu, under "Settings", click **Endpoints**.
1. Under "Blob service", take note of the value for "Blob service", specifically the blob endpoint suffix. This is the value after `https://<storageaccountname>.blob`. It is typically `core.windows.net`, but might vary depending on your Azure region or account type.

   For example, if your blob service URL is `https://my-storage-account.blob.core.windows.net`, the blob endpoint suffix is `core.windows.net`.

   Note your storage account name and blob endpoint suffix, as these values are used later.

### 3. Configuring {% data variables.product.prodname_ghe_server %} to connect to Azure using OIDC

{% data reusables.enterprise_site_admin_settings.access-settings %}
{% data reusables.enterprise_site_admin_settings.management-console %}
{% data reusables.enterprise_management_console.actions %}
{% data reusables.actions.enterprise-enable-checkbox %}
{% data reusables.actions.enterprise-azure-storage-setup %}
1. Under "Authentication", select **OpenID Connect (OIDC)**, and enter the values for your storage that you noted down in the previous procedures:
   * Azure tenant ID
   * Azure client ID
   * Azure storage account name
   * Azure blob endpoint suffix
{% data reusables.enterprise_management_console.test-storage-button %}
{% data reusables.enterprise_management_console.save-settings %}

{% endif %}

## Enabling {% data variables.product.prodname_actions %} with Azure Blob storage{% ifversion ghes-actions-storage-oidc %} using a connection string{% endif %}

{% data reusables.enterprise_site_admin_settings.access-settings %}
{% data reusables.enterprise_site_admin_settings.management-console %}
{% data reusables.enterprise_management_console.actions %}
{% data reusables.actions.enterprise-enable-checkbox %}
{%- ifversion ghes-actions-storage-oidc %}
{% data reusables.actions.enterprise-azure-storage-setup %}
1. Under "Authentication", select **Credentials-based**, and enter your Azure storage account's connection string. For more information on getting the connection string for your storage account, see the [Azure documentation](https://docs.microsoft.com/en-us/azure/storage/common/storage-account-keys-manage?tabs=azure-portal#view-account-access-keys).
{%- else %}
1. Under "Artifact & Log Storage", select **Azure Blob Storage**, then enter your Azure storage account's connection string. For more information about getting the connection string for your storage account, see the [View account access keys](https://docs.microsoft.com/en-us/azure/storage/common/storage-account-keys-manage?tabs=azure-portal#view-account-access-keys) in the Azure documentation.
{%- endif %}
{% data reusables.enterprise_management_console.test-storage-button %}
{% data reusables.enterprise_management_console.save-settings %}

{% data reusables.actions.enterprise-postinstall-nextsteps %}
