---
title: Downloading workflow artifacts
intro: You can download archived artifacts before they automatically expire.
permissions: 'People who are signed into {% data variables.product.product_name %} and have read access to a repository can download workflow artifacts.'
versions:
  fpt: '*'
  ghes: '*'
  ghae: '*'
  ghec: '*'
shortTitle: Download workflow artifacts
---

{% data reusables.actions.enterprise-beta %}
{% data reusables.actions.enterprise-github-hosted-runners %}

By default, {% data variables.product.product_name %} stores build logs and artifacts for 90 days, and you can customize this retention period, depending on the type of repository. For more information, see "[Managing {% data variables.product.prodname_actions %} settings for a repository](/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#configuring-the-retention-period-for-github-actions-artifacts-and-logs-in-your-repository)."

{% data reusables.repositories.permissions-statement-read %}

{% webui %}

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.actions-tab %}
{% data reusables.repositories.navigate-to-workflow %}
{% data reusables.repositories.view-run %}
1. Under **Artifacts**, click the artifact you want to download.
    
    ![Download artifact drop-down menu](/assets/images/help/repository/artifact-drop-down-updated.png)
    

{% endwebui %}

{% cli %}

{% data reusables.cli.cli-learn-more %}

{% data variables.product.prodname_cli %} will download each artifact into separate directories based on the artifact name. If only a single artifact is specified, it will be extracted into the current directory.

To download all artifacts generated by a workflow run, use the `run download` subcommand. Replace `run-id` with the ID of the run that you want to download artifacts from. If you don't specify a `run-id`, {% data variables.product.prodname_cli %} returns an interactive menu for you to choose a recent run.

```shell
gh run download RUN_ID
```

To download a specific artifact from a run, use the `run download` subcommand. Replace `run-id` with the ID of the run that you want to download artifacts from. Replace `artifact-name` with the name of the artifact that you want to download.

```shell
gh run download RUN_ID -n ARTIFACT_NAME
```

You can specify more than one artifact.

```shell
gh run download RUN_ID> -n ARTIFACT_NAME-1 -n ARTIFACT_NAME-2
```

To download specific artifacts across all runs in a repository, use the `run download` subcommand.

```shell
gh run download -n ARTIFACT_NAME-1 ARTIFACT_NAME-2
```

{% endcli %}
